/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public abstract class FilterCacheBase
implements Filter {
    protected static final long CACHE_MONTH = 2592000000L;
    protected static final long CACHE_WEEK = 604800000L;
    protected static final long CACHE_DAY = 86400000L;
    protected static final long CACHE_NONE = -1L;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        long ct = this.getCacheTime();
        HttpServletResponse resp = (HttpServletResponse)response;
        if (ct <= 0L) {
            resp.setHeader("Cache-Control", "no-cache");
            resp.setHeader("Pragma", "no-cache");
            resp.setDateHeader("Expires", 0L);
        } else {
            long now = System.currentTimeMillis();
            resp.addHeader("Cache-Control", "max-age=" + ct / 1000L);
            resp.setDateHeader("Last-Modified", now);
            resp.setDateHeader("Expires", now + ct);
        }
        chain.doFilter(request, response);
    }

    protected long getCacheTime() {
        return 604800000L;
    }

    public void init(FilterConfig fc) throws ServletException {
    }

    public void destroy() {
    }
}

