/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.resource;

import com.modnut.framework2.lang.LangMap;
import com.modnut.framework2.lang.LangPack;
import com.modnut.framework2.memcache.MemConn;
import com.modnut.framework2.resource.ResPack;
import com.modnut.framework2.tool.ToolStr;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ResServlet
extends ResPack {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    public static final int COOKIE_EXPIRY_DELETE = 0;
    public static final int COOKIE_EXPIRY_SESSION = -1;
    private LangPack cachePack = null;
    private LangMap cacheMap = null;
    private static final int MEMSESSION_DEFAULT_EXPIRY = 1800;
    private static final String MEMSESSION_DEFAULT_COOKIE_NAME = "MEMSID";
    private HttpSession serverSession = null;
    private String curSessionID = null;

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ResServlet(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public String getCookie(String name) {
        Cookie[] cs = this.request.getCookies();
        if (cs == null) {
            return null;
        }
        for (Cookie c : cs) {
            if (!c.getName().equals(name)) continue;
            return c.getValue();
        }
        return null;
    }

    public void setCookie(String name, String value) {
        Cookie c = new Cookie(name, value);
        this.response.addCookie(c);
    }

    public void setCookie(String name, String value, int expiry) {
        Cookie c = new Cookie(name, value);
        c.setMaxAge(expiry);
        this.response.addCookie(c);
    }

    public void setCookie(Cookie c) {
        this.response.addCookie(c);
    }

    public boolean hasParam(String paramName) {
        return this.request.getParameter(paramName) != null;
    }

    public String[] getAjaxParams(String paramName) {
        String value = this.getParam(paramName);
        String[] values = new String[]{};
        if (value != null && !value.trim().equals("")) {
            values = value.split(",");
        }
        return values;
    }

    public String[] getParams(String paramName) {
        return this.request.getParameterValues(paramName);
    }

    public String getParam(String paramName) {
        String[] values = this.getParams(paramName);
        return values == null ? null : values[0];
    }

    public String getParam(String paramName, String defaultVal) {
        return ToolStr.nullToDefault(this.getParam(paramName), defaultVal);
    }

    public boolean getParam(String paramName, boolean defaultVal) {
        String str = this.getParam(paramName);
        return ToolStr.parseBoolean(str, defaultVal);
    }

    public short getParam(String paramName, short defaultVal) {
        String str = this.getParam(paramName);
        return ToolStr.parseShort(str, defaultVal);
    }

    public int getParam(String paramName, int defaultVal) {
        String str = this.getParam(paramName);
        return ToolStr.parseInt(str, defaultVal);
    }

    public long getParam(String paramName, long defaultVal) {
        String str = this.getParam(paramName);
        return ToolStr.parseLong(str, defaultVal);
    }

    public float getParam(String paramName, float defaultVal) {
        String str = this.getParam(paramName);
        return ToolStr.parseFloat(str, defaultVal);
    }

    public double getParam(String paramName, double defaultVal) {
        String str = this.getParam(paramName);
        return ToolStr.parseDouble(str, defaultVal);
    }

    public HashMap<String, String> getParamMap() {
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration parameterNames = this.request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            params.put(parameterName, this.getParam(parameterName));
        }
        return params;
    }

    public LangMap getLangMap(LangPack langPack) {
        if (!langPack.equals(this.cachePack)) {
            this.cachePack = langPack;
            this.cacheMap = null;
        }
        if (this.cacheMap == null) {
            this.cacheMap = langPack.map(this.getLocales());
        }
        return this.cacheMap;
    }

    public String getLangStr(LangPack langPack, String key) {
        return this.getLangMap(langPack).get(key);
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.request.getLocales();
    }

    protected String getSessionMemName() {
        return null;
    }

    protected int getMemcacheSessionExpiry() {
        return 1800;
    }

    protected String getMemcacheSessionCookieName() {
        return MEMSESSION_DEFAULT_COOKIE_NAME;
    }

    protected String getMemcacheSessionCookieDomain() {
        return null;
    }

    protected String getMemcacheSessionCookiePath() {
        return null;
    }

    private HttpSession getServerSession() {
        if (this.serverSession == null) {
            this.serverSession = this.request.getSession(true);
        }
        return this.serverSession;
    }

    public String getSession(String name) {
        String memName = this.getSessionMemName();
        if (memName != null) {
            String sessionID;
            String memcacheID;
            MemConn sessionMemcache = this.getMemConn(memName);
            String sessionVal = sessionMemcache.get(memcacheID = (sessionID = this.getSessionID()) + '_' + name);
            if (sessionVal != null) {
                sessionMemcache.set(memcacheID, sessionVal, this.getMemcacheSessionExpiry());
            }
            return sessionVal;
        }
        Object val = this.getServerSession().getAttribute(name);
        return val == null ? null : (String)val;
    }

    public void setSession(String name, String value) {
        String memName = this.getSessionMemName();
        if (memName != null) {
            MemConn sessionMemcache = this.getMemConn(memName);
            String sessionID = this.getSessionID();
            String memcacheID = sessionID + '_' + name;
            sessionMemcache.set(memcacheID, value, this.getMemcacheSessionExpiry());
        } else {
            this.getServerSession().setAttribute(name, (Object)value);
        }
    }

    public void removeSession(String name) {
        String memName = this.getSessionMemName();
        if (memName != null) {
            MemConn sessionMemcache = this.getMemConn(memName);
            String sessionID = this.getSessionID();
            String memcacheID = sessionID + '_' + name;
            sessionMemcache.del(memcacheID);
        } else {
            this.getServerSession().removeAttribute(name);
        }
    }

    public String getSessionID() {
        if (this.curSessionID != null) {
            return this.curSessionID;
        }
        String sessionId = this.getCookie(this.getMemcacheSessionCookieName());
        if (sessionId == null) {
            String path;
            sessionId = ToolStr.randomSHA();
            Cookie sessionCookie = new Cookie(this.getMemcacheSessionCookieName(), sessionId);
            String domain = this.getMemcacheSessionCookieDomain();
            if (domain != null) {
                sessionCookie.setDomain(domain);
            }
            if ((path = this.getMemcacheSessionCookiePath()) != null) {
                sessionCookie.setPath(path);
            } else {
                sessionCookie.setPath(this.request.getServletContext().getContextPath() + "/");
            }
            this.setCookie(sessionCookie);
        }
        this.curSessionID = sessionId;
        return this.curSessionID;
    }

    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public boolean sendRedirect(String location) {
        try {
            this.response.sendRedirect(location);
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(ResServlet.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public String getClientIP() {
        return this.request.getRemoteAddr();
    }

    public String getUserAgent() {
        return this.request.getHeader("User-Agent");
    }

    public String getReferer() {
        return this.request.getHeader("Referer");
    }

    public String getHost() {
        return this.request.getHeader("Host");
    }

    public PrintWriter getWriter() {
        try {
            return this.response.getWriter();
        }
        catch (IOException ex) {
            Logger.getLogger(ResServlet.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

