/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.message;

import com.modnut.framework2.message.MessageObj;
import java.util.concurrent.atomic.AtomicInteger;

public class MessageStatus<CO extends MessageObj> {
    private final AtomicInteger counter = new AtomicInteger(0);
    private CO msg;

    public MessageStatus() {
        this.msg = null;
    }

    public MessageStatus(CO initMsg) {
        this.msg = initMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(CO newMsg) {
        MessageStatus messageStatus = this;
        synchronized (messageStatus) {
            this.msg = newMsg;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CO get() {
        MessageStatus messageStatus = this;
        synchronized (messageStatus) {
            return this.msg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CO listen(long timestamp, long timenano, long timeout) {
        CO newObj;
        MessageStatus messageStatus = this;
        synchronized (messageStatus) {
            if (this.msg == null || !((MessageObj)this.msg).after(timestamp, timenano)) {
                this.counter.incrementAndGet();
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.counter.decrementAndGet();
                }
            }
            newObj = this.msg != null && ((MessageObj)this.msg).after(timestamp, timenano) ? (CO)this.msg : null;
        }
        return newObj;
    }

    public int count() {
        return this.counter.get();
    }
}

