/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.memcache;

import com.modnut.framework2.constant.ConstFramework;
import com.modnut.framework2.memcache.MemConn;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class MemJava
extends MemConn {
    public static final String CLASS_NAME = MemJava.class.getSimpleName();
    private static final long DEFAULT_CLEANDT = 300000L;
    private final HashMap<String, CacheObj> pool = new HashMap();
    private final AtomicLong cleants = new AtomicLong(System.currentTimeMillis());
    private final long cleandt;

    public MemJava() {
        this.cleandt = 300000L;
    }

    public MemJava(long cleandt) {
        this.cleandt = cleandt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemConn flush() {
        HashMap<String, CacheObj> hashMap = this.pool;
        synchronized (hashMap) {
            this.pool.clear();
        }
        MemJava.echoAct(ECHO_TYPE.FLUSH, null, null);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemConn set(String key, String value, int expiry) {
        CacheObj obj;
        HashMap<String, CacheObj> hashMap = this.pool;
        synchronized (hashMap) {
            obj = this.pool.get(key);
        }
        if (obj == null) {
            hashMap = this.pool;
            synchronized (hashMap) {
                this.pool.put(key, new CacheObj(value, expiry));
            }
        } else {
            obj.update(value, expiry);
        }
        MemJava.echoAct(ECHO_TYPE.SET, key, value);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key) {
        CacheObj obj;
        this.clean();
        HashMap<String, CacheObj> hashMap = this.pool;
        synchronized (hashMap) {
            obj = this.pool.get(key);
        }
        String value = obj == null || obj.timeout() ? null : obj.value;
        MemJava.echoAct(ECHO_TYPE.GET, key, value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemConn del(String key) {
        HashMap<String, CacheObj> hashMap = this.pool;
        synchronized (hashMap) {
            this.pool.remove(key);
        }
        MemJava.echoAct(ECHO_TYPE.DELETE, key, null);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemConn refresh(String key, int expiry) {
        CacheObj obj;
        HashMap<String, CacheObj> hashMap = this.pool;
        synchronized (hashMap) {
            obj = this.pool.get(key);
        }
        if (obj != null) {
            obj.refresh(expiry);
        }
        MemJava.echoAct(ECHO_TYPE.REFRESH, key, null);
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isAlive() {
        return true;
    }

    private void clean() {
        boolean run = false;
        long now = System.currentTimeMillis();
        long ts = this.cleants.get();
        if (ts + this.cleandt < now && this.cleants.compareAndSet(ts, now)) {
            run = true;
        }
        if (run) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HashMap hashMap = MemJava.this.pool;
                    synchronized (hashMap) {
                        Set keySet = MemJava.this.pool.keySet();
                        Iterator iterator = keySet.iterator();
                        while (iterator.hasNext()) {
                            String key = (String)iterator.next();
                            CacheObj obj = (CacheObj)MemJava.this.pool.get(key);
                            if (obj != null && !obj.timeout()) continue;
                            iterator.remove();
                        }
                    }
                }
            };
            new Thread(runnable).start();
        }
    }

    private static void echoAct(ECHO_TYPE echoType, String key, String value) {
        if (ConstFramework.getDebug()) {
            switch (echoType) {
                case GET: {
                    System.out.println(CLASS_NAME + " Get: " + key + " - " + value);
                    break;
                }
                case SET: {
                    System.out.println(CLASS_NAME + " Set: " + key + " - " + value);
                    break;
                }
                case DELETE: {
                    System.out.println(CLASS_NAME + " Delete: " + key);
                    break;
                }
                case REFRESH: {
                    System.out.println(CLASS_NAME + " Refresh: " + key);
                    break;
                }
                case FLUSH: {
                    System.out.println(CLASS_NAME + " Flush");
                }
            }
        }
    }

    private static class CacheObj {
        public long ts = System.currentTimeMillis();
        public String value;
        public int expiry;

        public CacheObj(String value, int expiry) {
            this.value = value;
            this.expiry = expiry;
        }

        public void update(String value, int expiry) {
            this.ts = System.currentTimeMillis();
            this.value = value;
            this.expiry = expiry;
        }

        public void refresh(int expiry) {
            this.ts = System.currentTimeMillis();
            this.expiry = expiry;
        }

        public boolean timeout() {
            return this.ts + (long)(this.expiry * 1000) < System.currentTimeMillis();
        }
    }

    private static enum ECHO_TYPE {
        FLUSH,
        GET,
        SET,
        DELETE,
        REFRESH;

    }
}

