/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.memcache;

import com.modnut.framework2.constant.ConstFramework;
import com.modnut.framework2.memcache.MemConn;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.MemcachedClient;

public class MemClient
extends MemConn {
    private static final long TIMEOUT = 5000L;
    public static final String CLASS_NAME;
    private final MemcachedClient memCachedClient;
    private boolean isAlive = true;
    private final LinkedList<TimeFuture> results = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFuture(Future<Boolean> result) {
        LinkedList<TimeFuture> linkedList = this.results;
        synchronized (linkedList) {
            while (this.results.size() > 0) {
                TimeFuture tf = this.results.getFirst();
                if (tf.timeout(5000L)) {
                    tf.cancel();
                    this.results.removeFirst();
                    continue;
                }
                if (!tf.finished()) break;
                this.results.removeFirst();
            }
            this.results.add(new TimeFuture(result));
        }
    }

    public MemClient(String configStr) throws IOException {
        this.memCachedClient = new MemcachedClient(AddrUtil.getAddresses((String)configStr));
    }

    @Override
    public MemConn flush() {
        this.addFuture(this.memCachedClient.flush());
        MemClient.echoAct(ECHO_TYPE.FLUSH, null, null);
        return this;
    }

    @Override
    public MemConn set(String key, String value, int expiry) {
        this.addFuture(this.memCachedClient.set(key, expiry, (Object)value));
        MemClient.echoAct(ECHO_TYPE.SET, key, value);
        return this;
    }

    @Override
    public String get(String key) {
        try {
            String value = (String)this.memCachedClient.get(key);
            MemClient.echoAct(ECHO_TYPE.GET, key, value);
            return value;
        }
        catch (Exception ex) {
            Logger.getLogger(MemConn.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public MemConn del(String key) {
        this.addFuture(this.memCachedClient.delete(key));
        MemClient.echoAct(ECHO_TYPE.DELETE, key, null);
        return this;
    }

    @Override
    public MemConn refresh(String key, int expiry) {
        this.memCachedClient.set(key, expiry, this.memCachedClient.get(key));
        MemClient.echoAct(ECHO_TYPE.REFRESH, key, null);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LinkedList<TimeFuture> linkedList = this.results;
        synchronized (linkedList) {
            while (this.results.size() > 0) {
                TimeFuture tf = this.results.getFirst();
                if (!tf.finished()) {
                    tf.get();
                }
                this.results.removeFirst();
            }
        }
        this.memCachedClient.shutdown();
        this.isAlive = false;
    }

    @Override
    public boolean isAlive() {
        return this.memCachedClient.isAlive() && this.isAlive;
    }

    private static void echoAct(ECHO_TYPE echoType, String key, String value) {
        if (ConstFramework.getDebug()) {
            switch (echoType) {
                case GET: {
                    System.out.println(CLASS_NAME + " Get: " + key + " - " + value);
                    break;
                }
                case SET: {
                    System.out.println(CLASS_NAME + " Set: " + key + " - " + value);
                    break;
                }
                case DELETE: {
                    System.out.println(CLASS_NAME + " Delete: " + key);
                    break;
                }
                case REFRESH: {
                    System.out.println(CLASS_NAME + " Refresh: " + key);
                    break;
                }
                case FLUSH: {
                    System.out.println(CLASS_NAME + " Flush");
                }
            }
        }
    }

    static {
        if (!ConstFramework.getDebug()) {
            System.setProperty("net.spy.log.LoggerImpl", "net.spy.memcached.compat.log.SunLogger");
            Logger.getLogger("net.spy.memcached").setLevel(Level.OFF);
        }
        CLASS_NAME = MemClient.class.getSimpleName();
    }

    private static class TimeFuture {
        private Future future;
        private long timeStamp;

        public TimeFuture(Future future) {
            this.future = future;
            this.timeStamp = System.currentTimeMillis();
        }

        public boolean timeout(long dt) {
            return this.timeStamp + dt < System.currentTimeMillis();
        }

        public boolean finished() {
            return this.future.isDone() || this.future.isCancelled();
        }

        public void cancel() {
            this.future.cancel(false);
        }

        public Object get() {
            try {
                return this.future.get(5000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception ex) {
                Logger.getLogger(MemConn.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }
    }

    private static enum ECHO_TYPE {
        FLUSH,
        GET,
        SET,
        DELETE,
        REFRESH;

    }
}

