/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.listener;

import com.modnut.framework2.data.DataObj;

public abstract class ListenerXBase {
    private final String name;

    public ListenerXBase(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected DataObj send(String fromName, String toName, String cmd, DataObj param) {
        return this.receive(fromName, toName, cmd, param);
    }

    protected void doSend(String fromName, String toName, String cmd, DataObj param) {
        this.doSend(fromName, toName, cmd, param, null);
    }

    protected void doSend(String fromName, String toName, String cmd, DataObj param, ListenerXCallback callback) {
        new Thread(new ListenerXRunnable(fromName, toName, cmd, param, callback)).start();
    }

    protected abstract boolean accept(String var1, String var2, String var3);

    protected abstract DataObj receive(String var1, String var2, String var3, DataObj var4);

    private class ListenerXRunnable
    implements Runnable {
        private final String fromName;
        private final String toName;
        private final String cmd;
        private final DataObj param;
        private final ListenerXCallback cb;

        public ListenerXRunnable(String fromName, String toName, String cmd, DataObj param) {
            this.fromName = fromName;
            this.toName = toName;
            this.cmd = cmd;
            this.param = param;
            this.cb = null;
        }

        public ListenerXRunnable(String fromName, String toName, String cmd, DataObj param, ListenerXCallback cb) {
            this.fromName = fromName;
            this.toName = toName;
            this.cmd = cmd;
            this.param = param;
            this.cb = cb;
        }

        @Override
        public void run() {
            DataObj result = ListenerXBase.this.receive(this.fromName, this.toName, this.cmd, this.param);
            if (this.cb != null) {
                this.cb.callback(ListenerXBase.this.getName(), this.toName, this.cmd, this.param, result);
            }
        }
    }

    public static interface ListenerXCallback {
        public void callback(String var1, String var2, String var3, DataObj var4, DataObj var5);
    }
}

