/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.limit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

public class LimitString {
    public static final long DEFAULT_EXPIRY = 3600000L;
    public static final int NO_LIMIT = -1;
    private final ArrayList<LimitObj> limitPool = new ArrayList();
    private final AtomicInteger limitMax;
    private final long limitExpiry;

    public LimitString() {
        this.limitMax = new AtomicInteger(0);
        this.limitExpiry = 3600000L;
    }

    public LimitString(int max) {
        this.limitMax = new AtomicInteger(max);
        this.limitExpiry = 3600000L;
    }

    public LimitString(int max, long expiry) {
        this.limitMax = new AtomicInteger(max);
        this.limitExpiry = expiry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean test(String str) {
        boolean result = false;
        if (str != null) {
            ArrayList<LimitObj> arrayList = this.limitPool;
            synchronized (arrayList) {
                boolean find = false;
                Iterator<LimitObj> iterator = this.limitPool.iterator();
                while (iterator.hasNext()) {
                    LimitObj limitObj = iterator.next();
                    if (str.equals(limitObj.str)) {
                        limitObj.ts = System.currentTimeMillis();
                        find = true;
                        continue;
                    }
                    if (limitObj.ts + this.limitExpiry >= System.currentTimeMillis()) continue;
                    iterator.remove();
                }
                if (find) {
                    result = true;
                } else if (this.limitMax.get() < 0 || this.limitPool.size() < this.limitMax.get()) {
                    this.limitPool.add(new LimitObj(str, System.currentTimeMillis()));
                    result = true;
                } else {
                    result = false;
                }
            }
        }
        return result;
    }

    public int getMax() {
        return this.limitMax.get();
    }

    public void setMax(int max) {
        this.limitMax.set(max);
    }

    private final class LimitObj {
        String str;
        long ts;

        public LimitObj(String str, long ts) {
            this.str = str;
            this.ts = ts;
        }
    }
}

