/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.json;

import com.modnut.framework2.json.JSONArray;
import com.modnut.framework2.json.JSONException;
import com.modnut.framework2.json.JSONObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JSONConvert {
    private static final String EXPCETION_CONVERT_PREFIX = "convert exception:";

    public static JSONObject toJSONObject(Object obj) {
        return JSONConvert.toJSONObject(obj, false);
    }

    public static JSONObject toJSONObject(Object obj, boolean hasStatic) {
        try {
            return JSONConvert.toJSON(obj, JSONObject.class, hasStatic);
        }
        catch (JSONException ex) {
            Logger.getLogger(JSONConvert.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static JSONArray toJSONArray(Object obj) {
        return JSONConvert.toJSONArray(obj, false);
    }

    public static JSONArray toJSONArray(Object obj, boolean hasStatic) {
        try {
            return JSONConvert.toJSON(obj, JSONArray.class, hasStatic);
        }
        catch (JSONException ex) {
            Logger.getLogger(JSONConvert.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static <T> T toJSON(Object obj, Class<T> c) throws JSONException {
        return JSONConvert.parseObject(JSONConvert.toJSON(obj), c);
    }

    public static <T> T toJSON(Object obj, Class<T> c, boolean hasStatic) throws JSONException {
        return JSONConvert.parseObject(JSONConvert.toJSON(obj, hasStatic), c);
    }

    public static Object toJSON(Object obj) throws JSONException {
        return JSONConvert.toJSON(obj, false);
    }

    public static Object toJSON(Object obj, boolean hasStatic) throws JSONException {
        if (obj == null) {
            return null;
        }
        if (JSONConvert.isBasic(obj)) {
            return obj;
        }
        if (obj instanceof JSONArray || obj instanceof JSONObject) {
            return obj;
        }
        Class<?> objClass = obj.getClass();
        if (objClass.isArray()) {
            JSONArray rtn = new JSONArray();
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                Object value = Array.get(obj, i);
                rtn.put(JSONConvert.toJSON(value, hasStatic));
            }
            return rtn;
        }
        if (JSONConvert.hasInterface(objClass, List.class)) {
            List list = (List)obj;
            JSONArray jsonArr = new JSONArray();
            for (int i = 0; i < list.size(); ++i) {
                jsonArr.put(JSONConvert.toJSON(list.get(i), hasStatic));
            }
            return jsonArr;
        }
        if (JSONConvert.hasInterface(objClass, Map.class)) {
            Map map = (Map)obj;
            JSONObject jsonObj = new JSONObject();
            for (Object key : map.keySet()) {
                jsonObj.put(key.toString(), JSONConvert.toJSON(map.get(key), hasStatic));
            }
            return jsonObj;
        }
        JSONObject rtn = new JSONObject();
        Field[] fields = objClass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                Field f = fields[i];
                if (f.isSynthetic() || Modifier.isStatic(f.getModifiers()) && !hasStatic) continue;
                String name = f.getName();
                Object value = f.get(obj);
                rtn.put(name, JSONConvert.toJSON(value, hasStatic));
                continue;
            }
            catch (IllegalArgumentException ex) {
                throw new JSONException(EXPCETION_CONVERT_PREFIX + ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                throw new JSONException(EXPCETION_CONVERT_PREFIX + ex.getMessage());
            }
        }
        return rtn;
    }

    public static void fromJSON(Object obj, JSONObject json) throws JSONException {
        if (obj != null && json != null) {
            Field[] fields;
            Class<?> cls = obj.getClass();
            for (Field f : fields = cls.getFields()) {
                String name = f.getName();
                Class<?> type = f.getType();
                int modifiers = f.getModifiers();
                if (!Modifier.isPublic(modifiers) || Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers) || Modifier.isInterface(modifiers)) continue;
                try {
                    if (Boolean.TYPE.equals(type)) {
                        f.setBoolean(obj, json.getBoolean(name));
                        continue;
                    }
                    if (Byte.TYPE.equals(type)) {
                        f.setByte(obj, json.getByte(name));
                        continue;
                    }
                    if (Short.TYPE.equals(type)) {
                        f.setShort(obj, json.getShort(name));
                        continue;
                    }
                    if (Integer.TYPE.equals(type)) {
                        f.setInt(obj, json.getInteger(name));
                        continue;
                    }
                    if (Long.TYPE.equals(type)) {
                        f.setLong(obj, json.getLong(name));
                        continue;
                    }
                    if (Float.TYPE.equals(type)) {
                        f.setFloat(obj, json.getFloat(name));
                        continue;
                    }
                    if (Double.TYPE.equals(type)) {
                        f.setDouble(obj, json.getDouble(name));
                        continue;
                    }
                    if (String.class.equals(type)) {
                        f.set(obj, json.getString(name));
                        continue;
                    }
                    if (type.isArray()) {
                        Class<?> elmCls = type.getComponentType();
                        Object arrObj = null;
                        JSONArray arrJson = json.getJsonArray(name);
                        if (arrJson != null) {
                            arrObj = Array.newInstance(elmCls, arrJson.length());
                            JSONConvert.fromJSON(arrObj, arrJson);
                        }
                        f.set(obj, arrObj);
                        continue;
                    }
                    JSONConvert.fromJSON(f.get(obj), json.getJsonObject(name));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void fromJSON(Object obj, JSONArray json) throws JSONException {
        Class<?> cls;
        if (obj != null && json != null && (cls = obj.getClass()).isArray()) {
            Class<?> elmCls = cls.getComponentType();
            for (int i = 0; i < json.length(); ++i) {
                try {
                    if (Boolean.TYPE.equals(elmCls)) {
                        Array.setBoolean(obj, i, json.getBoolean(i));
                        continue;
                    }
                    if (Byte.TYPE.equals(elmCls)) {
                        Array.setByte(obj, i, json.getByte(i));
                        continue;
                    }
                    if (Short.TYPE.equals(elmCls)) {
                        Array.setShort(obj, i, json.getShort(i));
                        continue;
                    }
                    if (Integer.TYPE.equals(elmCls)) {
                        Array.setInt(obj, i, json.getInteger(i));
                        continue;
                    }
                    if (Long.TYPE.equals(elmCls)) {
                        Array.setLong(obj, i, json.getLong(i));
                        continue;
                    }
                    if (Float.TYPE.equals(elmCls)) {
                        Array.setFloat(obj, i, json.getFloat(i));
                        continue;
                    }
                    if (Double.TYPE.equals(elmCls)) {
                        Array.setDouble(obj, i, json.getDouble(i));
                        continue;
                    }
                    if (String.class.equals(elmCls)) {
                        Array.set(obj, i, json.getString(i));
                        continue;
                    }
                    Object elmObj = elmCls.newInstance();
                    JSONConvert.fromJSON(elmObj, json.getJsonObject(i));
                    Array.set(obj, i, elmObj);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static boolean isBasic(Object obj) {
        return obj instanceof Boolean || obj instanceof Short || obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double || obj instanceof String;
    }

    private static <T> T parseObject(Object o, Class<T> c) {
        if (o != null && JSONConvert.baseOfClass(o.getClass(), c)) {
            return (T)o;
        }
        return null;
    }

    protected static boolean baseOfClass(Class c, Class baseclass) {
        Class superclass = c;
        while (superclass != null) {
            if (superclass.equals(baseclass)) {
                return true;
            }
            c = superclass;
            superclass = c.getSuperclass();
        }
        return false;
    }

    protected static boolean hasInterface(Class c, Class i) {
        for (Class<?> ci : c.getInterfaces()) {
            if (!i.equals(ci)) continue;
            return true;
        }
        return false;
    }
}

