/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.extend;

import com.decard.api.DecardException;
import com.decard.api.DecardM1;
import com.decard.api.DecardParam;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WalletCard {
    private final String passwordA;
    private final String passwordB;
    private static byte[] defaultKeyA = DecardParam.hex2Bytes((String)"FFFFFFFFFFFF");
    private static byte[] defaultKeyB = DecardParam.hex2Bytes((String)"FFFFFFFFFFFF");
    private static Charset defaultCharset = Charset.forName("UTF-8");

    public String getPasswordA() {
        return this.passwordA;
    }

    public String getPasswordB() {
        return this.passwordB;
    }

    public static byte[] getDefaultKeyA() {
        return defaultKeyA;
    }

    public static byte[] getDefaultKeyB() {
        return defaultKeyB;
    }

    public static void setDefaultKeyA(String defaultKeyA) {
        WalletCard.setDefaultKeyA(DecardParam.hex2Bytes((String)defaultKeyA));
    }

    public static void setDefaultKeyA(byte[] defaultKeyA) {
        WalletCard.defaultKeyA = defaultKeyA;
    }

    public static void setDefaultKeyB(String defaultKeyB) {
        WalletCard.setDefaultKeyB(DecardParam.hex2Bytes((String)defaultKeyB));
    }

    public static void setDefaultKeyB(byte[] defaultKeyB) {
        WalletCard.defaultKeyB = defaultKeyB;
    }

    public static void setDefaultCharset(String charset) {
        defaultCharset = Charset.forName(charset);
    }

    public static void setDefaultCharset(Charset charset) {
        defaultCharset = charset;
    }

    public WalletCard(String passwordA, String passwordB) {
        this.passwordA = passwordA;
        this.passwordB = passwordB;
    }

    public WalletCard(String passwordA) {
        this.passwordA = passwordA;
        this.passwordB = null;
    }

    private byte[] getSectorKey(byte[] sn, int secnum, char type) {
        String passwdStr = type == 'A' ? this.passwordA : this.passwordB;
        byte[] passwd = passwdStr == null ? new byte[]{} : passwdStr.getBytes();
        byte[] data = new byte[2 + sn.length + passwd.length];
        data[0] = (byte)secnum;
        data[1] = (byte)type;
        System.arraycopy(sn, 0, data, 2, sn.length);
        System.arraycopy(passwd, 0, data, 2 + sn.length, passwd.length);
        byte[] md5 = WalletCard.md5(data);
        byte[] key = new byte[6];
        System.arraycopy(md5, 0, key, 0, key.length);
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() throws DecardException {
        DecardM1.init();
        try {
            byte[] sn = DecardM1.card();
            byte[] empty = DecardParam.hex2Bytes((String)"00000000000000000000000000000000");
            for (int i = 0; i < 16; ++i) {
                byte[] sectorKeyA = this.getSectorKey(sn, i, 'A');
                byte[] sectorKeyB = this.getSectorKey(sn, i, 'B');
                DecardM1.authenticationPass((byte[])defaultKeyA, (char)'A', (int)i);
                if (i != 0) {
                    DecardM1.write((int)(i * 4 + 0), (byte[])empty);
                }
                DecardM1.write((int)(i * 4 + 1), (byte[])empty);
                DecardM1.write((int)(i * 4 + 2), (byte[])empty);
                DecardM1.Control.BlockInfo blockInfo = new DecardM1.Control.BlockInfo();
                blockInfo.keyA = DecardParam.bytes2Hex((byte[])sectorKeyA);
                blockInfo.keyB = DecardParam.bytes2Hex((byte[])sectorKeyB);
                blockInfo.block0 = (byte)6;
                blockInfo.block1 = (byte)6;
                blockInfo.block2 = (byte)6;
                blockInfo.block3 = (byte)3;
                DecardM1.changeB3((int)i, (DecardM1.Control.BlockInfo)blockInfo);
            }
            DecardM1.authenticationPass((byte[])this.getSectorKey(sn, 0, 'B'), (char)'B', (int)0);
            DecardM1.initval((int)1, (int)0);
            DecardM1.initval((int)2, (int)0);
        }
        finally {
            DecardM1.exit();
        }
    }

    public void valSet(int val) throws DecardException {
        this.valSet(val, 1);
    }

    public void valSet2(int val) throws DecardException {
        this.valSet(val, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void valSet(int val, int index) throws DecardException {
        DecardM1.init();
        try {
            byte[] sn = DecardM1.card();
            int secnum = 0;
            char type = 'B';
            DecardM1.authenticationPass((byte[])this.getSectorKey(sn, secnum, type), (char)type, (int)secnum);
            DecardM1.initval((int)(secnum * 4 + index), (int)val);
        }
        finally {
            DecardM1.exit();
        }
    }

    public void valInc(int val) throws DecardException {
        this.valInc(val, 1);
    }

    public void valInc2(int val) throws DecardException {
        this.valInc(val, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void valInc(int val, int index) throws DecardException {
        DecardM1.init();
        try {
            byte[] sn = DecardM1.card();
            int secnum = 0;
            char type = 'B';
            DecardM1.authenticationPass((byte[])this.getSectorKey(sn, secnum, type), (char)type, (int)secnum);
            DecardM1.increment((int)(secnum * 4 + index), (int)val);
        }
        finally {
            DecardM1.exit();
        }
    }

    public void valDec(int val) throws DecardException {
        this.valDec(val, 1);
    }

    public void valDec2(int val) throws DecardException {
        this.valDec(val, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void valDec(int val, int index) throws DecardException {
        DecardM1.init();
        try {
            byte[] sn = DecardM1.card();
            int secnum = 0;
            char type = this.passwordB == null ? (char)'A' : 'B';
            DecardM1.authenticationPass((byte[])this.getSectorKey(sn, secnum, type), (char)type, (int)secnum);
            DecardM1.decrement((int)(secnum * 4 + index), (int)val);
        }
        finally {
            DecardM1.exit();
        }
    }

    public int valGet() throws DecardException {
        return this.valGet(1);
    }

    public int valGet2() throws DecardException {
        return this.valGet(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int valGet(int index) throws DecardException {
        int rtnVal = 0;
        DecardM1.init();
        try {
            byte[] sn = DecardM1.card();
            int secnum = 0;
            char type = this.passwordB == null ? (char)'A' : 'B';
            DecardM1.authenticationPass((byte[])this.getSectorKey(sn, secnum, type), (char)type, (int)secnum);
            rtnVal = DecardM1.readval((int)(secnum * 4 + index));
        }
        finally {
            DecardM1.exit();
        }
        return rtnVal;
    }

    public String strGet(int secnum) throws DecardException {
        return this.strGet(secnum, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String strGet(int secnum, int width) throws DecardException {
        String rtnVal = null;
        if (secnum < 1 || width < 1 || secnum + width - 1 > 15) {
            return rtnVal;
        }
        DecardM1.init();
        try {
            int i;
            byte[] sn = DecardM1.card();
            char type = this.passwordB == null ? (char)'A' : 'B';
            byte[] data = new byte[width * 48];
            byte[] buff = new byte[16];
            for (i = 0; i < width; ++i) {
                DecardM1.authenticationPass((byte[])this.getSectorKey(sn, secnum + i, type), (char)type, (int)(secnum + i));
                for (int j = 0; j < 3; ++j) {
                    DecardM1.read((int)((secnum + i) * 4 + j), (byte[])buff);
                    System.arraycopy(buff, 0, data, i * 48 + j * 16, buff.length);
                }
            }
            for (i = 0; i < data.length; ++i) {
                if (data[i] != 0) continue;
                byte[] newData = new byte[i];
                System.arraycopy(data, 0, newData, 0, i);
                data = newData;
                break;
            }
            rtnVal = new String(data, defaultCharset);
        }
        finally {
            DecardM1.exit();
        }
        return rtnVal;
    }

    public void strSet(int secnum, String str) throws DecardException {
        this.strSet(secnum, str, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void strSet(int secnum, String str, int width) throws DecardException {
        if (secnum < 1 || width < 1 || secnum + width - 1 > 15) {
            return;
        }
        DecardM1.init();
        try {
            int i;
            byte[] sn = DecardM1.card();
            char type = 'B';
            byte[] data = new byte[width * 48];
            byte[] buff = new byte[16];
            byte[] strBytes = str.getBytes(defaultCharset);
            for (i = 0; i < data.length; ++i) {
                data[i] = i < strBytes.length ? strBytes[i] : (byte)0;
            }
            for (i = 0; i < width; ++i) {
                DecardM1.authenticationPass((byte[])this.getSectorKey(sn, secnum + i, type), (char)type, (int)(secnum + i));
                for (int j = 0; j < 3; ++j) {
                    System.arraycopy(data, i * 48 + j * 16, buff, 0, buff.length);
                    DecardM1.write((int)((secnum + i) * 4 + j), (byte[])buff);
                }
            }
        }
        finally {
            DecardM1.exit();
        }
    }

    public void beep() throws DecardException {
        this.beep(100);
    }

    public void beep(int ms) throws DecardException {
        DecardM1.init();
        try {
            DecardM1.beep((int)ms);
        }
        finally {
            DecardM1.exit();
        }
    }

    private static byte[] md5(byte[] data) {
        try {
            return MessageDigest.getInstance("MD5").digest(data);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(WalletCard.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

