/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.extend;

import com.modnut.framework2.extend.ExcelReader;
import java.io.File;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import jxl.Cell;
import jxl.CellType;
import jxl.CellView;
import jxl.DateCell;
import jxl.NumberCell;
import jxl.Range;
import jxl.Workbook;
import jxl.biff.DisplayFormat;
import jxl.biff.FontRecord;
import jxl.format.Alignment;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.VerticalAlignment;
import jxl.write.DateFormat;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public class ExcelWriter
extends ExcelReader {
    public WritableWorkbook rw_workbook;
    public WritableSheet rw_sheet;
    private boolean hasCopy = false;
    private boolean readCopy = false;

    public boolean hasCopy() {
        return this.hasCopy;
    }

    public boolean readCopy() {
        return this.readCopy;
    }

    public ExcelWriter setMode(boolean readCopy) {
        this.readCopy = readCopy;
        return this;
    }

    @Override
    public boolean open(String filePath) {
        return this.open(new File(filePath));
    }

    @Override
    public boolean open(File file) {
        try {
            if (file.exists() && super.open(file)) {
                this.hasCopy = true;
                this.rw_workbook = Workbook.createWorkbook((File)file, (Workbook)this.ro_workbook);
            } else {
                this.rw_workbook = Workbook.createWorkbook((File)file);
            }
            return true;
        }
        catch (Exception ex) {
            Logger.getLogger(ExcelWriter.class.getName()).log(Level.SEVERE, null, ex);
            this.rw_workbook = null;
            return false;
        }
    }

    @Override
    public boolean close() {
        boolean rtn = false;
        if (this.rw_workbook != null) {
            try {
                this.rw_workbook.write();
                this.rw_workbook.close();
                rtn = true;
            }
            catch (Exception ex) {
                Logger.getLogger(ExcelWriter.class.getName()).log(Level.SEVERE, null, ex);
                rtn = false;
            }
            this.rw_sheet = null;
            this.rw_workbook = null;
            return rtn;
        }
        return rtn;
    }

    @Override
    public String[] getSheetNames() {
        if (this.readCopy) {
            return super.getSheetNames();
        }
        return this.rw_workbook == null ? null : this.rw_workbook.getSheetNames();
    }

    @Override
    public boolean setSheet(int index) {
        if (this.readCopy) {
            return super.setSheet(index);
        }
        if (this.rw_workbook != null) {
            WritableSheet[] sheets = this.rw_workbook.getSheets();
            if (index >= 0 && index < sheets.length) {
                this.rw_sheet = sheets[index];
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean setSheet(String name) {
        if (this.readCopy) {
            return super.setSheet(name);
        }
        boolean rtn = false;
        if (this.rw_workbook != null) {
            String[] sheetNames;
            for (String sheetName : sheetNames = this.rw_workbook.getSheetNames()) {
                if (!sheetName.equals(name)) continue;
                this.rw_sheet = this.rw_workbook.getSheet(name);
                rtn = true;
                break;
            }
        }
        return rtn;
    }

    @Override
    public int getRows() {
        if (this.readCopy) {
            return super.getRows();
        }
        return this.rw_sheet == null ? 0 : this.rw_sheet.getRows();
    }

    @Override
    public int getCols() {
        if (this.readCopy) {
            return super.getCols();
        }
        return this.rw_sheet == null ? 0 : this.rw_sheet.getColumns();
    }

    @Override
    public boolean checkCell(int row, int col) {
        if (this.readCopy) {
            return super.checkCell(row, col);
        }
        return this.rw_sheet != null && row >= 0 && row < this.getRows() && col >= 0 && col < this.getCols();
    }

    @Override
    public Cell getCellObject(int row, int col) {
        if (this.readCopy) {
            return super.getCellObject(row, col);
        }
        return this.checkCell(row, col) ? this.rw_sheet.getCell(col, row) : null;
    }

    public WritableCell getWritableCellObject(int row, int col) {
        return this.rw_sheet == null ? null : this.rw_sheet.getWritableCell(col, row);
    }

    @Override
    public String getCell(int row, int col) {
        if (this.readCopy) {
            return super.getCell(row, col);
        }
        return this.checkCell(row, col) ? this.rw_sheet.getCell(col, row).getContents() : null;
    }

    @Override
    public Date getCellDate(int row, int col) {
        Cell cell;
        if (this.readCopy) {
            return super.getCellDate(row, col);
        }
        if (this.checkCell(row, col) && (cell = this.rw_sheet.getCell(col, row)).getType() == CellType.DATE) {
            DateCell dc = (DateCell)cell;
            return dc.getDate();
        }
        return null;
    }

    @Override
    public double getCellNumber(int row, int col) {
        Cell cell;
        if (this.readCopy) {
            return super.getCellNumber(row, col);
        }
        if (this.checkCell(row, col) && (cell = this.rw_sheet.getCell(col, row)).getType() == CellType.NUMBER) {
            NumberCell nc = (NumberCell)cell;
            return nc.getValue();
        }
        return 0.0;
    }

    @Override
    public int getRowHeight(int row) {
        if (this.readCopy) {
            return super.getRowHeight(row);
        }
        return this.rw_sheet == null ? 0 : this.rw_sheet.getRowView(row).getSize();
    }

    @Override
    public int getColWidth(int col) {
        if (this.readCopy) {
            return super.getColWidth(col);
        }
        return this.rw_sheet == null ? 0 : this.rw_sheet.getColumnView(col).getSize();
    }

    @Override
    public boolean getRowAutosize(int row) {
        if (this.readCopy) {
            return super.getRowAutosize(row);
        }
        return this.rw_sheet == null ? false : this.rw_sheet.getRowView(row).isAutosize();
    }

    @Override
    public boolean getColAutosize(int col) {
        if (this.readCopy) {
            return super.getColAutosize(col);
        }
        return this.rw_sheet == null ? false : this.rw_sheet.getColumnView(col).isAutosize();
    }

    @Override
    public boolean getRowHidden(int row) {
        if (this.readCopy) {
            return super.getRowHidden(row);
        }
        return this.rw_sheet == null ? false : this.rw_sheet.getRowView(row).isHidden();
    }

    @Override
    public boolean getColHidden(int col) {
        if (this.readCopy) {
            return super.getColHidden(col);
        }
        return this.rw_sheet == null ? false : this.rw_sheet.getColumnView(col).isHidden();
    }

    @Override
    public ExcelReader.CellRange[] getMerages() {
        if (this.readCopy) {
            return super.getMerages();
        }
        if (this.rw_sheet == null) {
            return null;
        }
        Range[] ranges = this.rw_sheet.getMergedCells();
        if (ranges == null) {
            return null;
        }
        ExcelReader.CellRange[] rtn = new ExcelReader.CellRange[ranges.length];
        for (int i = 0; i < ranges.length; ++i) {
            Cell topLeft = ranges[i].getTopLeft();
            Cell bottomRight = ranges[i].getBottomRight();
            rtn[i] = new ExcelReader.CellRange(topLeft.getRow(), topLeft.getColumn(), bottomRight.getRow(), bottomRight.getColumn());
        }
        return rtn;
    }

    @Override
    public String getCellFontName(int row, int col) {
        if (this.readCopy) {
            return super.getCellFontName(row, col);
        }
        if (this.checkCell(row, col)) {
            Cell cell = this.rw_sheet.getCell(col, row);
            return cell.getCellFormat().getFont().getName();
        }
        return null;
    }

    @Override
    public int getCellFontSize(int row, int col) {
        if (this.readCopy) {
            return super.getCellFontSize(row, col);
        }
        if (this.checkCell(row, col)) {
            Cell cell = this.rw_sheet.getCell(col, row);
            return cell.getCellFormat().getFont().getPointSize();
        }
        return 0;
    }

    @Override
    public boolean getCellFontItalic(int row, int col) {
        if (this.readCopy) {
            return super.getCellFontItalic(row, col);
        }
        if (this.checkCell(row, col)) {
            Cell cell = this.rw_sheet.getCell(col, row);
            return cell.getCellFormat().getFont().isItalic();
        }
        return false;
    }

    @Override
    public int getCellFontBoldWeight(int row, int col) {
        if (this.readCopy) {
            return super.getCellFontBoldWeight(row, col);
        }
        if (this.checkCell(row, col)) {
            Cell cell = this.rw_sheet.getCell(col, row);
            return cell.getCellFormat().getFont().getBoldWeight();
        }
        return 0;
    }

    @Override
    public Colour getCellFontColor(int row, int col) {
        if (this.readCopy) {
            return super.getCellFontColor(row, col);
        }
        if (this.checkCell(row, col)) {
            Cell cell = this.rw_sheet.getCell(col, row);
            return cell.getCellFormat().getFont().getColour();
        }
        return null;
    }

    @Override
    public Colour getCellBgColor(int row, int col) {
        if (this.readCopy) {
            return super.getCellBgColor(row, col);
        }
        if (this.checkCell(row, col)) {
            Cell cell = this.rw_sheet.getCell(col, row);
            return cell.getCellFormat().getBackgroundColour();
        }
        return null;
    }

    @Override
    public Alignment getCellAlignment(int row, int col) {
        if (this.readCopy) {
            return super.getCellAlignment(row, col);
        }
        if (this.checkCell(row, col)) {
            Cell cell = this.ro_sheet.getCell(col, row);
            return cell.getCellFormat().getAlignment();
        }
        return null;
    }

    @Override
    public VerticalAlignment getCellVerticalAlignment(int row, int col) {
        if (this.readCopy) {
            return super.getCellVerticalAlignment(row, col);
        }
        if (this.checkCell(row, col)) {
            Cell cell = this.ro_sheet.getCell(col, row);
            return cell.getCellFormat().getVerticalAlignment();
        }
        return null;
    }

    public boolean addSheet(String name, int index) {
        boolean rtn = this.rw_workbook != null;
        if (rtn) {
            this.rw_sheet = this.rw_workbook.createSheet(name, index);
        }
        return rtn;
    }

    public boolean setCell(int row, int col, String content) {
        if (this.rw_sheet != null) {
            Label label = new Label(col, row, content);
            try {
                this.rw_sheet.addCell((WritableCell)label);
                return true;
            }
            catch (WriteException ex) {
                Logger.getLogger(ExcelWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public boolean setCell(int row, int col, Date date) {
        if (this.rw_sheet != null) {
            try {
                this.rw_sheet.addCell((WritableCell)new DateTime(col, row, date));
                return true;
            }
            catch (Exception ex) {
                Logger.getLogger(ExcelWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public boolean setCell(int row, int col, Date date, String format) {
        if (this.rw_sheet != null) {
            try {
                DateFormat customDateFormat = new DateFormat(format);
                this.rw_sheet.addCell((WritableCell)new DateTime(col, row, date, (CellFormat)new WritableCellFormat((DisplayFormat)customDateFormat)));
                return true;
            }
            catch (Exception ex) {
                Logger.getLogger(ExcelWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public boolean setCell(int row, int col, double value) {
        if (this.rw_sheet != null) {
            try {
                this.rw_sheet.addCell((WritableCell)new Number(col, row, value));
                return true;
            }
            catch (Exception ex) {
                Logger.getLogger(ExcelWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public boolean setCell(int row, int col, int value) {
        if (this.rw_sheet != null) {
            try {
                this.rw_sheet.addCell((WritableCell)new Number(col, row, (double)value, (CellFormat)new WritableCellFormat(NumberFormats.INTEGER)));
                return true;
            }
            catch (Exception ex) {
                Logger.getLogger(ExcelWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public boolean setCell(int row, int col, float value) {
        if (this.rw_sheet != null) {
            try {
                this.rw_sheet.addCell((WritableCell)new Number(col, row, (double)value, (CellFormat)new WritableCellFormat(NumberFormats.FLOAT)));
                return true;
            }
            catch (Exception ex) {
                Logger.getLogger(ExcelWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public boolean setRowHeight(int row, int height) {
        if (this.rw_sheet == null) {
            try {
                CellView view = this.rw_sheet.getRowView(row);
                view.setSize(height);
                this.rw_sheet.setRowView(row, view);
                return true;
            }
            catch (Exception ex) {
                Logger.getLogger(ExcelWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public boolean setColWidth(int col, int width) {
        if (this.rw_sheet != null) {
            try {
                CellView view = this.rw_sheet.getColumnView(col);
                view.setSize(width);
                this.rw_sheet.setColumnView(col, view);
                return true;
            }
            catch (Exception ex) {
                Logger.getLogger(ExcelWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public boolean setRowAutosize(int row, boolean autosize) {
        if (this.rw_sheet == null) {
            try {
                CellView view = this.rw_sheet.getRowView(row);
                view.setAutosize(autosize);
                this.rw_sheet.setRowView(row, view);
                return true;
            }
            catch (Exception ex) {
                Logger.getLogger(ExcelWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public boolean setColAutosize(int col, boolean autosize) {
        if (this.rw_sheet != null) {
            try {
                CellView view = this.rw_sheet.getColumnView(col);
                view.setAutosize(autosize);
                this.rw_sheet.setColumnView(col, view);
                return true;
            }
            catch (Exception ex) {
                Logger.getLogger(ExcelWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public boolean setRowHidden(int row, boolean hidden) {
        if (this.rw_sheet == null) {
            try {
                CellView view = this.rw_sheet.getRowView(row);
                view.setHidden(hidden);
                this.rw_sheet.setRowView(row, view);
                return true;
            }
            catch (Exception ex) {
                Logger.getLogger(ExcelWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public boolean setColHidden(int col, boolean hidden) {
        if (this.rw_sheet != null) {
            try {
                CellView view = this.rw_sheet.getColumnView(col);
                view.setHidden(hidden);
                this.rw_sheet.setColumnView(col, view);
                return true;
            }
            catch (Exception ex) {
                Logger.getLogger(ExcelWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public boolean setMerage(ExcelReader.CellRange range) {
        if (this.rw_sheet != null && range != null) {
            try {
                this.rw_sheet.mergeCells(range.col1, range.row1, range.col2, range.row2);
                return true;
            }
            catch (Exception ex) {
                Logger.getLogger(ExcelWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public boolean setUnmerage(int merageIndex) {
        if (this.rw_sheet != null) {
            try {
                Range[] ranges = this.rw_sheet.getMergedCells();
                if (merageIndex >= 0 && merageIndex < ranges.length) {
                    this.rw_sheet.unmergeCells(ranges[merageIndex]);
                    return true;
                }
            }
            catch (Exception ex) {
                Logger.getLogger(ExcelWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public boolean setCellFontName(int row, int col, String fontName) {
        if (this.rw_sheet != null) {
            WritableCell cell = this.rw_sheet.getWritableCell(col, row);
            CellFormat cf = cell.getCellFormat();
            WritableCellFormat wcf = new WritableCellFormat(cf);
            WritableFont font = fontName == null ? new WritableFont(WritableFont.ARIAL) : new WritableFont(WritableFont.createFont((String)fontName));
            wcf.setFont((FontRecord)font);
            cell.setCellFormat((CellFormat)wcf);
            return true;
        }
        return false;
    }

    public boolean setCellFontSize(int row, int col, int fontSize) {
        if (this.rw_sheet != null) {
            WritableCell cell = this.rw_sheet.getWritableCell(col, row);
            CellFormat cf = cell.getCellFormat();
            WritableCellFormat wcf = new WritableCellFormat(cf);
            WritableFont font = new WritableFont(wcf.getFont());
            try {
                font.setPointSize(fontSize <= 0 ? 10 : fontSize);
            }
            catch (WriteException ex) {
                Logger.getLogger(ExcelWriter.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            wcf.setFont((FontRecord)font);
            cell.setCellFormat((CellFormat)wcf);
            return true;
        }
        return false;
    }

    public boolean setCellFontItalic(int row, int col, boolean italic) {
        if (this.rw_sheet != null) {
            WritableCell cell = this.rw_sheet.getWritableCell(col, row);
            CellFormat cf = cell.getCellFormat();
            WritableCellFormat wcf = new WritableCellFormat(cf);
            WritableFont font = new WritableFont(wcf.getFont());
            try {
                font.setItalic(italic);
            }
            catch (WriteException ex) {
                Logger.getLogger(ExcelWriter.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            wcf.setFont((FontRecord)font);
            cell.setCellFormat((CellFormat)wcf);
            return true;
        }
        return false;
    }

    public boolean setCellFontBold(int row, int col, boolean bold) {
        if (this.rw_sheet != null) {
            WritableCell cell = this.rw_sheet.getWritableCell(col, row);
            CellFormat cf = cell.getCellFormat();
            WritableCellFormat wcf = new WritableCellFormat(cf);
            WritableFont font = new WritableFont(wcf.getFont());
            try {
                font.setBoldStyle(bold ? WritableFont.BOLD : WritableFont.NO_BOLD);
            }
            catch (WriteException ex) {
                Logger.getLogger(ExcelWriter.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            wcf.setFont((FontRecord)font);
            cell.setCellFormat((CellFormat)wcf);
            return true;
        }
        return false;
    }

    public boolean setCellFontColor(int row, int col, Colour color) {
        if (this.rw_sheet != null) {
            WritableCell cell = this.rw_sheet.getWritableCell(col, row);
            CellFormat cf = cell.getCellFormat();
            WritableCellFormat wcf = new WritableCellFormat(cf);
            WritableFont font = new WritableFont(wcf.getFont());
            try {
                font.setColour(color);
            }
            catch (WriteException ex) {
                Logger.getLogger(ExcelWriter.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            wcf.setFont((FontRecord)font);
            cell.setCellFormat((CellFormat)wcf);
            return true;
        }
        return false;
    }

    public boolean setCellBgColor(int row, int col, Colour color) {
        if (this.rw_sheet != null) {
            WritableCell cell = this.rw_sheet.getWritableCell(col, row);
            CellFormat cf = cell.getCellFormat();
            WritableCellFormat wcf = new WritableCellFormat(cf);
            try {
                wcf.setBackground(color);
            }
            catch (WriteException ex) {
                Logger.getLogger(ExcelWriter.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            cell.setCellFormat((CellFormat)wcf);
            return true;
        }
        return false;
    }

    public boolean setCellAlignment(int row, int col, Alignment alignment) {
        if (this.rw_sheet != null) {
            WritableCell cell = this.rw_sheet.getWritableCell(col, row);
            CellFormat cf = cell.getCellFormat();
            WritableCellFormat wcf = new WritableCellFormat(cf);
            try {
                wcf.setAlignment(alignment);
            }
            catch (WriteException ex) {
                Logger.getLogger(ExcelWriter.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            cell.setCellFormat((CellFormat)wcf);
            return true;
        }
        return false;
    }

    public boolean setCellVerticalAlignment(int row, int col, VerticalAlignment alignment) {
        if (this.rw_sheet != null) {
            WritableCell cell = this.rw_sheet.getWritableCell(col, row);
            CellFormat cf = cell.getCellFormat();
            WritableCellFormat wcf = new WritableCellFormat(cf);
            try {
                wcf.setVerticalAlignment(alignment);
            }
            catch (WriteException ex) {
                Logger.getLogger(ExcelWriter.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            cell.setCellFormat((CellFormat)wcf);
            return true;
        }
        return false;
    }
}

