/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.extend;

import com.modnut.framework2.json.JSONArray;
import com.modnut.framework2.json.JSONConvert;
import com.modnut.framework2.json.JSONException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ActionRecorder<T> {
    private static final Class[] BASIC = new Class[]{Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static final Class[] BASIC2 = new Class[]{Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class};
    private final ArrayList<ActionObj> actions = new ArrayList();
    private final Class clazz;

    public ActionRecorder(Class clazz) {
        this.clazz = clazz;
    }

    public void clear() {
        this.actions.clear();
    }

    public int size() {
        return this.actions.size();
    }

    public boolean record(String func, Object ... params) {
        Method method = this.findMethod(func, params);
        if (method == null) {
            return false;
        }
        String[] paramStrs = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramStrs[i] = this.convert2str(params[i]);
        }
        Class<?>[] types = method.getParameterTypes();
        String[] typeStrs = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            typeStrs[i] = types[i].toString();
        }
        this.actions.add(new ActionObj(func, paramStrs, typeStrs));
        return true;
    }

    public int play(T obj) {
        int success = 0;
        for (ActionObj action : this.actions) {
            Method method = this.findMethod(action.func, action.types);
            if (method == null) continue;
            try {
                Class<?>[] types = method.getParameterTypes();
                Object[] params = new Object[action.params.length];
                if (types.length != params.length) continue;
                for (int i = 0; i < types.length; ++i) {
                    params[i] = this.convert2obj(action.params[i], types[i]);
                }
                method.invoke(obj, params);
                ++success;
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(ActionRecorder.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(ActionRecorder.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(ActionRecorder.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return success;
    }

    public JSONArray output() {
        JSONArray actionArr = new JSONArray();
        for (ActionObj action : this.actions) {
            JSONArray actionObj = new JSONArray();
            actionObj.put(action.func);
            actionObj.put(JSONConvert.toJSONArray(action.params));
            actionObj.put(JSONConvert.toJSONArray(action.types));
            actionArr.put(actionObj);
        }
        return actionArr;
    }

    public boolean input(JSONArray data) {
        boolean success = true;
        this.actions.clear();
        for (int i = 0; i < data.length(); ++i) {
            try {
                JSONArray actionObj = data.getJsonArray(i);
                String func = actionObj.getString(0);
                JSONArray paramArr = actionObj.getJsonArray(1);
                String[] paramStrs = new String[paramArr.length()];
                for (int j = 0; j < paramArr.length(); ++j) {
                    paramStrs[j] = paramArr.getString(j);
                }
                JSONArray typeArr = actionObj.getJsonArray(2);
                String[] typeStrs = new String[typeArr.length()];
                for (int j = 0; j < typeArr.length(); ++j) {
                    typeStrs[j] = typeArr.getString(j);
                }
                this.actions.add(new ActionObj(func, paramStrs, typeStrs));
                continue;
            }
            catch (JSONException ex) {
                Logger.getLogger(ActionRecorder.class.getName()).log(Level.SEVERE, null, ex);
                success = false;
            }
        }
        return success;
    }

    protected abstract String parseObj(Object var1);

    protected abstract Object parseStr(String var1, Class var2);

    private Method findMethod(String func, Object ... params) {
        Method[] methods;
        for (Method m : methods = this.clazz.getMethods()) {
            int len2;
            Class<?>[] types;
            int len1;
            if (!m.getName().equals(func) || (len1 = (types = m.getParameterTypes()).length) != (len2 = params.length)) continue;
            if (len1 == 0) {
                return m;
            }
            boolean matched = true;
            for (int i = 0; i < len1; ++i) {
                if (this.matchParam(types[i], params[i])) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return m;
        }
        return null;
    }

    private Method findMethod(String func, String ... paramTypes) {
        Method[] methods;
        for (Method m : methods = this.clazz.getMethods()) {
            int len2;
            Class<?>[] types;
            int len1;
            if (!m.getName().equals(func) || (len1 = (types = m.getParameterTypes()).length) != (len2 = paramTypes.length)) continue;
            if (len1 == 0) {
                return m;
            }
            boolean matched = true;
            for (int i = 0; i < len1; ++i) {
                if (types[i].toString().equals(paramTypes[i])) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return m;
        }
        return null;
    }

    private boolean matchParam(Class type, Object obj) {
        if (obj == null) {
            for (Class c : BASIC) {
                if (!c.equals(type)) continue;
                return false;
            }
            return true;
        }
        if (type.equals(obj.getClass())) {
            return true;
        }
        for (int i = 0; i < BASIC.length; ++i) {
            if (!BASIC[i].equals(type) || !BASIC2[i].equals(obj.getClass())) continue;
            return true;
        }
        return false;
    }

    private String convert2str(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> c = obj.getClass();
        for (Class basic : BASIC2) {
            if (!basic.equals(c)) continue;
            return obj.toString();
        }
        if (String.class.equals(c)) {
            return (String)obj;
        }
        if (c.isArray()) {
            Class<?> type = c.getComponentType();
            if (type.equals(Character.TYPE)) {
                return new String((char[])obj);
            }
            for (Class basic : BASIC) {
                if (!basic.equals(type) || basic.equals(Character.TYPE)) continue;
                int length = Array.getLength(obj);
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(Array.get(obj, i).toString());
                }
                return sb.toString();
            }
            if (type.equals(String.class)) {
                int length = Array.getLength(obj);
                JSONArray arr = new JSONArray();
                for (int i = 0; i < length; ++i) {
                    arr.put(Array.get(obj, i));
                }
                return arr.toString();
            }
        }
        return this.parseObj(obj);
    }

    private Object convert2obj(String str, Class type) {
        if (str == null) {
            return null;
        }
        if (type.equals(Boolean.TYPE)) {
            return this.convert2boolean(str);
        }
        if (type.equals(Character.TYPE)) {
            return Character.valueOf(this.convert2char(str));
        }
        if (type.equals(Byte.TYPE)) {
            return this.convert2byte(str);
        }
        if (type.equals(Short.TYPE)) {
            return this.convert2short(str);
        }
        if (type.equals(Integer.TYPE)) {
            return this.convert2int(str);
        }
        if (type.equals(Long.TYPE)) {
            return this.convert2long(str);
        }
        if (type.equals(Float.TYPE)) {
            return Float.valueOf(this.convert2float(str));
        }
        if (type.equals(Double.TYPE)) {
            return this.convert2double(str);
        }
        if (type.equals(String.class)) {
            return str;
        }
        if (type.equals(boolean[].class)) {
            String[] strs = str.split(",");
            boolean[] arr = new boolean[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                arr[i] = this.convert2boolean(strs[i]);
            }
            return arr;
        }
        if (type.equals(char[].class)) {
            char[] arr = new char[str.length()];
            for (int i = 0; i < str.length(); ++i) {
                arr[i] = str.charAt(i);
            }
            return arr;
        }
        if (type.equals(byte[].class)) {
            String[] strs = str.split(",");
            byte[] arr = new byte[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                arr[i] = this.convert2byte(strs[i]);
            }
            return arr;
        }
        if (type.equals(short[].class)) {
            String[] strs = str.split(",");
            short[] arr = new short[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                arr[i] = this.convert2short(strs[i]);
            }
            return arr;
        }
        if (type.equals(int[].class)) {
            String[] strs = str.split(",");
            int[] arr = new int[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                arr[i] = this.convert2int(strs[i]);
            }
            return arr;
        }
        if (type.equals(long[].class)) {
            String[] strs = str.split(",");
            long[] arr = new long[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                arr[i] = this.convert2long(strs[i]);
            }
            return arr;
        }
        if (type.equals(float[].class)) {
            String[] strs = str.split(",");
            float[] arr = new float[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                arr[i] = this.convert2float(strs[i]);
            }
            return arr;
        }
        if (type.equals(double[].class)) {
            String[] strs = str.split(",");
            double[] arr = new double[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                arr[i] = this.convert2double(strs[i]);
            }
            return arr;
        }
        if (type.equals(String[].class)) {
            try {
                JSONArray arr = new JSONArray(str, true);
                String[] strs = new String[arr.length()];
                for (int i = 0; i < arr.length(); ++i) {
                    strs[i] = arr.getString(i);
                }
                return strs;
            }
            catch (JSONException ex) {
                Logger.getLogger(ActionRecorder.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }
        return this.parseStr(str, type);
    }

    private boolean convert2boolean(String str) {
        try {
            return str == null ? false : Boolean.parseBoolean(str);
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private char convert2char(String str) {
        return str == null || str.isEmpty() ? (char)'\u0000' : str.charAt(0);
    }

    private byte convert2byte(String str) {
        try {
            return str == null ? (byte)0 : Byte.parseByte(str);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    private short convert2short(String str) {
        try {
            return str == null ? (short)0 : Short.parseShort(str);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    private int convert2int(String str) {
        try {
            return str == null ? 0 : Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    private long convert2long(String str) {
        try {
            return str == null ? 0L : Long.parseLong(str);
        }
        catch (NumberFormatException ex) {
            return 0L;
        }
    }

    private float convert2float(String str) {
        try {
            return str == null ? 0.0f : Float.parseFloat(str);
        }
        catch (NumberFormatException ex) {
            return 0.0f;
        }
    }

    private double convert2double(String str) {
        try {
            return str == null ? 0.0 : Double.parseDouble(str);
        }
        catch (NumberFormatException ex) {
            return 0.0;
        }
    }

    public static class ActionObj {
        public final String func;
        public final String[] params;
        public final String[] types;

        public ActionObj(String func, String[] params, String[] types) {
            this.func = func;
            this.params = params == null ? new String[]{} : params;
            this.types = types == null ? new String[]{} : types;
        }
    }
}

