/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.draw;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class DrawCanvas {
    private final BufferedImage image;
    private Color color;
    private Font font;

    public DrawCanvas(BufferedImage image) {
        this.image = image;
        this.color = Color.BLACK;
    }

    public DrawCanvas(int width, int height) {
        this.image = new BufferedImage(width, height, 6);
        this.color = Color.BLACK;
    }

    public DrawCanvas(int width, int height, int type) {
        this.image = new BufferedImage(width, height, type);
        this.color = Color.BLACK;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public Graphics getGraphics() {
        return this.image.getGraphics();
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(int r, int g, int b) {
        this.color = new Color(r, g, b);
    }

    public void setColor(int r, int g, int b, int a) {
        this.color = new Color(r, g, b, a);
    }

    public void setColor(int color) {
        this.color = new Color(color);
    }

    public void setColor(int color, boolean hasalpha) {
        this.color = new Color(color, hasalpha);
    }

    public Color getColor() {
        return this.color;
    }

    public void setFont(String name, int style, int size) {
        this.font = new Font(name, style, size);
    }

    public void setFont(Font font) {
        if (font != null) {
            this.font = font;
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void clearRect(int x, int y, int width, int height) {
        Graphics g = this.getGraphics();
        g.clearRect(x, y, width, height);
        g.dispose();
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Graphics g = this.getGraphics();
        g.setColor(this.color);
        g.drawArc(x, y, width, height, startAngle, arcAngle);
        g.dispose();
    }

    public void drawImage(Image img, int x, int y) {
        Graphics g = this.getGraphics();
        g.drawImage(img, x, y, null);
        g.dispose();
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        Graphics g = this.getGraphics();
        g.setColor(this.color);
        g.drawLine(x1, y1, x2, y2);
        g.dispose();
    }

    public void drawOval(int x, int y, int width, int height) {
        Graphics g = this.getGraphics();
        g.setColor(this.color);
        g.drawOval(x, y, width, height);
        g.dispose();
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Graphics g = this.getGraphics();
        g.setColor(this.color);
        g.drawPolygon(xPoints, yPoints, nPoints);
        g.dispose();
    }

    public void drawRect(int x, int y, int width, int height) {
        Graphics g = this.getGraphics();
        g.setColor(this.color);
        g.drawRect(x, y, width, height);
        g.dispose();
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        Graphics g = this.getGraphics();
        g.setColor(this.color);
        g.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
        g.dispose();
    }

    public void drawString(String str, int x, int y) {
        Graphics g = this.getGraphics();
        g.setColor(this.color);
        g.setFont(this.font);
        g.drawString(str, x, y);
        g.dispose();
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Graphics g = this.getGraphics();
        g.setColor(this.color);
        g.fillArc(x, y, width, height, startAngle, arcAngle);
        g.dispose();
    }

    public void fillOval(int x, int y, int width, int height) {
        Graphics g = this.getGraphics();
        g.setColor(this.color);
        g.fillOval(x, y, width, height);
        g.dispose();
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Graphics g = this.getGraphics();
        g.setColor(this.color);
        g.fillPolygon(xPoints, yPoints, nPoints);
        g.dispose();
    }

    public void fillRect(int x, int y, int width, int height) {
        Graphics g = this.getGraphics();
        g.setColor(this.color);
        g.fillRect(x, y, width, height);
        g.dispose();
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        Graphics g = this.getGraphics();
        g.setColor(this.color);
        g.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
        g.dispose();
    }
}

