/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.draw;

import com.modnut.framework2.extend.ZXingHelper;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class DrawBill {
    private final Graphics2D g;
    private final Font defaultFont;
    public final double width;
    public final double height;
    public double cursor;
    public double space;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;

    public DrawBill(Graphics2D g, double width, double height) {
        this.g = g;
        Font font = g.getFont();
        this.defaultFont = font.deriveFont(font.getSize());
        this.width = width;
        this.height = height;
        this.cursor = 0.0;
        this.space = 0.0;
    }

    public Graphics2D getGraphics() {
        return this.g;
    }

    public double print(BufferedImage img) {
        return this.print(img, 0.0, 0.0, 0, false);
    }

    public double print(BufferedImage img, double x) {
        return this.print(img, x, 0.0, 0, false);
    }

    public double print(BufferedImage img, double x, double y) {
        return this.print(img, x, y, 0, false);
    }

    public double print(BufferedImage img, double x, double y, int align) {
        return this.print(img, x, y, align, false);
    }

    public double print(BufferedImage img, double x, double y, int align, boolean notMove) {
        if (img == null || img.getWidth() == 0 || img.getHeight() == 0) {
            return 0.0;
        }
        double left = x;
        double top = this.cursor + y;
        if (align % 3 != 0) {
            if (align % 3 == 1) {
                left -= (double)img.getWidth() / 2.0;
            } else if (align % 3 == 2) {
                left -= (double)img.getWidth();
            }
        }
        this.g.drawImage((Image)img, (int)left, (int)top, null);
        double movePos = y + (double)img.getHeight() + this.space;
        if (!notMove) {
            this.move(movePos);
        }
        return movePos;
    }

    public double print(String text) {
        return this.print(text, 0.0, 0.0, 0, false);
    }

    public double print(String text, double x) {
        return this.print(text, x, 0.0, 0, false);
    }

    public double print(String text, double x, double y) {
        return this.print(text, x, y, 0, false);
    }

    public double print(String text, double x, double y, int align) {
        return this.print(text, x, y, align, false);
    }

    public double print(String text, double x, double y, int align, boolean notMove) {
        return this.print(text, x, y, align, notMove, -1.0);
    }

    public double print(String text, double x, double y, int align, boolean notMove, double limitWidth) {
        if (text == null || text.isEmpty()) {
            return 0.0;
        }
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            Rectangle2D nextRect;
            char ch = text.charAt(i);
            if (limitWidth > 0.0 && (nextRect = this.g.getFont().getStringBounds(buff.toString() + ch, this.g.getFontRenderContext())).getWidth() > limitWidth) {
                lines.add(buff.toString());
                buff = new StringBuilder();
            }
            buff.append(ch);
        }
        lines.add(buff.toString());
        double linesHeight = 0.0;
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            Rectangle2D rect = this.g.getFont().getStringBounds(line, this.g.getFontRenderContext());
            double left = x;
            double bottom = this.cursor + y + linesHeight + rect.getHeight();
            if (align % 3 != 0) {
                if (align % 3 == 1) {
                    left -= rect.getWidth() / 2.0;
                } else if (align % 3 == 2) {
                    left -= rect.getWidth();
                }
            }
            this.g.drawString(line, (float)left, (float)bottom);
            linesHeight += rect.getHeight();
        }
        double movePos = y + linesHeight + this.space;
        if (!notMove) {
            this.move(movePos);
        }
        return movePos;
    }

    public double print(String[] texts) {
        return this.print(texts, 0, false, false);
    }

    public double print(String[] texts, int align) {
        return this.print(texts, align, false, false);
    }

    public double print(String[] texts, int align, boolean notMove) {
        return this.print(texts, align, notMove, false);
    }

    public double print(String[] texts, int align, boolean notMove, boolean limitWidth) {
        double w = this.width / (double)texts.length;
        double rtn = 0.0;
        double limit = limitWidth ? w : -1.0;
        for (int i = 0; i < texts.length; ++i) {
            double x = w * (double)i;
            if (align % 3 != 0) {
                if (align % 3 == 1) {
                    x += w / 2.0;
                } else if (align % 3 == 2) {
                    x += w;
                }
            }
            double h = this.print(texts[i], x, 0.0, align, true, limit);
            rtn = Math.max(h, rtn);
        }
        if (!notMove) {
            this.move(rtn);
        }
        return rtn;
    }

    public double printPercent(String text, int align, boolean notMove, double limitWidth) {
        double w = limitWidth >= 0.0 ? this.width * limitWidth : -1.0;
        double x = 0.0;
        if (align % 3 != 0) {
            if (align % 3 == 1) {
                x += this.width / 2.0;
            } else if (align % 3 == 2) {
                x += this.width;
            }
        }
        return this.print(text, x, 0.0, align, notMove, w);
    }

    public double printCenter(BufferedImage img) {
        return this.print(img, this.width / 2.0, 0.0, 1, false);
    }

    public double printRight(BufferedImage img) {
        return this.print(img, this.width, 0.0, 2, false);
    }

    public double printCenter(String text) {
        return this.print(text, this.width / 2.0, 0.0, 1, false);
    }

    public double printRight(String text) {
        return this.print(text, this.width, 0.0, 2, false);
    }

    public double printCenter(String[] texts) {
        return this.print(texts, 1, false);
    }

    public double printRight(String[] texts) {
        return this.print(texts, 2, false);
    }

    public double printQRcode(String content, double size, int correction) {
        return this.printCenter(ZXingHelper.encodeQRCode(content, (int)size, correction));
    }

    public double printEAN8(String content, double width, double height) {
        return this.printCenter(ZXingHelper.encodeEAN8(content, (int)width, (int)height));
    }

    public double printEAN13(String content, double width, double height) {
        return this.printCenter(ZXingHelper.encodeEAN13(content, (int)width, (int)height));
    }

    public double line(char ch) {
        return this.line(ch, false);
    }

    public double line(char ch, boolean notMove) {
        StringBuilder sb = new StringBuilder();
        Rectangle2D rect = this.g.getFont().getStringBounds(sb.toString(), this.g.getFontRenderContext());
        Rectangle2D nextRect = this.g.getFont().getStringBounds(sb.toString() + ch, this.g.getFontRenderContext());
        while (nextRect.getWidth() <= this.width) {
            rect = nextRect;
            sb.append(ch);
            nextRect = this.g.getFont().getStringBounds(sb.toString() + ch, this.g.getFontRenderContext());
        }
        this.g.drawString(sb.toString(), (float)(this.width - rect.getWidth()) / 2.0f, (float)(this.cursor + rect.getHeight()));
        if (!notMove) {
            this.move(rect.getHeight() + this.space);
        }
        return rect.getHeight();
    }

    public double move(double pos) {
        this.cursor += pos;
        return this.cursor;
    }

    public double divider(double padding) {
        this.g.drawLine((int)padding, (int)this.cursor, (int)(this.width - padding), (int)this.cursor);
        this.move(1.0 + this.space);
        return 1.0 + this.space;
    }

    public void reset() {
        this.g.setFont(this.defaultFont);
    }

    public void size(double size) {
        Font font = this.g.getFont();
        this.g.setFont(font.deriveFont((float)size));
    }

    public void size(double size, boolean bold) {
        Font font = this.g.getFont();
        if (bold) {
            this.g.setFont(font.deriveFont(1, (float)size));
        } else {
            this.g.setFont(font.deriveFont(0, (float)size));
        }
    }

    public void zoom(double zoom) {
        Font font = this.g.getFont();
        this.g.setFont(font.deriveFont((float)font.getSize() * (float)zoom));
    }

    public void zoom(double zoom, boolean bold) {
        Font font = this.g.getFont();
        if (bold) {
            this.g.setFont(font.deriveFont(1, (float)font.getSize() * (float)zoom));
        } else {
            this.g.setFont(font.deriveFont(0, (float)font.getSize() * (float)zoom));
        }
    }

    public void style(int style) {
        Font font = this.g.getFont();
        this.g.setFont(font.deriveFont(style));
    }

    public static double mm2pixel(double mm) {
        return mm / (double)0.35f;
    }

    public static double pixel2mm(double pixel) {
        return pixel * (double)0.35f;
    }
}

