/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.database;

import com.modnut.framework2.database.DBCreator;
import com.modnut.framework2.database.DBException;
import com.modnut.framework2.database.DBHelper;
import com.modnut.framework2.database.DBMulValPair;
import com.modnut.framework2.database.DBResult;
import com.modnut.framework2.database.DBStat;
import com.modnut.framework2.database.DBValPair;

public class DBTransfer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transfer(Listener listener, DBStat src, DBStat dest, DBCreator.DBTable table) {
        try {
            listener.updateStatus(0);
            if (listener.getSkip(table.name)) {
                return;
            }
            listener.updateStatus(1);
            if (!DBTransfer.exist(dest, table)) {
                DBHelper.execute(dest, DBCreator.getCreateTableSql(dest, table));
            } else if (listener.getClear()) {
                DBHelper.delete(dest, table.name, null);
            }
            if (listener.getCanceled()) {
                listener.updateStatus(-1);
                return;
            }
            listener.updateStatus(2);
            listener.updateTotal(DBHelper.count(src, table.name, null));
            if (listener.getCanceled()) {
                listener.updateStatus(-1);
                return;
            }
            listener.updateStatus(3);
            String[] queryCols = new String[table.columns.size()];
            for (int i = 0; i < table.columns.size(); ++i) {
                queryCols[i] = table.columns.get((int)i).name;
            }
            DBResult rs = DBHelper.query(src, table.name, queryCols, null, null, null);
            try {
                long count = 0L;
                while (rs.next()) {
                    DBValPair[] values = new DBValPair[table.columns.size()];
                    for (int i = 0; i < table.columns.size(); ++i) {
                        DBCreator.DBColumn col = table.columns.get(i);
                        if (col.type instanceof DBCreator.DBColumn.DateTime) {
                            values[i] = new DBValPair(col.name, rs.getTimestamp(col.name));
                            continue;
                        }
                        if (col.type instanceof DBCreator.DBColumn.Text) {
                            values[i] = new DBValPair(col.name, rs.getString(col.name));
                            continue;
                        }
                        if (col.type instanceof DBCreator.DBColumn.Numeric.INT || col.type instanceof DBCreator.DBColumn.Numeric.INTEGER || col.type instanceof DBCreator.DBColumn.Numeric.BIGINT || col.type instanceof DBCreator.DBColumn.Numeric.MEDIUMINT || col.type instanceof DBCreator.DBColumn.Numeric.SMALLINT || col.type instanceof DBCreator.DBColumn.Numeric.TINYINT) {
                            values[i] = new DBValPair(col.name, rs.getLong(col.name));
                            continue;
                        }
                        if (!(col.type instanceof DBCreator.DBColumn.Numeric)) continue;
                        values[i] = new DBValPair(col.name, rs.getDouble(col.name));
                    }
                    DBHelper.insert(dest, table.name, values);
                    if (listener.getCanceled()) {
                        listener.updateStatus(-1);
                        return;
                    }
                    listener.updateProgress(++count);
                }
            }
            finally {
                rs.close();
            }
            listener.updateStatus(4);
        }
        catch (Exception ex) {
            listener.updateStatus(-2);
            listener.solveException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transfer(Listener listener, DBStat src, DBStat dest, DBCreator.DBTable table, int pack) {
        if (pack <= 1) {
            DBTransfer.transfer(listener, src, dest, table);
            return;
        }
        try {
            listener.updateStatus(0);
            if (listener.getSkip(table.name)) {
                return;
            }
            listener.updateStatus(1);
            if (!DBTransfer.exist(dest, table)) {
                DBHelper.execute(dest, DBCreator.getCreateTableSql(dest, table));
            } else if (listener.getClear()) {
                DBHelper.delete(dest, table.name, null);
            }
            if (listener.getCanceled()) {
                listener.updateStatus(-1);
                return;
            }
            listener.updateStatus(2);
            listener.updateTotal(DBHelper.count(src, table.name, null));
            if (listener.getCanceled()) {
                listener.updateStatus(-1);
                return;
            }
            listener.updateStatus(3);
            String[] queryCols = new String[table.columns.size()];
            for (int i = 0; i < table.columns.size(); ++i) {
                queryCols[i] = table.columns.get((int)i).name;
            }
            DBResult rs = DBHelper.query(src, table.name, queryCols, null, null, null);
            try {
                DBMulValPair[] values = new DBMulValPair[table.columns.size()];
                for (int i = 0; i < table.columns.size(); ++i) {
                    values[i] = new DBMulValPair(table.columns.get((int)i).name);
                }
                long count = 0L;
                long packCount = 0L;
                while (rs.next()) {
                    for (int i = 0; i < table.columns.size(); ++i) {
                        DBCreator.DBColumn col = table.columns.get(i);
                        if (col.type instanceof DBCreator.DBColumn.DateTime) {
                            values[i].addVal(rs.getTimestamp(col.name));
                            continue;
                        }
                        if (col.type instanceof DBCreator.DBColumn.Text) {
                            values[i].addVal(rs.getString(col.name));
                            continue;
                        }
                        if (col.type instanceof DBCreator.DBColumn.Numeric.INT || col.type instanceof DBCreator.DBColumn.Numeric.INTEGER || col.type instanceof DBCreator.DBColumn.Numeric.BIGINT || col.type instanceof DBCreator.DBColumn.Numeric.MEDIUMINT || col.type instanceof DBCreator.DBColumn.Numeric.SMALLINT || col.type instanceof DBCreator.DBColumn.Numeric.TINYINT) {
                            values[i].addVal(rs.getLong(col.name));
                            continue;
                        }
                        if (col.type instanceof DBCreator.DBColumn.Numeric) {
                            values[i].addVal(rs.getDouble(col.name));
                            continue;
                        }
                        values[i].addVal(DBMulValPair.NULL.STRING);
                    }
                    ++packCount;
                    if (listener.getCanceled()) {
                        listener.updateStatus(-1);
                        return;
                    }
                    if (packCount < (long)pack) continue;
                    DBHelper.insert(dest, table.name, values);
                    listener.updateProgress(count += packCount);
                    for (DBMulValPair value : values) {
                        value.colValues.clear();
                    }
                    packCount = 0L;
                }
                if (packCount > 0L) {
                    DBHelper.insert(dest, table.name, values);
                    listener.updateProgress(count += packCount);
                }
            }
            finally {
                rs.close();
            }
            listener.updateStatus(4);
        }
        catch (Exception ex) {
            listener.updateStatus(-2);
            listener.solveException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean exist(DBStat stat, DBCreator.DBTable table) throws DBException {
        DBResult rs = DBHelper.getTables(stat, DBHelper.formatSqlStr(stat, table.name));
        try {
            boolean bl = rs.next();
            return bl;
        }
        finally {
            rs.close();
        }
    }

    public static abstract class Listener {
        public boolean getSkip(String name) {
            return false;
        }

        public boolean getCanceled() {
            return false;
        }

        public boolean getClear() {
            return false;
        }

        public abstract void updateTotal(long var1);

        public abstract void updateProgress(long var1);

        public abstract void updateStatus(int var1);

        public void solveException(Exception ex) {
        }

        public static final class STATUS {
            public static final int START = 0;
            public static final int TABLE = 1;
            public static final int COUNT = 2;
            public static final int TRANSFER = 3;
            public static final int DONE = 4;
            public static final int CANCEL = -1;
            public static final int EXCEPTION = -2;
        }
    }
}

