/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.database;

import com.modnut.framework2.database.DBCreator;
import com.modnut.framework2.database.DBException;
import com.modnut.framework2.database.DBHelper;
import com.modnut.framework2.database.DBResult;
import com.modnut.framework2.database.DBStat;
import com.modnut.framework2.str.StrAnalyer;
import com.modnut.framework2.str.StrLexer;
import java.util.ArrayList;

public class DBSolver {
    public static DBCreator.DBTable solve(DBStat stat, String name) throws DBException {
        switch (stat.getType()) {
            case 1: {
                return MYSQL.solve(stat, name);
            }
            case 5: {
                return SQLITE.solve(stat, name);
            }
        }
        throw new DBException("datebase type not supported");
    }

    public static DBCreator.DBTable solve(String sql, short type) throws DBException {
        switch (type) {
            case 1: {
                return MYSQL.solve(sql);
            }
            case 5: {
                return SQLITE.solve(sql);
            }
        }
        throw new DBException("datebase type not supported");
    }

    public static class SQLITE {
        public static DBCreator.DBTable solve(DBStat stat, String name) throws DBException {
            DBResult rs = DBHelper.fullQuery(stat, "SELECT sql FROM sqlite_master WHERE type='table' and name=" + DBHelper.formatSqlStr(stat, name));
            String sql = rs.next() ? rs.getString("sql") : null;
            rs.close();
            return SQLITE.solve(sql);
        }

        public static DBCreator.DBTable solve(String sql) throws DBException {
            try {
                return new SqliteAnalyer(new SqliteLexer(sql).getTokens()).getTable();
            }
            catch (Exception ex) {
                throw new DBException(ex);
            }
        }

        protected static class SqliteAnalyer
        extends SqlAnalyer {
            protected static final int STATE_TABLE_START = 1;
            protected static final int STATE_TABLE_DEF = 2;
            protected static final int STATE_TABLE_END = 3;
            protected DBCreator.DBTable table;

            public SqliteAnalyer(ArrayList<String> tokens) throws StrAnalyer.AnalyerException {
                super(tokens);
            }

            public DBCreator.DBTable getTable() {
                return this.table;
            }

            @Override
            protected int run(int state, String token) throws StrAnalyer.AnalyerException {
                switch (state) {
                    case 0: {
                        this.table = new DBCreator.DBTable();
                        return 1;
                    }
                    case 1: {
                        return this.tableStart();
                    }
                    case 2: {
                        return this.tableDef();
                    }
                    case 3: {
                        throw new StrAnalyer.AnalyerException("statment should be end at " + token);
                    }
                }
                throw new StrAnalyer.AnalyerException("unknow state " + state);
            }

            @Override
            protected String getName() throws StrAnalyer.AnalyerException {
                String name = this.readStr("`[\"", true);
                if (name == null) {
                    name = this.read();
                }
                return name;
            }

            protected int tableStart() throws StrAnalyer.AnalyerException {
                this.throwMatch("CREATE");
                if (this.match("TEMPORARY") || this.match("TEMP")) {
                    this.table.temp = Boolean.TRUE;
                }
                this.throwMatch("TABLE");
                if (this.match("IF NOT EXISTS".split(" "))) {
                    this.table.ifnotexist = Boolean.TRUE;
                }
                this.table.name = this.getName();
                if (this.match(".")) {
                    this.table.database = this.table.name;
                    this.table.name = this.getName();
                }
                this.throwMatch("(");
                return 2;
            }

            protected int tableDef() throws StrAnalyer.AnalyerException {
                if (this.match("CONSTRAINT")) {
                    this.read();
                }
                if (this.match("CHECK")) {
                    this.skipExpr();
                } else if (this.match("PRIMARY KEY".split(" "))) {
                    this.table.addPkColNames(this.getNames().toArray(new String[0]));
                    this.skipConflictClause();
                } else if (this.match("UNIQUE")) {
                    this.table.addUniqueColNames(this.getNames().toArray(new String[0]));
                    this.skipConflictClause();
                } else if (this.match("FOREIGN KEY".split(" "))) {
                    this.getNames();
                    this.skipRefDef();
                } else {
                    this.table.addColumn(this.getColumn());
                }
                if (this.match(",")) {
                    return 2;
                }
                if (this.match(")")) {
                    return 3;
                }
                throw new StrAnalyer.AnalyerException("expect ',' or ')' at " + this.read());
            }

            protected DBCreator.DBColumn getColumn() throws StrAnalyer.AnalyerException {
                DBCreator.DBColumn col = new DBCreator.DBColumn(this.getName(), this.getType());
                int pos = -1;
                while (!this.test(",") && !this.test(")")) {
                    if (pos == this.index) {
                        throw new StrAnalyer.AnalyerException("solve column error");
                    }
                    pos = this.index;
                    if (this.match("PRIMARY KEY".split(" "))) {
                        if (this.match("ASC") || this.match("DESC")) {
                            // empty if block
                        }
                        this.skipConflictClause();
                        this.table.addPkColNames(col.name);
                        if (!this.match("AUTO_INCREMENT")) continue;
                        col.autoinc = Boolean.TRUE;
                        continue;
                    }
                    if (this.match("NOT NULL".split(" "))) {
                        col.notnull = Boolean.TRUE;
                        this.skipConflictClause();
                        continue;
                    }
                    if (this.match("NULL")) {
                        col.notnull = Boolean.FALSE;
                        this.skipConflictClause();
                        continue;
                    }
                    if (this.match("UNIQUE")) {
                        this.table.addPkColNames(col.name);
                        this.skipConflictClause();
                        continue;
                    }
                    if (this.match("CHECK")) {
                        this.skipExpr();
                        continue;
                    }
                    if (this.match("COLLATE")) {
                        col.collate = this.read();
                        continue;
                    }
                    if (this.match("DEFAULT")) {
                        if (this.test("(")) {
                            this.skipExpr();
                            continue;
                        }
                        if (this.match("NULL")) {
                            col.defaultVal = null;
                            continue;
                        }
                        String str = this.readStr("'");
                        if (str != null) {
                            col.defaultVal = str;
                            continue;
                        }
                        str = this.read();
                        col.defaultVal = str.indexOf(46) >= 0 ? Double.parseDouble(str) : (double)Long.parseLong(str);
                        continue;
                    }
                    this.skipRefDef();
                }
                return col;
            }

            protected void skipConflictClause() throws StrAnalyer.AnalyerException {
                if (this.match("ON CONFLICT".split(" "))) {
                    this.read();
                }
            }
        }

        protected static class SqliteLexer
        extends StrLexer {
            public SqliteLexer(String str) throws StrLexer.LexerException {
                super(str);
            }

            @Override
            protected int run(int state, char ch) throws StrLexer.LexerException {
                if (this.isSpaceChar(ch)) {
                    this.next();
                } else if (this.match("/*")) {
                    this.solveComment("/*", "*/");
                } else if (this.match("--")) {
                    this.solveComment("--", "\r\n".toCharArray());
                } else if (ch == '`' || ch == '\'' || ch == '\"') {
                    this.solveCommonString();
                } else if (ch == '[') {
                    int i = this.str.indexOf(93, this.index + 1);
                    if (i >= 0) {
                        this.addToken(this.str.substring(this.index + 1, i));
                        this.index = i + 1;
                    } else {
                        this.addToken(this.str.substring(this.index + 1));
                        this.index = this.str.length();
                    }
                } else if (this.isNumChar(ch)) {
                    this.solveCommonNumber();
                } else if (this.isWordChar(ch)) {
                    this.solveCommonWord();
                } else {
                    this.addToken(ch);
                    this.next();
                }
                return 0;
            }
        }
    }

    public static class MYSQL {
        public static DBCreator.DBTable solve(DBStat stat, String name) throws DBException {
            DBResult rs = DBHelper.fullQuery(stat, "SHOW CREATE TABLE `" + name + "`");
            String sql = rs.next() ? rs.getString(2) : null;
            rs.close();
            return MYSQL.solve(sql);
        }

        public static DBCreator.DBTable solve(String sql) throws DBException {
            try {
                return new MysqlAnalyer(new MysqlLexer(sql).getTokens()).getTable();
            }
            catch (Exception ex) {
                throw new DBException(ex);
            }
        }

        protected static class MysqlAnalyer
        extends SqlAnalyer {
            protected static final int STATE_TABLE_START = 1;
            protected static final int STATE_TABLE_DEF = 2;
            protected static final int STATE_TABLE_OPTION = 3;
            protected DBCreator.DBTable table;

            public MysqlAnalyer(ArrayList<String> tokens) throws StrAnalyer.AnalyerException {
                super(tokens);
            }

            public DBCreator.DBTable getTable() {
                return this.table;
            }

            @Override
            protected int run(int state, String token) throws StrAnalyer.AnalyerException {
                switch (state) {
                    case 0: {
                        this.table = new DBCreator.DBTable();
                        return 1;
                    }
                    case 1: {
                        return this.tableStart();
                    }
                    case 2: {
                        return this.tableDef();
                    }
                    case 3: {
                        return this.tableOption();
                    }
                }
                throw new StrAnalyer.AnalyerException("unknow state " + state);
            }

            @Override
            protected void end(int state) throws StrAnalyer.AnalyerException {
                if (state != 3) {
                    this.throwIllegal();
                }
            }

            @Override
            protected String getName() throws StrAnalyer.AnalyerException {
                String name = this.readStr("`", true);
                if (name == null) {
                    name = this.read();
                }
                return name;
            }

            protected int tableStart() throws StrAnalyer.AnalyerException {
                this.throwMatch("CREATE");
                if (this.match("TEMPORARY")) {
                    this.table.temp = Boolean.TRUE;
                }
                this.throwMatch("TABLE");
                if (this.match("IF NOT EXISTS".split(" "))) {
                    this.table.ifnotexist = Boolean.TRUE;
                }
                this.table.name = this.getName();
                if (this.match(".")) {
                    this.table.database = this.table.name;
                    this.table.name = this.getName();
                }
                this.throwMatch("(");
                return 2;
            }

            protected int tableDef() throws StrAnalyer.AnalyerException {
                if (this.match("CONSTRAINT")) {
                    this.read();
                }
                if (this.match("CHECK")) {
                    this.skipExpr();
                } else if (this.match("KEY") || this.match("INDEX")) {
                    String name = this.getName();
                    String type = null;
                    if (!this.test("(")) {
                        type = this.read();
                    }
                    DBCreator.DBIndex dbindex = new DBCreator.DBIndex(name, this.getNames());
                    dbindex.type = type;
                    this.table.addIndex(dbindex);
                } else if (this.match("PRIMARY KEY".split(" "))) {
                    if (!this.test("(")) {
                        this.read();
                    }
                    this.table.addPkColNames(this.getNames().toArray(new String[0]));
                } else if (this.match("UNIQUE INDEX".split(" ")) || this.match("UNIQUE")) {
                    while (!this.test("(")) {
                        this.read();
                    }
                    this.table.addUniqueColNames(this.getNames().toArray(new String[0]));
                } else if (this.match("FOREIGN KEY".split(" "))) {
                    while (!this.test("(")) {
                        this.read();
                    }
                    this.getNames();
                    this.skipRefDef();
                } else if (this.match("FULLTEXT") || this.match("SPATIAL")) {
                    this.match("INDEX");
                    if (!this.test("(")) {
                        this.read();
                    }
                    this.getNames();
                } else {
                    this.table.addColumn(this.getColumn());
                }
                if (this.match(",")) {
                    return 2;
                }
                if (this.match(")")) {
                    return 3;
                }
                throw new StrAnalyer.AnalyerException("expect ',' or ')' at " + this.read());
            }

            protected DBCreator.DBColumn getColumn() throws StrAnalyer.AnalyerException {
                DBCreator.DBColumn col = new DBCreator.DBColumn(this.getName(), this.getType());
                int pos = -1;
                while (!this.test(",") && !this.test(")")) {
                    if (pos == this.index) {
                        throw new StrAnalyer.AnalyerException("solve column error");
                    }
                    pos = this.index;
                    if (this.match("NOT NULL".split(" "))) {
                        col.notnull = Boolean.TRUE;
                        continue;
                    }
                    if (this.match("NULL")) {
                        col.notnull = Boolean.FALSE;
                        continue;
                    }
                    if (this.match("CHARACTER SET".split(" "))) {
                        col.charset = this.read();
                        if (!this.match("COLLATE")) continue;
                        col.collate = this.read();
                        continue;
                    }
                    if (this.match("DEFAULT")) {
                        if (this.match("NULL")) {
                            col.defaultVal = null;
                            continue;
                        }
                        String str = this.readStr("'");
                        if (str != null) {
                            col.defaultVal = str;
                            continue;
                        }
                        str = this.read();
                        col.defaultVal = str.indexOf(46) >= 0 ? Double.parseDouble(str) : (double)Long.parseLong(str);
                        continue;
                    }
                    if (this.match("AUTO_INCREMENT")) {
                        col.autoinc = Boolean.TRUE;
                        continue;
                    }
                    if (this.match("UNIQUE")) {
                        if (this.match("KEY")) {
                            // empty if block
                        }
                        this.table.addPkColNames(col.name);
                        continue;
                    }
                    if (this.match("PRIMARY") || this.match("PRIMARY KEY".split(" ")) || this.match("KEY")) {
                        this.table.addPkColNames(col.name);
                        continue;
                    }
                    if (this.match("COMMENT")) {
                        col.comment = this.readStr("'");
                        continue;
                    }
                    this.skipRefDef();
                }
                return col;
            }

            protected int tableOption() throws StrAnalyer.AnalyerException {
                if (this.match("ENGINE") || this.match("TYPE")) {
                    this.throwMatch("=");
                    this.table.type = this.read();
                } else if (this.match("AUTO_INCREMENT")) {
                    this.throwMatch("=");
                    this.table.autoinc = Long.parseLong(this.read());
                } else if (this.match("AVG_ROW_LENGTH")) {
                    this.throwMatch("=");
                    this.table.avgrowlen = Long.parseLong(this.read());
                } else if (this.match("DEFAULT CHARACTER SET".split(" ")) || this.match("CHARACTER SET".split(" "))) {
                    this.table.charset = this.read();
                    if (this.match("COLLATE")) {
                        this.table.collation = this.read();
                    }
                } else if (this.match("DEFAULT CHARSET".split(" "))) {
                    this.throwMatch("=");
                    this.table.charset = this.read();
                    if (this.match("COLLATE")) {
                        this.table.collation = this.read();
                    }
                } else if (this.match("CHECKSUM")) {
                    this.throwMatch("=");
                    this.table.checksum = Long.parseLong(this.read()) > 0L;
                } else if (this.match("COMMENT")) {
                    this.throwMatch("=");
                    this.table.comment = this.readStr('\'');
                } else if (this.match("CONNECTION")) {
                    this.throwMatch("=");
                    this.readStr('\'');
                } else if (this.match("ROW_FORMAT")) {
                    this.throwMatch("=");
                    this.table.rowformat = this.read();
                } else if (this.match("CONNECTION") || this.match("MAX_ROWS") || this.match("MIN_ROWS") || this.match("PACK_KEYS") || this.match("PASSWORD") || this.match("DELAY_KEY_WRITE") || this.match("INSERT_METHOD") || this.match("DATA DIRECTORY".split(" ")) || this.match("INDEX DIRECTORY".split(" "))) {
                    this.throwMatch("=");
                    this.read();
                } else if (this.match("UNION")) {
                    this.throwMatch("=");
                    this.throwMatch("(");
                    while (!this.match(")")) {
                    }
                } else {
                    throw new StrAnalyer.AnalyerException("unknow table option " + this.read());
                }
                return 3;
            }
        }

        protected static class MysqlLexer
        extends StrLexer {
            public MysqlLexer(String str) throws StrLexer.LexerException {
                super(str);
            }

            @Override
            protected int run(int state, char ch) throws StrLexer.LexerException {
                if (this.isSpaceChar(ch)) {
                    this.next();
                } else if (this.match("/*")) {
                    this.solveComment("/*", "*/");
                } else if (this.match("--")) {
                    this.solveComment("--", "\r\n".toCharArray());
                } else if (ch == '`' || ch == '\'' || ch == '\"') {
                    this.solveCommonString();
                } else if (this.isNumChar(ch)) {
                    this.solveCommonNumber();
                } else if (this.isWordChar(ch)) {
                    this.solveCommonWord();
                } else {
                    this.addToken(ch);
                    this.next();
                }
                return 0;
            }
        }
    }

    protected static abstract class SqlAnalyer
    extends StrAnalyer {
        public SqlAnalyer(ArrayList<String> tokens) throws StrAnalyer.AnalyerException {
            super(tokens);
        }

        protected String getName() throws StrAnalyer.AnalyerException {
            return this.read();
        }

        protected NumPair getNumPair() throws StrAnalyer.AnalyerException {
            if (this.match("(")) {
                NumPair nums = new NumPair();
                nums.m = new Integer(this.read());
                if (this.match(",")) {
                    nums.n = new Integer(this.read());
                }
                this.throwMatch(")");
                return nums;
            }
            return null;
        }

        protected ArrayList<String> getNames() throws StrAnalyer.AnalyerException {
            if (this.match("(")) {
                ArrayList<String> names = new ArrayList<String>();
                names.add(this.getName());
                if (this.match("ASC") || this.match("DESC")) {
                    // empty if block
                }
                while (this.match(",")) {
                    names.add(this.getName());
                }
                this.throwMatch(")");
                return names;
            }
            return null;
        }

        protected DBCreator.DBColumn.DataType getType() throws StrAnalyer.AnalyerException {
            String typeStr = this.read();
            NumPair nums = this.getNumPair();
            return this.getType(typeStr, nums);
        }

        protected DBCreator.DBColumn.DataType getType(String typeStr, NumPair nums) throws StrAnalyer.AnalyerException {
            DBCreator.DBColumn.DataType type;
            if (SqlAnalyer.strEqual("BIT", typeStr)) {
                DBCreator.DBColumn.Numeric.BIT t = nums != null && nums.m != null ? new DBCreator.DBColumn.Numeric.BIT(nums.m) : new DBCreator.DBColumn.Numeric.BIT();
                type = t;
            } else if (SqlAnalyer.strEqual("TINYINT", typeStr)) {
                DBCreator.DBColumn.Numeric.TINYINT t = nums != null && nums.m != null ? new DBCreator.DBColumn.Numeric.TINYINT(nums.m) : new DBCreator.DBColumn.Numeric.TINYINT();
                if (this.match("UNSIGNED")) {
                    t.unsigned = Boolean.TRUE;
                }
                if (this.match("ZEROFILL")) {
                    t.zerofill = Boolean.TRUE;
                }
                type = t;
            } else if (SqlAnalyer.strEqual("SMALLINT", typeStr)) {
                DBCreator.DBColumn.Numeric.SMALLINT t = nums != null && nums.m != null ? new DBCreator.DBColumn.Numeric.SMALLINT(nums.m) : new DBCreator.DBColumn.Numeric.SMALLINT();
                if (this.match("UNSIGNED")) {
                    t.unsigned = Boolean.TRUE;
                }
                if (this.match("ZEROFILL")) {
                    t.zerofill = Boolean.TRUE;
                }
                type = t;
            } else if (SqlAnalyer.strEqual("MEDIUMINT", typeStr)) {
                DBCreator.DBColumn.Numeric.MEDIUMINT t = nums != null && nums.m != null ? new DBCreator.DBColumn.Numeric.MEDIUMINT(nums.m) : new DBCreator.DBColumn.Numeric.MEDIUMINT();
                if (this.match("UNSIGNED")) {
                    t.unsigned = Boolean.TRUE;
                }
                if (this.match("ZEROFILL")) {
                    t.zerofill = Boolean.TRUE;
                }
                type = t;
            } else if (SqlAnalyer.strEqual("INT", typeStr)) {
                DBCreator.DBColumn.Numeric.INT t = nums != null && nums.m != null ? new DBCreator.DBColumn.Numeric.INT(nums.m) : new DBCreator.DBColumn.Numeric.INT();
                if (this.match("UNSIGNED")) {
                    t.unsigned = Boolean.TRUE;
                }
                if (this.match("ZEROFILL")) {
                    t.zerofill = Boolean.TRUE;
                }
                type = t;
            } else if (SqlAnalyer.strEqual("INTEGER", typeStr)) {
                DBCreator.DBColumn.Numeric.INTEGER t = nums != null && nums.m != null ? new DBCreator.DBColumn.Numeric.INTEGER(nums.m) : new DBCreator.DBColumn.Numeric.INTEGER();
                if (this.match("UNSIGNED")) {
                    t.unsigned = Boolean.TRUE;
                }
                if (this.match("ZEROFILL")) {
                    t.zerofill = Boolean.TRUE;
                }
                type = t;
            } else if (SqlAnalyer.strEqual("BIGINT", typeStr)) {
                DBCreator.DBColumn.Numeric.BIGINT t = nums != null && nums.m != null ? new DBCreator.DBColumn.Numeric.BIGINT(nums.m) : new DBCreator.DBColumn.Numeric.BIGINT();
                if (this.match("UNSIGNED")) {
                    t.unsigned = Boolean.TRUE;
                }
                if (this.match("ZEROFILL")) {
                    t.zerofill = Boolean.TRUE;
                }
                type = t;
            } else if (SqlAnalyer.strEqual("REAL", typeStr)) {
                DBCreator.DBColumn.Numeric.REAL t = nums != null && nums.m != null && nums.n != null ? new DBCreator.DBColumn.Numeric.REAL(nums.m, nums.n) : new DBCreator.DBColumn.Numeric.REAL();
                if (this.match("UNSIGNED")) {
                    t.unsigned = Boolean.TRUE;
                }
                if (this.match("ZEROFILL")) {
                    t.zerofill = Boolean.TRUE;
                }
                type = t;
            } else if (SqlAnalyer.strEqual("DOUBLE", typeStr)) {
                DBCreator.DBColumn.Numeric.DOUBLE t = nums != null && nums.m != null && nums.n != null ? new DBCreator.DBColumn.Numeric.DOUBLE(nums.m, nums.n) : new DBCreator.DBColumn.Numeric.DOUBLE();
                if (this.match("UNSIGNED")) {
                    t.unsigned = Boolean.TRUE;
                }
                if (this.match("ZEROFILL")) {
                    t.zerofill = Boolean.TRUE;
                }
                type = t;
            } else if (SqlAnalyer.strEqual("FLOAT", typeStr)) {
                DBCreator.DBColumn.Numeric.FLOAT t = nums != null && nums.m != null && nums.n != null ? new DBCreator.DBColumn.Numeric.FLOAT(nums.m, nums.n) : new DBCreator.DBColumn.Numeric.FLOAT();
                if (this.match("UNSIGNED")) {
                    t.unsigned = Boolean.TRUE;
                }
                if (this.match("ZEROFILL")) {
                    t.zerofill = Boolean.TRUE;
                }
                type = t;
            } else if (SqlAnalyer.strEqual("DECIMAL", typeStr)) {
                DBCreator.DBColumn.Numeric.DECIMAL t;
                if (nums != null && nums.m != null && nums.n != null) {
                    t = new DBCreator.DBColumn.Numeric.DECIMAL(nums.m, nums.n);
                } else if (nums != null && nums.m != null && nums.n == null) {
                    t = new DBCreator.DBColumn.Numeric.DECIMAL(nums.m, 0);
                } else {
                    throw new StrAnalyer.AnalyerException("DECIMAL type needs length and decimals");
                }
                if (this.match("UNSIGNED")) {
                    t.unsigned = Boolean.TRUE;
                }
                if (this.match("ZEROFILL")) {
                    t.zerofill = Boolean.TRUE;
                }
                type = t;
            } else if (SqlAnalyer.strEqual("NUMERIC", typeStr)) {
                DBCreator.DBColumn.Numeric.NUMERIC t;
                if (nums != null && nums.m != null && nums.n != null) {
                    t = new DBCreator.DBColumn.Numeric.NUMERIC(nums.m, nums.n);
                } else if (nums != null && nums.m != null && nums.n == null) {
                    t = new DBCreator.DBColumn.Numeric.NUMERIC(nums.m, 0);
                } else {
                    throw new StrAnalyer.AnalyerException("NUMERIC type needs length and decimals");
                }
                if (this.match("UNSIGNED")) {
                    t.unsigned = Boolean.TRUE;
                }
                if (this.match("ZEROFILL")) {
                    t.zerofill = Boolean.TRUE;
                }
                type = t;
            } else if (SqlAnalyer.strEqual("DATE", typeStr)) {
                type = new DBCreator.DBColumn.DateTime.DATE();
            } else if (SqlAnalyer.strEqual("TIME", typeStr)) {
                type = new DBCreator.DBColumn.DateTime.TIME();
            } else if (SqlAnalyer.strEqual("TIMESTAMP", typeStr)) {
                type = new DBCreator.DBColumn.DateTime.TIMESTAMP();
            } else if (SqlAnalyer.strEqual("DATETIME", typeStr)) {
                type = new DBCreator.DBColumn.DateTime.DATETIME();
            } else if (SqlAnalyer.strEqual("CHAR", typeStr) || SqlAnalyer.strEqual("NCHAR", typeStr)) {
                if (nums == null || nums.m == null) {
                    throw new StrAnalyer.AnalyerException("CHAR type needs length");
                }
                DBCreator.DBColumn.Text.CHAR t = new DBCreator.DBColumn.Text.CHAR(nums.m);
                if (this.match("BINARY")) {
                    t.binary = Boolean.TRUE;
                }
                if (this.match("ASCII")) {
                    t.ascii = Boolean.TRUE;
                }
                if (this.match("UNICODE")) {
                    t.unicode = Boolean.TRUE;
                }
                type = t;
            } else if (SqlAnalyer.strEqual("VARCHAR", typeStr) || SqlAnalyer.strEqual("NVARCHAR", typeStr)) {
                if (nums == null || nums.m == null) {
                    throw new StrAnalyer.AnalyerException("VARCHAR type needs length");
                }
                DBCreator.DBColumn.Text.VARCHAR t = new DBCreator.DBColumn.Text.VARCHAR(nums.m);
                if (this.match("BINARY")) {
                    t.binary = Boolean.TRUE;
                }
                type = t;
            } else if (SqlAnalyer.strEqual("TINYBLOB", typeStr)) {
                type = new DBCreator.DBColumn.Text.TINYBLOB();
            } else if (SqlAnalyer.strEqual("TINYBLOB", typeStr)) {
                type = new DBCreator.DBColumn.Text.TINYBLOB();
            } else if (SqlAnalyer.strEqual("TINYBLOB", typeStr)) {
                type = new DBCreator.DBColumn.Text.TINYBLOB();
            } else if (SqlAnalyer.strEqual("TINYBLOB", typeStr)) {
                type = new DBCreator.DBColumn.Text.TINYBLOB();
            } else if (SqlAnalyer.strEqual("TINYTEXT", typeStr)) {
                DBCreator.DBColumn.Text.TINYTEXT t = new DBCreator.DBColumn.Text.TINYTEXT();
                if (this.match("BINARY")) {
                    t.binary = Boolean.TRUE;
                }
                type = t;
            } else if (SqlAnalyer.strEqual("TEXT", typeStr) || SqlAnalyer.strEqual("NTEXT", typeStr)) {
                DBCreator.DBColumn.Text.TEXT t = new DBCreator.DBColumn.Text.TEXT();
                if (this.match("BINARY")) {
                    t.binary = Boolean.TRUE;
                }
                type = t;
            } else if (SqlAnalyer.strEqual("MEDIUMTEXT", typeStr)) {
                DBCreator.DBColumn.Text.MEDIUMTEXT t = new DBCreator.DBColumn.Text.MEDIUMTEXT();
                if (this.match("BINARY")) {
                    t.binary = Boolean.TRUE;
                }
                type = t;
            } else if (SqlAnalyer.strEqual("LONGTEXT", typeStr)) {
                DBCreator.DBColumn.Text.LONGTEXT t = new DBCreator.DBColumn.Text.LONGTEXT();
                if (this.match("BINARY")) {
                    t.binary = Boolean.TRUE;
                }
                type = t;
            } else if (SqlAnalyer.strEqual("MONEY", typeStr)) {
                type = new DBCreator.DBColumn.Numeric.DECIMAL(15, 4);
            } else if (SqlAnalyer.strEqual("SMALLMONEY", typeStr)) {
                type = new DBCreator.DBColumn.Numeric.DECIMAL(6, 4);
            } else {
                throw new StrAnalyer.AnalyerException("unsupported data type " + typeStr);
            }
            return type;
        }

        protected void skipExpr() throws StrAnalyer.AnalyerException {
            int stack = 0;
            this.throwMatch("(");
            while (stack > 0 || !this.match(")")) {
                if (this.match("(")) {
                    ++stack;
                    continue;
                }
                if (this.match(")")) {
                    --stack;
                    continue;
                }
                this.next();
            }
        }

        protected void skipRefDef() throws StrAnalyer.AnalyerException {
            if (this.match("REFERENCES")) {
                this.read();
                this.getNames();
                while (!this.test(",") && !this.test(")")) {
                    this.read();
                }
            }
        }

        protected static class NumPair {
            public Integer m;
            public Integer n;

            protected NumPair() {
            }
        }
    }
}

