/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.database;

import com.modnut.framework2.database.DBException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBResult {
    private ResultSet rs;
    private short type;

    public DBResult(ResultSet rs) throws DBException {
        if (rs == null) {
            throw new DBException("result set is null");
        }
        this.rs = rs;
        this.type = 0;
    }

    public DBResult(ResultSet rs, short type) throws DBException {
        if (rs == null) {
            throw new DBException("result set is null");
        }
        this.rs = rs;
        this.type = type;
    }

    public synchronized ResultSet getOrigin() {
        return this.rs;
    }

    public short getType() {
        return this.type;
    }

    public boolean isClosed() throws DBException {
        try {
            return this.getOrigin().isClosed();
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
        catch (AbstractMethodError ex) {
            return false;
        }
    }

    public void close() throws DBException {
        if (!this.isClosed()) {
            try {
                this.getOrigin().close();
            }
            catch (SQLException ex) {
                throw new DBException(ex);
            }
        }
    }

    public boolean first() throws DBException {
        try {
            return this.getOrigin().first();
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public boolean last() throws DBException {
        try {
            return this.getOrigin().last();
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public boolean absolute(int row) throws DBException {
        try {
            return this.getOrigin().absolute(row);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public boolean next() throws DBException {
        try {
            return this.getOrigin().next();
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public int getRow() throws DBException {
        try {
            return this.getOrigin().getRow();
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public boolean isNull(String columnLabel) throws DBException {
        try {
            this.getObject(columnLabel);
            return this.getOrigin().wasNull();
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public boolean isNull(int columnIndex) throws DBException {
        try {
            this.getObject(columnIndex);
            return this.getOrigin().wasNull();
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public Object getObject(String columnLabel, Object defaultVal) throws DBException {
        try {
            Object value = this.getObject(columnLabel);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public Object getObject(int columnIndex, Object defaultVal) throws DBException {
        try {
            Object value = this.getObject(columnIndex);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public boolean getBoolean(String columnLabel, boolean defaultVal) throws DBException {
        try {
            boolean value = this.getBoolean(columnLabel);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public boolean getBoolean(int columnIndex, boolean defaultVal) throws DBException {
        try {
            boolean value = this.getBoolean(columnIndex);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public byte getByte(String columnLabel, byte defaultVal) throws DBException {
        try {
            byte value = this.getByte(columnLabel);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public byte getByte(int columnIndex, byte defaultVal) throws DBException {
        try {
            byte value = this.getByte(columnIndex);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public short getShort(String columnLabel, short defaultVal) throws DBException {
        try {
            short value = this.getShort(columnLabel);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public short getShort(int columnIndex, short defaultVal) throws DBException {
        try {
            short value = this.getShort(columnIndex);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public int getInt(String columnLabel, int defaultVal) throws DBException {
        try {
            int value = this.getInt(columnLabel);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public int getInt(int columnIndex, int defaultVal) throws DBException {
        try {
            int value = this.getInt(columnIndex);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public long getLong(String columnLabel, long defaultVal) throws DBException {
        try {
            long value = this.getLong(columnLabel);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public long getLong(int columnIndex, long defaultVal) throws DBException {
        try {
            long value = this.getLong(columnIndex);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public float getFloat(String columnLabel, float defaultVal) throws DBException {
        try {
            float value = this.getFloat(columnLabel);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public float getFloat(int columnIndex, float defaultVal) throws DBException {
        try {
            float value = this.getFloat(columnIndex);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public double getDouble(String columnLabel, double defaultVal) throws DBException {
        try {
            double value = this.getDouble(columnLabel);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public double getDouble(int columnIndex, double defaultVal) throws DBException {
        try {
            double value = this.getDouble(columnIndex);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public String getString(String columnLabel, String defaultVal) throws DBException {
        try {
            String value = this.getString(columnLabel);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public String getString(int columnIndex, String defaultVal) throws DBException {
        try {
            String value = this.getString(columnIndex);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public Date getDate(String columnLabel, Date defaultVal) throws DBException {
        try {
            Date value = this.getDate(columnLabel);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public Date getDate(int columnIndex, Date defaultVal) throws DBException {
        try {
            Date value = this.getDate(columnIndex);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public Time getTime(String columnLabel, Time defaultVal) throws DBException {
        try {
            Time value = this.getTime(columnLabel);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public Time getTime(int columnIndex, Time defaultVal) throws DBException {
        try {
            Time value = this.getTime(columnIndex);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public Timestamp getTimestamp(String columnLabel, Timestamp defaultVal) throws DBException {
        try {
            Timestamp value = this.getTimestamp(columnLabel);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public Timestamp getTimestamp(int columnIndex, Timestamp defaultVal) throws DBException {
        try {
            Timestamp value = this.getTimestamp(columnIndex);
            return this.getOrigin().wasNull() ? defaultVal : value;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public Object getObject(String columnLabel) throws DBException {
        try {
            return this.getOrigin().getObject(columnLabel);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public Object getObject(int columnIndex) throws DBException {
        try {
            return this.getOrigin().getObject(columnIndex);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public boolean getBoolean(String columnLabel) throws DBException {
        try {
            return this.getOrigin().getBoolean(columnLabel);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public boolean getBoolean(int columnIndex) throws DBException {
        try {
            return this.getOrigin().getBoolean(columnIndex);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public byte getByte(String columnLabel) throws DBException {
        try {
            return this.getOrigin().getByte(columnLabel);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public byte getByte(int columnIndex) throws DBException {
        try {
            return this.getOrigin().getByte(columnIndex);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public short getShort(String columnLabel) throws DBException {
        try {
            return this.getOrigin().getShort(columnLabel);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public short getShort(int columnIndex) throws DBException {
        try {
            return this.getOrigin().getShort(columnIndex);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public int getInt(String columnLabel) throws DBException {
        try {
            return this.getOrigin().getInt(columnLabel);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public int getInt(int columnIndex) throws DBException {
        try {
            return this.getOrigin().getInt(columnIndex);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public long getLong(String columnLabel) throws DBException {
        try {
            return this.getOrigin().getLong(columnLabel);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public long getLong(int columnIndex) throws DBException {
        try {
            return this.getOrigin().getLong(columnIndex);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public float getFloat(String columnLabel) throws DBException {
        try {
            return this.getOrigin().getFloat(columnLabel);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public float getFloat(int columnIndex) throws DBException {
        try {
            return this.getOrigin().getFloat(columnIndex);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public double getDouble(String columnLabel) throws DBException {
        try {
            return this.getOrigin().getDouble(columnLabel);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public double getDouble(int columnIndex) throws DBException {
        try {
            return this.getOrigin().getDouble(columnIndex);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public String getString(String columnLabel) throws DBException {
        try {
            return this.getOrigin().getString(columnLabel);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public String getString(int columnIndex) throws DBException {
        try {
            return this.getOrigin().getString(columnIndex);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public Date getDate(String columnLabel) throws DBException {
        try {
            if (this.type == 5) {
                String dateStr = this.getOrigin().getString(columnLabel);
                return dateStr == null ? null : new Date(this.parseSQLiteDate(dateStr));
            }
            return this.getOrigin().getDate(columnLabel);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public Date getDate(int columnIndex) throws DBException {
        try {
            if (this.type == 5) {
                String dateStr = this.getOrigin().getString(columnIndex);
                return dateStr == null ? null : new Date(this.parseSQLiteDate(dateStr));
            }
            return this.getOrigin().getDate(columnIndex);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public Time getTime(String columnLabel) throws DBException {
        try {
            if (this.type == 5) {
                String dateStr = this.getOrigin().getString(columnLabel);
                return dateStr == null ? null : new Time(this.parseSQLiteDate(dateStr));
            }
            return this.getOrigin().getTime(columnLabel);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public Time getTime(int columnIndex) throws DBException {
        try {
            if (this.type == 5) {
                String dateStr = this.getOrigin().getString(columnIndex);
                return dateStr == null ? null : new Time(this.parseSQLiteDate(dateStr));
            }
            return this.getOrigin().getTime(columnIndex);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public Timestamp getTimestamp(String columnLabel) throws DBException {
        try {
            if (this.type == 5) {
                String dateStr = this.getOrigin().getString(columnLabel);
                return dateStr == null ? null : new Timestamp(this.parseSQLiteDate(dateStr));
            }
            return this.getOrigin().getTimestamp(columnLabel);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public Timestamp getTimestamp(int columnIndex) throws DBException {
        try {
            if (this.type == 5) {
                String dateStr = this.getOrigin().getString(columnIndex);
                return dateStr == null ? null : new Timestamp(this.parseSQLiteDate(dateStr));
            }
            return this.getOrigin().getTimestamp(columnIndex);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public Reader getCharacterStream(String columnLabel) throws DBException {
        try {
            return this.getOrigin().getCharacterStream(columnLabel);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public Reader getCharacterStream(int columnIndex) throws DBException {
        try {
            return this.getOrigin().getCharacterStream(columnIndex);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public InputStream getBinaryStream(String columnLabel) throws DBException {
        try {
            return this.getOrigin().getBinaryStream(columnLabel);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public InputStream getBinaryStream(int columnIndex) throws DBException {
        try {
            return this.getOrigin().getBinaryStream(columnIndex);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public byte[] getBytes(String columnLabel) throws DBException {
        try {
            return this.getOrigin().getBytes(columnLabel);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public byte[] getBytes(int columnIndex) throws DBException {
        try {
            return this.getOrigin().getBytes(columnIndex);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    private long parseSQLiteDate(String dateStr) throws DBException {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return format.parse(dateStr).getTime();
        }
        catch (ParseException ex) {
            Logger.getLogger(DBResult.class.getName()).log(Level.SEVERE, null, ex);
            throw new DBException("parse SQLite datetime failed");
        }
    }
}

