/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.database;

import com.modnut.framework2.database.DB2Helper;
import com.modnut.framework2.database.DBException;
import com.modnut.framework2.database.DBLiteHelper;
import com.modnut.framework2.database.DBMSHelper;
import com.modnut.framework2.database.DBMulValPair;
import com.modnut.framework2.database.DBMyHelper;
import com.modnut.framework2.database.DBOraHelper;
import com.modnut.framework2.database.DBResult;
import com.modnut.framework2.database.DBStat;
import com.modnut.framework2.database.DBValPair;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;

public class DBHelper {
    private static final String ROWNUM_COLNAME = "RN";

    public static DBResult getTables(DBStat stat) throws DBException {
        return DBHelper.getTables(stat, null, null);
    }

    public static DBResult getTables(DBStat stat, String likeStr) throws DBException {
        return DBHelper.getTables(stat, likeStr, null);
    }

    public static DBResult getTables(DBStat stat, String likeStr, String dbOrOwner) throws DBException {
        try {
            switch (stat.getType()) {
                case 1: {
                    return new DBResult(DBMyHelper.getTables(stat.getOrigin(), likeStr, dbOrOwner));
                }
                case 2: {
                    return new DBResult(DBMSHelper.getTables(stat.getOrigin(), likeStr, dbOrOwner));
                }
                case 3: {
                    return new DBResult(DBOraHelper.getTables(stat.getOrigin(), likeStr, dbOrOwner));
                }
                case 4: {
                    return new DBResult(DB2Helper.getTables(stat.getOrigin(), likeStr, dbOrOwner));
                }
                case 5: {
                    return new DBResult(DBLiteHelper.getTables(stat.getOrigin(), likeStr));
                }
            }
            throw new DBException("statement type not supported");
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public static String formatSqlStr(DBStat stat, String str) throws DBException {
        switch (stat.getType()) {
            case 1: {
                return DBMyHelper.formatSqlStr(str);
            }
            case 2: {
                return DBMSHelper.formatSqlStr(str);
            }
            case 3: {
                return DBOraHelper.formatSqlStr(str);
            }
            case 4: {
                return DB2Helper.formatSqlStr(str);
            }
            case 5: {
                return DBLiteHelper.formatSqlStr(str);
            }
        }
        throw new DBException("statement type not supported");
    }

    public static String createSearchStr(DBStat stat, String str) throws DBException {
        return DBHelper.createSearchStr(stat, str, false, false);
    }

    public static String createPrefixSearchStr(DBStat stat, String str) throws DBException {
        return DBHelper.createSearchStr(stat, str, true, false);
    }

    public static String createSuffixSearchStr(DBStat stat, String str) throws DBException {
        return DBHelper.createSearchStr(stat, str, false, true);
    }

    public static String createSearchStr(DBStat stat, String str, boolean prefix, boolean suffix) throws DBException {
        switch (stat.getType()) {
            case 1: {
                return DBMyHelper.createSearchStr(str, prefix, suffix);
            }
            case 2: {
                return DBMSHelper.createSearchStr(str, prefix, suffix);
            }
            case 3: {
                return DBOraHelper.createSearchStr(str, prefix, suffix);
            }
            case 4: {
                return DB2Helper.createSearchStr(str, prefix, suffix);
            }
            case 5: {
                return DBLiteHelper.createSearchStr(str, prefix, suffix);
            }
        }
        throw new DBException("statement type not supported");
    }

    public static String buildQuery(DBStat stat, String tbName, String[] colNames, String whereStr, String groupStr, String orderStr) throws DBException {
        switch (stat.getType()) {
            case 1: {
                return DBMyHelper.buildQuery(tbName, colNames, whereStr, groupStr, orderStr, null);
            }
            case 2: {
                return DBMSHelper.buildQuery(tbName, colNames, whereStr, groupStr, orderStr, null);
            }
            case 3: {
                return DBOraHelper.buildQuery(tbName, colNames, whereStr, groupStr, orderStr);
            }
            case 4: {
                return DB2Helper.buildQuery(tbName, colNames, whereStr, groupStr, orderStr);
            }
            case 5: {
                return DBLiteHelper.buildQuery(tbName, colNames, whereStr, groupStr, orderStr, null);
            }
        }
        throw new DBException("statement type not supported");
    }

    public static String buildSubQuery(DBStat stat, String tbName, String colName, String whereStr, String groupStr, String orderStr) throws DBException {
        switch (stat.getType()) {
            case 1: {
                return DBMyHelper.buildSubQuery(tbName, colName, whereStr, groupStr, orderStr, null);
            }
            case 2: {
                return DBMSHelper.buildSubQuery(tbName, colName, whereStr, groupStr, orderStr, null);
            }
            case 3: {
                return DBOraHelper.buildSubQuery(tbName, colName, whereStr, groupStr, orderStr);
            }
            case 4: {
                return DB2Helper.buildSubQuery(tbName, colName, whereStr, groupStr, orderStr);
            }
            case 5: {
                return DBLiteHelper.buildSubQuery(tbName, colName, whereStr, groupStr, orderStr, null);
            }
        }
        throw new DBException("statement type not supported");
    }

    public static String inList(DBStat stat, boolean[] nums) throws DBException {
        StringBuilder sb = new StringBuilder("(");
        if (nums == null || nums.length == 0) {
            sb.append(DBHelper.formatSqlStr(stat, null));
        } else {
            for (int i = 0; i < nums.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(nums[i]);
            }
        }
        return sb.append(")").toString();
    }

    public static String inList(DBStat stat, short[] nums) throws DBException {
        StringBuilder sb = new StringBuilder("(");
        if (nums == null || nums.length == 0) {
            sb.append(DBHelper.formatSqlStr(stat, null));
        } else {
            for (int i = 0; i < nums.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(nums[i]);
            }
        }
        return sb.append(")").toString();
    }

    public static String inList(DBStat stat, int[] nums) throws DBException {
        StringBuilder sb = new StringBuilder("(");
        if (nums == null || nums.length == 0) {
            sb.append(DBHelper.formatSqlStr(stat, null));
        } else {
            for (int i = 0; i < nums.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(nums[i]);
            }
        }
        return sb.append(")").toString();
    }

    public static String inList(DBStat stat, long[] nums) throws DBException {
        StringBuilder sb = new StringBuilder("(");
        if (nums == null || nums.length == 0) {
            sb.append(DBHelper.formatSqlStr(stat, null));
        } else {
            for (int i = 0; i < nums.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(nums[i]);
            }
        }
        return sb.append(")").toString();
    }

    public static String inList(DBStat stat, float[] nums) throws DBException {
        StringBuilder sb = new StringBuilder("(");
        if (nums == null || nums.length == 0) {
            sb.append(DBHelper.formatSqlStr(stat, null));
        } else {
            for (int i = 0; i < nums.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(nums[i]);
            }
        }
        return sb.append(")").toString();
    }

    public static String inList(DBStat stat, double[] nums) throws DBException {
        StringBuilder sb = new StringBuilder("(");
        if (nums == null || nums.length == 0) {
            sb.append(DBHelper.formatSqlStr(stat, null));
        } else {
            for (int i = 0; i < nums.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(nums[i]);
            }
        }
        return sb.append(")").toString();
    }

    public static String inList(DBStat stat, String[] strs) throws DBException {
        StringBuilder sb = new StringBuilder("(");
        if (strs == null || strs.length == 0) {
            sb.append(DBHelper.formatSqlStr(stat, null));
        } else {
            for (int i = 0; i < strs.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(DBHelper.formatSqlStr(stat, strs[i]));
            }
        }
        return sb.append(")").toString();
    }

    public static String inList(DBStat stat, ArrayList<String> list) throws DBException {
        StringBuilder sb = new StringBuilder("(");
        if (list == null || list.isEmpty()) {
            sb.append(DBHelper.formatSqlStr(stat, null));
        } else {
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(DBHelper.formatSqlStr(stat, list.get(i)));
            }
        }
        return sb.append(")").toString();
    }

    public static String funcSum(DBStat stat, String param, String colName) throws DBException {
        switch (stat.getType()) {
            case 1: {
                return DBMyHelper.funcSum(param, colName);
            }
            case 2: {
                return DBMSHelper.funcSum(param, colName);
            }
            case 3: {
                return DBOraHelper.funcSum(param, colName);
            }
            case 4: {
                return DB2Helper.funcSum(param, colName);
            }
            case 5: {
                return DBLiteHelper.funcSum(param, colName);
            }
        }
        throw new DBException("statement type not supported");
    }

    public static String funcAvg(DBStat stat, String param, String colName) throws DBException {
        switch (stat.getType()) {
            case 1: {
                return DBMyHelper.funcAvg(param, colName);
            }
            case 2: {
                return DBMSHelper.funcAvg(param, colName);
            }
            case 3: {
                return DBOraHelper.funcAvg(param, colName);
            }
            case 4: {
                return DB2Helper.funcAvg(param, colName);
            }
            case 5: {
                return DBLiteHelper.funcAvg(param, colName);
            }
        }
        throw new DBException("statement type not supported");
    }

    public static String funcMax(DBStat stat, String param, String colName) throws DBException {
        switch (stat.getType()) {
            case 1: {
                return DBMyHelper.funcMax(param, colName);
            }
            case 2: {
                return DBMSHelper.funcMax(param, colName);
            }
            case 3: {
                return DBOraHelper.funcMax(param, colName);
            }
            case 4: {
                return DB2Helper.funcMax(param, colName);
            }
            case 5: {
                return DBLiteHelper.funcMax(param, colName);
            }
        }
        throw new DBException("statement type not supported");
    }

    public static String funcMin(DBStat stat, String param, String colName) throws DBException {
        switch (stat.getType()) {
            case 1: {
                return DBMyHelper.funcMin(param, colName);
            }
            case 2: {
                return DBMSHelper.funcMin(param, colName);
            }
            case 3: {
                return DBOraHelper.funcMin(param, colName);
            }
            case 4: {
                return DB2Helper.funcMin(param, colName);
            }
            case 5: {
                return DBLiteHelper.funcMin(param, colName);
            }
        }
        throw new DBException("statement type not supported");
    }

    public static String funcCount(DBStat stat, String param, String colName) throws DBException {
        switch (stat.getType()) {
            case 1: {
                return DBMyHelper.funcCount(param, colName);
            }
            case 2: {
                return DBMSHelper.funcCount(param, colName);
            }
            case 3: {
                return DBOraHelper.funcCount(param, colName);
            }
            case 4: {
                return DB2Helper.funcCount(param, colName);
            }
            case 5: {
                return DBLiteHelper.funcCount(param, colName);
            }
        }
        throw new DBException("statement type not supported");
    }

    public static String andWhereStr(DBStat stat, String whereStr) throws DBException {
        switch (stat.getType()) {
            case 1: {
                return DBMyHelper.andWhereStr(whereStr);
            }
            case 2: {
                return DBMSHelper.andWhereStr(whereStr);
            }
            case 3: {
                return DBOraHelper.andWhereStr(whereStr);
            }
            case 4: {
                return DB2Helper.andWhereStr(whereStr);
            }
            case 5: {
                return DBLiteHelper.andWhereStr(whereStr);
            }
        }
        throw new DBException("statement type not supported");
    }

    public static String orWhereStr(DBStat stat, String whereStr) throws DBException {
        switch (stat.getType()) {
            case 1: {
                return DBMyHelper.orWhereStr(whereStr);
            }
            case 2: {
                return DBMSHelper.orWhereStr(whereStr);
            }
            case 3: {
                return DBOraHelper.orWhereStr(whereStr);
            }
            case 4: {
                return DB2Helper.orWhereStr(whereStr);
            }
            case 5: {
                return DBLiteHelper.orWhereStr(whereStr);
            }
        }
        throw new DBException("statement type not supported");
    }

    public static String andWhereStrs(DBStat stat, String[] whereStrs) throws DBException {
        switch (stat.getType()) {
            case 1: {
                return DBMyHelper.andWhereStrs(whereStrs);
            }
            case 2: {
                return DBMSHelper.andWhereStrs(whereStrs);
            }
            case 3: {
                return DBOraHelper.andWhereStrs(whereStrs);
            }
            case 4: {
                return DB2Helper.andWhereStrs(whereStrs);
            }
            case 5: {
                return DBLiteHelper.andWhereStrs(whereStrs);
            }
        }
        throw new DBException("statement type not supported");
    }

    public static String orWhereStrs(DBStat stat, String[] whereStrs) throws DBException {
        switch (stat.getType()) {
            case 1: {
                return DBMyHelper.orWhereStrs(whereStrs);
            }
            case 2: {
                return DBMSHelper.orWhereStrs(whereStrs);
            }
            case 3: {
                return DBOraHelper.orWhereStrs(whereStrs);
            }
            case 4: {
                return DB2Helper.orWhereStrs(whereStrs);
            }
            case 5: {
                return DBLiteHelper.orWhereStrs(whereStrs);
            }
        }
        throw new DBException("statement type not supported");
    }

    public static String euqalStr(DBStat stat, String valueA, String valueB) throws DBException {
        switch (stat.getType()) {
            case 1: {
                return DBMyHelper.euqalStr(valueA, valueB);
            }
            case 2: {
                return DBMSHelper.euqalStr(valueA, valueB);
            }
            case 3: {
                return DBOraHelper.euqalStr(valueA, valueB);
            }
            case 4: {
                return DB2Helper.euqalStr(valueA, valueB);
            }
            case 5: {
                return DBLiteHelper.euqalStr(valueA, valueB);
            }
        }
        throw new DBException("statement type not supported");
    }

    public static String euqalStr(DBStat stat, String valueA, String valueB, boolean bIsStr) throws DBException {
        switch (stat.getType()) {
            case 1: {
                return DBMyHelper.euqalStr(valueA, valueB, bIsStr);
            }
            case 2: {
                return DBMSHelper.euqalStr(valueA, valueB, bIsStr);
            }
            case 3: {
                return DBOraHelper.euqalStr(valueA, valueB, bIsStr);
            }
            case 4: {
                return DB2Helper.euqalStr(valueA, valueB, bIsStr);
            }
            case 5: {
                return DBLiteHelper.euqalStr(valueA, valueB, bIsStr);
            }
        }
        throw new DBException("statement type not supported");
    }

    public static boolean execute(DBStat stat, String cmdStr) throws DBException {
        try {
            switch (stat.getType()) {
                case 1: {
                    return DBMyHelper.execute(stat.getOrigin(), cmdStr);
                }
                case 2: {
                    return DBMSHelper.execute(stat.getOrigin(), cmdStr);
                }
                case 3: {
                    return DBOraHelper.execute(stat.getOrigin(), cmdStr);
                }
                case 4: {
                    return DB2Helper.execute(stat.getOrigin(), cmdStr);
                }
                case 5: {
                    return DBLiteHelper.execute(stat.getOrigin(), cmdStr);
                }
            }
            throw new DBException("statement type not supported");
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public static DBResult fullQuery(DBStat stat, String sqlStr) throws DBException {
        try {
            switch (stat.getType()) {
                case 1: {
                    return new DBResult(DBMyHelper.fullQuery(stat.getOrigin(), sqlStr), stat.getType());
                }
                case 2: {
                    return new DBResult(DBMSHelper.fullQuery(stat.getOrigin(), sqlStr), stat.getType());
                }
                case 3: {
                    return new DBResult(DBOraHelper.fullQuery(stat.getOrigin(), sqlStr), stat.getType());
                }
                case 4: {
                    return new DBResult(DB2Helper.fullQuery(stat.getOrigin(), sqlStr), stat.getType());
                }
                case 5: {
                    return new DBResult(DBLiteHelper.fullQuery(stat.getOrigin(), sqlStr), stat.getType());
                }
            }
            throw new DBException("statement type not supported");
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public static DBResult query(DBStat stat, String tbName, String[] colNames, String whereStr, String groupStr, String orderStr) throws DBException {
        try {
            switch (stat.getType()) {
                case 1: {
                    return new DBResult(DBMyHelper.query(stat.getOrigin(), tbName, colNames, whereStr, groupStr, orderStr, null), stat.getType());
                }
                case 2: {
                    return new DBResult(DBMSHelper.query(stat.getOrigin(), tbName, colNames, whereStr, groupStr, orderStr, null), stat.getType());
                }
                case 3: {
                    return new DBResult(DBOraHelper.query(stat.getOrigin(), tbName, colNames, whereStr, groupStr, orderStr), stat.getType());
                }
                case 4: {
                    return new DBResult(DB2Helper.query(stat.getOrigin(), tbName, colNames, whereStr, groupStr, orderStr), stat.getType());
                }
                case 5: {
                    return new DBResult(DBLiteHelper.query(stat.getOrigin(), tbName, colNames, whereStr, groupStr, orderStr, null), stat.getType());
                }
            }
            throw new DBException("statement type not supported");
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public static DBResult pageQuery(DBStat stat, String tbName, String[] colNames, String whereStr, String groupStr, String orderStr, String primaryCol, int pageCur, int pageSize) throws DBException {
        try {
            switch (stat.getType()) {
                case 1: {
                    return new DBResult(DBMyHelper.query(stat.getOrigin(), tbName, colNames, whereStr, groupStr, orderStr, pageCur * pageSize + "," + pageSize), stat.getType());
                }
                case 2: {
                    return new DBResult(DBMSHelper.pageQuery(stat.getOrigin(), tbName, colNames, whereStr, groupStr, orderStr, primaryCol, pageCur, pageSize), stat.getType());
                }
                case 3: {
                    return new DBResult(DBOraHelper.pageQuery(stat.getOrigin(), tbName, colNames, whereStr, groupStr, orderStr, ROWNUM_COLNAME, pageCur, pageSize), stat.getType());
                }
                case 4: {
                    return new DBResult(DB2Helper.pageQuery(stat.getOrigin(), tbName, colNames, whereStr, groupStr, orderStr, ROWNUM_COLNAME, pageCur, pageSize), stat.getType());
                }
                case 5: {
                    return new DBResult(DBLiteHelper.query(stat.getOrigin(), tbName, colNames, whereStr, groupStr, orderStr, pageCur * pageSize + "," + pageSize), stat.getType());
                }
            }
            throw new DBException("statement type not supported");
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public static int insert(DBStat stat, String tbName, DBValPair[] values) throws DBException {
        try {
            switch (stat.getType()) {
                case 1: {
                    return DBMyHelper.insert(stat.getOrigin(), tbName, values);
                }
                case 2: {
                    return DBMSHelper.insert(stat.getOrigin(), tbName, values);
                }
                case 3: {
                    return DBOraHelper.insert(stat.getOrigin(), tbName, values);
                }
                case 4: {
                    return DB2Helper.insert(stat.getOrigin(), tbName, values);
                }
                case 5: {
                    return DBLiteHelper.insert(stat.getOrigin(), tbName, values);
                }
            }
            throw new DBException("statement type not supported");
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public static int insert(DBStat stat, String tbName, DBMulValPair[] values) throws DBException {
        try {
            switch (stat.getType()) {
                case 1: {
                    return DBMyHelper.insert(stat.getOrigin(), tbName, values);
                }
                case 2: {
                    return DBMSHelper.insert(stat.getOrigin(), tbName, values);
                }
                case 3: {
                    return DBOraHelper.insert(stat.getOrigin(), tbName, values);
                }
                case 4: {
                    return DB2Helper.insert(stat.getOrigin(), tbName, values);
                }
                case 5: {
                    return DBLiteHelper.insert(stat.getOrigin(), tbName, values);
                }
            }
            throw new DBException("statement type not supported");
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public static int update(DBStat stat, String tbName, ArrayList<DBValPair> list, String whereStr) throws DBException {
        if (list == null || list.isEmpty()) {
            return 0;
        }
        DBValPair[] values = new DBValPair[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            values[i] = list.get(i);
        }
        return DBHelper.update(stat, tbName, values, whereStr);
    }

    public static int update(DBStat stat, String tbName, DBValPair[] values, String whereStr) throws DBException {
        try {
            switch (stat.getType()) {
                case 1: {
                    return DBMyHelper.update(stat.getOrigin(), tbName, values, whereStr);
                }
                case 2: {
                    return DBMSHelper.update(stat.getOrigin(), tbName, values, whereStr);
                }
                case 3: {
                    return DBOraHelper.update(stat.getOrigin(), tbName, values, whereStr);
                }
                case 4: {
                    return DB2Helper.update(stat.getOrigin(), tbName, values, whereStr);
                }
                case 5: {
                    return DBLiteHelper.update(stat.getOrigin(), tbName, values, whereStr);
                }
            }
            throw new DBException("statement type not supported");
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public static int delete(DBStat stat, String tbName, String whereStr) throws DBException {
        try {
            switch (stat.getType()) {
                case 1: {
                    return DBMyHelper.delete(stat.getOrigin(), tbName, whereStr);
                }
                case 2: {
                    return DBMSHelper.delete(stat.getOrigin(), tbName, whereStr);
                }
                case 3: {
                    return DBOraHelper.delete(stat.getOrigin(), tbName, whereStr);
                }
                case 4: {
                    return DB2Helper.delete(stat.getOrigin(), tbName, whereStr);
                }
                case 5: {
                    return DBLiteHelper.delete(stat.getOrigin(), tbName, whereStr);
                }
            }
            throw new DBException("statement type not supported");
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public static long count(DBStat stat, String tbName, String whereStr) throws DBException {
        try {
            switch (stat.getType()) {
                case 1: {
                    return DBMyHelper.count(stat.getOrigin(), tbName, whereStr);
                }
                case 2: {
                    return DBMSHelper.count(stat.getOrigin(), tbName, whereStr);
                }
                case 3: {
                    return DBOraHelper.count(stat.getOrigin(), tbName, whereStr);
                }
                case 4: {
                    return DB2Helper.count(stat.getOrigin(), tbName, whereStr);
                }
                case 5: {
                    return DBLiteHelper.count(stat.getOrigin(), tbName, whereStr);
                }
            }
            throw new DBException("statement type not supported");
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public static long count(DBStat stat, String tbName, String cntColName, String whereStr) throws DBException {
        try {
            switch (stat.getType()) {
                case 1: {
                    return DBMyHelper.count(stat.getOrigin(), tbName, cntColName, whereStr);
                }
                case 2: {
                    return DBMSHelper.count(stat.getOrigin(), tbName, cntColName, whereStr);
                }
                case 3: {
                    return DBOraHelper.count(stat.getOrigin(), tbName, cntColName, whereStr);
                }
                case 4: {
                    return DB2Helper.count(stat.getOrigin(), tbName, cntColName, whereStr);
                }
                case 5: {
                    return DBLiteHelper.count(stat.getOrigin(), tbName, cntColName, whereStr);
                }
            }
            throw new DBException("statement type not supported");
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public static long max(DBStat stat, String tbName, String maxColName, String whereStr) throws DBException {
        try {
            switch (stat.getType()) {
                case 1: {
                    return DBMyHelper.max(stat.getOrigin(), tbName, maxColName, whereStr);
                }
                case 2: {
                    return DBMSHelper.max(stat.getOrigin(), tbName, maxColName, whereStr);
                }
                case 3: {
                    return DBOraHelper.max(stat.getOrigin(), tbName, maxColName, whereStr);
                }
                case 4: {
                    return DB2Helper.max(stat.getOrigin(), tbName, maxColName, whereStr);
                }
                case 5: {
                    return DBLiteHelper.max(stat.getOrigin(), tbName, maxColName, whereStr);
                }
            }
            throw new DBException("statement type not supported");
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public static long min(DBStat stat, String tbName, String minColName, String whereStr) throws DBException {
        try {
            switch (stat.getType()) {
                case 1: {
                    return DBMyHelper.min(stat.getOrigin(), tbName, minColName, whereStr);
                }
                case 2: {
                    return DBMSHelper.min(stat.getOrigin(), tbName, minColName, whereStr);
                }
                case 3: {
                    return DBOraHelper.min(stat.getOrigin(), tbName, minColName, whereStr);
                }
                case 4: {
                    return DB2Helper.min(stat.getOrigin(), tbName, minColName, whereStr);
                }
                case 5: {
                    return DBLiteHelper.min(stat.getOrigin(), tbName, minColName, whereStr);
                }
            }
            throw new DBException("statement type not supported");
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public static double sum(DBStat stat, String tbName, String sumColName, String whereStr) throws DBException {
        try {
            switch (stat.getType()) {
                case 1: {
                    return DBMyHelper.sum(stat.getOrigin(), tbName, sumColName, whereStr);
                }
                case 2: {
                    return DBMSHelper.sum(stat.getOrigin(), tbName, sumColName, whereStr);
                }
                case 3: {
                    return DBOraHelper.sum(stat.getOrigin(), tbName, sumColName, whereStr);
                }
                case 4: {
                    return DB2Helper.sum(stat.getOrigin(), tbName, sumColName, whereStr);
                }
                case 5: {
                    return DBLiteHelper.sum(stat.getOrigin(), tbName, sumColName, whereStr);
                }
            }
            throw new DBException("statement type not supported");
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public static double avg(DBStat stat, String tbName, String avgColName, String whereStr) throws DBException {
        try {
            switch (stat.getType()) {
                case 1: {
                    return DBMyHelper.avg(stat.getOrigin(), tbName, avgColName, whereStr);
                }
                case 2: {
                    return DBMSHelper.avg(stat.getOrigin(), tbName, avgColName, whereStr);
                }
                case 3: {
                    return DBOraHelper.avg(stat.getOrigin(), tbName, avgColName, whereStr);
                }
                case 4: {
                    return DB2Helper.avg(stat.getOrigin(), tbName, avgColName, whereStr);
                }
                case 5: {
                    return DBLiteHelper.avg(stat.getOrigin(), tbName, avgColName, whereStr);
                }
            }
            throw new DBException("statement type not supported");
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public static String toDateTimeString(DBStat stat, Date date) throws DBException {
        switch (stat.getType()) {
            case 1: {
                return DBMyHelper.toDateTimeString(date);
            }
            case 2: {
                return DBMSHelper.toDateTimeString(date);
            }
            case 3: {
                return DBOraHelper.toDateTimeString(date);
            }
            case 4: {
                return DB2Helper.toDateTimeString(date);
            }
            case 5: {
                return DBLiteHelper.toDateTimeString(date);
            }
        }
        throw new DBException("statement type not supported");
    }

    public static Object queryColObject(DBStat stat, String tbName, String colName, String whereStr, String groupStr, String orderStr) throws DBException {
        return DBHelper.queryColObject(stat, tbName, colName, whereStr, groupStr, orderStr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object queryColObject(DBStat stat, String tbName, String colName, String whereStr, String groupStr, String orderStr, Object defaultVal) throws DBException {
        Object rtnVal = defaultVal;
        DBResult rs = DBHelper.query(stat, tbName, new String[]{colName}, whereStr, groupStr, orderStr);
        try {
            if (rs.next()) {
                rtnVal = rs.getObject(colName);
            }
        }
        finally {
            rs.close();
        }
        return rtnVal;
    }

    public static String queryColString(DBStat stat, String tbName, String colName, String whereStr, String groupStr, String orderStr) throws DBException {
        return DBHelper.queryColString(stat, tbName, colName, whereStr, groupStr, orderStr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String queryColString(DBStat stat, String tbName, String colName, String whereStr, String groupStr, String orderStr, String defaultVal) throws DBException {
        String rtnVal = defaultVal;
        DBResult rs = DBHelper.query(stat, tbName, new String[]{colName}, whereStr, groupStr, orderStr);
        try {
            if (rs.next()) {
                rtnVal = rs.getString(colName);
            }
        }
        finally {
            rs.close();
        }
        return rtnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean queryColBoolean(DBStat stat, String tbName, String colName, String whereStr, String groupStr, String orderStr, boolean defaultVal) throws DBException {
        boolean rtnVal = defaultVal;
        DBResult rs = DBHelper.query(stat, tbName, new String[]{colName}, whereStr, groupStr, orderStr);
        try {
            if (rs.next()) {
                rtnVal = rs.getBoolean(colName);
            }
        }
        finally {
            rs.close();
        }
        return rtnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte queryColByte(DBStat stat, String tbName, String colName, String whereStr, String groupStr, String orderStr, byte defaultVal) throws DBException {
        byte rtnVal = defaultVal;
        DBResult rs = DBHelper.query(stat, tbName, new String[]{colName}, whereStr, groupStr, orderStr);
        try {
            if (rs.next()) {
                rtnVal = rs.getByte(colName);
            }
        }
        finally {
            rs.close();
        }
        return rtnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short queryColShort(DBStat stat, String tbName, String colName, String whereStr, String groupStr, String orderStr, short defaultVal) throws DBException {
        short rtnVal = defaultVal;
        DBResult rs = DBHelper.query(stat, tbName, new String[]{colName}, whereStr, groupStr, orderStr);
        try {
            if (rs.next()) {
                rtnVal = rs.getShort(colName);
            }
        }
        finally {
            rs.close();
        }
        return rtnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int queryColInteger(DBStat stat, String tbName, String colName, String whereStr, String groupStr, String orderStr, int defaultVal) throws DBException {
        int rtnVal = defaultVal;
        DBResult rs = DBHelper.query(stat, tbName, new String[]{colName}, whereStr, groupStr, orderStr);
        try {
            if (rs.next()) {
                rtnVal = rs.getInt(colName);
            }
        }
        finally {
            rs.close();
        }
        return rtnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long queryColLong(DBStat stat, String tbName, String colName, String whereStr, String groupStr, String orderStr, long defaultVal) throws DBException {
        long rtnVal = defaultVal;
        DBResult rs = DBHelper.query(stat, tbName, new String[]{colName}, whereStr, groupStr, orderStr);
        try {
            if (rs.next()) {
                rtnVal = rs.getLong(colName);
            }
        }
        finally {
            rs.close();
        }
        return rtnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float queryColFloat(DBStat stat, String tbName, String colName, String whereStr, String groupStr, String orderStr, float defaultVal) throws DBException {
        float rtnVal = defaultVal;
        DBResult rs = DBHelper.query(stat, tbName, new String[]{colName}, whereStr, groupStr, orderStr);
        try {
            if (rs.next()) {
                rtnVal = rs.getFloat(colName);
            }
        }
        finally {
            rs.close();
        }
        return rtnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double queryColDouble(DBStat stat, String tbName, String colName, String whereStr, String groupStr, String orderStr, double defaultVal) throws DBException {
        double rtnVal = defaultVal;
        DBResult rs = DBHelper.query(stat, tbName, new String[]{colName}, whereStr, groupStr, orderStr);
        try {
            if (rs.next()) {
                rtnVal = rs.getDouble(colName);
            }
        }
        finally {
            rs.close();
        }
        return rtnVal;
    }

    public static long queryColTimestamp(DBStat stat, String tbName, String colName, String whereStr, String groupStr, String orderStr) throws DBException {
        return DBHelper.queryColTimestamp(stat, tbName, colName, whereStr, groupStr, orderStr, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long queryColTimestamp(DBStat stat, String tbName, String colName, String whereStr, String groupStr, String orderStr, long defaultVal) throws DBException {
        long rtnVal = defaultVal;
        DBResult rs = DBHelper.query(stat, tbName, new String[]{colName}, whereStr, groupStr, orderStr);
        try {
            Timestamp timestamp;
            if (rs.next() && (timestamp = rs.getTimestamp(colName)) != null) {
                rtnVal = timestamp.getTime();
            }
        }
        finally {
            rs.close();
        }
        return rtnVal;
    }
}

