/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.database;

import com.modnut.framework2.database.DB2Helper;
import com.modnut.framework2.database.DBException;
import com.modnut.framework2.database.DBHelper;
import com.modnut.framework2.database.DBLiteHelper;
import com.modnut.framework2.database.DBMSHelper;
import com.modnut.framework2.database.DBMyHelper;
import com.modnut.framework2.database.DBOraHelper;
import com.modnut.framework2.database.DBResult;
import com.modnut.framework2.database.DBStat;
import com.modnut.framework2.tool.ToolStr;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBCreator {
    private static final String CN_NULL = "N";
    private static final String CP_PK = "PK";
    private static final String CT_TINYINT = "TI";
    private static final String CT_SMALLINT = "SI";
    private static final String CT_MEDIUMINT = "MI";
    private static final String CT_INT = "I";
    private static final String CT_BIGINT = "BI";
    private static final String CT_FLOAT = "F";
    private static final String CT_DOUBLE = "D";
    private static final String CT_DECIMAL = "DEC";
    private static final String CT_DATETIME = "DT";
    private static final String CT_CHAR = "C";
    private static final String CT_VARCHAR = "V";
    private static final String CT_TEXT = "T";

    public static DBTable convert(Class tb) {
        try {
            String tbName = tb.getField("NAME").get(null).toString();
            DBTable table = new DBTable(tbName, "InnoDB", "utf8");
            Class<?> cols = null;
            for (Class<?> clazz : tb.getClasses()) {
                if (!"Cols".equals(clazz.getSimpleName())) continue;
                cols = clazz;
            }
            if (cols == null) {
                throw new NoSuchFieldException("Cols");
            }
            for (AnnotatedElement annotatedElement : cols.getFields()) {
                String colParam = ((Field)annotatedElement).getName();
                String colName = ((Field)annotatedElement).get(null).toString();
                DBColumn.DataType type = null;
                boolean notNull = true;
                boolean isPk = false;
                String[] params = colParam.split("_");
                for (int i = 1; i < params.length; ++i) {
                    String param = params[i];
                    if (param == null || param.trim().isEmpty()) continue;
                    if (CN_NULL.equals(param)) {
                        notNull = false;
                        continue;
                    }
                    if (CP_PK.equals(param)) {
                        isPk = true;
                        continue;
                    }
                    if (CT_TINYINT.equals(param)) {
                        type = new DBColumn.Numeric.TINYINT();
                        continue;
                    }
                    if (CT_SMALLINT.equals(param)) {
                        type = new DBColumn.Numeric.SMALLINT();
                        continue;
                    }
                    if (CT_MEDIUMINT.equals(param)) {
                        type = new DBColumn.Numeric.MEDIUMINT();
                        continue;
                    }
                    if (CT_INT.equals(param)) {
                        type = new DBColumn.Numeric.INT();
                        continue;
                    }
                    if (CT_BIGINT.equals(param)) {
                        type = new DBColumn.Numeric.BIGINT();
                        continue;
                    }
                    if (CT_FLOAT.equals(param)) {
                        type = new DBColumn.Numeric.FLOAT();
                        continue;
                    }
                    if (CT_DOUBLE.equals(param)) {
                        type = new DBColumn.Numeric.DOUBLE();
                        continue;
                    }
                    if (CT_DECIMAL.equals(param)) {
                        type = new DBColumn.Numeric.DECIMAL(19, 4);
                        continue;
                    }
                    if (CT_DATETIME.equals(param)) {
                        type = new DBColumn.DateTime.DATETIME();
                        continue;
                    }
                    if (CT_CHAR.equals(param)) {
                        type = new DBColumn.Text.CHAR(36);
                        continue;
                    }
                    if (CT_VARCHAR.equals(param)) {
                        type = new DBColumn.Text.VARCHAR(200);
                        continue;
                    }
                    if (CT_TEXT.equals(param)) {
                        type = new DBColumn.Text.TEXT();
                        continue;
                    }
                    if (param.startsWith(CT_DECIMAL)) {
                        int[] decimalNums = DBCreator.parseNums(CT_DECIMAL, param, 19, 4);
                        type = new DBColumn.Numeric.DECIMAL(decimalNums[1], decimalNums[2]);
                        continue;
                    }
                    if (param.startsWith(CT_CHAR)) {
                        int[] charNums = DBCreator.parseNums(CT_CHAR, param, 36, 0);
                        type = new DBColumn.Text.CHAR(charNums[0]);
                        continue;
                    }
                    if (!param.startsWith(CT_VARCHAR)) continue;
                    int[] varcharNums = DBCreator.parseNums(CT_VARCHAR, param, 200, 0);
                    type = new DBColumn.Text.VARCHAR(varcharNums[0]);
                }
                if (type == null) {
                    type = new DBColumn.Text.TEXT();
                }
                table.addColumn(new DBColumn(colName, type, notNull ? Boolean.TRUE : Boolean.FALSE));
                if (!isPk) continue;
                table.addPkColNames(colName);
            }
            return table;
        }
        catch (Exception ex) {
            Logger.getLogger(DBCreator.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static DBTable[] converts(Class cls) {
        ArrayList<DBTable> tables = new ArrayList<DBTable>();
        for (Class<?> tb : cls.getClasses()) {
            int modifiers = tb.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) continue;
            boolean hasName = false;
            boolean hasCols = false;
            for (Field field : tb.getFields()) {
                if (!"NAME".equals(field.getName())) continue;
                hasName = true;
            }
            for (AnnotatedElement annotatedElement : tb.getClasses()) {
                if (!"Cols".equals(((Class)annotatedElement).getSimpleName())) continue;
                hasCols = true;
            }
            if (!hasName || !hasCols) continue;
            tables.add(DBCreator.convert(tb));
        }
        Collections.sort(tables);
        return tables.toArray(new DBTable[tables.size()]);
    }

    private static int[] parseNums(String prefix, String param, int defNumA, int defNumB) {
        String numPart = param.substring(prefix.length());
        int index = numPart.length() - numPart.length() / 2;
        int[] nums = new int[]{DBCreator.parseNum(numPart, defNumA), DBCreator.parseNum(numPart.substring(0, index), defNumA), DBCreator.parseNum(numPart.substring(index), defNumB)};
        return nums;
    }

    private static int parseNum(String numStr, int defaultVal) {
        if (numStr == null) {
            return defaultVal;
        }
        int num = defaultVal;
        try {
            num = Integer.parseInt(numStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return num;
    }

    public static String getCreateTableSql(DBStat stat, DBTable table) throws DBException {
        return DBCreator.getCreateTableSql(stat.getType(), table);
    }

    public static String getCreateTableSql(short type, DBTable table) throws DBException {
        switch (type) {
            case 1: {
                return MYSQL.getCreateTableSql(table);
            }
            case 2: {
                return MSSQL.getCreateTableSql(table);
            }
            case 3: {
                return ORASQL.getCreateTableSql(table);
            }
            case 4: {
                return DB2SQL.getCreateTableSql(table);
            }
            case 5: {
                return SQLITE.getCreateTableSql(table);
            }
        }
        throw new DBException("statement type not supported");
    }

    public static String getDropTableSql(DBStat stat, String tableName) throws DBException {
        return DBCreator.getDropTableSql(stat.getType(), tableName);
    }

    public static String getDropTableSql(short type, String tableName) throws DBException {
        switch (type) {
            case 1: {
                return MYSQL.getDropTableSql(tableName);
            }
            case 2: {
                return MSSQL.getDropTableSql(tableName);
            }
            case 3: {
                return ORASQL.getDropTableSql(tableName);
            }
            case 4: {
                return DB2SQL.getDropTableSql(tableName);
            }
            case 5: {
                return SQLITE.getDropTableSql(tableName);
            }
        }
        throw new DBException("statement type not supported");
    }

    public static String getAddColumnSql(DBStat stat, String tableName, DBColumn column) throws DBException {
        return DBCreator.getAddColumnSql(stat.getType(), tableName, column);
    }

    public static String getAddColumnSql(short type, String tableName, DBColumn column) throws DBException {
        switch (type) {
            case 1: {
                return MYSQL.getAddColumnSql(tableName, column);
            }
            case 2: {
                return MSSQL.getAddColumnSql(tableName, column);
            }
            case 3: {
                return ORASQL.getAddColumnSql(tableName, column);
            }
            case 4: {
                return DB2SQL.getAddColumnSql(tableName, column);
            }
            case 5: {
                return SQLITE.getAddColumnSql(tableName, column);
            }
        }
        throw new DBException("statement type not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doDropTable(DBStat stat, String tableName) throws DBException {
        boolean exist = false;
        DBResult rs = DBHelper.getTables(stat, DBHelper.formatSqlStr(stat, tableName));
        try {
            if (rs.next()) {
                exist = true;
            }
        }
        finally {
            rs.close();
        }
        if (exist) {
            stat.execute(DBCreator.getDropTableSql(stat, tableName));
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doCheckTable(DBStat stat, DBTable table) throws DBException {
        boolean exist = false;
        DBResult rs = DBHelper.getTables(stat, DBHelper.formatSqlStr(stat, table.name));
        try {
            exist = rs.next();
        }
        finally {
            rs.close();
        }
        if (!exist) {
            String createTableSql = DBCreator.getCreateTableSql(stat, table);
            DBHelper.execute(stat, createTableSql);
        }
        return exist;
    }

    private static class SQLITE {
        private SQLITE() {
        }

        public static String getCreateTableSql(DBTable table) throws DBException {
            StringBuilder sb = new StringBuilder();
            String temporary = "";
            if (table.temp != null && table.temp.booleanValue()) {
                temporary = " TEMPORARY";
            }
            String ifnotexist = "";
            if (table.ifnotexist != null && table.ifnotexist.booleanValue()) {
                ifnotexist = " IF NOT EXISTS";
            }
            sb.append("CREATE").append(temporary).append(" TABLE").append(ifnotexist).append(" ");
            if (table.database != null) {
                sb.append(table.database).append(".");
            }
            sb.append(table.name).append("(");
            int defCnt = 0;
            if (table.columns != null) {
                for (DBColumn column : table.columns) {
                    if (defCnt > 0) {
                        sb.append(",");
                    }
                    sb.append(SQLITE.getColumnStr(column));
                    ++defCnt;
                }
            }
            if (table.pkColNames != null) {
                if (defCnt > 0) {
                    sb.append(",");
                }
                sb.append("PRIMARY KEY(");
                int colCnt = 0;
                for (String pkColName : table.pkColNames) {
                    if (colCnt > 0) {
                        sb.append(",");
                    }
                    sb.append(pkColName);
                    ++colCnt;
                }
                sb.append(")");
                ++defCnt;
            }
            if (table.uniqueColNames != null) {
                if (defCnt > 0) {
                    sb.append(",");
                }
                sb.append("UNIQUE(");
                int colCnt = 0;
                for (String uniqueColName : table.uniqueColNames) {
                    if (colCnt > 0) {
                        sb.append(",");
                    }
                    sb.append(uniqueColName);
                    ++colCnt;
                }
                sb.append(")");
                ++defCnt;
            }
            sb.append(")");
            return sb.toString();
        }

        public static String getDropTableSql(String name) throws DBException {
            StringBuilder sb = new StringBuilder();
            sb.append("DROP TABLE ").append(name);
            return sb.toString();
        }

        public static String getAddColumnSql(String name, DBColumn column) throws DBException {
            StringBuilder sb = new StringBuilder();
            sb.append("ALTER TABLE ").append(name);
            sb.append(" ADD COLUMN ").append(SQLITE.getColumnStr(column));
            return sb.toString();
        }

        private static String getColumnStr(DBColumn column) throws DBException {
            StringBuilder sb = new StringBuilder();
            sb.append(column.name).append(" ").append(SQLITE.getTypeStr(column.type));
            if (column.collate != null) {
                sb.append(" COLLATE ").append(column.collate);
            }
            if (column.defaultVal != null) {
                sb.append(" DEFAULT ");
                if (column.defaultVal instanceof String) {
                    sb.append(DBLiteHelper.formatSqlStr((String)column.defaultVal));
                } else {
                    sb.append(column.defaultVal.toString());
                }
            }
            if (column.notnull != null) {
                sb.append(" ").append(column.notnull != false ? "NOT NULL" : "NULL");
            }
            return sb.toString();
        }

        private static String getTypeStr(DBColumn.DataType type) throws DBException {
            if (type instanceof DBColumn.Numeric) {
                return SQLITE.getTypeNumericStr((DBColumn.Numeric)type);
            }
            if (type instanceof DBColumn.DateTime) {
                return SQLITE.getTypeDateTimeStr((DBColumn.DateTime)type);
            }
            if (type instanceof DBColumn.Text) {
                return SQLITE.getTypeTextStr((DBColumn.Text)type);
            }
            throw new DBException("unknow column data type");
        }

        private static String getTypeNumericStr(DBColumn.Numeric type) throws DBException {
            StringBuilder sb = new StringBuilder();
            if (type instanceof DBColumn.Numeric.BIT) {
                sb.append("BIT");
            } else if (type instanceof DBColumn.Numeric.TINYINT) {
                sb.append("TINYINT");
            } else if (type instanceof DBColumn.Numeric.SMALLINT) {
                sb.append("SMALLINT");
            } else if (type instanceof DBColumn.Numeric.MEDIUMINT) {
                sb.append("MEDIUMINT");
            } else if (type instanceof DBColumn.Numeric.INT) {
                sb.append("INT");
            } else if (type instanceof DBColumn.Numeric.BIGINT) {
                sb.append("BIGINT");
            } else if (type instanceof DBColumn.Numeric.FLOAT) {
                sb.append("FLOAT");
            } else if (type instanceof DBColumn.Numeric.DOUBLE) {
                sb.append("DOUBLE");
            } else if (type instanceof DBColumn.Numeric.DECIMAL) {
                DBColumn.Numeric.DECIMAL t = (DBColumn.Numeric.DECIMAL)type;
                sb.append("DECIMAL");
                sb.append("(").append(t.m).append(",").append(t.d).append(")");
            } else {
                throw new DBException("unknow numeric column data type");
            }
            return sb.toString();
        }

        private static String getTypeDateTimeStr(DBColumn.DateTime type) throws DBException {
            StringBuilder sb = new StringBuilder();
            if (type instanceof DBColumn.DateTime.DATE) {
                sb.append("DATETIME");
            } else if (type instanceof DBColumn.DateTime.DATETIME) {
                sb.append("DATETIME");
            } else if (type instanceof DBColumn.DateTime.TIMESTAMP) {
                sb.append("DATETIME");
            } else if (type instanceof DBColumn.DateTime.TIME) {
                sb.append("DATETIME");
            } else {
                throw new DBException("unknow datetime column data type");
            }
            return sb.toString();
        }

        private static String getTypeTextStr(DBColumn.Text type) throws DBException {
            StringBuilder sb = new StringBuilder();
            if (type instanceof DBColumn.Text.CHAR) {
                DBColumn.Text.CHAR t = (DBColumn.Text.CHAR)type;
                sb.append("CHARACTER");
                sb.append("(").append(t.m).append(")");
            } else if (type instanceof DBColumn.Text.VARCHAR) {
                DBColumn.Text.VARCHAR t = (DBColumn.Text.VARCHAR)type;
                sb.append("VARCHAR");
                sb.append("(").append(t.m).append(")");
            } else if (type instanceof DBColumn.Text.TEXT) {
                sb.append("TEXT");
            } else if (type instanceof DBColumn.Text.TINYTEXT) {
                sb.append("TEXT");
            } else if (type instanceof DBColumn.Text.MEDIUMTEXT) {
                sb.append("TEXT");
            } else if (type instanceof DBColumn.Text.LONGTEXT) {
                sb.append("TEXT");
            } else if (type instanceof DBColumn.Text.BLOB) {
                sb.append("BLOB");
            } else if (type instanceof DBColumn.Text.TINYBLOB) {
                sb.append("BLOB");
            } else if (type instanceof DBColumn.Text.MEDIUMBLOB) {
                sb.append("BLOB");
            } else if (type instanceof DBColumn.Text.LONGBLOB) {
                sb.append("BLOB");
            } else {
                throw new DBException("unknow text column data type");
            }
            return sb.toString();
        }
    }

    private static class DB2SQL {
        private DB2SQL() {
        }

        public static String getCreateTableSql(DBTable table) throws DBException {
            StringBuilder sb = new StringBuilder();
            sb.append("CREATE TABLE ").append(table.name).append("(");
            int defCnt = 0;
            if (table.columns != null) {
                for (DBColumn column : table.columns) {
                    if (defCnt > 0) {
                        sb.append(",");
                    }
                    sb.append(DB2SQL.getColumnStr(column));
                    ++defCnt;
                }
            }
            if (table.pkColNames != null) {
                if (defCnt > 0) {
                    sb.append(",");
                }
                sb.append("PRIMARY KEY(");
                int pkColCnt = 0;
                for (String pkColName : table.pkColNames) {
                    if (pkColCnt > 0) {
                        sb.append(",");
                    }
                    sb.append(pkColName);
                    ++pkColCnt;
                }
                sb.append(")");
                ++defCnt;
            }
            if (table.uniqueColNames != null) {
                if (defCnt > 0) {
                    sb.append(",");
                }
                sb.append("UNIQUE(");
                int colCnt = 0;
                for (String uniqueColName : table.uniqueColNames) {
                    if (colCnt > 0) {
                        sb.append(",");
                    }
                    sb.append(uniqueColName);
                    ++colCnt;
                }
                sb.append(")");
                ++defCnt;
            }
            sb.append(")");
            return sb.toString();
        }

        public static String getDropTableSql(String name) throws DBException {
            StringBuilder sb = new StringBuilder();
            sb.append("DROP TABLE ").append(name);
            return sb.toString();
        }

        public static String getAddColumnSql(String name, DBColumn column) throws DBException {
            StringBuilder sb = new StringBuilder();
            sb.append("ALTER TABLE ").append(name);
            sb.append(" ADD COLUMN ").append(DB2SQL.getColumnStr(column));
            return sb.toString();
        }

        private static String getColumnStr(DBColumn column) throws DBException {
            StringBuilder sb = new StringBuilder();
            sb.append(column.name).append(" ").append(DB2SQL.getTypeStr(column.type));
            if (column.defaultVal != null) {
                sb.append(" DEFAULT ");
                if (column.defaultVal instanceof String) {
                    sb.append(DB2Helper.formatSqlStr((String)column.defaultVal));
                } else {
                    sb.append(column.defaultVal.toString());
                }
            }
            if (column.notnull != null) {
                sb.append(" ").append(column.notnull != false ? "NOT NULL" : "NULL");
            }
            return sb.toString();
        }

        private static String getTypeStr(DBColumn.DataType type) throws DBException {
            if (type instanceof DBColumn.Numeric) {
                return DB2SQL.getTypeNumericStr((DBColumn.Numeric)type);
            }
            if (type instanceof DBColumn.DateTime) {
                return DB2SQL.getTypeDateTimeStr((DBColumn.DateTime)type);
            }
            if (type instanceof DBColumn.Text) {
                return DB2SQL.getTypeTextStr((DBColumn.Text)type);
            }
            throw new DBException("unknow column data type");
        }

        private static String getTypeNumericStr(DBColumn.Numeric type) throws DBException {
            StringBuilder sb = new StringBuilder();
            if (type instanceof DBColumn.Numeric.BIT) {
                sb.append("SMALLINT");
            } else if (type instanceof DBColumn.Numeric.TINYINT) {
                sb.append("SMALLINT");
            } else if (type instanceof DBColumn.Numeric.SMALLINT) {
                sb.append("SMALLINT");
            } else if (type instanceof DBColumn.Numeric.MEDIUMINT) {
                sb.append("INTEGER");
            } else if (type instanceof DBColumn.Numeric.INT) {
                sb.append("INTEGER");
            } else if (type instanceof DBColumn.Numeric.BIGINT) {
                sb.append("BIGINT");
            } else if (type instanceof DBColumn.Numeric.FLOAT) {
                sb.append("REAL");
            } else if (type instanceof DBColumn.Numeric.DOUBLE) {
                sb.append("DOUBLE");
            } else if (type instanceof DBColumn.Numeric.DECIMAL) {
                DBColumn.Numeric.DECIMAL t = (DBColumn.Numeric.DECIMAL)type;
                sb.append("DECIMAL");
                sb.append("(").append(t.m).append(",").append(t.d).append(")");
            } else {
                throw new DBException("unknow numeric column data type");
            }
            return sb.toString();
        }

        private static String getTypeDateTimeStr(DBColumn.DateTime type) throws DBException {
            StringBuilder sb = new StringBuilder();
            if (type instanceof DBColumn.DateTime.DATE) {
                sb.append("DATE");
            } else if (type instanceof DBColumn.DateTime.DATETIME) {
                sb.append("TIMESTAMP");
            } else if (type instanceof DBColumn.DateTime.TIMESTAMP) {
                sb.append("TIMESTAMP");
            } else if (type instanceof DBColumn.DateTime.TIME) {
                sb.append("TIME");
            } else {
                throw new DBException("unknow datetime column data type");
            }
            return sb.toString();
        }

        private static String getTypeTextStr(DBColumn.Text type) throws DBException {
            StringBuilder sb = new StringBuilder();
            if (type instanceof DBColumn.Text.CHAR) {
                DBColumn.Text.CHAR t = (DBColumn.Text.CHAR)type;
                sb.append("CHARACTER");
                sb.append("(").append(t.m).append(")");
            } else if (type instanceof DBColumn.Text.VARCHAR) {
                DBColumn.Text.VARCHAR t = (DBColumn.Text.VARCHAR)type;
                sb.append("VARCHAR");
                sb.append("(").append(t.m).append(")");
            } else if (type instanceof DBColumn.Text.TEXT) {
                sb.append("CLOB");
            } else if (type instanceof DBColumn.Text.TINYTEXT) {
                sb.append("CLOB");
            } else if (type instanceof DBColumn.Text.MEDIUMTEXT) {
                sb.append("CLOB");
            } else if (type instanceof DBColumn.Text.LONGTEXT) {
                sb.append("CLOB");
            } else {
                throw new DBException("unknow text column data type");
            }
            return sb.toString();
        }
    }

    private static class ORASQL {
        private ORASQL() {
        }

        public static String getCreateTableSql(DBTable table) throws DBException {
            StringBuilder sb = new StringBuilder();
            sb.append("CREATE TABLE ");
            if (table.database != null) {
                sb.append(table.database).append(".");
            }
            sb.append(table.name).append("(");
            int defCnt = 0;
            if (table.columns != null) {
                for (DBColumn column : table.columns) {
                    if (defCnt > 0) {
                        sb.append(",");
                    }
                    sb.append(ORASQL.getColumnStr(column));
                    ++defCnt;
                }
            }
            if (table.pkColNames != null) {
                if (defCnt > 0) {
                    sb.append(",");
                }
                sb.append("PRIMARY KEY(");
                int colCnt = 0;
                for (String pkColName : table.pkColNames) {
                    if (colCnt > 0) {
                        sb.append(",");
                    }
                    sb.append(pkColName);
                    ++colCnt;
                }
                sb.append(")");
                ++defCnt;
            }
            if (table.uniqueColNames != null) {
                if (defCnt > 0) {
                    sb.append(",");
                }
                sb.append("UNIQUE(");
                int colCnt = 0;
                for (String uniqueColName : table.uniqueColNames) {
                    if (colCnt > 0) {
                        sb.append(",");
                    }
                    sb.append(uniqueColName);
                    ++colCnt;
                }
                sb.append(")");
                ++defCnt;
            }
            sb.append(")");
            return sb.toString();
        }

        public static String getDropTableSql(String name) throws DBException {
            StringBuilder sb = new StringBuilder();
            sb.append("DROP TABLE ").append(name).append("");
            return sb.toString();
        }

        public static String getAddColumnSql(String name, DBColumn column) throws DBException {
            StringBuilder sb = new StringBuilder();
            sb.append("ALTER TABLE ").append(name);
            sb.append(" ADD (").append(ORASQL.getColumnStr(column)).append(")");
            return sb.toString();
        }

        private static String getColumnStr(DBColumn column) throws DBException {
            StringBuilder sb = new StringBuilder();
            sb.append(column.name).append(" ").append(ORASQL.getTypeStr(column.type));
            if (column.defaultVal != null) {
                sb.append(" DEFAULT ");
                if (column.defaultVal instanceof String) {
                    sb.append(DBOraHelper.formatSqlStr((String)column.defaultVal));
                } else {
                    sb.append(column.defaultVal.toString());
                }
            }
            if (column.notnull != null) {
                sb.append(" ").append(column.notnull != false ? "NOT NULL" : "NULL");
            }
            return sb.toString();
        }

        private static String getTypeStr(DBColumn.DataType type) throws DBException {
            if (type instanceof DBColumn.Numeric) {
                return ORASQL.getTypeNumericStr((DBColumn.Numeric)type);
            }
            if (type instanceof DBColumn.DateTime) {
                return ORASQL.getTypeDateTimeStr((DBColumn.DateTime)type);
            }
            if (type instanceof DBColumn.Text) {
                return ORASQL.getTypeTextStr((DBColumn.Text)type);
            }
            throw new DBException("unknow column data type");
        }

        private static String getTypeNumericStr(DBColumn.Numeric type) throws DBException {
            StringBuilder sb = new StringBuilder();
            if (type instanceof DBColumn.Numeric.BIT) {
                DBColumn.Numeric.BIT t = (DBColumn.Numeric.BIT)type;
                sb.append("RAW");
                sb.append("(").append(t.m).append(")");
            } else if (type instanceof DBColumn.Numeric.TINYINT) {
                sb.append("NUMBER(3)");
            } else if (type instanceof DBColumn.Numeric.SMALLINT) {
                sb.append("NUMBER(5)");
            } else if (type instanceof DBColumn.Numeric.MEDIUMINT) {
                sb.append("NUMBER(7)");
            } else if (type instanceof DBColumn.Numeric.INT) {
                sb.append("NUMBER(10)");
            } else if (type instanceof DBColumn.Numeric.BIGINT) {
                sb.append("NUMBER(20)");
            } else if (type instanceof DBColumn.Numeric.FLOAT) {
                sb.append("FLOAT");
            } else if (type instanceof DBColumn.Numeric.DOUBLE) {
                sb.append("DOUBLE");
            } else if (type instanceof DBColumn.Numeric.DECIMAL) {
                DBColumn.Numeric.DECIMAL t = (DBColumn.Numeric.DECIMAL)type;
                sb.append("NUMBER");
                sb.append("(").append(t.m).append(",").append(t.d).append(")");
            } else {
                throw new DBException("unknow numeric column data type");
            }
            return sb.toString();
        }

        private static String getTypeDateTimeStr(DBColumn.DateTime type) throws DBException {
            StringBuilder sb = new StringBuilder();
            if (type instanceof DBColumn.DateTime.DATE) {
                sb.append("DATE");
            } else if (type instanceof DBColumn.DateTime.DATETIME) {
                sb.append("TIMESTAMP");
            } else if (type instanceof DBColumn.DateTime.TIMESTAMP) {
                sb.append("TIMESTAMP");
            } else if (type instanceof DBColumn.DateTime.TIME) {
                sb.append("TIMESTAMP");
            } else {
                throw new DBException("unknow datetime column data type");
            }
            return sb.toString();
        }

        private static String getTypeTextStr(DBColumn.Text type) throws DBException {
            StringBuilder sb = new StringBuilder();
            if (type instanceof DBColumn.Text.CHAR) {
                DBColumn.Text.CHAR t = (DBColumn.Text.CHAR)type;
                sb.append("NCHAR");
                sb.append("(").append(t.m).append(")");
            } else if (type instanceof DBColumn.Text.VARCHAR) {
                DBColumn.Text.VARCHAR t = (DBColumn.Text.VARCHAR)type;
                sb.append("NVARCHAR2");
                sb.append("(").append(t.m).append(")");
            } else if (type instanceof DBColumn.Text.TEXT) {
                sb.append("NCLOB");
            } else if (type instanceof DBColumn.Text.TINYTEXT) {
                sb.append("NCLOB");
            } else if (type instanceof DBColumn.Text.MEDIUMTEXT) {
                sb.append("NCLOB");
            } else if (type instanceof DBColumn.Text.LONGTEXT) {
                sb.append("NCLOB");
            } else {
                throw new DBException("unknow text column data type");
            }
            return sb.toString();
        }
    }

    public static class MSSQL {
        public static String getCreateTableSql(DBTable table) throws DBException {
            StringBuilder sb = new StringBuilder();
            sb.append("CREATE TABLE ");
            if (table.database != null) {
                sb.append(table.database).append("..");
            }
            if (table.temp != null && table.temp.booleanValue()) {
                sb.append("#");
            }
            sb.append(table.name).append("(");
            int defCnt = 0;
            if (table.columns != null) {
                for (DBColumn column : table.columns) {
                    if (defCnt > 0) {
                        sb.append(",");
                    }
                    sb.append(MSSQL.getColumnStr(column));
                    ++defCnt;
                }
            }
            if (table.pkColNames != null) {
                if (defCnt > 0) {
                    sb.append(",");
                }
                sb.append("PRIMARY KEY(");
                int colCnt = 0;
                for (String pkColName : table.pkColNames) {
                    if (colCnt > 0) {
                        sb.append(",");
                    }
                    sb.append(pkColName);
                    ++colCnt;
                }
                sb.append(")");
                ++defCnt;
            }
            if (table.uniqueColNames != null) {
                if (defCnt > 0) {
                    sb.append(",");
                }
                sb.append("UNIQUE(");
                int colCnt = 0;
                for (String uniqueColName : table.uniqueColNames) {
                    if (colCnt > 0) {
                        sb.append(",");
                    }
                    sb.append(uniqueColName);
                    ++colCnt;
                }
                sb.append(")");
                ++defCnt;
            }
            sb.append(")");
            return sb.toString();
        }

        public static String getDropTableSql(String name) throws DBException {
            StringBuilder sb = new StringBuilder();
            sb.append("DROP TABLE ").append(name);
            return sb.toString();
        }

        public static String getAddColumnSql(String name, DBColumn column) throws DBException {
            StringBuilder sb = new StringBuilder();
            sb.append("ALTER TABLE ").append(name);
            sb.append(" ADD ").append(MSSQL.getColumnStr(column));
            return sb.toString();
        }

        private static String getColumnStr(DBColumn column) throws DBException {
            StringBuilder sb = new StringBuilder();
            sb.append(column.name).append(" ").append(MSSQL.getTypeStr(column.type));
            if (column.collate != null) {
                sb.append(" COLLATE ").append(column.collate);
            }
            if (column.defaultVal != null) {
                sb.append(" DEFAULT ");
                if (column.defaultVal instanceof String) {
                    sb.append(DBMSHelper.formatSqlStr((String)column.defaultVal));
                } else {
                    sb.append(column.defaultVal.toString());
                }
            }
            if (column.autoinc != null && column.autoinc.booleanValue()) {
                sb.append(" IDENTITY (1,1)");
            }
            if (column.notnull != null) {
                sb.append(" ").append(column.notnull != false ? "NOT NULL" : "NULL");
            }
            return sb.toString();
        }

        private static String getTypeStr(DBColumn.DataType type) throws DBException {
            if (type instanceof DBColumn.Numeric) {
                return MSSQL.getTypeNumericStr((DBColumn.Numeric)type);
            }
            if (type instanceof DBColumn.DateTime) {
                return MSSQL.getTypeDateTimeStr((DBColumn.DateTime)type);
            }
            if (type instanceof DBColumn.Text) {
                return MSSQL.getTypeTextStr((DBColumn.Text)type);
            }
            throw new DBException("unknow column data type");
        }

        private static String getTypeNumericStr(DBColumn.Numeric type) throws DBException {
            StringBuilder sb = new StringBuilder();
            if (type instanceof DBColumn.Numeric.BIT) {
                sb.append("BIT");
            } else if (type instanceof DBColumn.Numeric.TINYINT) {
                sb.append("TINYINT");
            } else if (type instanceof DBColumn.Numeric.SMALLINT) {
                sb.append("SMALLINT");
            } else if (type instanceof DBColumn.Numeric.MEDIUMINT) {
                sb.append("INT");
            } else if (type instanceof DBColumn.Numeric.INT) {
                sb.append("INT");
            } else if (type instanceof DBColumn.Numeric.BIGINT) {
                sb.append("BIGINT");
            } else if (type instanceof DBColumn.Numeric.FLOAT) {
                sb.append("FLOAT");
            } else if (type instanceof DBColumn.Numeric.DOUBLE) {
                sb.append("DOUBLE");
            } else if (type instanceof DBColumn.Numeric.DECIMAL) {
                DBColumn.Numeric.DECIMAL t = (DBColumn.Numeric.DECIMAL)type;
                sb.append("DECIMAL");
                sb.append("(").append(t.m).append(",").append(t.d).append(")");
            } else {
                throw new DBException("unknow numeric column data type");
            }
            return sb.toString();
        }

        private static String getTypeDateTimeStr(DBColumn.DateTime type) throws DBException {
            StringBuilder sb = new StringBuilder();
            if (type instanceof DBColumn.DateTime.DATE) {
                sb.append("DATETIME");
            } else if (type instanceof DBColumn.DateTime.DATETIME) {
                sb.append("DATETIME");
            } else if (type instanceof DBColumn.DateTime.TIMESTAMP) {
                sb.append("DATETIME");
            } else if (type instanceof DBColumn.DateTime.TIME) {
                sb.append("DATETIME");
            } else {
                throw new DBException("unknow datetime column data type");
            }
            return sb.toString();
        }

        private static String getTypeTextStr(DBColumn.Text type) throws DBException {
            StringBuilder sb = new StringBuilder();
            if (type instanceof DBColumn.Text.CHAR) {
                DBColumn.Text.CHAR t = (DBColumn.Text.CHAR)type;
                sb.append("NCHAR");
                sb.append("(").append(t.m).append(")");
            } else if (type instanceof DBColumn.Text.VARCHAR) {
                DBColumn.Text.VARCHAR t = (DBColumn.Text.VARCHAR)type;
                sb.append("NVARCHAR");
                sb.append("(").append(t.m).append(")");
            } else if (type instanceof DBColumn.Text.TEXT) {
                sb.append("NTEXT");
            } else if (type instanceof DBColumn.Text.TINYTEXT) {
                sb.append("NTEXT");
            } else if (type instanceof DBColumn.Text.MEDIUMTEXT) {
                sb.append("NTEXT");
            } else if (type instanceof DBColumn.Text.LONGTEXT) {
                sb.append("NTEXT");
            } else {
                throw new DBException("unknow text column data type");
            }
            return sb.toString();
        }
    }

    public static class MYSQL {
        public static String getCreateTableSql(DBTable table) throws DBException {
            StringBuilder sb = new StringBuilder();
            String temporary = "";
            if (table.temp != null && table.temp.booleanValue()) {
                temporary = " TEMPORARY";
            }
            String ifnotexist = "";
            if (table.ifnotexist != null && table.ifnotexist.booleanValue()) {
                ifnotexist = " IF NOT EXISTS";
            }
            sb.append("CREATE").append(temporary).append(" TABLE").append(ifnotexist).append(" ");
            if (table.database != null) {
                sb.append("`").append(table.database).append("`.");
            }
            sb.append("`").append(table.name).append("`(");
            int defCnt = 0;
            if (table.columns != null) {
                for (DBColumn dBColumn : table.columns) {
                    if (defCnt > 0) {
                        sb.append(",");
                    }
                    sb.append(MYSQL.getColumnStr(dBColumn));
                    ++defCnt;
                }
            }
            if (table.pkColNames != null) {
                if (defCnt > 0) {
                    sb.append(",");
                }
                sb.append("PRIMARY KEY(");
                int colCnt = 0;
                for (String pkColName : table.pkColNames) {
                    if (colCnt > 0) {
                        sb.append(",");
                    }
                    sb.append("`").append(pkColName).append("`");
                    ++colCnt;
                }
                sb.append(")");
                ++defCnt;
            }
            if (table.uniqueColNames != null) {
                if (defCnt > 0) {
                    sb.append(",");
                }
                sb.append("UNIQUE(");
                int colCnt = 0;
                for (String uniqueColName : table.uniqueColNames) {
                    if (colCnt > 0) {
                        sb.append(",");
                    }
                    sb.append("`").append(uniqueColName).append("`");
                    ++colCnt;
                }
                sb.append(")");
                ++defCnt;
            }
            if (table.indexs != null) {
                for (DBIndex dBIndex : table.indexs) {
                    if (defCnt > 0) {
                        sb.append(",");
                    }
                    sb.append(MYSQL.getIndexStr(dBIndex));
                    ++defCnt;
                }
            }
            sb.append(")");
            if (table.type != null) {
                sb.append(" ENGINE=").append(table.type);
            }
            if (table.charset != null) {
                sb.append(" DEFAULT CHARSET=").append(table.charset);
                if (table.collation != null) {
                    sb.append(" COLLATE=").append(table.collation);
                }
            }
            if (table.checksum != null) {
                sb.append(" CHECKSUM=").append(table.checksum != false ? "1" : "0");
            }
            if (table.autoinc != null) {
                sb.append(" AUTO_INCREMENT=").append(table.autoinc);
            }
            if (table.avgrowlen != null) {
                sb.append(" AVG_ROW_LENGTH=").append(table.avgrowlen);
            }
            if (table.rowformat != null) {
                sb.append(" ROW_FORMAT=").append(table.rowformat);
            }
            if (table.comment != null) {
                sb.append(" COMMENT=").append(DBMyHelper.formatSqlStr(table.comment));
            }
            return sb.toString();
        }

        public static String getDropTableSql(String name) throws DBException {
            StringBuilder sb = new StringBuilder();
            sb.append("DROP TABLE `").append(name).append("`");
            return sb.toString();
        }

        public static String getAddColumnSql(String name, DBColumn column) throws DBException {
            StringBuilder sb = new StringBuilder();
            sb.append("ALTER TABLE `").append(name).append("`");
            sb.append(" ADD COLUMN ").append(MYSQL.getColumnStr(column));
            return sb.toString();
        }

        private static String getColumnStr(DBColumn column) throws DBException {
            StringBuilder sb = new StringBuilder();
            sb.append("`").append(column.name).append("` ").append(MYSQL.getTypeStr(column.type));
            if (column.charset != null) {
                sb.append(" CHARACTER SET ").append(column.charset);
            }
            if (column.collate != null) {
                sb.append(" COLLATE ").append(column.collate);
            }
            if (column.notnull != null) {
                sb.append(" ").append(column.notnull != false ? "NOT NULL" : "NULL");
            }
            if (column.defaultVal != null) {
                sb.append(" DEFAULT ");
                if (column.defaultVal instanceof String) {
                    sb.append(DBMyHelper.formatSqlStr((String)column.defaultVal));
                } else {
                    sb.append(column.defaultVal.toString());
                }
            }
            if (column.autoinc != null && column.autoinc.booleanValue()) {
                sb.append(" AUTO_INCREMENT");
            }
            if (column.comment != null) {
                sb.append(" COMMENT ").append(DBMyHelper.formatSqlStr(column.comment));
            }
            return sb.toString();
        }

        private static String getIndexStr(DBIndex index) throws DBException {
            StringBuilder sb = new StringBuilder();
            sb.append("INDEX `").append(index.name).append("`");
            if (index.type != null) {
                sb.append(" USING ").append(index.type);
            }
            if (index.colNames != null && !index.colNames.isEmpty()) {
                sb.append("(");
                for (int i = 0; i < index.colNames.size(); ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append("`").append(index.colNames.get(i)).append("`");
                }
                sb.append(")");
            }
            return sb.toString();
        }

        private static String getTypeStr(DBColumn.DataType type) throws DBException {
            if (type instanceof DBColumn.Numeric) {
                return MYSQL.getTypeNumericStr((DBColumn.Numeric)type);
            }
            if (type instanceof DBColumn.DateTime) {
                return MYSQL.getTypeDateTimeStr((DBColumn.DateTime)type);
            }
            if (type instanceof DBColumn.Text) {
                return MYSQL.getTypeTextStr((DBColumn.Text)type);
            }
            throw new DBException("unknow column data type");
        }

        private static String getTypeNumericStr(DBColumn.Numeric type) throws DBException {
            StringBuilder sb = new StringBuilder();
            if (type instanceof DBColumn.Numeric.BIT) {
                DBColumn.Numeric.BIT t = (DBColumn.Numeric.BIT)type;
                sb.append("BIT");
                if (t.m != null) {
                    sb.append("(").append(t.m).append(")");
                }
            } else if (type instanceof DBColumn.Numeric.TINYINT) {
                DBColumn.Numeric.TINYINT t = (DBColumn.Numeric.TINYINT)type;
                sb.append("TINYINT");
                if (t.m != null) {
                    sb.append("(").append(t.m).append(")");
                }
                if (t.unsigned != null && t.unsigned.booleanValue()) {
                    sb.append(" UNSIGNED");
                }
                if (t.zerofill != null && t.zerofill.booleanValue()) {
                    sb.append(" ZEROFILL");
                }
            } else if (type instanceof DBColumn.Numeric.SMALLINT) {
                DBColumn.Numeric.SMALLINT t = (DBColumn.Numeric.SMALLINT)type;
                sb.append("SMALLINT");
                if (t.m != null) {
                    sb.append("(").append(t.m).append(")");
                }
                if (t.unsigned != null && t.unsigned.booleanValue()) {
                    sb.append(" UNSIGNED");
                }
                if (t.zerofill != null && t.zerofill.booleanValue()) {
                    sb.append(" ZEROFILL");
                }
            } else if (type instanceof DBColumn.Numeric.MEDIUMINT) {
                DBColumn.Numeric.MEDIUMINT t = (DBColumn.Numeric.MEDIUMINT)type;
                sb.append("MEDIUMINT");
                if (t.m != null) {
                    sb.append("(").append(t.m).append(")");
                }
                if (t.unsigned != null && t.unsigned.booleanValue()) {
                    sb.append(" UNSIGNED");
                }
                if (t.zerofill != null && t.zerofill.booleanValue()) {
                    sb.append(" ZEROFILL");
                }
            } else if (type instanceof DBColumn.Numeric.INT) {
                DBColumn.Numeric.INT t = (DBColumn.Numeric.INT)type;
                sb.append("INT");
                if (t.m != null) {
                    sb.append("(").append(t.m).append(")");
                }
                if (t.unsigned != null && t.unsigned.booleanValue()) {
                    sb.append(" UNSIGNED");
                }
                if (t.zerofill != null && t.zerofill.booleanValue()) {
                    sb.append(" ZEROFILL");
                }
            } else if (type instanceof DBColumn.Numeric.BIGINT) {
                DBColumn.Numeric.BIGINT t = (DBColumn.Numeric.BIGINT)type;
                sb.append("BIGINT");
                if (t.m != null) {
                    sb.append("(").append(t.m).append(")");
                }
                if (t.unsigned != null && t.unsigned.booleanValue()) {
                    sb.append(" UNSIGNED");
                }
                if (t.zerofill != null && t.zerofill.booleanValue()) {
                    sb.append(" ZEROFILL");
                }
            } else if (type instanceof DBColumn.Numeric.FLOAT) {
                DBColumn.Numeric.FLOAT t = (DBColumn.Numeric.FLOAT)type;
                sb.append("FLOAT");
                if (t.m != null) {
                    sb.append("(").append(t.m);
                    if (t.d != null) {
                        sb.append(",").append(t.d);
                    }
                    sb.append(")");
                }
                if (t.unsigned != null && t.unsigned.booleanValue()) {
                    sb.append(" UNSIGNED");
                }
                if (t.zerofill != null && t.zerofill.booleanValue()) {
                    sb.append(" ZEROFILL");
                }
            } else if (type instanceof DBColumn.Numeric.DOUBLE) {
                DBColumn.Numeric.DOUBLE t = (DBColumn.Numeric.DOUBLE)type;
                sb.append("DOUBLE");
                if (t.m != null) {
                    sb.append("(").append(t.m);
                    if (t.d != null) {
                        sb.append(",").append(t.d);
                    }
                    sb.append(")");
                }
                if (t.unsigned != null && t.unsigned.booleanValue()) {
                    sb.append(" UNSIGNED");
                }
                if (t.zerofill != null && t.zerofill.booleanValue()) {
                    sb.append(" ZEROFILL");
                }
            } else if (type instanceof DBColumn.Numeric.DECIMAL) {
                DBColumn.Numeric.DECIMAL t = (DBColumn.Numeric.DECIMAL)type;
                sb.append("DECIMAL");
                sb.append("(").append(t.m).append(",").append(t.d).append(")");
                if (t.unsigned != null && t.unsigned.booleanValue()) {
                    sb.append(" UNSIGNED");
                }
                if (t.zerofill != null && t.zerofill.booleanValue()) {
                    sb.append(" ZEROFILL");
                }
            } else {
                throw new DBException("unknow numeric column data type");
            }
            return sb.toString();
        }

        private static String getTypeDateTimeStr(DBColumn.DateTime type) throws DBException {
            StringBuilder sb = new StringBuilder();
            if (type instanceof DBColumn.DateTime.DATE) {
                sb.append("DATE");
            } else if (type instanceof DBColumn.DateTime.DATETIME) {
                sb.append("DATETIME");
            } else if (type instanceof DBColumn.DateTime.TIMESTAMP) {
                sb.append("TIMESTAMP");
            } else if (type instanceof DBColumn.DateTime.TIME) {
                sb.append("TIME");
            } else if (type instanceof DBColumn.DateTime.YEAR) {
                DBColumn.DateTime.YEAR t = (DBColumn.DateTime.YEAR)type;
                sb.append("YEAR");
                if (t.LEN4 != null) {
                    sb.append("(").append(t.LEN4 != false ? "4" : "2").append(")");
                }
            } else {
                throw new DBException("unknow datetime column data type");
            }
            return sb.toString();
        }

        private static String getTypeTextStr(DBColumn.Text type) throws DBException {
            StringBuilder sb = new StringBuilder();
            if (type instanceof DBColumn.Text.CHAR) {
                DBColumn.Text.CHAR t = (DBColumn.Text.CHAR)type;
                sb.append("CHAR");
                sb.append("(").append(t.m).append(")");
                if (t.binary != null && t.binary.booleanValue()) {
                    sb.append(" BINARY");
                }
                if (t.ascii != null && t.ascii.booleanValue()) {
                    sb.append(" ASCII");
                }
                if (t.unicode != null && t.unicode.booleanValue()) {
                    sb.append(" UNICODE");
                }
            } else if (type instanceof DBColumn.Text.VARCHAR) {
                DBColumn.Text.VARCHAR t = (DBColumn.Text.VARCHAR)type;
                sb.append("VARCHAR");
                sb.append("(").append(t.m).append(")");
                if (t.binary != null && t.binary.booleanValue()) {
                    sb.append(" BINARY");
                }
            } else if (type instanceof DBColumn.Text.TEXT) {
                DBColumn.Text.TEXT t = (DBColumn.Text.TEXT)type;
                sb.append("TEXT");
                if (t.binary != null && t.binary.booleanValue()) {
                    sb.append(" BINARY");
                }
            } else if (type instanceof DBColumn.Text.TINYTEXT) {
                DBColumn.Text.TINYTEXT t = (DBColumn.Text.TINYTEXT)type;
                sb.append("TINYTEXT");
                if (t.binary != null && t.binary.booleanValue()) {
                    sb.append(" BINARY");
                }
            } else if (type instanceof DBColumn.Text.MEDIUMTEXT) {
                DBColumn.Text.MEDIUMTEXT t = (DBColumn.Text.MEDIUMTEXT)type;
                sb.append("MEDIUMTEXT");
                if (t.binary != null && t.binary.booleanValue()) {
                    sb.append(" BINARY");
                }
            } else if (type instanceof DBColumn.Text.LONGTEXT) {
                DBColumn.Text.LONGTEXT t = (DBColumn.Text.LONGTEXT)type;
                sb.append("LONGTEXT");
                if (t.binary != null && t.binary.booleanValue()) {
                    sb.append(" BINARY");
                }
            } else if (type instanceof DBColumn.Text.BLOB) {
                sb.append("BLOB");
            } else if (type instanceof DBColumn.Text.TINYBLOB) {
                sb.append("TINYBLOB");
            } else if (type instanceof DBColumn.Text.MEDIUMBLOB) {
                sb.append("MEDIUMBLOB");
            } else if (type instanceof DBColumn.Text.LONGBLOB) {
                sb.append("LONGBLOB");
            } else if (type instanceof DBColumn.Text.ENUM) {
                DBColumn.Text.ENUM t = (DBColumn.Text.ENUM)type;
                sb.append("ENUM(");
                for (int i = 0; i < t.values.size(); ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(DBMyHelper.formatSqlStr(t.values.get(i)));
                }
                sb.append(")");
            } else if (type instanceof DBColumn.Text.SET) {
                DBColumn.Text.SET t = (DBColumn.Text.SET)type;
                sb.append("SET(");
                for (int i = 0; i < t.values.size(); ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(DBMyHelper.formatSqlStr(t.values.get(i)));
                }
                sb.append(")");
            } else {
                throw new DBException("unknow text column data type");
            }
            return sb.toString();
        }
    }

    public static class DBColumn {
        public String name;
        public DataType type;
        public Boolean notnull;
        public Object defaultVal;
        public Boolean autoinc;
        public String comment;
        public String charset;
        public String collate;

        public DBColumn(String name, DataType type) {
            this.name = name;
            this.type = type;
        }

        public DBColumn(String name, DataType type, Boolean notnull) {
            this.name = name;
            this.type = type;
            this.notnull = notnull;
        }

        public DBColumn(String name, DataType type, Boolean notnull, Object defaultVal) {
            this.name = name;
            this.type = type;
            this.notnull = notnull;
            this.defaultVal = defaultVal;
        }

        public DBColumn(String name, DataType type, Boolean notnull, Object defaultVal, String comment) {
            this.name = name;
            this.type = type;
            this.notnull = notnull;
            this.defaultVal = defaultVal;
            this.comment = comment;
        }

        public static abstract class Text
        extends DataType {

            public static class SET
            extends Text {
                ArrayList<String> values;

                public SET(ArrayList<String> values) {
                    this.values = values;
                }
            }

            public static class ENUM
            extends Text {
                ArrayList<String> values;

                public ENUM(ArrayList<String> values) {
                    this.values = values;
                }
            }

            public static class LONGBLOB
            extends Text {
            }

            public static class MEDIUMBLOB
            extends Text {
            }

            public static class TINYBLOB
            extends Text {
            }

            public static class BLOB
            extends Text {
            }

            public static class LONGTEXT
            extends Text {
                public Boolean binary;
            }

            public static class MEDIUMTEXT
            extends Text {
                public Boolean binary;
            }

            public static class TINYTEXT
            extends Text {
                public Boolean binary;
            }

            public static class TEXT
            extends Text {
                public Boolean binary;
            }

            public static class VARCHAR
            extends Text {
                public Integer m;
                public Boolean binary;

                public VARCHAR(int m) {
                    this.m = m;
                }
            }

            public static class CHAR
            extends Text {
                public Integer m;
                public Boolean binary;
                public Boolean ascii;
                public Boolean unicode;

                public CHAR(int m) {
                    this.m = m;
                }
            }
        }

        public static abstract class DateTime
        extends DataType {

            public static class YEAR
            extends DateTime {
                public Boolean LEN4;

                public YEAR() {
                }

                public YEAR(boolean len4) {
                    this.LEN4 = len4;
                }
            }

            public static class TIME
            extends DateTime {
            }

            public static class TIMESTAMP
            extends DateTime {
            }

            public static class DATETIME
            extends DateTime {
            }

            public static class DATE
            extends DateTime {
            }
        }

        public static abstract class Numeric
        extends DataType {

            public static class FIXED
            extends DECIMAL {
                public FIXED(int m, int d) {
                    super(m, d);
                }
            }

            public static class NUMERIC
            extends DECIMAL {
                public NUMERIC(int m, int d) {
                    super(m, d);
                }
            }

            public static class DEC
            extends DECIMAL {
                public DEC(int m, int d) {
                    super(m, d);
                }
            }

            public static class DECIMAL
            extends Numeric {
                public Integer m;
                public Integer d;
                public Boolean unsigned;
                public Boolean zerofill;

                public DECIMAL(int m, int d) {
                    this.m = m;
                    this.d = d;
                }
            }

            public static class REAL
            extends DOUBLE {
                public REAL() {
                }

                public REAL(int m) {
                    super(m);
                }

                public REAL(int m, int d) {
                    super(m, d);
                }
            }

            public static class DOUBLE_PRECISION
            extends DOUBLE {
                public DOUBLE_PRECISION() {
                }

                public DOUBLE_PRECISION(int m) {
                    super(m);
                }

                public DOUBLE_PRECISION(int m, int d) {
                    super(m, d);
                }
            }

            public static class DOUBLE
            extends Numeric {
                public Integer m;
                public Integer d;
                public Boolean unsigned;
                public Boolean zerofill;

                public DOUBLE() {
                }

                public DOUBLE(int m) {
                    this.m = m;
                }

                public DOUBLE(int m, int d) {
                    this.m = m;
                    this.d = d;
                }
            }

            public static class FLOAT
            extends Numeric {
                public Integer m;
                public Integer d;
                public Boolean unsigned;
                public Boolean zerofill;

                public FLOAT() {
                }

                public FLOAT(int m) {
                    this.m = m;
                }

                public FLOAT(int m, int d) {
                    this.m = m;
                    this.d = d;
                }
            }

            public static class BIGINT
            extends Numeric {
                public Integer m;
                public Boolean unsigned;
                public Boolean zerofill;

                public BIGINT() {
                }

                public BIGINT(int m) {
                    this.m = m;
                }
            }

            public static class INTEGER
            extends INT {
                public INTEGER() {
                }

                public INTEGER(int M) {
                    super(M);
                }
            }

            public static class INT
            extends Numeric {
                public Integer m;
                public Boolean unsigned;
                public Boolean zerofill;

                public INT() {
                }

                public INT(int m) {
                    this.m = m;
                }
            }

            public static class MEDIUMINT
            extends Numeric {
                public Integer m;
                public Boolean unsigned;
                public Boolean zerofill;

                public MEDIUMINT() {
                }

                public MEDIUMINT(int m) {
                    this.m = m;
                }
            }

            public static class SMALLINT
            extends Numeric {
                public Integer m;
                public Boolean unsigned;
                public Boolean zerofill;

                public SMALLINT() {
                }

                public SMALLINT(int m) {
                    this.m = m;
                }
            }

            public static class TINYINT
            extends Numeric {
                public Integer m;
                public Boolean unsigned;
                public Boolean zerofill;

                public TINYINT() {
                }

                public TINYINT(int m) {
                    this.m = m;
                }
            }

            public static class BIT
            extends Numeric {
                public Integer m;

                public BIT() {
                }

                public BIT(int m) {
                    this.m = m;
                }
            }
        }

        public static abstract class DataType {
        }
    }

    public static class DBIndex {
        public static final String TYPE_BTREE = "BTREE";
        public static final String TYPE_FULLTEXT = "FULLTEXT";
        public static final String TYPE_HASH = "HASH";
        public static final String TYPE_RTREE = "RTREE";
        public String name;
        public String kind;
        public String type;
        public ArrayList<String> colNames;

        public DBIndex(String name, ArrayList<String> colNames) {
            this.name = name;
            this.colNames = colNames;
        }
    }

    public static class DBTable
    implements Comparable<DBTable> {
        public static final String TYPE_MYISAM = "MyISAM";
        public static final String TYPE_INNODB = "InnoDB";
        public static final String TYPE_MEMORY = "Memory";
        public static final String FORMAT_DEFAULT = "DEFAULT";
        public static final String FORMAT_DYNAMIC = "DYNAMIC";
        public static final String FORMAT_FIXED = "FIXED";
        public static final String FORMAT_COMPRESSED = "COMPRESSED";
        public static final String FORMAT_REDUNDANT = "REDUNDANT";
        public static final String FORMAT_COMPACT = "COMPACT";
        public static final String CHARSET_UTF8 = "utf8";
        public String database;
        public String name;
        public ArrayList<DBColumn> columns;
        public ArrayList<String> pkColNames;
        public ArrayList<String> uniqueColNames;
        public ArrayList<DBIndex> indexs;
        public String type;
        public String charset;
        public String collation;
        public Long autoinc;
        public Long avgrowlen;
        public Boolean checksum;
        public String rowformat;
        public Boolean temp;
        public Boolean ifnotexist;
        public String comment;

        public DBTable() {
        }

        public DBTable(String name) {
            this.name = name;
        }

        public DBTable(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public DBTable(String name, String type, String charset) {
            this.name = name;
            this.type = type;
            this.charset = charset;
        }

        public DBTable(String name, String type, String charset, String comment) {
            this.name = name;
            this.type = type;
            this.charset = charset;
            this.comment = comment;
        }

        public void addColumn(DBColumn column) {
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.add(column);
        }

        public void addPkColNames(String ... colNames) {
            if (this.pkColNames == null) {
                this.pkColNames = DBTable.array2list(colNames);
            } else {
                this.pkColNames.addAll(Arrays.asList(colNames));
            }
        }

        public void addUniqueColNames(String ... colNames) {
            if (this.uniqueColNames == null) {
                this.uniqueColNames = DBTable.array2list(colNames);
            } else {
                this.uniqueColNames.addAll(Arrays.asList(colNames));
            }
        }

        public void addIndex(String name, String ... colNames) {
            this.addIndex(new DBIndex(name, DBTable.array2list(colNames)));
        }

        public void addIndex(DBIndex index) {
            if (this.indexs == null) {
                this.indexs = new ArrayList();
            }
            this.indexs.add(index);
        }

        public static ArrayList<String> array2list(String ... arr) {
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(Arrays.asList(arr));
            return list;
        }

        @Override
        public int compareTo(DBTable o) {
            String name1 = ToolStr.nullToEmpty(this.name);
            String name2 = o != null ? ToolStr.nullToEmpty(o.name) : "";
            return name1.compareTo(name2);
        }
    }
}

