/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.database;

import com.modnut.framework2.database.DBException;
import com.modnut.framework2.database.DBStat;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBConn {
    private Connection conn;
    private short type;
    private boolean doingTran;
    private DBStat dbstat;
    private final ArrayList<DBStat> newDbStats = new ArrayList();
    private String url;
    private String user;
    private String password;

    public DBConn(String url, String user, String password) throws DBException {
        try {
            this.conn = user == null && password == null ? DriverManager.getConnection(url) : DriverManager.getConnection(url, user, password);
            this.type = TYPE.getType(url);
            this.doingTran = false;
            this.url = url;
            this.user = user;
            this.password = password;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public DBConn getClone() throws DBException {
        if (this.url == null && this.user == null && this.password == null) {
            throw new DBException("connection not create by url");
        }
        return new DBConn(this.url, this.user, this.password);
    }

    public synchronized Connection getOrigin() throws DBException {
        try {
            if (this.conn == null || this.conn.isClosed()) {
                this.conn = this.user == null && this.password == null ? DriverManager.getConnection(this.url) : DriverManager.getConnection(this.url, this.user, this.password);
                this.doingTran = false;
            }
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
        return this.conn;
    }

    public short getType() {
        return this.type;
    }

    public boolean isClosed() throws DBException {
        try {
            return this.getOrigin().isClosed();
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public String getCatalog() throws DBException {
        try {
            return this.getOrigin().getCatalog();
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public void setCatalog(String catalog) throws DBException {
        try {
            this.getOrigin().setCatalog(catalog);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public void setAutoCommit(boolean autoCommit) throws DBException {
        try {
            this.getOrigin().setAutoCommit(autoCommit);
            this.doingTran = !autoCommit;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public boolean getAutoCommit() throws DBException {
        try {
            return this.getOrigin().getAutoCommit();
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public void startTran() throws DBException {
        try {
            this.getOrigin().setAutoCommit(false);
            this.doingTran = true;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public void commitTran() throws DBException {
        try {
            this.getOrigin().commit();
            this.doingTran = false;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public void rollbackTran() throws DBException {
        try {
            this.getOrigin().rollback();
            this.doingTran = false;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws DBException {
        if (!this.isClosed()) {
            ArrayList<DBStat> arrayList = this.newDbStats;
            synchronized (arrayList) {
                if (this.newDbStats != null) {
                    for (DBStat stat : this.newDbStats) {
                        DBStat.close(stat);
                    }
                    this.newDbStats.clear();
                }
            }
            DBStat.close(this.dbstat);
            if (this.doingTran) {
                this.rollbackTran();
            }
            try {
                this.getOrigin().close();
            }
            catch (SQLException ex) {
                throw new DBException(ex);
            }
        }
    }

    public DBStat getDBStat() throws DBException {
        if (this.dbstat == null) {
            this.dbstat = this.getNewDBStat();
        }
        return this.dbstat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBStat getNewDBStat() throws DBException {
        try {
            DBStat stat = new DBStat(this.getOrigin().createStatement(), this.type);
            ArrayList<DBStat> arrayList = this.newDbStats;
            synchronized (arrayList) {
                this.newDbStats.add(stat);
            }
            return stat;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public static void close(DBConn conn) {
        try {
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    static {
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DBConn.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DBConn.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DBConn.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            Class.forName("com.ibm.db2.jcc.DB2Driver");
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DBConn.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DBConn.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static class TYPE {
        public static final short NONE = 0;
        public static final short MYSQL = 1;
        public static final short MSSQL = 2;
        public static final short ORASQL = 3;
        public static final short DB2SQL = 4;
        public static final short SQLITE = 5;

        public static short getType(String url) {
            if (url.startsWith("jdbc:mysql")) {
                return 1;
            }
            if (url.startsWith("jdbc:sqlserver")) {
                return 2;
            }
            if (url.startsWith("jdbc:oracle")) {
                return 3;
            }
            if (url.startsWith("jdbc:db2")) {
                return 4;
            }
            if (url.startsWith("jdbc:sqlite")) {
                return 5;
            }
            return 0;
        }

        public static String getName(short type) {
            switch (type) {
                case 1: {
                    return "MySQL";
                }
                case 2: {
                    return "Microsoft SQL Server";
                }
                case 3: {
                    return "Oracle";
                }
                case 4: {
                    return "IBM DB2";
                }
                case 5: {
                    return "SQLite";
                }
            }
            return "(unknow)";
        }
    }
}

