/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.data;

import com.modnut.framework2.constant.ConstFramework;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;

public class DataTable {
    private static final byte BYTE_TRUE = 1;
    private static final byte BYTE_FASLE = 0;
    private static final int NULL_OBJECT_LENGTH = -1;
    private static final int EMPTY_COUNT = 0;

    public static class FileReader {
        private int rows;
        private int cols;
        private long[][] cellOffset;
        private String[] headNames;
        private MetaInfo meta;
        private RandomAccessFile file;
        private Charset charset;
        private long readOffset;
        private static final int NONE_OFFSET = -1;

        public FileReader(String path) throws DataTableException {
            try {
                this.init(new RandomAccessFile(path, "r"), null);
            }
            catch (FileNotFoundException ex) {
                throw new DataTableException(DataTableException.NUM.IO_EXCEPTION, ex.getMessage());
            }
        }

        public FileReader(String path, Charset charset) throws DataTableException {
            try {
                this.init(new RandomAccessFile(path, "r"), charset);
            }
            catch (FileNotFoundException ex) {
                throw new DataTableException(DataTableException.NUM.IO_EXCEPTION, ex.getMessage());
            }
        }

        public FileReader(File file) throws DataTableException {
            try {
                this.init(new RandomAccessFile(file, "r"), null);
            }
            catch (FileNotFoundException ex) {
                throw new DataTableException(DataTableException.NUM.IO_EXCEPTION, ex.getMessage());
            }
        }

        public FileReader(File file, Charset charset) throws DataTableException {
            try {
                this.init(new RandomAccessFile(file, "r"), charset);
            }
            catch (FileNotFoundException ex) {
                throw new DataTableException(DataTableException.NUM.IO_EXCEPTION, ex.getMessage());
            }
        }

        private void seek(long pos) throws DataTableException {
            if (pos != -1L) {
                try {
                    this.file.seek(pos);
                    this.readOffset = pos;
                }
                catch (IOException ex) {
                    throw new DataTableException(DataTableException.NUM.IO_EXCEPTION, ex.getMessage());
                }
            }
        }

        private byte readByte(long offset) throws DataTableException {
            int readByte;
            this.seek(offset);
            try {
                readByte = this.file.read();
                ++this.readOffset;
            }
            catch (IOException ex) {
                throw new DataTableException(DataTableException.NUM.IO_EXCEPTION, ex.getMessage());
            }
            if (readByte == -1) {
                throw new DataTableException(DataTableException.NUM.INPUT_STREAM_EOF);
            }
            return (byte)readByte;
        }

        private byte[] readBytes(long offset, int len) throws DataTableException {
            this.seek(offset);
            byte[] readData = new byte[len];
            for (int i = 0; i < readData.length; ++i) {
                int readByte;
                try {
                    readByte = this.file.read();
                }
                catch (IOException ex) {
                    throw new DataTableException(DataTableException.NUM.IO_EXCEPTION, ex.getMessage());
                }
                if (readByte == -1) {
                    throw new DataTableException(DataTableException.NUM.INPUT_STREAM_EOF);
                }
                readData[i] = (byte)readByte;
            }
            this.readOffset += (long)len;
            return readData;
        }

        private int readInt(long offset) throws DataTableException {
            this.seek(offset);
            byte[] readData = this.readBytes(-1L, TYPE.INT.sizeof());
            return BytesConvert.bytes2int(readData);
        }

        private void init(RandomAccessFile file, Charset charset) throws DataTableException {
            int headCount;
            if (charset == null) {
                charset = ConstFramework.getCharset();
            }
            this.file = file;
            this.charset = charset;
            this.readOffset = 0L;
            this.rows = this.readInt(-1L);
            this.cols = this.readInt(-1L);
            int metaCount = this.readInt(-1L);
            if (metaCount > 0) {
                this.meta = new MetaInfo();
                for (int count = 0; count < metaCount; ++count) {
                    String metaValue;
                    String metaKey;
                    int metaKeyBytesLen = this.readInt(-1L);
                    if (metaKeyBytesLen == -1) {
                        metaKey = null;
                    } else {
                        byte[] metaKeyBytes = this.readBytes(-1L, metaKeyBytesLen);
                        metaKey = new String(metaKeyBytes, charset);
                    }
                    int metaValueBytesLen = this.readInt(-1L);
                    if (metaValueBytesLen == -1) {
                        metaValue = null;
                    } else {
                        byte[] metaValueBytes = this.readBytes(-1L, metaValueBytesLen);
                        metaValue = new String(metaValueBytes, charset);
                    }
                    this.meta.put(metaKey, metaValue);
                }
            }
            if ((headCount = this.readInt(-1L)) > 0) {
                this.headNames = new String[headCount];
                for (int i = 0; i < headCount; ++i) {
                    int headNameBytesLen = this.readInt(-1L);
                    if (headNameBytesLen == -1) {
                        this.headNames[i] = null;
                        continue;
                    }
                    byte[] headNameBytes = this.readBytes(-1L, headNameBytesLen);
                    this.headNames[i] = new String(headNameBytes, charset);
                }
            }
            this.cellOffset = new long[this.rows][this.cols];
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.cols; ++j) {
                    this.cellOffset[i][j] = this.readOffset;
                    TYPE type = TYPE.getType(this.readByte(-1L));
                    if (type == null) {
                        throw new DataTableException(DataTableException.NUM.UNKNOW_TYPE);
                    }
                    int size = type.sizeof();
                    if (size == -1) {
                        size = this.readInt(-1L);
                    }
                    if (size == -1 || size == 0) continue;
                    try {
                        file.skipBytes(size);
                    }
                    catch (IOException ex) {
                        throw new DataTableException(DataTableException.NUM.IO_EXCEPTION, ex.getMessage());
                    }
                    this.readOffset += (long)size;
                }
            }
        }

        public int getRows() {
            return this.rows;
        }

        public int getCols() {
            return this.cols;
        }

        public Set<String> getMetaKeys() {
            if (this.meta != null) {
                return this.meta.getKeys();
            }
            return null;
        }

        public String getMetaValue(String key) {
            if (this.meta != null) {
                return this.meta.get(key);
            }
            return null;
        }

        public String[] getHeadNames() {
            return this.headNames;
        }

        private int getColByName(String name) throws DataTableException {
            if (this.headNames == null || name == null) {
                throw new DataTableException(DataTableException.NUM.UNKNOW_HEAD_NAME);
            }
            name = name.toLowerCase();
            for (int i = 0; i < this.headNames.length; ++i) {
                if (this.headNames[i] == null || !name.equals(this.headNames[i].toLowerCase())) continue;
                return i;
            }
            throw new DataTableException(DataTableException.NUM.UNKNOW_HEAD_NAME);
        }

        public TYPE getType(int row, String name) throws DataTableException {
            return this.getType(row, this.getColByName(name));
        }

        public TYPE getType(int row, int col) throws DataTableException {
            if (row < 0 || row >= this.rows || col < 0 || col >= this.cols) {
                throw new DataTableException(DataTableException.NUM.CELL_INDEX_OUT_OF_RANGE);
            }
            TYPE type = TYPE.getType(this.readByte(this.cellOffset[row][col]));
            if (type == null) {
                throw new DataTableException(DataTableException.NUM.UNKNOW_TYPE);
            }
            return type;
        }

        public Object getObject(int row, String name) throws DataTableException {
            return this.getObject(row, this.getColByName(name));
        }

        public Object getObject(int row, int col) throws DataTableException {
            if (row < 0 || row >= this.rows || col < 0 || col >= this.cols) {
                throw new DataTableException(DataTableException.NUM.CELL_INDEX_OUT_OF_RANGE);
            }
            TYPE type = this.getType(row, col);
            int size = type.sizeof();
            if (size == -1) {
                size = this.readInt(-1L);
            }
            byte[] data = size == -1 || size == 0 ? null : this.readBytes(-1L, size);
            switch (type) {
                case BOOLEAN: {
                    return BytesConvert.bytes2boolean(data);
                }
                case BYTE: {
                    return BytesConvert.bytes2byte(data);
                }
                case CHAR: {
                    return Character.valueOf(BytesConvert.bytes2char(data));
                }
                case SHORT: {
                    return BytesConvert.bytes2short(data);
                }
                case INT: {
                    return BytesConvert.bytes2int(data);
                }
                case LONG: {
                    return BytesConvert.bytes2long(data);
                }
                case FLOAT: {
                    return Float.valueOf(BytesConvert.bytes2float(data));
                }
                case DOUBLE: {
                    return BytesConvert.bytes2double(data);
                }
                case STRING: {
                    return data == null ? null : new String(data, this.charset);
                }
                case BYTES: {
                    return data;
                }
                case DATE: {
                    return data == null ? null : new Date(BytesConvert.bytes2long(data));
                }
            }
            throw new DataTableException(DataTableException.NUM.UNKNOW_TYPE);
        }

        public boolean getBoolean(int row, int col) throws DataTableException {
            return ObjectConvert.toBoolean(this.getObject(row, col));
        }

        public byte getByte(int row, int col) throws DataTableException {
            return ObjectConvert.toByte(this.getObject(row, col));
        }

        public char getCharacter(int row, int col) throws DataTableException {
            return ObjectConvert.toCharacter(this.getObject(row, col));
        }

        public short getShort(int row, int col) throws DataTableException {
            return ObjectConvert.toShort(this.getObject(row, col));
        }

        public int getInt(int row, int col) throws DataTableException {
            return ObjectConvert.toInteger(this.getObject(row, col));
        }

        public long getLong(int row, int col) throws DataTableException {
            return ObjectConvert.toLong(this.getObject(row, col));
        }

        public float getFloat(int row, int col) throws DataTableException {
            return ObjectConvert.toFloat(this.getObject(row, col));
        }

        public double getDouble(int row, int col) throws DataTableException {
            return ObjectConvert.toDouble(this.getObject(row, col));
        }

        public String getString(int row, int col) throws DataTableException {
            return ObjectConvert.toString(this.getObject(row, col));
        }

        public byte[] getBytes(int row, int col) throws DataTableException {
            return ObjectConvert.toBytes(this.getObject(row, col));
        }

        public Date getDate(int row, int col) throws DataTableException {
            return ObjectConvert.toDate(this.getObject(row, col));
        }

        public boolean getBoolean(int row, String name) throws DataTableException {
            return ObjectConvert.toBoolean(this.getObject(row, name));
        }

        public byte getByte(int row, String name) throws DataTableException {
            return ObjectConvert.toByte(this.getObject(row, name));
        }

        public char getCharacter(int row, String name) throws DataTableException {
            return ObjectConvert.toCharacter(this.getObject(row, name));
        }

        public short getShort(int row, String name) throws DataTableException {
            return ObjectConvert.toShort(this.getObject(row, name));
        }

        public int getInt(int row, String name) throws DataTableException {
            return ObjectConvert.toInteger(this.getObject(row, name));
        }

        public long getLong(int row, String name) throws DataTableException {
            return ObjectConvert.toLong(this.getObject(row, name));
        }

        public float getFloat(int row, String name) throws DataTableException {
            return ObjectConvert.toFloat(this.getObject(row, name));
        }

        public double getDouble(int row, String name) throws DataTableException {
            return ObjectConvert.toDouble(this.getObject(row, name));
        }

        public String getString(int row, String name) throws DataTableException {
            return ObjectConvert.toString(this.getObject(row, name));
        }

        public byte[] getBytes(int row, String name) throws DataTableException {
            return ObjectConvert.toBytes(this.getObject(row, name));
        }

        public Date getDate(int row, String name) throws DataTableException {
            return ObjectConvert.toDate(this.getObject(row, name));
        }

        public void close() throws DataTableException {
            try {
                this.file.close();
            }
            catch (IOException ex) {
                throw new DataTableException(DataTableException.NUM.IO_EXCEPTION, ex.getMessage());
            }
        }
    }

    public static class Reader {
        private int rows;
        private int cols;
        private CellData[][] cellData;
        private String[] headNames;
        private MetaInfo meta;
        private Charset charset;
        private int readOffset;

        public Reader(byte[] data) throws DataTableException {
            this.init(data, null, null);
        }

        public Reader(InputStream in) throws DataTableException {
            this.init(null, in, null);
        }

        public Reader(byte[] data, Charset charset) throws DataTableException {
            this.init(data, null, charset);
        }

        public Reader(InputStream in, Charset charset) throws DataTableException {
            this.init(null, in, charset);
        }

        private byte readByte(byte[] data, InputStream in) throws DataTableException {
            int readByte;
            if (data != null) {
                return data[this.readOffset++];
            }
            try {
                readByte = in.read();
            }
            catch (IOException ex) {
                throw new DataTableException(DataTableException.NUM.IO_EXCEPTION, ex.getMessage());
            }
            if (readByte == -1) {
                throw new DataTableException(DataTableException.NUM.INPUT_STREAM_EOF);
            }
            return (byte)readByte;
        }

        private byte[] readBytes(byte[] data, InputStream in, int len) throws DataTableException {
            if (data != null) {
                if (len == -1) {
                    return null;
                }
                byte[] val = new byte[len];
                System.arraycopy(data, this.readOffset, val, 0, len);
                this.readOffset += len;
                return val;
            }
            byte[] readData = new byte[len];
            for (int i = 0; i < readData.length; ++i) {
                int readByte;
                try {
                    readByte = in.read();
                }
                catch (IOException ex) {
                    throw new DataTableException(DataTableException.NUM.IO_EXCEPTION, ex.getMessage());
                }
                if (readByte == -1) {
                    throw new DataTableException(DataTableException.NUM.INPUT_STREAM_EOF);
                }
                readData[i] = (byte)readByte;
            }
            return readData;
        }

        private int readInt(byte[] data, InputStream in) throws DataTableException {
            if (data != null) {
                int val = BytesConvert.bytes2int(data, this.readOffset);
                this.readOffset += TYPE.INT.sizeof();
                return val;
            }
            byte[] readData = this.readBytes(data, in, TYPE.INT.sizeof());
            return BytesConvert.bytes2int(readData);
        }

        private void init(byte[] data, InputStream in, Charset charset) throws DataTableException {
            int headCount;
            if (charset == null) {
                charset = ConstFramework.getCharset();
            }
            this.charset = charset;
            this.readOffset = 0;
            this.rows = this.readInt(data, in);
            this.cols = this.readInt(data, in);
            int metaCount = this.readInt(data, in);
            if (metaCount > 0) {
                this.meta = new MetaInfo();
                for (int count = 0; count < metaCount; ++count) {
                    String metaValue;
                    String metaKey;
                    int metaKeyBytesLen = this.readInt(data, in);
                    if (metaKeyBytesLen == -1) {
                        metaKey = null;
                    } else {
                        byte[] metaKeyBytes = this.readBytes(data, in, metaKeyBytesLen);
                        metaKey = new String(metaKeyBytes, charset);
                    }
                    int metaValueBytesLen = this.readInt(data, in);
                    if (metaValueBytesLen == -1) {
                        metaValue = null;
                    } else {
                        byte[] metaValueBytes = this.readBytes(data, in, metaValueBytesLen);
                        metaValue = new String(metaValueBytes, charset);
                    }
                    this.meta.put(metaKey, metaValue);
                }
            }
            if ((headCount = this.readInt(data, in)) > 0) {
                this.headNames = new String[headCount];
                for (int i = 0; i < headCount; ++i) {
                    int headNameBytesLen = this.readInt(data, in);
                    if (headNameBytesLen == -1) {
                        this.headNames[i] = null;
                        continue;
                    }
                    byte[] headNameBytes = this.readBytes(data, in, headNameBytesLen);
                    this.headNames[i] = new String(headNameBytes, charset);
                }
            }
            this.cellData = new CellData[this.rows][this.cols];
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.cols; ++j) {
                    TYPE type = TYPE.getType(this.readByte(data, in));
                    if (type == null) {
                        throw new DataTableException(DataTableException.NUM.UNKNOW_TYPE);
                    }
                    int size = type.sizeof();
                    if (size == -1) {
                        size = this.readInt(data, in);
                    }
                    byte[] cellBytes = size == -1 || size == 0 ? null : this.readBytes(data, in, size);
                    this.cellData[i][j] = new CellData(type, cellBytes);
                }
            }
        }

        public int getRows() {
            return this.rows;
        }

        public int getCols() {
            return this.cols;
        }

        public Set<String> getMetaKeys() {
            if (this.meta != null) {
                return this.meta.getKeys();
            }
            return null;
        }

        public String getMetaValue(String key) {
            if (this.meta != null) {
                return this.meta.get(key);
            }
            return null;
        }

        public String[] getHeadNames() {
            return this.headNames;
        }

        private int getColByName(String name) throws DataTableException {
            if (this.headNames == null || name == null) {
                throw new DataTableException(DataTableException.NUM.UNKNOW_HEAD_NAME);
            }
            name = name.toLowerCase();
            for (int i = 0; i < this.headNames.length; ++i) {
                if (this.headNames[i] == null || !name.equals(this.headNames[i].toLowerCase())) continue;
                return i;
            }
            throw new DataTableException(DataTableException.NUM.UNKNOW_HEAD_NAME);
        }

        public TYPE getType(int row, String name) throws DataTableException {
            return this.getType(row, this.getColByName(name));
        }

        public TYPE getType(int row, int col) throws DataTableException {
            if (row < 0 || row >= this.rows || col < 0 || col >= this.cols) {
                throw new DataTableException(DataTableException.NUM.CELL_INDEX_OUT_OF_RANGE);
            }
            return this.cellData[row][col].type;
        }

        public Object getObject(int row, String name) throws DataTableException {
            return this.getObject(row, this.getColByName(name));
        }

        public Object getObject(int row, int col) throws DataTableException {
            if (row < 0 || row >= this.rows || col < 0 || col >= this.cols) {
                throw new DataTableException(DataTableException.NUM.CELL_INDEX_OUT_OF_RANGE);
            }
            CellData cell = this.cellData[row][col];
            switch (cell.type) {
                case BOOLEAN: {
                    return BytesConvert.bytes2boolean(cell.data);
                }
                case BYTE: {
                    return BytesConvert.bytes2byte(cell.data);
                }
                case CHAR: {
                    return Character.valueOf(BytesConvert.bytes2char(cell.data));
                }
                case SHORT: {
                    return BytesConvert.bytes2short(cell.data);
                }
                case INT: {
                    return BytesConvert.bytes2int(cell.data);
                }
                case LONG: {
                    return BytesConvert.bytes2long(cell.data);
                }
                case FLOAT: {
                    return Float.valueOf(BytesConvert.bytes2float(cell.data));
                }
                case DOUBLE: {
                    return BytesConvert.bytes2double(cell.data);
                }
                case STRING: {
                    return cell.data == null ? null : new String(cell.data, this.charset);
                }
                case BYTES: {
                    return cell.data;
                }
                case DATE: {
                    return cell.data == null ? null : new Date(BytesConvert.bytes2long(cell.data));
                }
            }
            throw new DataTableException(DataTableException.NUM.UNKNOW_TYPE);
        }

        public boolean getBoolean(int row, int col) throws DataTableException {
            return ObjectConvert.toBoolean(this.getObject(row, col));
        }

        public byte getByte(int row, int col) throws DataTableException {
            return ObjectConvert.toByte(this.getObject(row, col));
        }

        public char getCharacter(int row, int col) throws DataTableException {
            return ObjectConvert.toCharacter(this.getObject(row, col));
        }

        public short getShort(int row, int col) throws DataTableException {
            return ObjectConvert.toShort(this.getObject(row, col));
        }

        public int getInt(int row, int col) throws DataTableException {
            return ObjectConvert.toInteger(this.getObject(row, col));
        }

        public long getLong(int row, int col) throws DataTableException {
            return ObjectConvert.toLong(this.getObject(row, col));
        }

        public float getFloat(int row, int col) throws DataTableException {
            return ObjectConvert.toFloat(this.getObject(row, col));
        }

        public double getDouble(int row, int col) throws DataTableException {
            return ObjectConvert.toDouble(this.getObject(row, col));
        }

        public String getString(int row, int col) throws DataTableException {
            return ObjectConvert.toString(this.getObject(row, col));
        }

        public byte[] getBytes(int row, int col) throws DataTableException {
            return ObjectConvert.toBytes(this.getObject(row, col));
        }

        public Date getDate(int row, int col) throws DataTableException {
            return ObjectConvert.toDate(this.getObject(row, col));
        }

        public boolean getBoolean(int row, String name) throws DataTableException {
            return ObjectConvert.toBoolean(this.getObject(row, name));
        }

        public byte getByte(int row, String name) throws DataTableException {
            return ObjectConvert.toByte(this.getObject(row, name));
        }

        public char getCharacter(int row, String name) throws DataTableException {
            return ObjectConvert.toCharacter(this.getObject(row, name));
        }

        public short getShort(int row, String name) throws DataTableException {
            return ObjectConvert.toShort(this.getObject(row, name));
        }

        public int getInt(int row, String name) throws DataTableException {
            return ObjectConvert.toInteger(this.getObject(row, name));
        }

        public long getLong(int row, String name) throws DataTableException {
            return ObjectConvert.toLong(this.getObject(row, name));
        }

        public float getFloat(int row, String name) throws DataTableException {
            return ObjectConvert.toFloat(this.getObject(row, name));
        }

        public double getDouble(int row, String name) throws DataTableException {
            return ObjectConvert.toDouble(this.getObject(row, name));
        }

        public String getString(int row, String name) throws DataTableException {
            return ObjectConvert.toString(this.getObject(row, name));
        }

        public byte[] getBytes(int row, String name) throws DataTableException {
            return ObjectConvert.toBytes(this.getObject(row, name));
        }

        public Date getDate(int row, String name) throws DataTableException {
            return ObjectConvert.toDate(this.getObject(row, name));
        }

        private static class CellData {
            public TYPE type;
            public byte[] data;

            public CellData(TYPE type, byte[] data) {
                this.type = type;
                this.data = data;
            }
        }
    }

    public static class Writer {
        private static final int COUNT_UNSTART = -1;
        private static final int COUNT_START = 0;
        private int blockSize;
        private int rows;
        private int cols;
        private int count;
        private OutputStream out;
        private ByteBlocks data;
        private Charset charset;

        public Writer(int rows, int cols, MetaInfo meta) throws DataTableException {
            this.init(rows, cols, meta, 4096, null, null);
        }

        public Writer(int rows, int cols, MetaInfo meta, int blockSize) throws DataTableException {
            this.init(rows, cols, meta, blockSize, null, null);
        }

        public Writer(int rows, int cols, MetaInfo meta, OutputStream out) throws DataTableException {
            this.init(rows, cols, meta, 4096, out, null);
        }

        public Writer(int rows, int cols, MetaInfo meta, Charset charset) throws DataTableException {
            this.init(rows, cols, meta, 4096, null, charset);
        }

        public Writer(int rows, int cols, MetaInfo meta, int blockSize, Charset charset) throws DataTableException {
            this.init(rows, cols, meta, blockSize, null, charset);
        }

        public Writer(int rows, int cols, MetaInfo meta, OutputStream out, Charset charset) throws DataTableException {
            this.init(rows, cols, meta, 4096, out, charset);
        }

        private void init(int rows, int cols, MetaInfo meta, int blockSize, OutputStream out, Charset charset) throws DataTableException {
            this.rows = rows >= 0 ? rows : 0;
            this.cols = cols >= 0 ? cols : 0;
            this.count = -1;
            this.blockSize = blockSize;
            this.out = out;
            this.data = null;
            this.charset = charset == null ? ConstFramework.getCharset() : charset;
            this.append(BytesConvert.int2bytes(rows));
            this.append(BytesConvert.int2bytes(cols));
            if (meta != null) {
                this.append(meta.getBytes(charset));
            } else {
                this.append(MetaInfo.getEmptyBytes());
            }
        }

        private void append(byte[] bytes) throws DataTableException {
            if (this.out == null) {
                if (this.data == null) {
                    this.data = new ByteBlocks(this.blockSize);
                }
                this.data.append(bytes);
            } else {
                try {
                    this.out.write(bytes);
                }
                catch (IOException ex) {
                    throw new DataTableException(DataTableException.NUM.IO_EXCEPTION, ex.getMessage());
                }
            }
        }

        public void appendHead(String[] head) throws DataTableException {
            if (this.count == -1) {
                if (head == null) {
                    this.append(BytesConvert.int2bytes(0));
                } else {
                    if (head.length != this.cols) {
                        throw new DataTableException(DataTableException.NUM.HEAD_COUNT_NOT_MATCH);
                    }
                    this.append(BytesConvert.int2bytes(head.length));
                    for (String name : head) {
                        if (name != null) {
                            byte[] nameBytes = name.getBytes(this.charset);
                            this.append(BytesConvert.int2bytes(nameBytes.length));
                            this.append(nameBytes);
                            continue;
                        }
                        this.append(BytesConvert.int2bytes(-1));
                    }
                }
            } else {
                throw new DataTableException(DataTableException.NUM.APPEND_HEAD_AFTER_START);
            }
            this.count = 0;
        }

        public void appendCell(boolean val) throws DataTableException {
            this.checkAppendCell();
            this.append(BytesConvert.byte2bytes(TYPE.BOOLEAN.getOrdinal()));
            this.append(BytesConvert.boolean2bytes(val));
        }

        public void appendCell(byte val) throws DataTableException {
            this.checkAppendCell();
            this.append(BytesConvert.byte2bytes(TYPE.BYTE.getOrdinal()));
            this.append(BytesConvert.byte2bytes(val));
        }

        public void appendCell(char val) throws DataTableException {
            this.checkAppendCell();
            this.append(BytesConvert.byte2bytes(TYPE.CHAR.getOrdinal()));
            this.append(BytesConvert.char2bytes(val));
        }

        public void appendCell(short val) throws DataTableException {
            this.checkAppendCell();
            this.append(BytesConvert.byte2bytes(TYPE.SHORT.getOrdinal()));
            this.append(BytesConvert.short2bytes(val));
        }

        public void appendCell(int val) throws DataTableException {
            this.checkAppendCell();
            this.append(BytesConvert.byte2bytes(TYPE.INT.getOrdinal()));
            this.append(BytesConvert.int2bytes(val));
        }

        public void appendCell(long val) throws DataTableException {
            this.checkAppendCell();
            this.append(BytesConvert.byte2bytes(TYPE.LONG.getOrdinal()));
            this.append(BytesConvert.long2bytes(val));
        }

        public void appendCell(float val) throws DataTableException {
            this.checkAppendCell();
            this.append(BytesConvert.byte2bytes(TYPE.FLOAT.getOrdinal()));
            this.append(BytesConvert.float2bytes(val));
        }

        public void appendCell(double val) throws DataTableException {
            this.checkAppendCell();
            this.append(BytesConvert.byte2bytes(TYPE.DOUBLE.getOrdinal()));
            this.append(BytesConvert.double2bytes(val));
        }

        public void appendCell(String val) throws DataTableException {
            this.checkAppendCell();
            this.append(BytesConvert.byte2bytes(TYPE.STRING.getOrdinal()));
            if (val != null) {
                byte[] strBytes = val.getBytes(this.charset);
                this.append(BytesConvert.int2bytes(strBytes.length));
                this.append(strBytes);
            } else {
                this.append(BytesConvert.int2bytes(-1));
            }
        }

        public void appendCell(byte[] val) throws DataTableException {
            this.checkAppendCell();
            this.append(BytesConvert.byte2bytes(TYPE.BYTES.getOrdinal()));
            if (val != null) {
                this.append(BytesConvert.int2bytes(val.length));
                this.append(val);
            } else {
                this.append(BytesConvert.int2bytes(-1));
            }
        }

        public void appendCell(Date val) throws DataTableException {
            this.checkAppendCell();
            this.append(BytesConvert.byte2bytes(TYPE.DATE.getOrdinal()));
            if (val != null) {
                this.append(BytesConvert.int2bytes(TYPE.LONG.sizeof()));
                this.append(BytesConvert.long2bytes(val.getTime()));
            } else {
                this.append(BytesConvert.int2bytes(-1));
            }
        }

        public void appendCell(Object val) throws DataTableException {
            if (val == null) {
                this.appendCell((byte[])null);
            } else if (val instanceof Boolean) {
                this.appendCell((Boolean)val);
            } else if (val instanceof Byte) {
                this.appendCell((Byte)val);
            } else if (val instanceof Character) {
                this.appendCell(((Character)val).charValue());
            } else if (val instanceof Short) {
                this.appendCell((Short)val);
            } else if (val instanceof Integer) {
                this.appendCell((Integer)val);
            } else if (val instanceof Long) {
                this.appendCell((Long)val);
            } else if (val instanceof Float) {
                this.appendCell(((Float)val).floatValue());
            } else if (val instanceof Double) {
                this.appendCell((Double)val);
            } else if (val instanceof String) {
                this.appendCell((String)val);
            } else if (val.getClass().getName().equals("[B")) {
                this.appendCell((byte[])val);
            } else if (val instanceof Date) {
                this.appendCell((Date)val);
            } else {
                throw new DataTableException(DataTableException.NUM.UNKNOW_TYPE);
            }
        }

        private void checkAppendCell() throws DataTableException {
            if (this.count == -1) {
                this.append(BytesConvert.int2bytes(-1));
                this.count = 0;
            }
            if (this.count >= this.rows * this.cols) {
                throw new DataTableException(DataTableException.NUM.TABLE_FULL);
            }
            ++this.count;
        }

        public byte[] finish() throws DataTableException {
            if (this.count == -1) {
                this.append(BytesConvert.int2bytes(-1));
                this.count = 0;
            }
            if (this.count != this.rows * this.cols) {
                throw new DataTableException(DataTableException.NUM.TABLE_NOT_FINISH);
            }
            if (this.out == null) {
                return this.data.getBytes();
            }
            return null;
        }
    }

    public static class MetaInfo {
        HashMap<String, String> infos = new HashMap();

        public String put(String key, String value) {
            return this.infos.put(key, value);
        }

        public String get(String key) {
            return this.infos.get(key);
        }

        public String remove(String key) {
            return this.infos.remove(key);
        }

        public Set<String> getKeys() {
            return this.infos.keySet();
        }

        protected byte[] getBytes() throws DataTableException {
            return this.getBytes(ConstFramework.getCharset());
        }

        protected byte[] getBytes(String charsetName) throws DataTableException {
            return this.getBytes(Charset.forName(charsetName));
        }

        protected byte[] getBytes(Charset charset) throws DataTableException {
            if (charset == null) {
                charset = ConstFramework.getCharset();
            }
            ByteBlocks blocks = new ByteBlocks();
            blocks.append(BytesConvert.int2bytes(this.infos.size()));
            for (String key : this.infos.keySet()) {
                byte[] keyBytes = key.getBytes(charset);
                blocks.append(BytesConvert.int2bytes(keyBytes.length));
                blocks.append(keyBytes);
                String value = this.infos.get(key);
                if (value != null) {
                    byte[] valueBytes = value.getBytes(charset);
                    blocks.append(BytesConvert.int2bytes(valueBytes.length));
                    blocks.append(valueBytes);
                    continue;
                }
                blocks.append(BytesConvert.int2bytes(-1));
            }
            return blocks.getBytes();
        }

        protected static byte[] getEmptyBytes() {
            return BytesConvert.int2bytes(0);
        }
    }

    public static class ByteBlocks {
        private ArrayList<Block> blocks = new ArrayList();
        private int blockSize;

        public ByteBlocks() {
            this.blockSize = 4096;
        }

        public ByteBlocks(int blockSize) {
            this.blockSize = blockSize;
        }

        public void append(byte[] bytes) {
            this.append(bytes, 0, bytes.length);
        }

        public void append(byte[] bytes, int pos, int len) {
            if (this.blocks.isEmpty()) {
                this.blocks.add(new Block(this.blockSize));
            }
            Block block = this.blocks.get(this.blocks.size() - 1);
            for (int writeCnt = block.append(bytes); writeCnt < len; writeCnt += block.append(bytes, writeCnt, len - writeCnt)) {
                block = new Block(this.blockSize);
                this.blocks.add(block);
            }
        }

        public int getSize() {
            int count = 0;
            for (Block block : this.blocks) {
                count += block.length;
            }
            return count;
        }

        public byte[] getBytes() {
            int size = this.getSize();
            byte[] data = new byte[size];
            int count = 0;
            for (Block block : this.blocks) {
                System.arraycopy(block.data, 0, data, count, block.length);
                count += block.length;
            }
            return data;
        }

        private class Block {
            public static final int DEFAULT_BLOCK_SIZE = 4096;
            public static final int MIN_BLOCK_SIZE = 512;
            public static final int MAX_BLOCK_SIZE = 65536;
            public int length;
            public byte[] data;

            public Block() {
                this.data = new byte[4096];
                this.length = 0;
            }

            public Block(int size) {
                size = size < 512 ? 512 : size;
                size = size > 65536 ? 65536 : size;
                this.data = new byte[size];
                this.length = 0;
            }

            public int append(byte[] bytes) {
                return this.append(bytes, 0, bytes.length);
            }

            public int append(byte[] bytes, int pos, int len) {
                int maxLen = bytes.length - pos;
                int bytesLen = len > maxLen ? maxLen : len;
                int writeBytes = this.length + bytesLen <= this.data.length ? bytesLen : this.data.length - this.length;
                System.arraycopy(bytes, pos, this.data, this.length, writeBytes);
                this.length += writeBytes;
                return writeBytes;
            }
        }
    }

    public static class ObjectConvert {
        public static final boolean DEFAULT_BOOLEAN = false;
        public static final byte DEFAULT_BYTE = 0;
        public static final char DEFAULT_CHAR = '\u0000';
        public static final short DEFAULT_SHORT = 0;
        public static final int DEFAULT_INT = 0;
        public static final long DEFAULT_LONG = 0L;
        public static final float DEFAULT_FLOAT = 0.0f;
        public static final double DEFAULT_DOUBLE = 0.0;

        public static boolean toBoolean(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            if (obj instanceof Character) {
                return ((Character)obj).charValue() != '\u0000';
            }
            if (obj instanceof Number) {
                return ((Number)obj).byteValue() != 0;
            }
            if (obj instanceof String) {
                return !((String)obj).isEmpty();
            }
            return false;
        }

        public static byte toByte(Object obj) {
            if (obj == null) {
                return 0;
            }
            if (obj instanceof Boolean) {
                return (byte)((Boolean)obj != false ? 1 : 0);
            }
            if (obj instanceof Character) {
                return (byte)((Character)obj).charValue();
            }
            if (obj instanceof Number) {
                return ((Number)obj).byteValue();
            }
            if (obj instanceof String) {
                try {
                    return Byte.parseByte((String)obj);
                }
                catch (Exception ex) {
                    return 0;
                }
            }
            return 0;
        }

        public static char toCharacter(Object obj) {
            if (obj == null) {
                return '\u0000';
            }
            if (obj instanceof Boolean) {
                return '\u0000';
            }
            if (obj instanceof Character) {
                return ((Character)obj).charValue();
            }
            if (obj instanceof Number) {
                return (char)((Number)obj).intValue();
            }
            if (obj instanceof String) {
                String str = (String)obj;
                if (str.isEmpty()) {
                    return '\u0000';
                }
                return str.charAt(0);
            }
            return '\u0000';
        }

        public static short toShort(Object obj) {
            if (obj == null) {
                return 0;
            }
            if (obj instanceof Boolean) {
                return (short)((Boolean)obj != false ? 1 : 0);
            }
            if (obj instanceof Character) {
                return (short)((Character)obj).charValue();
            }
            if (obj instanceof Number) {
                return ((Number)obj).shortValue();
            }
            if (obj instanceof String) {
                try {
                    return Short.parseShort((String)obj);
                }
                catch (Exception ex) {
                    return 0;
                }
            }
            return 0;
        }

        public static int toInteger(Object obj) {
            if (obj == null) {
                return 0;
            }
            if (obj instanceof Boolean) {
                return (Boolean)obj != false ? 1 : 0;
            }
            if (obj instanceof Character) {
                return ((Character)obj).charValue();
            }
            if (obj instanceof Number) {
                return ((Number)obj).intValue();
            }
            if (obj instanceof String) {
                try {
                    return Integer.parseInt((String)obj);
                }
                catch (Exception ex) {
                    return 0;
                }
            }
            return 0;
        }

        public static long toLong(Object obj) {
            if (obj == null) {
                return 0L;
            }
            if (obj instanceof Boolean) {
                return (Boolean)obj != false ? 1L : 0L;
            }
            if (obj instanceof Character) {
                return ((Character)obj).charValue();
            }
            if (obj instanceof Number) {
                return ((Number)obj).longValue();
            }
            if (obj instanceof String) {
                try {
                    return Long.parseLong((String)obj);
                }
                catch (Exception ex) {
                    return 0L;
                }
            }
            if (obj instanceof Date) {
                return ((Date)obj).getTime();
            }
            return 0L;
        }

        public static float toFloat(Object obj) {
            if (obj == null) {
                return 0.0f;
            }
            if (obj instanceof Boolean) {
                return (Boolean)obj != false ? 1.0f : 0.0f;
            }
            if (obj instanceof Character) {
                return ((Character)obj).charValue();
            }
            if (obj instanceof Number) {
                return ((Number)obj).floatValue();
            }
            if (obj instanceof String) {
                try {
                    return Float.parseFloat((String)obj);
                }
                catch (Exception ex) {
                    return 0.0f;
                }
            }
            if (obj instanceof Date) {
                return ((Date)obj).getTime();
            }
            return 0.0f;
        }

        public static double toDouble(Object obj) {
            if (obj == null) {
                return 0.0;
            }
            if (obj instanceof Boolean) {
                return (Boolean)obj != false ? 1.0 : 0.0;
            }
            if (obj instanceof Character) {
                return ((Character)obj).charValue();
            }
            if (obj instanceof Number) {
                return ((Number)obj).doubleValue();
            }
            if (obj instanceof String) {
                try {
                    return Double.parseDouble((String)obj);
                }
                catch (Exception ex) {
                    return 0.0;
                }
            }
            if (obj instanceof Date) {
                return ((Date)obj).getTime();
            }
            return 0.0;
        }

        public static String toString(Object obj) {
            if (obj == null) {
                return null;
            }
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj.getClass().getName().equals("[B")) {
                return new String((byte[])obj);
            }
            if (obj instanceof Date) {
                return ((Date)obj).toString();
            }
            return obj.toString();
        }

        public static byte[] toBytes(Object obj) {
            if (obj == null) {
                return null;
            }
            if (obj instanceof Boolean) {
                return BytesConvert.boolean2bytes((Boolean)obj);
            }
            if (obj instanceof Character) {
                return BytesConvert.char2bytes(((Character)obj).charValue());
            }
            if (obj instanceof Byte) {
                return BytesConvert.byte2bytes((Byte)obj);
            }
            if (obj instanceof Short) {
                return BytesConvert.short2bytes((Short)obj);
            }
            if (obj instanceof Integer) {
                return BytesConvert.int2bytes((Integer)obj);
            }
            if (obj instanceof Long) {
                return BytesConvert.long2bytes((Long)obj);
            }
            if (obj instanceof Float) {
                return BytesConvert.float2bytes(((Float)obj).floatValue());
            }
            if (obj instanceof Double) {
                return BytesConvert.double2bytes((Double)obj);
            }
            if (obj instanceof String) {
                return ((String)obj).getBytes();
            }
            if (obj.getClass().getName().equals("[B")) {
                return (byte[])obj;
            }
            if (obj instanceof Date) {
                return BytesConvert.long2bytes(((Date)obj).getTime());
            }
            return null;
        }

        public static Date toDate(Object obj) {
            if (obj == null) {
                return null;
            }
            return new Date(ObjectConvert.toLong(obj));
        }
    }

    public static class BytesConvert {
        public static byte[] boolean2bytes(boolean val) {
            byte[] data = new byte[TYPE.BOOLEAN.sizeof()];
            data[0] = val ? (byte)1 : 0;
            return data;
        }

        public static byte[] byte2bytes(byte val) {
            byte[] data = new byte[TYPE.BYTE.sizeof()];
            data[0] = val;
            return data;
        }

        public static byte[] char2bytes(char val) {
            byte[] data = new byte[TYPE.CHAR.sizeof()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(val >> i * 8 & 0xFF);
            }
            return data;
        }

        public static byte[] short2bytes(short val) {
            byte[] data = new byte[TYPE.SHORT.sizeof()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(val >> i * 8 & 0xFF);
            }
            return data;
        }

        public static byte[] int2bytes(int val) {
            byte[] data = new byte[TYPE.INT.sizeof()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(val >> i * 8 & 0xFF);
            }
            return data;
        }

        public static byte[] long2bytes(long val) {
            byte[] data = new byte[TYPE.LONG.sizeof()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(val >> i * 8 & 0xFFL);
            }
            return data;
        }

        public static byte[] float2bytes(float val) {
            int valNum = Float.floatToIntBits(val);
            byte[] data = new byte[TYPE.FLOAT.sizeof()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(valNum >> i * 8 & 0xFF);
            }
            return data;
        }

        public static byte[] double2bytes(double val) {
            long valNum = Double.doubleToLongBits(val);
            byte[] data = new byte[TYPE.DOUBLE.sizeof()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(valNum >> i * 8 & 0xFFL);
            }
            return data;
        }

        public static boolean bytes2boolean(byte[] data) throws DataTableException {
            return BytesConvert.bytes2boolean(data, 0);
        }

        public static boolean bytes2boolean(byte[] data, int offset) throws DataTableException {
            if (offset + TYPE.BOOLEAN.sizeof() > data.length) {
                throw new DataTableException(DataTableException.NUM.BYTE_ARRAY_REACH_END);
            }
            return data[offset] != 0;
        }

        public static byte bytes2byte(byte[] data) throws DataTableException {
            return BytesConvert.bytes2byte(data, 0);
        }

        public static byte bytes2byte(byte[] data, int offset) throws DataTableException {
            if (offset + TYPE.BYTE.sizeof() > data.length) {
                throw new DataTableException(DataTableException.NUM.BYTE_ARRAY_REACH_END);
            }
            return data[offset];
        }

        public static char bytes2char(byte[] data) throws DataTableException {
            return BytesConvert.bytes2char(data, 0);
        }

        public static char bytes2char(byte[] data, int offset) throws DataTableException {
            if (offset + TYPE.CHAR.sizeof() > data.length) {
                throw new DataTableException(DataTableException.NUM.BYTE_ARRAY_REACH_END);
            }
            char val = '\u0000';
            for (int i = 0; i < TYPE.CHAR.sizeof(); ++i) {
                val = (char)(val | ((char)data[offset + i] & 0xFF) << i * 8);
            }
            return val;
        }

        public static short bytes2short(byte[] data) throws DataTableException {
            return BytesConvert.bytes2short(data, 0);
        }

        public static short bytes2short(byte[] data, int offset) throws DataTableException {
            if (offset + TYPE.SHORT.sizeof() > data.length) {
                throw new DataTableException(DataTableException.NUM.BYTE_ARRAY_REACH_END);
            }
            short val = 0;
            for (int i = 0; i < TYPE.SHORT.sizeof(); ++i) {
                val = (short)(val | ((short)data[offset + i] & 0xFF) << i * 8);
            }
            return val;
        }

        public static int bytes2int(byte[] data) throws DataTableException {
            return BytesConvert.bytes2int(data, 0);
        }

        public static int bytes2int(byte[] data, int offset) throws DataTableException {
            if (offset + TYPE.INT.sizeof() > data.length) {
                throw new DataTableException(DataTableException.NUM.BYTE_ARRAY_REACH_END);
            }
            int val = 0;
            for (int i = 0; i < TYPE.INT.sizeof(); ++i) {
                val |= (data[offset + i] & 0xFF) << i * 8;
            }
            return val;
        }

        public static long bytes2long(byte[] data) throws DataTableException {
            return BytesConvert.bytes2long(data, 0);
        }

        public static long bytes2long(byte[] data, int offset) throws DataTableException {
            if (offset + TYPE.LONG.sizeof() > data.length) {
                throw new DataTableException(DataTableException.NUM.BYTE_ARRAY_REACH_END);
            }
            long val = 0L;
            for (int i = 0; i < TYPE.LONG.sizeof(); ++i) {
                val |= ((long)data[offset + i] & 0xFFL) << i * 8;
            }
            return val;
        }

        public static float bytes2float(byte[] data) throws DataTableException {
            return BytesConvert.bytes2float(data, 0);
        }

        public static float bytes2float(byte[] data, int offset) throws DataTableException {
            if (offset + TYPE.FLOAT.sizeof() > data.length) {
                throw new DataTableException(DataTableException.NUM.BYTE_ARRAY_REACH_END);
            }
            int val = 0;
            for (int i = 0; i < TYPE.FLOAT.sizeof(); ++i) {
                val |= (data[offset + i] & 0xFF) << i * 8;
            }
            return Float.intBitsToFloat(val);
        }

        public static double bytes2double(byte[] data) throws DataTableException {
            return BytesConvert.bytes2double(data, 0);
        }

        public static double bytes2double(byte[] data, int offset) throws DataTableException {
            if (offset + TYPE.DOUBLE.sizeof() > data.length) {
                throw new DataTableException(DataTableException.NUM.BYTE_ARRAY_REACH_END);
            }
            long val = 0L;
            for (int i = 0; i < TYPE.DOUBLE.sizeof(); ++i) {
                val |= ((long)data[offset + i] & 0xFFL) << i * 8;
            }
            return Double.longBitsToDouble(val);
        }

        public static byte[] cutbytes(byte[] data, int offset, int length) throws DataTableException {
            if (offset == 0 && data.length == length) {
                return data;
            }
            if (offset + length > data.length) {
                throw new DataTableException(DataTableException.NUM.BYTE_ARRAY_REACH_END);
            }
            byte[] cutBytes = new byte[length];
            System.arraycopy(data, offset, cutBytes, 0, length);
            return cutBytes;
        }
    }

    public static enum TYPE {
        BOOLEAN,
        BYTE,
        CHAR,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        STRING,
        BYTES,
        DATE;

        public static final int SIZE_VAR = -1;
        public static final int SIZE_UNKNOW = 0;

        public byte getOrdinal() {
            return (byte)this.ordinal();
        }

        public int sizeof() {
            switch (this) {
                case BOOLEAN: {
                    return 1;
                }
                case BYTE: {
                    return 1;
                }
                case CHAR: {
                    return 2;
                }
                case SHORT: {
                    return 2;
                }
                case INT: {
                    return 4;
                }
                case LONG: {
                    return 8;
                }
                case FLOAT: {
                    return 4;
                }
                case DOUBLE: {
                    return 8;
                }
                case STRING: {
                    return -1;
                }
                case BYTES: {
                    return -1;
                }
                case DATE: {
                    return -1;
                }
            }
            return 0;
        }

        public static int sizeof(TYPE type) {
            return type == null ? 0 : type.sizeof();
        }

        public static TYPE getType(byte ordinal) {
            TYPE[] values;
            for (TYPE type : values = TYPE.values()) {
                if (type.ordinal() != ordinal) continue;
                return type;
            }
            return null;
        }
    }

    public static class DataTableException
    extends Exception {
        public NUM num;
        public String msg;

        public DataTableException(NUM num) {
            this.num = num;
            this.msg = DataTableException.getDefaultMsg(num);
        }

        public DataTableException(NUM num, String msg) {
            this.num = num;
            this.msg = msg;
        }

        public static String getDefaultMsg(NUM num) {
            switch (num) {
                case IO_EXCEPTION: {
                    return "io expcetion";
                }
                case BYTE_ARRAY_REACH_END: {
                    return "read byte array reach end";
                }
                case INPUT_STREAM_EOF: {
                    return "input stream eof";
                }
                case HEAD_COUNT_NOT_MATCH: {
                    return "head count not match with column count";
                }
                case APPEND_HEAD_AFTER_START: {
                    return "can not append head after start table content";
                }
                case TABLE_FULL: {
                    return "table full";
                }
                case TABLE_NOT_FINISH: {
                    return "table not finish";
                }
                case UNKNOW_TYPE: {
                    return "unknow type";
                }
                case UNKNOW_HEAD_NAME: {
                    return "unknow head name";
                }
                case CELL_INDEX_OUT_OF_RANGE: {
                    return "cell index out of range";
                }
            }
            return "unknow error";
        }

        @Override
        public String toString() {
            return this.msg;
        }

        public static enum NUM {
            IO_EXCEPTION,
            BYTE_ARRAY_REACH_END,
            INPUT_STREAM_EOF,
            HEAD_COUNT_NOT_MATCH,
            APPEND_HEAD_AFTER_START,
            TABLE_FULL,
            TABLE_NOT_FINISH,
            UNKNOW_TYPE,
            UNKNOW_HEAD_NAME,
            CELL_INDEX_OUT_OF_RANGE;

        }
    }
}

