/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.data;

import java.util.ArrayList;

public class DataStack<Obj> {
    public static final int NO_LIMIT = -1;
    protected final ArrayList<Obj> stack = new ArrayList();
    public int sizeLimit = -1;

    public DataStack() {
    }

    public DataStack(Obj[] data) {
        this.initData(data);
    }

    public DataStack(int sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public DataStack(Obj[] data, int sizeLimit) {
        this.sizeLimit = sizeLimit;
        this.initData(data);
    }

    private boolean initData(Obj[] data) {
        if (this.stack.size() > 0) {
            this.stack.clear();
        }
        if (data != null) {
            for (Obj o : data) {
                if (this.push(o)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        ArrayList<Obj> arrayList = this.stack;
        synchronized (arrayList) {
            return this.stack.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Obj object) {
        ArrayList<Obj> arrayList = this.stack;
        synchronized (arrayList) {
            return this.stack.contains(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Obj object) {
        ArrayList<Obj> arrayList = this.stack;
        synchronized (arrayList) {
            return this.stack.indexOf(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean push(Obj object) {
        if (object == null) {
            return false;
        }
        ArrayList<Obj> arrayList = this.stack;
        synchronized (arrayList) {
            if (this.sizeLimit != -1 && this.stack.size() >= this.sizeLimit) {
                return false;
            }
            return this.stack.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Obj pop() {
        ArrayList<Obj> arrayList = this.stack;
        synchronized (arrayList) {
            if (this.stack.size() > 0) {
                return this.stack.remove(this.stack.size() - 1);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ArrayList<Obj> arrayList = this.stack;
        synchronized (arrayList) {
            return this.stack.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Obj getBottom() {
        ArrayList<Obj> arrayList = this.stack;
        synchronized (arrayList) {
            if (this.stack.isEmpty()) {
                return null;
            }
            return this.stack.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Obj getTop() {
        ArrayList<Obj> arrayList = this.stack;
        synchronized (arrayList) {
            if (this.stack.isEmpty()) {
                return null;
            }
            return this.stack.get(this.stack.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Obj get(int index) {
        ArrayList<Obj> arrayList = this.stack;
        synchronized (arrayList) {
            if (index >= 0 && index < this.stack.size()) {
                return this.stack.get(index);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(Obj[] data) {
        ArrayList<Obj> arrayList = this.stack;
        synchronized (arrayList) {
            return this.initData(data);
        }
    }
}

