/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.data;

import java.util.LinkedList;

public class DataQueue<Obj> {
    public static final int NO_LIMIT = -1;
    protected final LinkedList<Obj> queue = new LinkedList();
    public int sizeLimit = -1;

    public DataQueue() {
    }

    public DataQueue(Obj[] data) {
        this.initData(data);
    }

    public DataQueue(int sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public DataQueue(Obj[] data, int sizeLimit) {
        this.sizeLimit = sizeLimit;
        this.initData(data);
    }

    private boolean initData(Obj[] data) {
        if (this.queue.size() > 0) {
            this.queue.clear();
        }
        if (data != null) {
            for (Obj o : data) {
                if (this.push(o)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        LinkedList<Obj> linkedList = this.queue;
        synchronized (linkedList) {
            return this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Obj object) {
        LinkedList<Obj> linkedList = this.queue;
        synchronized (linkedList) {
            return this.queue.contains(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Obj object) {
        LinkedList<Obj> linkedList = this.queue;
        synchronized (linkedList) {
            return this.queue.indexOf(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean push(Obj object) {
        if (object == null) {
            return false;
        }
        LinkedList<Obj> linkedList = this.queue;
        synchronized (linkedList) {
            if (this.sizeLimit != -1 && this.queue.size() >= this.sizeLimit) {
                return false;
            }
            return this.queue.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Obj pop() {
        LinkedList<Obj> linkedList = this.queue;
        synchronized (linkedList) {
            if (this.queue.isEmpty()) {
                return null;
            }
            return this.queue.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LinkedList<Obj> linkedList = this.queue;
        synchronized (linkedList) {
            return this.queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Obj getFirst() {
        LinkedList<Obj> linkedList = this.queue;
        synchronized (linkedList) {
            if (this.queue.isEmpty()) {
                return null;
            }
            return this.queue.getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Obj getLast() {
        LinkedList<Obj> linkedList = this.queue;
        synchronized (linkedList) {
            if (this.queue.isEmpty()) {
                return null;
            }
            return this.queue.getLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Obj get(int index) {
        LinkedList<Obj> linkedList = this.queue;
        synchronized (linkedList) {
            if (index >= 0 && index < this.queue.size()) {
                return this.queue.get(index);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(Obj[] data) {
        LinkedList<Obj> linkedList = this.queue;
        synchronized (linkedList) {
            return this.initData(data);
        }
    }
}

