/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.data;

import com.modnut.framework2.data.DataObj;
import java.util.ArrayList;

public class DataArr
extends DataObj {
    private final ArrayList<Object> list = new ArrayList();

    public int length() {
        return this.list.size();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(size=").append(this.list.size()).append(")");
        int count = 0;
        for (Object obj : this.list) {
            if (count > 0) {
                sb.append(",");
            }
            if (obj != null) {
                sb.append(obj.toString());
            } else {
                sb.append("null");
            }
            ++count;
        }
        return sb.toString();
    }

    private DataArr putObj(Object obj) {
        this.list.add(obj);
        return this;
    }

    public DataArr put(Object dataObj) {
        return this.putObj(dataObj);
    }

    public DataArr put(boolean dataBoolean) {
        return this.putObj(dataBoolean ? Boolean.TRUE : Boolean.FALSE);
    }

    public DataArr put(char dataChar) {
        return this.putObj(new Character(dataChar));
    }

    public DataArr put(byte dataByte) {
        return this.putObj(new Byte(dataByte));
    }

    public DataArr put(short dataShort) {
        Short val = new Short(dataShort);
        return this.putObj(val);
    }

    public DataArr put(int dataInteger) {
        Integer val = new Integer(dataInteger);
        return this.putObj(val);
    }

    public DataArr put(long dataLong) {
        Long val = new Long(dataLong);
        return this.putObj(val);
    }

    public DataArr put(float dataFloat) {
        Float val = new Float(dataFloat);
        return this.putObj(val);
    }

    public DataArr put(double dataDouble) {
        Double val = new Double(dataDouble);
        return this.putObj(val);
    }

    public DataArr put(String dataString) {
        return this.putObj(dataString);
    }

    public DataArr put(DataObj.DataCall dataCall) {
        return this.putObj(dataCall);
    }

    public <T> T get(int index, Class<T> c) {
        return this.get(index, c, false);
    }

    public <T> T get(int index, Class<T> c, boolean accurate) {
        Object obj;
        if (index >= 0 && index < this.list.size() && (obj = this.list.get(index)) != null && c != null && (accurate ? c.equals(obj.getClass()) : DataArr.baseOfClass(obj.getClass(), c))) {
            return (T)obj;
        }
        return null;
    }

    public Object getObject(int index) {
        if (index >= 0 && index < this.list.size()) {
            return this.list.get(index);
        }
        return null;
    }

    public boolean getBoolean(int index, boolean defaultVal) {
        Object obj = this.getObject(index);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue() != 0L;
        }
        if (obj instanceof String) {
            try {
                return Boolean.parseBoolean((String)obj);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public char getChar(int index, char defaultVal) {
        Object obj = this.getObject(index);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Number) {
            return (char)((Number)obj).intValue();
        }
        if (obj instanceof String) {
            try {
                String str = (String)obj;
                return str.isEmpty() ? defaultVal : str.charAt(0);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public byte getByte(int index, byte defaultVal) {
        Object obj = this.getObject(index);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Number) {
            return ((Number)obj).byteValue();
        }
        if (obj instanceof String) {
            try {
                return Byte.parseByte((String)obj);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public short getShort(int index, short defaultVal) {
        Object obj = this.getObject(index);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Number) {
            return ((Number)obj).shortValue();
        }
        if (obj instanceof String) {
            try {
                return Short.parseShort((String)obj);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public int getInt(int index, int defaultVal) {
        Object obj = this.getObject(index);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof String) {
            try {
                return Integer.parseInt((String)obj);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public long getLong(int index, long defaultVal) {
        Object obj = this.getObject(index);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof String) {
            try {
                return Long.parseLong((String)obj);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public float getFloat(int index, float defaultVal) {
        Object obj = this.getObject(index);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Number) {
            return ((Number)obj).floatValue();
        }
        if (obj instanceof String) {
            try {
                return Float.parseFloat((String)obj);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public double getDouble(int index, double defaultVal) {
        Object obj = this.getObject(index);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof String) {
            try {
                return Double.parseDouble((String)obj);
            }
            catch (Exception ex) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public String getString(int index, String defaultVal) {
        Object obj = this.getObject(index);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }

    public DataObj.DataCall getCall(int index) {
        Object obj = this.getObject(index);
        if (obj != null && obj instanceof DataObj.DataCall) {
            return (DataObj.DataCall)obj;
        }
        return null;
    }

    public Object remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public void clear() {
        super.clear();
        this.list.clear();
    }

    public void clear(boolean arr, boolean obj) {
        if (arr) {
            this.list.clear();
        }
        if (obj) {
            super.clear();
        }
    }
}

