/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.daemon;

import java.util.Calendar;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class DaemonBase
implements Runnable {
    private AtomicBoolean running = new AtomicBoolean(false);
    private AtomicBoolean canceled = new AtomicBoolean(false);
    private boolean scheduleDaemon = false;
    private int[] min = null;
    private int[] hour = null;
    private int[] dayOfMonth = null;
    private int[] month = null;
    private int[] dayOfWeek = null;

    public DaemonBase() {
    }

    public DaemonBase(String schedule) {
        this.scheduleDaemon = true;
        schedule = schedule == null ? "" : schedule;
        String[] s = schedule.split("\\s");
        if (s.length > 0) {
            this.min = DaemonBase.parse(s[0], 0, 59);
        }
        if (s.length > 1) {
            this.hour = DaemonBase.parse(s[1], 0, 23);
        }
        if (s.length > 2) {
            this.dayOfMonth = DaemonBase.parse(s[2], 1, 31);
        }
        if (s.length > 3) {
            this.month = DaemonBase.parse(s[3], 1, 12);
        }
        if (s.length > 4) {
            this.dayOfWeek = DaemonBase.parse(s[4], 0, 6);
        }
    }

    @Override
    public void run() {
        if (this.running.compareAndSet(false, true)) {
            try {
                this.canceled.set(false);
                this.doTask();
            }
            finally {
                this.canceled.set(false);
                this.running.set(false);
            }
        }
    }

    public boolean getRunning() {
        return this.running.get();
    }

    public boolean getCanceled() {
        return this.canceled.get();
    }

    protected abstract void doTask();

    public void cancelTask() {
        if (this.getRunning()) {
            this.canceled.set(true);
        }
    }

    public boolean getTimeout() {
        return false;
    }

    public boolean onSchedule(long timeStamp) {
        if (this.scheduleDaemon) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(timeStamp);
            if (!DaemonBase.match(this.min, cal.get(12))) {
                return false;
            }
            if (!DaemonBase.match(this.hour, cal.get(11))) {
                return false;
            }
            if (!DaemonBase.match(this.dayOfMonth, cal.get(5))) {
                return false;
            }
            if (!DaemonBase.match(this.month, cal.get(2) + 1)) {
                return false;
            }
            return DaemonBase.match(this.dayOfWeek, cal.get(7) - 1);
        }
        return false;
    }

    private static boolean match(int[] values, int value) {
        boolean match = values == null;
        for (int i = 0; !match && i < values.length; ++i) {
            match = values[i] == value;
        }
        return match;
    }

    private static int[] parse(String str, int min, int max) {
        int index = str.indexOf(45);
        if (index >= 0) {
            int end;
            String startStr = str.substring(0, index);
            String endStr = str.substring(index + 1);
            int start = DaemonBase.parseInt(startStr, min);
            if (start > (end = DaemonBase.parseInt(endStr, max))) {
                return null;
            }
            int[] values = new int[end - start + 1];
            for (int value = start; value <= end; ++value) {
                values[value - start] = value;
            }
            return values;
        }
        if (str.indexOf(44) >= 0) {
            String[] valuesStr = str.split(",");
            int[] values = new int[valuesStr.length];
            for (int i = 0; i < valuesStr.length; ++i) {
                values[i] = DaemonBase.parseInt(valuesStr[i], min);
            }
            return values;
        }
        if ("*".equals(str)) {
            return null;
        }
        int[] values = new int[]{DaemonBase.parseInt(str, min)};
        return values;
    }

    private static int parseInt(String str, int defaultVal) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception ex) {
            return defaultVal;
        }
    }
}

