/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.crypto;

import ET299jni.CET299;
import ET299jni.ET299API;
import ET299jni.ET299Def;
import ET299jni.IET299;
import ET299jni.RTException;
import com.modnut.framework2.constant.ConstFramework;
import com.modnut.framework2.crypto.Digest;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TokenET99 {
    private static final int BUFF_SIZE = 1024;
    private static final int PID_PIN_BUFF_SIZE = 16;
    private static final int SN_SIZE = 8;
    private static final int PID_SIZE = 8;
    private static final int PIN_SIZE = 16;
    private static final int RANDOM_SIZE = 16;
    private static final int RW_BLOCK_SIZE = 59;
    private static final int VERIFY_PASS = 0;
    private static final int VERIFY_NOT_INIT = 1;
    private static final int VERIFY_EXCEPTION = 2;
    private static final int VERIFY_CLASS_BROKEN = 3;
    private static final int VERIFY_LIBRARY_BROKEN = 4;
    private static final byte[] CET299_MD5 = TokenET99.hex2Bytes("a3b1b3e48a2a86b6f256bf1c17931288");
    private static final byte[] ET299API_MD5 = TokenET99.hex2Bytes("39be71f1f5b009433f88c75530bb8688");
    private static final byte[] ET299DEF_MD5 = TokenET99.hex2Bytes("d1ac466a5246451eae1bc512cca58631");
    private static final byte[] IET299_MD5 = TokenET99.hex2Bytes("434731f013a1434a2adbfdf531557644");
    private static final byte[] RTEXCEPTION_MD5 = TokenET99.hex2Bytes("116411758ad94963128da36b3bf24b8d");
    private static final byte[] LIB_WIN32_MD5 = TokenET99.hex2Bytes("34f738100724d22c73d4dbb9de6ee8d2");
    private static final byte[] LIB_WIN64_MD5 = TokenET99.hex2Bytes("ebfe2b04e44a14f785caafbe3abfc572");
    private static final byte[] LIB_LINUX32_MD5 = TokenET99.hex2Bytes("77649636fb1d11701e425641ab3c49a3");
    private static final byte[] LIB_LINUX64_MD5 = TokenET99.hex2Bytes("bedaf313cc9c5bcc70780119d68ebb3e");
    private static final byte[] LIB_MAC_MD5 = TokenET99.hex2Bytes("8692980af906d0dde720e64b2d7f7791");
    private static final byte[] CET299_SHA1 = TokenET99.hex2Bytes("63d5d9b6dcaa93a5c31695f4c65580db7e093bfa");
    private static final byte[] ET299API_SHA1 = TokenET99.hex2Bytes("057131ec78f0ec5aa4ca33b344823c20cd7f4e30");
    private static final byte[] ET299DEF_SHA1 = TokenET99.hex2Bytes("dacd6bb03632e2381a67c3a4c7a691965862d0b9");
    private static final byte[] IET299_SHA1 = TokenET99.hex2Bytes("5cf1ed267f1b0d6f1ee579f8c9f16cddfcab096c");
    private static final byte[] RTEXCEPTION_SHA1 = TokenET99.hex2Bytes("1b9b7822337fca7a9e0b09d6f8694314e897b05b");
    private static final byte[] LIB_WIN32_SHA1 = TokenET99.hex2Bytes("3b1c8c67988d38237ad45cca9a510767ae583094");
    private static final byte[] LIB_WIN64_SHA1 = TokenET99.hex2Bytes("4df2cde8136f895affb00f509badd78b0cbd4091");
    private static final byte[] LIB_LINUX32_SHA1 = TokenET99.hex2Bytes("f993248e65a97af3a256985b057936b0ae01ff10");
    private static final byte[] LIB_LINUX64_SHA1 = TokenET99.hex2Bytes("8d8f9289f87eabc4dda6d2f480bcd4bb8f96a0f6");
    private static final byte[] LIB_MAC_SHA1 = TokenET99.hex2Bytes("59eeabe554fe763f4c840f5cc64875c582455e3f");
    private static int verify = 1;
    private final IET299 et99 = new CET299();
    private byte[] pid;
    private byte[] pin;
    private boolean admin;

    public TokenET99(String pid, String pin, boolean admin) {
        this.pid = TokenET99.getPidPinBytes(pid == null ? "" : pid);
        this.pin = TokenET99.getPidPinBytes(pin == null ? "" : pin);
        this.admin = admin;
    }

    private static byte[] getPidPinBytes(String str) {
        byte[] data = new byte[16];
        for (int i = 0; i < str.length() && i < 16; ++i) {
            data[i] = (byte)str.charAt(i);
        }
        return data;
    }

    private static String getResultMessage(int result) {
        switch (result) {
            case 0: {
                return "\u51fd\u6570\u6267\u884c\u6210\u529f";
            }
            case 1: {
                return "\u8bbf\u95ee\u88ab\u62d2\u7edd,\u6743\u9650\u4e0d\u591f";
            }
            case 2: {
                return "\u901a\u8baf\u9519\u8bef,\u6ca1\u6709\u6253\u5f00\u8bbe\u5907";
            }
            case 3: {
                return "\u65e0\u6548\u7684\u53c2\u6570,\u53c2\u6570\u51fa\u9519";
            }
            case 4: {
                return "\u6ca1\u6709\u8bbe\u7f6e PID";
            }
            case 5: {
                return "\u6253\u5f00\u6307\u5b9a\u7684\u8bbe\u5907\u5931\u8d25";
            }
            case 6: {
                return "\u786c\u4ef6\u9519\u8bef";
            }
            case 7: {
                return "\u672a\u77e5\u9519\u8bef";
            }
        }
        return "";
    }

    public byte[] getPid() {
        byte[] data = new byte[8];
        System.arraycopy(this.pid, 0, data, 0, 8);
        return data;
    }

    public byte[] getPin() {
        byte[] data = new byte[16];
        System.arraycopy(this.pin, 0, data, 0, 16);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int tokenCount() {
        if (verify == 0) {
            try {
                int[] count = new int[]{0};
                IET299 iET299 = this.et99;
                synchronized (iET299) {
                    this.et99.FindToken(this.pid, count);
                }
                return count[0];
            }
            catch (RTException ex) {
                TokenET99.echo("tokenCount - " + ex.HResult() + " : " + TokenET99.getResultMessage(ex.HResult()));
                return 0;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tokenOpen(int index) {
        if (verify == 0) {
            try {
                IET299 iET299 = this.et99;
                synchronized (iET299) {
                    this.et99.OpenToken(this.pid, index);
                }
                return true;
            }
            catch (RTException ex) {
                TokenET99.echo("tokenOpen - " + ex.HResult() + " : " + TokenET99.getResultMessage(ex.HResult()));
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tokenClose() {
        if (verify == 0) {
            try {
                IET299 iET299 = this.et99;
                synchronized (iET299) {
                    this.et99.CloseToken();
                }
                return true;
            }
            catch (RTException ex) {
                TokenET99.echo("tokenClose - " + ex.HResult() + " : " + TokenET99.getResultMessage(ex.HResult()));
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tokenSN() {
        if (verify == 0) {
            try {
                byte[] sn = new byte[8];
                IET299 iET299 = this.et99;
                synchronized (iET299) {
                    this.et99.GetSN(sn);
                }
                return TokenET99.bytes2Hex(sn);
            }
            catch (RTException ex) {
                TokenET99.echo("tokenSN - " + ex.HResult() + " : " + TokenET99.getResultMessage(ex.HResult()));
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tokenLED(boolean on) {
        if (verify == 0) {
            try {
                IET299 iET299 = this.et99;
                synchronized (iET299) {
                    if (on) {
                        this.et99.TurnOnLED();
                    } else {
                        this.et99.TurnOffLED();
                    }
                }
                return true;
            }
            catch (RTException ex) {
                TokenET99.echo("tokenLED - " + ex.HResult() + " : " + TokenET99.getResultMessage(ex.HResult()));
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tokenVerify() {
        if (verify == 0) {
            try {
                IET299 iET299 = this.et99;
                synchronized (iET299) {
                    this.et99.Verify(this.admin ? 1 : 0, this.pin);
                }
                return true;
            }
            catch (RTException ex) {
                TokenET99.echo("tokenVerify - " + ex.HResult() + " : " + TokenET99.getResultMessage(ex.HResult()));
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tokenReset() {
        if (verify == 0) {
            try {
                IET299 iET299 = this.et99;
                synchronized (iET299) {
                    this.et99.ResetSecurityState();
                }
                return true;
            }
            catch (RTException ex) {
                TokenET99.echo("tokenReset - " + ex.HResult() + " : " + TokenET99.getResultMessage(ex.HResult()));
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tokenSetup(int soRetry, int userRetry, boolean userReadOnly) {
        if (verify == 0) {
            try {
                soRetry = Math.min(Math.max(soRetry, 0), 15);
                userRetry = Math.min(Math.max(userRetry, 0), 15);
                IET299 iET299 = this.et99;
                synchronized (iET299) {
                    this.et99.SetupToken(soRetry, userRetry, userReadOnly ? 1 : 0, 0);
                }
                return true;
            }
            catch (RTException ex) {
                TokenET99.echo("tokenSetup - " + ex.HResult() + " : " + TokenET99.getResultMessage(ex.HResult()));
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] tokenRead(int offset, int length) {
        if (verify == 0) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IET299 iET299 = this.et99;
                synchronized (iET299) {
                    int read;
                    byte[] buff = new byte[59];
                    for (int count = 0; count < length; count += read) {
                        read = length - count;
                        read = read > 59 ? 59 : read;
                        this.et99.Read(offset + count, read, buff);
                        out.write(buff, 0, read);
                    }
                }
                return out.toByteArray();
            }
            catch (RTException ex) {
                TokenET99.echo("tokenRead - " + ex.HResult() + " : " + TokenET99.getResultMessage(ex.HResult()));
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tokenWrite(int offset, byte[] data) {
        if (verify == 0) {
            try {
                IET299 iET299 = this.et99;
                synchronized (iET299) {
                    byte[] buff = new byte[59];
                    for (int count = 0; count < data.length; count += 59) {
                        int write = data.length - count;
                        write = write > 59 ? 59 : write;
                        System.arraycopy(data, count, buff, 0, write);
                        this.et99.Write(offset + count, write, buff);
                    }
                }
                return true;
            }
            catch (RTException ex) {
                TokenET99.echo("tokenWrite - " + ex.HResult() + " : " + TokenET99.getResultMessage(ex.HResult()));
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] tokenGenRandom() {
        if (verify == 0) {
            try {
                byte[] buff = new byte[16];
                IET299 iET299 = this.et99;
                synchronized (iET299) {
                    this.et99.GenRandom(buff);
                }
                return buff;
            }
            catch (RTException ex) {
                TokenET99.echo("tokenGenRandom - " + ex.HResult() + " : " + TokenET99.getResultMessage(ex.HResult()));
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tokenGenPid(String seedStr) {
        if (verify == 0) {
            try {
                byte[] seed = new Digest().update(seedStr.getBytes(ConstFramework.getCharset())).digest();
                IET299 iET299 = this.et99;
                synchronized (iET299) {
                    this.et99.GenPid(seed, seed.length, this.pid);
                }
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < 8; ++i) {
                    sb.append((char)this.pid[i]);
                }
                return sb.toString();
            }
            catch (RTException ex) {
                TokenET99.echo("tokenGenPid - " + ex.HResult() + " : " + TokenET99.getResultMessage(ex.HResult()));
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tokenGenAdminPin(String seedStr) {
        if (verify == 0) {
            try {
                byte[] buff = new byte[16];
                byte[] seed = new Digest().update(seedStr.getBytes(ConstFramework.getCharset())).digest();
                IET299 iET299 = this.et99;
                synchronized (iET299) {
                    this.et99.GenSoPIN(seed, seed.length, buff);
                }
                if (this.admin) {
                    System.arraycopy(buff, 0, this.pin, 0, 16);
                }
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < 16; ++i) {
                    sb.append((char)buff[i]);
                }
                return sb.toString();
            }
            catch (RTException ex) {
                TokenET99.echo("tokenGenAdminPin - " + ex.HResult() + " : " + TokenET99.getResultMessage(ex.HResult()));
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tokenResetUserPin(String adminPinStr) {
        if (verify == 0) {
            try {
                byte[] adminPin = TokenET99.getPidPinBytes(adminPinStr);
                IET299 iET299 = this.et99;
                synchronized (iET299) {
                    this.et99.ResetPIN(adminPin);
                }
                return true;
            }
            catch (RTException ex) {
                TokenET99.echo("tokenResetUserPin - " + ex.HResult() + " : " + TokenET99.getResultMessage(ex.HResult()));
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tokenChangeUserPin(String oldpasswd, String newpasswd) {
        if (verify == 0) {
            try {
                byte[] oldpin = TokenET99.getPidPinBytes(oldpasswd);
                byte[] newpin = TokenET99.getPidPinBytes(newpasswd);
                IET299 iET299 = this.et99;
                synchronized (iET299) {
                    this.et99.ChangeUserPIN(oldpin, newpin);
                }
                return true;
            }
            catch (RTException ex) {
                TokenET99.echo("tokenChangeUserPin - " + ex.HResult() + " : " + TokenET99.getResultMessage(ex.HResult()));
                return false;
            }
        }
        return false;
    }

    private static String[] getLibNames() {
        String osname = System.getProperty("os.name");
        String string = osname = osname == null ? "" : osname.toLowerCase();
        if (osname.indexOf("windows") >= 0) {
            String[] lib = new String[]{"JET299AI20.dll"};
            return lib;
        }
        if (osname.indexOf("linux") >= 0) {
            String[] lib = new String[]{"libJET299ai20.so"};
            return lib;
        }
        if (osname.indexOf("mac") >= 0) {
            String[] lib = new String[]{"libJET299ai20.jnilib"};
            return lib;
        }
        String[] lib = new String[]{"JET299AI20.dll,libJET299ai20.so,libJET299ai20.jnilib"};
        return lib;
    }

    private static String getLibDir() {
        String[] libpaths;
        String osname = System.getProperty("os.name");
        String libpath = System.getProperty("java.library.path");
        String betterDir = null;
        osname = osname == null ? "" : osname.toLowerCase();
        String[] stringArray = libpaths = libpath == null ? null : libpath.split(File.pathSeparator);
        if (osname.indexOf("windows") >= 0) {
            betterDir = "system32";
        } else if (osname.indexOf("linux") >= 0) {
            betterDir = "jni";
        } else if (osname.indexOf("mac") >= 0) {
            betterDir = "extensions";
        }
        if (libpaths != null) {
            if (betterDir != null) {
                for (String p : libpaths) {
                    if (!p.toLowerCase().endsWith(betterDir)) continue;
                    return p;
                }
            }
            return libpaths[0];
        }
        return null;
    }

    private static InputStream getLibInputStream(String libName) {
        String arch = System.getProperty("sun.arch.data.model");
        InputStream is = CET299.class.getResourceAsStream(libName);
        if (is == null) {
            arch = arch == null ? "32" : arch;
            is = CET299.class.getResourceAsStream(libName + "." + arch);
        }
        return is;
    }

    public static boolean getVerify() {
        return verify == 0;
    }

    public static void setVerify() {
        if (verify == 0 || verify == 1) {
            verify = TokenET99.doVerify();
        }
    }

    private static int doVerify() {
        return TokenET99.doVerify(true);
    }

    private static int doVerify(boolean verifyLib) {
        try {
            if (!TokenET99.doClassVerify(CET299.class, CET299_MD5, CET299_SHA1)) {
                return 3;
            }
            if (!TokenET99.doClassVerify(ET299API.class, ET299API_MD5, ET299API_SHA1)) {
                return 3;
            }
            if (!TokenET99.doClassVerify(ET299Def.class, ET299DEF_MD5, ET299DEF_SHA1)) {
                return 3;
            }
            if (!TokenET99.doClassVerify(IET299.class, IET299_MD5, IET299_SHA1)) {
                return 3;
            }
            if (!TokenET99.doClassVerify(RTException.class, RTEXCEPTION_MD5, RTEXCEPTION_SHA1)) {
                return 3;
            }
            if (verifyLib) {
                if (!TokenET99.doLibVerify("JET299AI20.dll.32", LIB_WIN32_MD5, LIB_WIN32_SHA1)) {
                    return 4;
                }
                if (!TokenET99.doLibVerify("JET299AI20.dll.64", LIB_WIN64_MD5, LIB_WIN64_SHA1)) {
                    return 4;
                }
                if (!TokenET99.doLibVerify("libJET299ai20.so.32", LIB_LINUX32_MD5, LIB_LINUX32_SHA1)) {
                    return 4;
                }
                if (!TokenET99.doLibVerify("libJET299ai20.so.64", LIB_LINUX64_MD5, LIB_LINUX64_SHA1)) {
                    return 4;
                }
                if (!TokenET99.doLibVerify("libJET299ai20.jnilib", LIB_MAC_MD5, LIB_MAC_SHA1)) {
                    return 4;
                }
            }
            return 0;
        }
        catch (IOException ex) {
            Logger.getLogger(TokenET99.class.getName()).log(Level.SEVERE, null, ex);
            return 2;
        }
    }

    private static boolean doClassVerify(Class c, byte[] md5, byte[] sha1) throws IOException {
        String name = c.getName().replace('.', '/') + ".class";
        return TokenET99.doInputStreamVerify(c.getClassLoader().getResourceAsStream(name), md5, sha1);
    }

    private static boolean doLibVerify(String name, byte[] md5, byte[] sha1) throws IOException {
        return TokenET99.doInputStreamVerify(CET299.class.getResourceAsStream(name), md5, sha1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doInputStreamVerify(InputStream is, byte[] md5, byte[] sha1) throws IOException {
        if (is == null) {
            return false;
        }
        try {
            int read;
            Digest dmd5 = new Digest(Digest.ALGORITHM.MD5);
            Digest dsha1 = new Digest(Digest.ALGORITHM.SHA1);
            byte[] buff = new byte[1024];
            while ((read = is.read(buff)) != -1) {
                dmd5.update(buff, 0, read);
                dsha1.update(buff, 0, read);
            }
            if (!TokenET99.compareBytes(md5, dmd5.digest())) {
                boolean bl = false;
                return bl;
            }
            if (!TokenET99.compareBytes(sha1, dsha1.digest())) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            is.close();
        }
    }

    private static boolean compareBytes(byte[] b1, byte[] b2) {
        if (b1 == null || b2 == null || b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private static char getHexCh(int b) {
        if (b >= 10) {
            return (char)(87 + b);
        }
        return (char)(48 + b);
    }

    private static String bytes2Hex(byte[] data) {
        return TokenET99.bytes2Hex(data, 0, data.length);
    }

    private static String bytes2Hex(byte[] data, int start, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < data.length && i < length; ++i) {
            int b = data[i];
            b = b < 0 ? b + 256 : b;
            sb.append(TokenET99.getHexCh(b / 16));
            sb.append(TokenET99.getHexCh(b % 16));
        }
        return sb.toString();
    }

    private static byte[] hex2Bytes(String hex) {
        if (hex == null) {
            return null;
        }
        hex = hex.toLowerCase();
        byte[] bytes = new byte[hex.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(hex.substring(i * 2, i * 2 + 2), 16);
        }
        return bytes;
    }

    private static void echo(String msg) {
        if (ConstFramework.getDebug()) {
            System.out.println("[ET299]" + msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        int firstVerify = TokenET99.doVerify(true);
        if (firstVerify == 0) {
            String[] libNames = TokenET99.getLibNames();
            String libDir = TokenET99.getLibDir();
            File libDirFile = new File(libDir = new File(libDir).getAbsolutePath());
            if (libDirFile.exists() ? libDirFile.isDirectory() : libDirFile.mkdirs()) {
                for (int i = 0; i < libNames.length; ++i) {
                    String path = libDir + File.separator + libNames[i];
                    InputStream is = TokenET99.getLibInputStream(libNames[i]);
                    try {
                        byte[] buff = new byte[1024];
                        FileOutputStream out = new FileOutputStream(path);
                        try {
                            int read;
                            while ((read = is.read(buff)) != -1) {
                                out.write(buff, 0, read);
                            }
                        }
                        finally {
                            out.close();
                        }
                        TokenET99.echo("copy " + libNames[i] + " \"" + path + "\"");
                        continue;
                    }
                    catch (IOException ex) {
                        Logger.getLogger(TokenET99.class.getName()).log(Level.SEVERE, null, ex);
                        continue;
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(TokenET99.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            } else {
                TokenET99.echo("library path \"" + libDir + "\" not exist");
            }
        }
        verify = firstVerify;
    }

    private static final class VAL {
        public static final int ET_SUCCESS = 0;
        public static final int ET_ACCESS_DENY = 1;
        public static final int ET_COMMUNICATIONS_ERROR = 2;
        public static final int ET_INVALID_PARAMETER = 3;
        public static final int ET_NOT_SET_PID = 4;
        public static final int ET_UNIT_NOT_FOUND = 5;
        public static final int ET_HARD_ERROR = 6;
        public static final int ET_UNKNOWN_ERROR = 7;
        public static final int ET_PIN_ERR_MASK = 15;
        public static final int ET_PIN_ERR_MAX = 255;
        public static final int ET_VERIFY_USERPIN = 0;
        public static final int ET_VERIFY_SOPIN = 1;
        public static final int ET_USER_WRITE_READ = 0;
        public static final int ET_USER_READ_ONLY = 1;

        private VAL() {
        }
    }
}

