/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.crypto;

import com.modnut.framework2.constant.ConstFramework;
import com.modnut.framework2.crypto.BASE64;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DSA {
    private static final String KEY_ALGORITHM = "DSA";
    private static final int KEY_SIZE = 1024;
    private Signature signature;
    private MODE mode;

    public DSA(String key, MODE mode) {
        this.init(key, mode);
    }

    private boolean init(String key, MODE mode) {
        block11: {
            try {
                if (mode == null) {
                    this.mode = mode = MODE.DEFAULT;
                }
                byte[] keyBytes = BASE64.decode(key);
                KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
                switch (mode) {
                    case PRIVATE_SIGN: {
                        PrivateKey priKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(keyBytes));
                        this.signature = Signature.getInstance(KEY_ALGORITHM);
                        this.signature.initSign(priKey);
                        break;
                    }
                    case PUBLIC_VERIFY: {
                        PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(keyBytes));
                        this.signature = Signature.getInstance(KEY_ALGORITHM);
                        this.signature.initVerify(pubKey);
                    }
                }
                return true;
            }
            catch (InvalidKeyException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(DSA.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (InvalidKeySpecException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(DSA.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (NoSuchAlgorithmException ex) {
                if (!ConstFramework.getDebug()) break block11;
                Logger.getLogger(DSA.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.signature = null;
        return false;
    }

    public void update(byte[] input) {
        block2: {
            try {
                this.signature.update(input);
            }
            catch (SignatureException ex) {
                if (!ConstFramework.getDebug()) break block2;
                Logger.getLogger(DSA.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void update(byte[] input, int offset, int len) {
        block2: {
            try {
                this.signature.update(input, offset, len);
            }
            catch (SignatureException ex) {
                if (!ConstFramework.getDebug()) break block2;
                Logger.getLogger(DSA.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public String sign() {
        try {
            return BASE64.encode(this.signature.sign());
        }
        catch (SignatureException ex) {
            if (ConstFramework.getDebug()) {
                Logger.getLogger(DSA.class.getName()).log(Level.SEVERE, null, ex);
            }
            return null;
        }
    }

    public boolean verify(String sign) {
        try {
            return this.signature.verify(BASE64.decode(sign));
        }
        catch (SignatureException ex) {
            if (ConstFramework.getDebug()) {
                Logger.getLogger(DSA.class.getName()).log(Level.SEVERE, null, ex);
            }
            return false;
        }
    }

    public static Keys generateKeys() {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
            keyPairGen.initialize(1024);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            Keys keys = new Keys();
            keys.publicKey = BASE64.encode(keyPair.getPublic().getEncoded());
            keys.privateKey = BASE64.encode(keyPair.getPrivate().getEncoded());
            return keys;
        }
        catch (NoSuchAlgorithmException ex) {
            if (ConstFramework.getDebug()) {
                Logger.getLogger(DSA.class.getName()).log(Level.SEVERE, null, ex);
            }
            return null;
        }
    }

    public static String signByPrivateKey(byte[] data, String key) {
        DSA dsa = new DSA(key, MODE.PRIVATE_SIGN);
        dsa.update(data);
        return dsa.sign();
    }

    public static boolean verifyByPublicKey(byte[] data, String key, String sign) {
        DSA dsa = new DSA(key, MODE.PUBLIC_VERIFY);
        dsa.update(data);
        return dsa.verify(sign);
    }

    public static enum MODE {
        PRIVATE_SIGN,
        PUBLIC_VERIFY;

        public static MODE DEFAULT;

        static {
            DEFAULT = PRIVATE_SIGN;
        }
    }

    public static class Keys {
        public String publicKey;
        public String privateKey;
    }
}

