/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.crypto;

import com.modnut.framework2.constant.ConstFramework;
import com.modnut.framework2.crypto.BASE64;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class DES {
    private Cipher cipher;

    public DES(String key, MODE mode) {
        this.init(key, mode, null);
    }

    public DES(String key, MODE mode, ALGORITHM algorithm) {
        this.init(key, mode, algorithm);
    }

    private boolean init(String key, MODE mode, ALGORITHM algorithm) {
        block8: {
            if (algorithm == null) {
                algorithm = ALGORITHM.DEFAULT;
            }
            if (mode == null) {
                mode = MODE.DEFAULT;
            }
            try {
                SecretKeySpec secretKey = new SecretKeySpec(BASE64.decode(key), algorithm.getAlgorithm());
                this.cipher = Cipher.getInstance(algorithm.getAlgorithm());
                this.cipher.init(mode.getMode(), secretKey);
                return true;
            }
            catch (NoSuchPaddingException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(DES.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (InvalidKeyException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(DES.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (NoSuchAlgorithmException ex) {
                if (!ConstFramework.getDebug()) break block8;
                Logger.getLogger(DES.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.cipher = null;
        return false;
    }

    public byte[] update(byte[] input) {
        return this.cipher.update(input);
    }

    public byte[] update(byte[] input, int offset, int len) {
        return this.cipher.update(input, offset, len);
    }

    public byte[] doFinal(byte[] input) {
        block4: {
            try {
                return this.cipher.doFinal(input);
            }
            catch (IllegalBlockSizeException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(DES.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (BadPaddingException ex) {
                if (!ConstFramework.getDebug()) break block4;
                Logger.getLogger(DES.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public byte[] doFinal(byte[] input, int offset, int len) {
        block4: {
            try {
                return this.cipher.doFinal(input, offset, len);
            }
            catch (IllegalBlockSizeException ex) {
                if (ConstFramework.getDebug()) {
                    Logger.getLogger(DES.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (BadPaddingException ex) {
                if (!ConstFramework.getDebug()) break block4;
                Logger.getLogger(DES.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public static String generateKey() {
        return DES.generateKey(null);
    }

    public static String generateKey(ALGORITHM algorithm) {
        if (algorithm == null) {
            algorithm = ALGORITHM.DEFAULT;
        }
        try {
            SecureRandom secureRandom = new SecureRandom();
            KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm.getAlgorithm());
            keyGenerator.init(secureRandom);
            SecretKey secretKey = keyGenerator.generateKey();
            return BASE64.encode(secretKey.getEncoded());
        }
        catch (NoSuchAlgorithmException ex) {
            if (ConstFramework.getDebug()) {
                Logger.getLogger(DES.class.getName()).log(Level.SEVERE, null, ex);
            }
            return null;
        }
    }

    public static byte[] encrypt(byte[] data, String key) {
        return DES.encrypt(data, key, null);
    }

    public static byte[] encrypt(byte[] data, String key, ALGORITHM algorithm) {
        return new DES(key, MODE.ENCRYPT, algorithm).doFinal(data);
    }

    public static byte[] decrypt(byte[] data, String key) {
        return DES.decrypt(data, key, null);
    }

    public static byte[] decrypt(byte[] data, String key, ALGORITHM algorithm) {
        return new DES(key, MODE.DECRYPT, algorithm).doFinal(data);
    }

    public static enum MODE {
        ENCRYPT,
        DECRYPT;

        public static MODE DEFAULT;

        public int getMode() {
            switch (this) {
                case ENCRYPT: {
                    return 1;
                }
                case DECRYPT: {
                    return 2;
                }
            }
            return DEFAULT.getMode();
        }

        static {
            DEFAULT = ENCRYPT;
        }
    }

    public static enum ALGORITHM {
        DES,
        DESede,
        AES,
        Blowfish,
        RC2,
        RC4;

        public static ALGORITHM DEFAULT;

        public String getAlgorithm() {
            switch (this) {
                case DES: {
                    return "DES";
                }
                case DESede: {
                    return "DESede";
                }
                case AES: {
                    return "AES";
                }
                case Blowfish: {
                    return "Blowfish";
                }
                case RC2: {
                    return "RC2";
                }
                case RC4: {
                    return "RC4";
                }
            }
            return null;
        }

        static {
            DEFAULT = DES;
        }
    }
}

