/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.constant;

import com.modnut.framework2.json.JSONArray;
import com.modnut.framework2.json.JSONObject;

public abstract class ConstJsBase {
    public String createParamJS(Object ... params) {
        return this.createParam(params);
    }

    public String createParam(Object[] params) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            if (params[i] == null) {
                sb.append("null");
                continue;
            }
            if (params[i] instanceof String) {
                sb.append(this.formatJsStr((String)params[i]));
                continue;
            }
            if (params[i] instanceof Character) {
                sb.append(this.formatJsStr(((Character)params[i]).toString()));
                continue;
            }
            if (params[i] instanceof Byte) {
                sb.append(((Byte)params[i]).byteValue());
                continue;
            }
            if (params[i] instanceof Short) {
                sb.append(((Short)params[i]).byteValue());
                continue;
            }
            if (params[i] instanceof Integer) {
                sb.append(((Integer)params[i]).byteValue());
                continue;
            }
            if (params[i] instanceof Long) {
                sb.append(((Long)params[i]).byteValue());
                continue;
            }
            if (params[i] instanceof Float) {
                sb.append(((Float)params[i]).floatValue());
                continue;
            }
            if (params[i] instanceof Double) {
                sb.append((Double)params[i]);
                continue;
            }
            if (params[i] instanceof Number) {
                sb.append(((Number)params[i]).doubleValue());
                continue;
            }
            if (params[i] instanceof JsObject) {
                sb.append(params[i].toString());
                continue;
            }
            if (params[i] instanceof JsCode) {
                sb.append(((JsCode)params[i]).code);
                continue;
            }
            if (params[i] instanceof JSONObject) {
                sb.append(((JSONObject)params[i]).toString(true));
                continue;
            }
            if (params[i] instanceof JSONArray) {
                sb.append(((JSONArray)params[i]).toString(true));
                continue;
            }
            sb.append(params[i].toString());
        }
        return sb.toString();
    }

    protected String formatJsStr(String str) {
        if (str == null) {
            return "null";
        }
        char[] chArr = str.toCharArray();
        StringBuilder sb = new StringBuilder();
        sb.append('\'');
        for (char ch : chArr) {
            if (ch >= '\u0000' && ch <= '\u007f') {
                switch (ch) {
                    case '\'': {
                        sb.append("\\'");
                        break;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        break;
                    }
                    case '/': {
                        sb.append("\\/");
                        break;
                    }
                    case '\b': {
                        sb.append("\\b");
                        break;
                    }
                    case '\f': {
                        sb.append("\\f");
                        break;
                    }
                    case '\n': {
                        sb.append("\\n");
                        break;
                    }
                    case '\r': {
                        sb.append("\\r");
                        break;
                    }
                    case '\t': {
                        sb.append("\\t");
                        break;
                    }
                    default: {
                        sb.append(ch);
                        break;
                    }
                }
                continue;
            }
            String uStr = Integer.toHexString(ch);
            while (uStr.length() < 4) {
                uStr = '0' + uStr;
            }
            sb.append("\\u").append(uStr);
        }
        sb.append('\'');
        return sb.toString();
    }

    public static class JsObject {
        private final String prefix;
        private final String name;

        public JsObject(String prefix, String name) {
            this.prefix = prefix;
            this.name = name;
        }

        public String toString() {
            return this.prefix == null ? this.name : this.prefix + "." + this.name;
        }
    }

    public static class JsCode {
        private final String code;

        public JsCode(String code) {
            this.code = code;
        }
    }
}

