/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.compiler;

import com.modnut.framework2.compiler.CompilerException;
import com.modnut.framework2.compiler.CompilerProject;
import com.modnut.framework2.extend.DomParser;
import com.modnut.framework2.tool.ToolFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CompilerNetbeans {
    public static final String DIR_INFO = "nbproject";
    public static final String DIR_INFO_SUB = "private";
    public static final String DIR_CLASSES = "classes";
    public static final String DIR_WEBINF = "WEB-INF";
    public static final String DIR_WEB = "web";
    public static final String DIR_LIB = "lib";
    public static final String FILE_XML = "project.xml";
    public static final String FILE_PROP = "project.properties";
    public static final String FILE_PROP_SUB = "private.properties";
    public final Info info;
    public final NetbeansProp prop;

    public CompilerNetbeans(Info info) throws IOException {
        this.info = info;
        File projectDir = info.getProjectDir();
        File projectProp1 = new File(projectDir.getAbsolutePath() + File.separator + DIR_INFO + File.separator + FILE_PROP);
        File projectProp2 = new File(projectDir.getAbsolutePath() + File.separator + DIR_INFO + File.separator + DIR_INFO_SUB + File.separator + FILE_PROP_SUB);
        File projectXml = new File(projectDir.getAbsolutePath() + File.separator + DIR_INFO + File.separator + FILE_XML);
        this.prop = NetbeansProp.create(projectProp1, projectProp2, projectXml);
    }

    public File compile(InputStream in, OutputStream out, OutputStream err) throws CompilerException {
        if ("org.netbeans.modules.java.j2seproject".equals(this.prop.type)) {
            return this.compileJ2SE(in, out, err, this.prop);
        }
        if ("org.netbeans.modules.web.project".equals(this.prop.type)) {
            return this.compileWeb(in, out, err, this.prop);
        }
        return null;
    }

    public File compileJ2SE(InputStream in, OutputStream out, OutputStream err, NetbeansProp prop) throws CompilerException {
        try {
            boolean hasMainClass;
            File sourceDir = this.info.getProjectFile(prop.get("src.dir"));
            File sourceCopyDir = new File(this.info.getTempDir().getAbsolutePath() + File.separator + DIR_CLASSES);
            File buildJar = this.info.getBuildFile(prop.get("dist.jar"));
            ToolFile.copyFile(sourceDir, sourceCopyDir);
            this.info.preSolve();
            Manifest manifest = this.info.getProjectManifest(prop.get("manifest.file"));
            CompilerProject c = new CompilerProject(sourceCopyDir, manifest);
            c.setDebug(this.info.getDebug());
            c.setEncode(this.info.getEncode(prop.get("source.encoding")));
            c.setTarget(this.info.getTarget(prop.get("javac.target")));
            String mainClass = prop.get("main.class");
            boolean bl = hasMainClass = mainClass != null && !mainClass.isEmpty();
            if (hasMainClass) {
                c.setMainClass(this.info.getMainClass(mainClass));
                c.setCreateBy("ModNut Compiler");
            } else {
                c.setManifestVersion("1.0");
                c.setCreateBy("ModNut Compiler");
            }
            String[] classpath = this.info.getClassPath(prop.get("javac.classpath")).split(File.pathSeparator);
            ArrayList<String> mfclasspath = new ArrayList<String>();
            File jarLibDir = new File(buildJar.getParent() + File.separator + DIR_LIB);
            for (String cp : classpath) {
                File cpFile = this.info.getClassPathFile(cp);
                if (cpFile == null) continue;
                if (cpFile.isDirectory()) {
                    c.addClassDir(cpFile);
                    continue;
                }
                c.addClassJar(cpFile);
                if (!hasMainClass) continue;
                mfclasspath.add(DIR_LIB + File.separator + cpFile.getName());
                if (!jarLibDir.exists()) {
                    jarLibDir.mkdirs();
                }
                ToolFile.copyFile(cpFile, new File(jarLibDir.getAbsolutePath() + File.separator + cpFile.getName()));
            }
            if (hasMainClass && mfclasspath.size() > 0) {
                c.setClassPath(mfclasspath);
            }
            c.compile(in, out, err, buildJar);
            return buildJar;
        }
        catch (IOException ex) {
            Logger.getLogger(CompilerNetbeans.class.getName()).log(Level.SEVERE, null, ex);
            throw new CompilerException("io exception");
        }
    }

    public File compileWeb(InputStream in, OutputStream out, OutputStream err, NetbeansProp prop) throws CompilerException {
        try {
            File cpFile;
            File webDir = this.info.getProjectFile(prop.get("web.docbase.dir"));
            File webCopyDir = new File(this.info.getTempDir().getAbsolutePath() + File.separator + DIR_WEB);
            File sourceDir = this.info.getProjectFile(prop.get("src.dir"));
            File sourceCopyDir = new File(webCopyDir.getAbsolutePath() + File.separator + DIR_WEBINF + File.separator + DIR_CLASSES);
            File buildWar = this.info.getBuildFile(prop.get("dist.war"));
            ToolFile.copyFile(webDir, webCopyDir);
            ToolFile.copyFile(sourceDir, sourceCopyDir);
            this.info.preSolve();
            CompilerProject c = new CompilerProject(sourceCopyDir, webCopyDir);
            c.setDebug(this.info.getDebug());
            c.setEncode(this.info.getEncode(prop.get("source.encoding")));
            c.setSource(this.info.getTarget(prop.get("javac.source")));
            c.setTarget(this.info.getTarget(prop.get("javac.target")));
            String[] classpath = this.info.getClassPath(prop.get("javac.classpath")).split(File.pathSeparator);
            String[] j2eeclasspath = this.info.getClassPath(prop.get("j2ee.platform.classpath")).split(File.pathSeparator);
            File warLibDir = new File(webCopyDir.getAbsolutePath() + File.separator + DIR_WEBINF + File.separator + DIR_LIB);
            for (String cp : classpath) {
                cpFile = this.info.getClassPathFile(cp);
                if (cpFile == null) continue;
                if (cpFile.isDirectory()) {
                    c.addClassDir(cpFile);
                    continue;
                }
                c.addClassJar(cpFile);
                if (!warLibDir.exists()) {
                    warLibDir.mkdirs();
                }
                ToolFile.copyFile(cpFile, new File(warLibDir.getAbsolutePath() + File.separator + cpFile.getName()));
            }
            for (String cp : j2eeclasspath) {
                cpFile = this.info.getClassPathFile(cp);
                if (cpFile == null) continue;
                if (cpFile.isDirectory()) {
                    c.addClassDir(cpFile);
                    continue;
                }
                c.addClassJar(cpFile);
            }
            c.compile(in, out, err, buildWar);
            return buildWar;
        }
        catch (IOException ex) {
            Logger.getLogger(CompilerNetbeans.class.getName()).log(Level.SEVERE, null, ex);
            throw new CompilerException("io exception");
        }
    }

    public static class NetbeansProp {
        public String type = null;
        public String name = null;
        public String source = null;
        public String test = null;
        public final Properties data = new Properties();

        public Set<String> names() {
            return this.data.stringPropertyNames();
        }

        public void set(String name, String value) {
            this.data.put(name, value);
        }

        public String get(String name) {
            int start;
            String originValue = this.data.getProperty(name);
            if (originValue == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            int index = 0;
            while ((start = originValue.indexOf("${", index)) >= 0) {
                int end = originValue.indexOf("}", start);
                if (index < start) {
                    sb.append(originValue.substring(index, start));
                }
                String subname = originValue.substring(start + 2, end);
                sb.append(this.get(subname));
                index = end + 1;
            }
            if (index < originValue.length()) {
                sb.append(originValue.substring(index));
            }
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static NetbeansProp create(File prop1, File prop2, File xml) throws IOException {
            FileInputStream in;
            NetbeansProp prop = new NetbeansProp();
            if (prop1 != null && prop1.exists()) {
                in = new FileInputStream(prop1);
                try {
                    prop.data.load(in);
                }
                finally {
                    in.close();
                }
            }
            if (prop2 != null && prop2.exists()) {
                in = new FileInputStream(prop2);
                try {
                    prop.data.load(in);
                }
                finally {
                    in.close();
                }
            }
            if (xml != null) {
                try {
                    DomParser dom = DomParser.create(xml);
                    prop.type = dom.document.search("project type").get(0).inner();
                    prop.name = dom.document.search("project configuration data name").get(0).inner();
                    DomParser.NodeElement sourceNode = dom.document.search("project configuration data source-roots root").get(0);
                    prop.source = prop.get(sourceNode.getAttrValue("id"));
                    DomParser.NodeElement testNode = dom.document.search("project configuration data test-roots root").get(0);
                    prop.test = prop.get(testNode.getAttrValue("id"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return prop;
        }
    }

    public static class TYPE {
        public static final String J2SE = "org.netbeans.modules.java.j2seproject";
        public static final String WEB = "org.netbeans.modules.web.project";
    }

    public static abstract class Info {
        public abstract File getProjectDir();

        public abstract File getTempDir();

        public void preSolve() {
        }

        public File searchClassPathFile(File file) {
            return null;
        }

        public File getClassPathFile(String classpath) {
            File file = new File(classpath);
            if (!file.isAbsolute()) {
                file = new File(this.getProjectDir().getAbsolutePath() + File.separator + file.getPath());
            }
            return file.exists() ? file : this.searchClassPathFile(file);
        }

        public ArrayList<String> addClassPathFiles() {
            return null;
        }

        public File getProjectFile(String refPath) {
            return new File(this.getProjectDir().getAbsolutePath() + File.separator + refPath);
        }

        public File getBuildFile(String projectValue) {
            return new File(this.getTempDir().getAbsolutePath() + File.separator + new File(projectValue).getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Manifest getProjectManifest(String refPath) throws IOException {
            File file = new File(refPath);
            if (file.exists()) {
                FileInputStream in = new FileInputStream(file);
                try {
                    Manifest manifest = new Manifest(in);
                    return manifest;
                }
                finally {
                    in.close();
                }
            }
            return new Manifest();
        }

        public String getMainClass(String projectValue) {
            return projectValue;
        }

        public String getEncode(String projectValue) {
            return projectValue;
        }

        public String getTarget(String projectValue) {
            return projectValue;
        }

        public String getClassPath(String projectValue) {
            return projectValue;
        }

        public int getDebug() {
            return 0;
        }
    }
}

