/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.platform2.logic;

import com.modnut.framework2.ajax.AjaxCmdBase;
import com.modnut.framework2.database.DBCreator;
import com.modnut.framework2.database.DBException;
import com.modnut.framework2.database.DBHelper;
import com.modnut.framework2.database.DBResult;
import com.modnut.framework2.database.DBStat;
import com.modnut.framework2.json.JSONArray;
import com.modnut.framework2.json.JSONObject;
import com.modnut.framework2.tool.ToolStr;
import com.modnut.platform2.PlatformApp;
import com.modnut.platform2.dom.DomList;
import com.modnut.platform2.logic.LogicCommon;
import java.util.ArrayList;

public class LogicList {
    public static final String PARAM_PAGE = "page";
    public static final String PARAM_LAST = "last";
    public static final String RTN_PACK_LIST = "list";
    public static final String RTN_PACK_PAGE = "page";
    public static final String RTN_PACK_TOTAL = "total";
    public static final String RTN_PACK_COUNT = "count";
    public static final String RTN_PACK_MORE = "more";
    public static final int DEFAULT_PAGE = 0;
    public static final int DEFAULT_SIZE = 10;

    public static long getCount(DBStat stat, ListInfo info) throws DBException {
        return DBHelper.count((DBStat)stat, (String)info.tbName, (String)info.whereStr);
    }

    public static JSONArray solveRs(DBResult rs, DBCreator.DBColumn[] columns, String[] labels, int max) throws DBException {
        JSONArray list = new JSONArray();
        for (int count = 0; (max <= 0 || count < max) && rs.next(); ++count) {
            if (labels != null) {
                JSONObject obj = new JSONObject();
                for (int i = 0; i < columns.length && i < labels.length; ++i) {
                    obj.put(labels[i], LogicCommon.getRsObject(rs, columns[i]));
                }
                list.put(obj);
                continue;
            }
            JSONArray arr = new JSONArray();
            for (DBCreator.DBColumn column : columns) {
                arr.put(LogicCommon.getRsObject(rs, column));
            }
            list.put(arr);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ListAll getAll(DBStat stat, ListInfo info) throws DBException {
        DBResult rs = DBHelper.query((DBStat)stat, (String)info.tbName, (String[])info.colNames, (String)info.whereStr, null, (String)info.orderStr);
        try {
            JSONArray list = LogicList.solveRs(rs, info.columns, info.labels, 0);
            ListAll listAll = new ListAll(list);
            return listAll;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ListPage getPage(DBStat stat, ListInfo info, int page) throws DBException {
        long count = LogicList.getCount(stat, info);
        int pageMax = DomList.getPageMax(count, info.pageSize);
        int pageCur = DomList.getPageCur(page, pageMax);
        DBResult rs = DBHelper.pageQuery((DBStat)stat, (String)info.tbName, (String[])info.colNames, (String)info.whereStr, null, (String)info.orderStr, (String)info.primaryCol, (int)pageCur, (int)info.pageSize);
        try {
            JSONArray list = LogicList.solveRs(rs, info.columns, info.labels, 0);
            ListPage listPage = new ListPage(list, pageCur, pageMax, count);
            return listPage;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ListMore getMore(DBStat stat, ListInfo info, String last, boolean desc) throws DBException {
        String whereStr = info.whereStr;
        if (last != null) {
            whereStr = info.primaryCol + (desc ? "<=" : ">=") + DBHelper.formatSqlStr((DBStat)stat, (String)last) + DBHelper.andWhereStr((DBStat)stat, (String)whereStr);
        }
        DBResult rs = DBHelper.pageQuery((DBStat)stat, (String)info.tbName, (String[])info.colNames, (String)whereStr, null, (String)info.orderStr, (String)info.primaryCol, (int)0, (int)(info.pageSize + 1));
        try {
            JSONArray list = LogicList.solveRs(rs, info.columns, info.labels, info.pageSize);
            String more = null;
            if (rs.next()) {
                more = rs.getString(info.primaryCol);
            }
            ListMore listMore = new ListMore(list, more);
            return listMore;
        }
        finally {
            rs.close();
        }
    }

    public static void putAll(AjaxCmdBase ajax, DBStat stat, ListInfo info) throws DBException {
        LogicList.putAll(ajax, stat, info, null);
    }

    public static void putAll(AjaxCmdBase ajax, DBStat stat, ListInfo info, String name) throws DBException {
        ListAll list = LogicList.getAll(stat, info);
        ajax.put(name == null ? RTN_PACK_LIST : name, list.list);
    }

    public static void putPage(AjaxCmdBase ajax, DBStat stat, ListInfo info) throws DBException {
        LogicList.putPage(ajax, stat, info, null);
    }

    public static void putPage(AjaxCmdBase ajax, DBStat stat, ListInfo info, String name) throws DBException {
        int page = ajax.getRes().getParam("page", 0);
        ListPage list = LogicList.getPage(stat, info, page);
        ajax.put(name == null ? RTN_PACK_LIST : name, list.list);
        ajax.put("page", list.page);
        ajax.put(RTN_PACK_TOTAL, list.total);
        ajax.put(RTN_PACK_COUNT, list.count);
    }

    public static void putMore(AjaxCmdBase ajax, DBStat stat, ListInfo info, boolean desc) throws DBException {
        LogicList.putMore(ajax, stat, info, desc, null);
    }

    public static void putMore(AjaxCmdBase ajax, DBStat stat, ListInfo info, boolean desc, String name) throws DBException {
        String last = ToolStr.emptyToNull((String)ajax.getRes().getParam(PARAM_LAST), (boolean)true);
        ListMore list = LogicList.getMore(stat, info, last, desc);
        ajax.put(name == null ? RTN_PACK_LIST : name, list.list);
        ajax.put(RTN_PACK_MORE, list.more);
    }

    public static class ListMore {
        public JSONArray list;
        public String more;

        public ListMore(JSONArray list, String more) {
            this.list = list;
            this.more = more;
        }
    }

    public static class ListPage {
        public JSONArray list;
        public int page;
        public int total;
        public long count;

        public ListPage(JSONArray list, int page, int total, long count) {
            this.list = list;
            this.page = page;
            this.total = total;
            this.count = count;
        }
    }

    public static class ListAll {
        public JSONArray list;

        public ListAll(JSONArray list) {
            this.list = list;
        }
    }

    public static class ListInfo {
        public String tbName = null;
        public DBCreator.DBColumn[] columns = null;
        public String[] labels = null;
        public String[] colNames = null;
        public String whereStr = null;
        public String orderStr = null;
        public String primaryCol = null;
        public int pageSize = 10;
    }

    public static class ListEngine {
        protected final String[] colNames;
        protected final String tbName;
        protected final DBCreator.DBColumn[] columns;
        protected final String pkColumn;

        public ListEngine(DBCreator.DBTable table, String[] colNames) {
            this.colNames = colNames;
            this.tbName = table.name;
            this.columns = LogicCommon.getTableColumns(table, colNames);
            this.pkColumn = table.pkColNames != null && !table.pkColNames.isEmpty() ? (String)table.pkColNames.get(0) : null;
        }

        public ListInfo buildInfo(String whereStr, String orderStr) {
            return this.buildInfo(whereStr, orderStr, null, 10);
        }

        public ListInfo buildInfo(String whereStr, String orderStr, String[] labels) {
            return this.buildInfo(whereStr, orderStr, labels, 10);
        }

        public ListInfo buildInfo(String whereStr, String orderStr, int pageSize) {
            return this.buildInfo(whereStr, orderStr, null, pageSize);
        }

        public ListInfo buildInfo(String whereStr, String orderStr, String[] labels, int pageSize) {
            ListInfo listInfo = new ListInfo();
            listInfo.tbName = this.tbName;
            listInfo.colNames = this.colNames;
            listInfo.columns = this.columns;
            listInfo.whereStr = whereStr;
            listInfo.orderStr = orderStr;
            listInfo.primaryCol = this.pkColumn;
            listInfo.labels = labels;
            listInfo.pageSize = pageSize;
            return listInfo;
        }

        public static ListEngine get(String tbName, String[] colNames) {
            ArrayList<PlatformApp.AppObj> apps = PlatformApp.getAppList();
            for (PlatformApp.AppObj app : apps) {
                ListEngine engine = ListEngine.get(app, tbName, colNames);
                if (engine == null) continue;
                return engine;
            }
            return null;
        }

        public static ListEngine get(PlatformApp.AppObj app, String tbName, String[] colNames) {
            DBCreator.DBTable[] tables = app.getAppTables();
            if (tables != null) {
                for (DBCreator.DBTable table : tables) {
                    if (!ToolStr.equals((String)tbName, (String)table.name)) continue;
                    return new ListEngine(table, colNames);
                }
            }
            return null;
        }
    }
}

