/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.platform2.logic;

import com.modnut.framework2.database.DBCreator;
import com.modnut.framework2.database.DBException;
import com.modnut.framework2.database.DBResult;
import com.modnut.framework2.database.DBValPair;
import com.modnut.framework2.resource.ResServlet;
import com.modnut.framework2.tool.ToolDate;
import com.modnut.framework2.tool.ToolStr;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;

public class LogicCommon {
    public static DBCreator.DBColumn[] getTableColumns(DBCreator.DBTable table, String[] colNames) {
        ArrayList<DBCreator.DBColumn> columns = new ArrayList<DBCreator.DBColumn>();
        block0: for (String colName : colNames) {
            for (DBCreator.DBColumn column : table.columns) {
                if (!ToolStr.equals((String)colName, (String)column.name, (boolean)true)) continue;
                columns.add(column);
                continue block0;
            }
        }
        return columns.toArray(new DBCreator.DBColumn[columns.size()]);
    }

    public static Object getRsObject(DBResult rs, DBCreator.DBColumn column) throws DBException {
        if (column.type instanceof DBCreator.DBColumn.Text) {
            return rs.getString(column.name);
        }
        if (column.type instanceof DBCreator.DBColumn.DateTime) {
            return ToolDate.toTs((Timestamp)rs.getTimestamp(column.name));
        }
        if (column.type instanceof DBCreator.DBColumn.Numeric.BIGINT) {
            return rs.getLong(column.name);
        }
        if (column.type instanceof DBCreator.DBColumn.Numeric.INT || column.type instanceof DBCreator.DBColumn.Numeric.INTEGER || column.type instanceof DBCreator.DBColumn.Numeric.MEDIUMINT) {
            return rs.getInt(column.name);
        }
        if (column.type instanceof DBCreator.DBColumn.Numeric.SMALLINT || column.type instanceof DBCreator.DBColumn.Numeric.TINYINT) {
            return rs.getShort(column.name);
        }
        if (column.type instanceof DBCreator.DBColumn.Numeric.BIT) {
            return rs.getBoolean(column.name);
        }
        if (column.type instanceof DBCreator.DBColumn.Numeric.DECIMAL || column.type instanceof DBCreator.DBColumn.Numeric.DEC || column.type instanceof DBCreator.DBColumn.Numeric.DOUBLE || column.type instanceof DBCreator.DBColumn.Numeric.DOUBLE_PRECISION || column.type instanceof DBCreator.DBColumn.Numeric.FIXED || column.type instanceof DBCreator.DBColumn.Numeric.NUMERIC || column.type instanceof DBCreator.DBColumn.Numeric.REAL) {
            return rs.getDouble(column.name);
        }
        if (column.type instanceof DBCreator.DBColumn.Numeric.FLOAT) {
            return Float.valueOf(rs.getFloat(column.name));
        }
        return null;
    }

    public static Object getPairValue(ResServlet res, String param, DBCreator.DBColumn column) {
        if (column.type instanceof DBCreator.DBColumn.Text) {
            return ToolStr.emptyToNull((String)res.getParam(param), (boolean)true);
        }
        if (column.type instanceof DBCreator.DBColumn.DateTime) {
            long ts = ToolDate.parseParam((String)res.getParam(param), (boolean)true);
            return ts == 0L ? DBValPair.NULL.DATE : ToolDate.toDate((long)ts);
        }
        if (column.type instanceof DBCreator.DBColumn.Numeric.BIGINT) {
            return res.getParam(param, 0L);
        }
        if (column.type instanceof DBCreator.DBColumn.Numeric.INT || column.type instanceof DBCreator.DBColumn.Numeric.INTEGER || column.type instanceof DBCreator.DBColumn.Numeric.MEDIUMINT) {
            return res.getParam(param, 0);
        }
        if (column.type instanceof DBCreator.DBColumn.Numeric.SMALLINT || column.type instanceof DBCreator.DBColumn.Numeric.TINYINT) {
            return res.getParam(param, (short)0);
        }
        if (column.type instanceof DBCreator.DBColumn.Numeric.BIT) {
            return res.getParam(param, false);
        }
        if (column.type instanceof DBCreator.DBColumn.Numeric.DECIMAL || column.type instanceof DBCreator.DBColumn.Numeric.DEC || column.type instanceof DBCreator.DBColumn.Numeric.DOUBLE || column.type instanceof DBCreator.DBColumn.Numeric.DOUBLE_PRECISION || column.type instanceof DBCreator.DBColumn.Numeric.FIXED || column.type instanceof DBCreator.DBColumn.Numeric.NUMERIC || column.type instanceof DBCreator.DBColumn.Numeric.REAL) {
            return res.getParam(param, 0.0);
        }
        if (column.type instanceof DBCreator.DBColumn.Numeric.FLOAT) {
            return Float.valueOf(res.getParam(param, 0.0f));
        }
        return null;
    }

    public static Object getAjaxValue(DBValPair value) {
        Object colValue = value.getColValue();
        if (colValue != null) {
            if (colValue instanceof String) {
                return (String)colValue;
            }
            if (colValue instanceof Boolean) {
                return (Boolean)colValue;
            }
            if (colValue instanceof Byte) {
                return ((Byte)colValue).shortValue();
            }
            if (colValue instanceof Character) {
                return ((Character)colValue).toString();
            }
            if (colValue instanceof Short) {
                return (Short)colValue;
            }
            if (colValue instanceof Integer) {
                return (Integer)colValue;
            }
            if (colValue instanceof Long) {
                return (Long)colValue;
            }
            if (colValue instanceof Float) {
                return (Float)colValue;
            }
            if (colValue instanceof Double) {
                return (Double)colValue;
            }
            if (colValue instanceof Date) {
                return ((Date)colValue).getTime();
            }
            if (colValue instanceof Time) {
                return ((Time)colValue).getTime();
            }
            if (colValue instanceof Timestamp) {
                return ((Timestamp)colValue).getTime();
            }
            if (colValue instanceof java.util.Date) {
                return ((java.util.Date)colValue).getTime();
            }
        }
        return null;
    }
}

