/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.platform2.dom;

import com.modnut.framework2.database.DBException;
import com.modnut.framework2.database.DBResult;
import com.modnut.platform2.dom.DomHelper;
import com.modnut.platform2.resource.ResPlatform;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DomList {
    protected final int pageCur;
    protected final int pageSize;
    public static final int PAGE_START = 0;

    public DomList(int pageCur, int pageSize) {
        this.pageCur = pageCur;
        this.pageSize = pageSize;
    }

    protected abstract long getCount(ResPlatform var1) throws DBException;

    protected abstract DBResult getResultSet(ResPlatform var1) throws DBException;

    protected void startList(ResPlatform res) throws DBException {
    }

    protected abstract void solveItem(ResPlatform var1, DBResult var2) throws DBException;

    protected abstract String endList(ResPlatform var1, int var2, int var3, long var4) throws DBException;

    protected String getDatabaseErrorDom(ResPlatform res) {
        return DomHelper.conCenter(res.getLangStr("TEXT_DATABASE_ERROR"));
    }

    protected String getListEmptyDom(ResPlatform res) {
        return DomHelper.conCenter(res.getLangStr("TEXT_LIST_EMPTY"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDom(ResPlatform res) {
        String string;
        long count = this.getCount(res);
        if (count <= 0L) return this.getListEmptyDom(res);
        int max = DomList.getPageMax(count, this.pageSize);
        int cur = DomList.getPageCur(this.pageCur, max);
        DBResult rs = this.getResultSet(res);
        try {
            this.startList(res);
            while (rs.next()) {
                this.solveItem(res, rs);
            }
            string = this.endList(res, cur, max, count);
        }
        catch (Throwable throwable) {
            try {
                rs.close();
                throw throwable;
            }
            catch (DBException ex) {
                Logger.getLogger(DomList.class.getName()).log(Level.SEVERE, null, ex);
                return this.getDatabaseErrorDom(res);
            }
        }
        rs.close();
        return string;
    }

    public static int getPageMax(long count, int pageSize) {
        return count > 0L ? (int)((count - 1L) / (long)pageSize) : 0;
    }

    public static int getPageCur(int page, int pageMax) {
        return page < 0 ? 0 : (page > pageMax ? pageMax : page);
    }
}

