/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.platform2.cache;

import com.modnut.framework2.cache.CacheMemBase;
import com.modnut.framework2.database.DBHelper;
import com.modnut.framework2.database.DBResult;
import com.modnut.framework2.database.DBStat;
import com.modnut.framework2.json.JSONArray;
import com.modnut.framework2.resource.ResPack;
import com.modnut.platform2.PlatformDB;
import com.modnut.platform2.PlatformUrl;

public class CacheGroup
extends CacheMemBase<GroupObj> {
    public static final CacheGroup i = new CacheGroup();
    private static final String[] COLS_CACHE = new String[]{"grp_code", "grp_name", "grp_avatar20", "grp_avatar50", "grp_avatar200", "grp_version"};

    protected String getMemName() {
        return "cache";
    }

    protected GroupObj str2obj(String str) throws Exception {
        JSONArray arr = new JSONArray(str);
        GroupObj obj = new GroupObj();
        int index = 0;
        obj.code = arr.getString(index++);
        obj.name = arr.getString(index++);
        obj.avatar20 = arr.getString(index++);
        obj.avatar50 = arr.getString(index++);
        obj.avatar200 = arr.getString(index++);
        obj.version = arr.getLong(index++);
        return obj;
    }

    protected String obj2str(GroupObj obj) throws Exception {
        JSONArray arr = new JSONArray();
        arr.put(obj.code);
        arr.put(obj.name);
        arr.put(obj.avatar20);
        arr.put(obj.avatar50);
        arr.put(obj.avatar200);
        arr.put(obj.version);
        return arr.toJsonString();
    }

    protected int getCacheTime() {
        return 86400;
    }

    protected GroupObj getNone() {
        return new GroupObj();
    }

    protected String getCacheKey(String key) {
        return "g|" + key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GroupObj fromDB(ResPack res, String key) throws Exception {
        DBStat stat = res.getDBStat(PlatformDB.NAME);
        String whereStr = "grp_code=" + DBHelper.formatSqlStr((DBStat)stat, (String)key);
        DBResult rs = DBHelper.query((DBStat)stat, (String)"platform_group", (String[])COLS_CACHE, (String)whereStr, null, null);
        try {
            if (rs.next()) {
                GroupObj obj = new GroupObj();
                obj.code = rs.getString("grp_code");
                obj.name = rs.getString("grp_name");
                obj.avatar20 = rs.getString("grp_avatar20");
                obj.avatar50 = rs.getString("grp_avatar50");
                obj.avatar200 = rs.getString("grp_avatar200");
                obj.version = rs.getLong("grp_version");
                GroupObj groupObj = obj;
                return groupObj;
            }
            GroupObj groupObj = null;
            return groupObj;
        }
        finally {
            rs.close();
        }
    }

    public static class GroupObj {
        public String code;
        public String name;
        public String avatar20;
        public String avatar50;
        public String avatar200;
        public long version;

        public String getAvatar20Url() {
            String avatar = this.avatar20 == null ? null : this.avatar20 + "?" + this.version;
            return PlatformUrl.i.convert(avatar, PlatformUrl.i.getImgGroup20());
        }

        public String getAvatar50Url() {
            String avatar = this.avatar50 == null ? null : this.avatar50 + "?" + this.version;
            return PlatformUrl.i.convert(avatar, PlatformUrl.i.getImgGroup50());
        }

        public String getAvatar200Url() {
            String avatar = this.avatar200 == null ? null : this.avatar200 + "?" + this.version;
            return PlatformUrl.i.convert(avatar, PlatformUrl.i.getImgGroup200());
        }
    }
}

