/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.platform2.ajax;

import com.modnut.framework2.ajax.AjaxCmdBasicBase;
import com.modnut.framework2.resource.ResPack;
import com.modnut.framework2.tool.ToolStr;
import com.modnut.platform2.PlatformUser;
import com.modnut.platform2.ajax.AjaxCmdUserException;
import com.modnut.platform2.daemon.DaemonCheckBase;
import com.modnut.platform2.logic.LogicRemote;
import com.modnut.platform2.resource.ResPlatform;

public abstract class AjaxCmdUserBase<RC extends ResPlatform>
extends AjaxCmdBasicBase<RC> {
    private static final String PARAM_RACCOUNT = "raccount";
    private static final String PARAM_RPASSWORD = "rpassword";
    private static final String PARAM_RTIMESTAMP = "rtimestamp";
    private static final String PARAM_RSIGN = "rsign";
    private boolean remoteVerifyFailed = false;

    public RC getRes() {
        return (RC)((Object)((ResPlatform)super.getRes()));
    }

    public void doInit() throws AjaxCmdUserException {
        if (this.getAllowRemote()) {
            String account = ToolStr.emptyToNull((String)this.getRes().getParam(PARAM_RACCOUNT), (boolean)true);
            String password = ToolStr.emptyToNull((String)this.getRes().getParam(PARAM_RPASSWORD), (boolean)true);
            long timestamp = this.getRes().getParam(PARAM_RTIMESTAMP, 0L);
            String sign = ToolStr.emptyToNull((String)this.getRes().getParam(PARAM_RSIGN), (boolean)true);
            if (account != null && sign != null) {
                if (LogicRemote.allowTimestamp(timestamp)) {
                    String passwordHash = PlatformUser.getPasswordHash((ResPack)this.getRes(), account);
                    if (LogicRemote.genSign(account, passwordHash, timestamp).equals(sign)) {
                        this.getRes().setUser(account);
                    } else {
                        this.remoteVerifyFailed = true;
                    }
                } else {
                    this.remoteVerifyFailed = true;
                }
            } else if (account != null && password != null) {
                if (PlatformUser.verifyUser((ResPack)this.getRes(), account, password, true)) {
                    this.getRes().setUser(account);
                } else {
                    this.remoteVerifyFailed = true;
                }
            }
        }
    }

    protected void doCheck() throws AjaxCmdUserException {
        String error;
        if (this.getAllowRemote() && this.remoteVerifyFailed) {
            throw new AjaxCmdUserException(-1, this.getRes().getLangStr("TEXT_WRONG_REMOTE"));
        }
        if (this.getNeedLogin() && !this.getRes().hasLogined()) {
            throw new AjaxCmdUserException(-1, this.getRes().getLangStr("TEXT_NEED_LOGIN"));
        }
        String needAuth = this.getNeedAuth();
        if (needAuth != null && !this.getRes().hasAuth(needAuth)) {
            throw new AjaxCmdUserException(-1, this.getRes().getLangStr("TEXT_NO_AUTH"));
        }
        DaemonCheckBase daemonCheck = this.getDaemonCheck();
        if (daemonCheck != null && (error = daemonCheck.getResult((ResPlatform)this.getRes())) != null) {
            String textProgramLock = this.getRes().getLangStr("TEXT_PROGRAM_LOCK");
            throw new AjaxCmdUserException(-1, textProgramLock + this.getRes().getLangStr("COMMON_COMMA") + error);
        }
    }

    protected abstract void doSolve() throws AjaxCmdUserException;

    public void doDispose() throws AjaxCmdUserException {
    }

    protected boolean getAllowRemote() {
        return false;
    }

    protected boolean getNeedLogin() {
        return true;
    }

    protected String getNeedAuth() {
        return null;
    }

    protected DaemonCheckBase getDaemonCheck() {
        return null;
    }

    protected static void checkLength(ResPlatform res, String paramName, String paramText, boolean allowNull, int maxLength) throws AjaxCmdUserException {
        String paramValue = ToolStr.emptyToNull((String)res.getParam(paramName), (boolean)true);
        if (paramValue == null && !allowNull) {
            throw new AjaxCmdUserException(-1, paramText + " " + res.getLangStr("CHECK_NULL"));
        }
        if (paramValue != null && paramValue.length() > maxLength) {
            throw new AjaxCmdUserException(-1, paramText + " " + res.getLangStr("CHECK_FULL1") + " " + maxLength + " " + res.getLangStr("CHECK_FULL2"));
        }
    }

    protected static void checkRange(ResPlatform res, String paramName, String paramText, Short max, Short min) throws AjaxCmdUserException {
        short paramValue = res.getParam(paramName, (short)0);
        if (max != null && paramValue > max) {
            throw new AjaxCmdUserException(-1, paramText + " " + res.getLangStr("CHECK_MAX1") + " " + max + " " + res.getLangStr("CHECK_MAX2"));
        }
        if (min != null && paramValue < min) {
            throw new AjaxCmdUserException(-1, paramText + " " + res.getLangStr("CHECK_MIN1") + " " + min + " " + res.getLangStr("CHECK_MIN2"));
        }
    }

    protected static void checkRange(ResPlatform res, String paramName, String paramText, Integer max, Integer min) throws AjaxCmdUserException {
        int paramValue = res.getParam(paramName, 0);
        if (max != null && paramValue > max) {
            throw new AjaxCmdUserException(-1, paramText + " " + res.getLangStr("CHECK_MAX1") + " " + max + " " + res.getLangStr("CHECK_MAX2"));
        }
        if (min != null && paramValue < min) {
            throw new AjaxCmdUserException(-1, paramText + " " + res.getLangStr("CHECK_MIN1") + " " + min + " " + res.getLangStr("CHECK_MIN2"));
        }
    }

    protected static void checkRange(ResPlatform res, String paramName, String paramText, Long max, Long min) throws AjaxCmdUserException {
        long paramValue = res.getParam(paramName, 0L);
        if (max != null && paramValue > max) {
            throw new AjaxCmdUserException(-1, paramText + " " + res.getLangStr("CHECK_MAX1") + " " + max + " " + res.getLangStr("CHECK_MAX2"));
        }
        if (min != null && paramValue < min) {
            throw new AjaxCmdUserException(-1, paramText + " " + res.getLangStr("CHECK_MIN1") + " " + min + " " + res.getLangStr("CHECK_MIN2"));
        }
    }

    protected static void checkRange(ResPlatform res, String paramName, String paramText, Double max, Double min) throws AjaxCmdUserException {
        double paramValue = res.getParam(paramName, 0.0);
        if (max != null && paramValue > max) {
            throw new AjaxCmdUserException(-1, paramText + " " + res.getLangStr("CHECK_MAX1") + " " + ToolStr.formatDouble((double)max) + " " + res.getLangStr("CHECK_MAX2"));
        }
        if (min != null && paramValue < min) {
            throw new AjaxCmdUserException(-1, paramText + " " + res.getLangStr("CHECK_MIN1") + " " + ToolStr.formatDouble((double)min) + " " + res.getLangStr("CHECK_MIN2"));
        }
    }

    protected static void checkRange(ResPlatform res, String paramName, String paramText, Float max, Float min) throws AjaxCmdUserException {
        float paramValue = res.getParam(paramName, 0.0f);
        if (max != null && paramValue > max.floatValue()) {
            throw new AjaxCmdUserException(-1, paramText + " " + res.getLangStr("CHECK_MAX1") + " " + ToolStr.formatDouble((double)max.floatValue()) + " " + res.getLangStr("CHECK_MAX2"));
        }
        if (min != null && paramValue < min.floatValue()) {
            throw new AjaxCmdUserException(-1, paramText + " " + res.getLangStr("CHECK_MIN1") + " " + ToolStr.formatDouble((double)min.floatValue()) + " " + res.getLangStr("CHECK_MIN2"));
        }
    }
}

