/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.axml;

import com.googlecode.dex2jar.reader.io.DataIn;
import com.googlecode.dex2jar.reader.io.DataOut;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import pxb.android.axml.StringItem;

class StringItems
extends ArrayList<StringItem> {
    byte[] stringData;

    StringItems() {
    }

    public int getSize() {
        return 20 + this.size() * 4 + this.stringData.length + 0;
    }

    public void prepare() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        int offset = 0;
        baos.reset();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (StringItem item : this) {
            item.index = i++;
            String stringData = item.data;
            Integer of = (Integer)map.get(stringData);
            if (of != null) {
                item.dataOffset = of;
                continue;
            }
            item.dataOffset = offset;
            map.put(stringData, offset);
            int length = stringData.length();
            byte[] data = stringData.getBytes("UTF-16LE");
            baos.write(length);
            baos.write(length >> 8);
            baos.write(data);
            baos.write(0);
            baos.write(0);
            offset += 4 + data.length;
        }
        this.stringData = baos.toByteArray();
    }

    public void read(DataIn in, int size) throws IOException {
        String value;
        int length;
        int p;
        int trunkOffset = in.getCurrentPosition() - 4;
        int stringCount = in.readIntx();
        int styleOffsetCount = in.readIntx();
        int flags = in.readIntx();
        int stringDataOffset = in.readIntx();
        int stylesOffset = in.readIntx();
        int i = 0;
        while (i < stringCount) {
            StringItem stringItem = new StringItem();
            stringItem.index = i++;
            stringItem.dataOffset = in.readIntx();
            this.add(stringItem);
        }
        TreeMap<Integer, String> stringMap = new TreeMap<Integer, String>();
        if (styleOffsetCount != 0) {
            throw new RuntimeException();
        }
        int endOfStringData = stylesOffset == 0 ? size : stylesOffset;
        int base = in.getCurrentPosition();
        if (0 != (flags & 0x100)) {
            p = base;
            while (p < endOfStringData) {
                length = (int)in.readLeb128();
                ByteArrayOutputStream bos = new ByteArrayOutputStream(length + 10);
                int r = in.readByte();
                while (r != 0) {
                    bos.write(r);
                    r = in.readByte();
                }
                value = new String(bos.toByteArray(), "UTF-8");
                stringMap.put(p - base, value);
                p = in.getCurrentPosition();
            }
        } else {
            p = base;
            while (p < endOfStringData) {
                length = in.readShortx();
                byte[] data = in.readBytes(length * 2);
                in.skip(2);
                value = new String(data, "UTF-16LE");
                stringMap.put(p - base, value);
                p = in.getCurrentPosition();
            }
        }
        if (stylesOffset != 0) {
            throw new RuntimeException();
        }
        for (StringItem item : this) {
            item.data = (String)stringMap.get(item.dataOffset);
        }
    }

    public void write(DataOut out) throws IOException {
        out.writeInt(this.size());
        out.writeInt(0);
        out.writeInt(0);
        out.writeInt(28 + this.size() * 4);
        out.writeInt(0);
        for (StringItem item : this) {
            out.writeInt(item.dataOffset);
        }
        out.writeBytes(this.stringData);
    }
}

