/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.axml;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import pxb.android.axml.AxmlVisitor;
import pxb.android.axml.NodeVisitor;

public class DumpAdapter
extends AxmlVisitor {
    private Map<String, String> nses = new HashMap<String, String>();
    private PrintWriter writer = null;

    public DumpAdapter() {
        this.setupWriter(null);
    }

    public DumpAdapter(Writer w) {
        this.setupWriter(w);
    }

    public DumpAdapter(Writer w, AxmlVisitor av) {
        super(av);
        this.setupWriter(w);
    }

    private void setupWriter(Writer w) {
        this.writer = w == null ? new PrintWriter(System.out, true) : new PrintWriter(w);
    }

    @Override
    public void visitBegin() {
        this.writer.println("<xml document>");
        super.visitBegin();
    }

    @Override
    public NodeVisitor visitFirst(String namespace, String name) {
        NodeVisitor nv = super.visitFirst(namespace, name);
        DumpNodeAdapter x = new DumpNodeAdapter(this.writer, nv, 1, this.nses, namespace, name);
        return x;
    }

    @Override
    public void visitNamespace(String prefix, String uri, int ln) {
        this.writer.println("xmlns:" + prefix + "=" + uri);
        this.nses.put(uri, prefix);
        super.visitNamespace(prefix, uri, ln);
    }

    @Override
    public void visitEnd() {
        this.writer.println("</xml document>");
        super.visitEnd();
    }

    public static class DumpNodeAdapter
    extends NodeVisitor {
        protected final int depth;
        protected Map<String, String> nses;
        protected String namespace;
        protected String name;
        protected PrintWriter writer;

        public DumpNodeAdapter(PrintWriter w, NodeVisitor nv, String namespace, String name) {
            super(nv);
            this.depth = 0;
            this.nses = null;
            this.namespace = namespace;
            this.name = name;
            this.writer = w;
        }

        public DumpNodeAdapter(PrintWriter w, NodeVisitor nv, int x, Map<String, String> nses, String namespace, String name) {
            super(nv);
            this.depth = x;
            this.nses = nses;
            this.namespace = namespace;
            this.name = name;
            this.writer = w;
        }

        @Override
        public void visitBegin() {
            this.indent();
            this.writer.print("<");
            if (this.namespace != null) {
                this.writer.println(this.getPrefix(this.namespace) + ":");
            }
            this.writer.print(this.name);
            super.visitBegin();
        }

        @Override
        public void visitContentAttr(String ns, String name, int resourceId, int type, Object obj) {
            this.writer.println();
            this.indentContent();
            if (ns != null) {
                this.writer.print(String.format("%s:", this.getPrefix(ns)));
            }
            this.writer.print(name);
            if (resourceId != -1) {
                this.writer.print(String.format("(%08x)", resourceId));
            }
            if (obj instanceof String) {
                this.writer.print(String.format("=[%08x]\"%s\"", type, obj));
            } else if (obj instanceof Boolean) {
                this.writer.print(String.format("=[%08x]\"%b\"", type, obj));
            } else {
                this.writer.print(String.format("=[%08x]%08x", type, obj));
            }
            super.visitContentAttr(ns, name, resourceId, type, obj);
        }

        @Override
        public void visitContentEnd() {
            this.writer.println(">");
            super.visitContentEnd();
        }

        @Override
        public NodeVisitor visitChild(String namespace, String name) {
            NodeVisitor nv = super.visitChild(namespace, name);
            return new DumpNodeAdapter(this.writer, nv, this.depth + 1, this.nses, namespace, name);
        }

        protected String getPrefix(String uri) {
            String prefix;
            if (this.nses != null && (prefix = this.nses.get(uri)) != null) {
                return prefix;
            }
            return uri;
        }

        @Override
        public void visitContentText(int ln, String value) {
            this.writer.println();
            this.indentContent();
            this.writer.print(value);
            super.visitContentText(ln, value);
        }

        @Override
        public void visitLineNumber(int n) {
            this.writer.println();
            this.indentContent();
            this.writer.print("L" + n);
            super.visitLineNumber(n);
        }

        @Override
        public void visitEnd() {
            this.indent();
            this.writer.println("</" + this.name + ">");
            super.visitEnd();
        }

        private void indent() {
            for (int i = 0; i < this.depth; ++i) {
                this.writer.print("  ");
            }
        }

        private void indentContent() {
            this.indent();
            this.writer.print("  ");
        }
    }
}

