/*
 * Decompiled with CFR 0.152.
 */
package sun.launcher;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.misc.VM;

public enum LauncherHelper {
    INSTANCE;

    private static final String MAIN_CLASS = "Main-Class";
    private static StringBuilder outBuf;
    private static final String INDENT = "    ";
    private static final String VM_SETTINGS = "VM settings:";
    private static final String PROP_SETTINGS = "Property settings:";
    private static final String LOCALE_SETTINGS = "Locale settings:";
    private static final String diagprop = "sun.java.launcher.diag";
    static final boolean trace;
    private static final String defaultBundleName = "sun.launcher.resources.launcher";
    private static PrintStream ostream;
    private static final ClassLoader scloader;
    private static Class<?> appClass;
    private static final int LM_UNKNOWN = 0;
    private static final int LM_CLASS = 1;
    private static final int LM_JAR = 2;
    private static final String encprop = "sun.jnu.encoding";
    private static String encoding;
    private static boolean isCharsetSupported;

    static void showSettings(boolean bl, String string, long l, long l2, long l3, boolean bl2) {
        String string2;
        LauncherHelper.initOutput(bl);
        String[] stringArray = string.split(":");
        switch (string2 = stringArray.length > 1 && stringArray[1] != null ? stringArray[1].trim() : "all") {
            case "vm": {
                LauncherHelper.printVmSettings(l, l2, l3, bl2);
                break;
            }
            case "properties": {
                LauncherHelper.printProperties();
                break;
            }
            case "locale": {
                LauncherHelper.printLocale();
                break;
            }
            default: {
                LauncherHelper.printVmSettings(l, l2, l3, bl2);
                LauncherHelper.printProperties();
                LauncherHelper.printLocale();
            }
        }
    }

    private static void printVmSettings(long l, long l2, long l3, boolean bl) {
        ostream.println(VM_SETTINGS);
        if (l3 != 0L) {
            ostream.println("    Stack Size: " + SizePrefix.scaleValue(l3));
        }
        if (l != 0L) {
            ostream.println("    Min. Heap Size: " + SizePrefix.scaleValue(l));
        }
        if (l2 != 0L) {
            ostream.println("    Max. Heap Size: " + SizePrefix.scaleValue(l2));
        } else {
            ostream.println("    Max. Heap Size (Estimated): " + SizePrefix.scaleValue(Runtime.getRuntime().maxMemory()));
        }
        ostream.println("    Ergonomics Machine Class: " + (bl ? "server" : "client"));
        ostream.println("    Using VM: " + System.getProperty("java.vm.name"));
        ostream.println();
    }

    private static void printProperties() {
        Properties properties = System.getProperties();
        ostream.println(PROP_SETTINGS);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(properties.stringPropertyNames());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            LauncherHelper.printPropertyValue(string, properties.getProperty(string));
        }
        ostream.println();
    }

    private static boolean isPath(String string) {
        return string.endsWith(".dirs") || string.endsWith(".path");
    }

    private static void printPropertyValue(String string, String string2) {
        ostream.print(INDENT + string + " = ");
        if (string.equals("line.separator")) {
            block4: for (byte by : string2.getBytes()) {
                switch (by) {
                    case 13: {
                        ostream.print("\\r ");
                        continue block4;
                    }
                    case 10: {
                        ostream.print("\\n ");
                        continue block4;
                    }
                    default: {
                        ostream.printf("0x%02X", by & 0xFF);
                    }
                }
            }
            ostream.println();
            return;
        }
        if (!LauncherHelper.isPath(string)) {
            ostream.println(string2);
            return;
        }
        String[] stringArray = string2.split(System.getProperty("path.separator"));
        boolean bl = true;
        for (String string3 : stringArray) {
            if (bl) {
                ostream.println(string3);
                bl = false;
                continue;
            }
            ostream.println("        " + string3);
        }
    }

    private static void printLocale() {
        Locale locale = Locale.getDefault();
        ostream.println(LOCALE_SETTINGS);
        ostream.println("    default locale = " + locale.getDisplayLanguage());
        ostream.println("    default display locale = " + Locale.getDefault(Locale.Category.DISPLAY).getDisplayName());
        ostream.println("    default format locale = " + Locale.getDefault(Locale.Category.FORMAT).getDisplayName());
        LauncherHelper.printLocales();
        ostream.println();
    }

    private static void printLocales() {
        int n;
        Locale[] localeArray = Locale.getAvailableLocales();
        int n2 = n = localeArray == null ? 0 : localeArray.length;
        if (n < 1) {
            return;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Locale object : localeArray) {
            treeSet.add(object.toString());
        }
        ostream.print("    available locales = ");
        Iterator iterator = treeSet.iterator();
        int n3 = n - 1;
        int n4 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ostream.print(string);
            if (n4 != n3) {
                ostream.print(", ");
            }
            if ((n4 + 1) % 8 == 0) {
                ostream.println();
                ostream.print("        ");
            }
            ++n4;
        }
    }

    private static String getLocalizedMessage(String string, Object ... objectArray) {
        String string2 = ResourceBundleHolder.RB.getString(string);
        return objectArray != null ? MessageFormat.format(string2, objectArray) : string2;
    }

    static void initHelpMessage(String string) {
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.header", string == null ? "java" : string));
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.datamodel", 32));
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.datamodel", 64));
    }

    static void appendVmSelectMessage(String string, String string2) {
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.vmselect", string, string2));
    }

    static void appendVmSynonymMessage(String string, String string2) {
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.hotspot", string, string2));
    }

    static void appendVmErgoMessage(boolean bl, String string) {
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.ergo.message1", string));
        outBuf = bl ? outBuf.append(",\n" + LauncherHelper.getLocalizedMessage("java.launcher.ergo.message2", new Object[0]) + "\n\n") : outBuf.append(".\n\n");
    }

    static void printHelpMessage(boolean bl) {
        LauncherHelper.initOutput(bl);
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.footer", File.pathSeparator));
        ostream.println(outBuf.toString());
    }

    static void printXUsageMessage(boolean bl) {
        LauncherHelper.initOutput(bl);
        ostream.println(LauncherHelper.getLocalizedMessage("java.launcher.X.usage", File.pathSeparator));
        if (System.getProperty("os.name").contains("OS X")) {
            ostream.println(LauncherHelper.getLocalizedMessage("java.launcher.X.macosx.usage", File.pathSeparator));
        }
    }

    static void initOutput(boolean bl) {
        ostream = bl ? System.err : System.out;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getMainClassFromJar(String string) {
        String string3 = null;
        try (JarFile jarFile = new JarFile(string);){
            Attributes attributes;
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                LauncherHelper.abort(null, "java.launcher.jar.error2", string);
            }
            if ((attributes = manifest.getMainAttributes()) == null) {
                LauncherHelper.abort(null, "java.launcher.jar.error3", string);
            }
            if ((string3 = attributes.getValue(MAIN_CLASS)) == null) {
                LauncherHelper.abort(null, "java.launcher.jar.error3", string);
            }
            if (attributes.containsKey(new Attributes.Name("JavaFX-Application-Class"))) {
                String string4 = FXHelper.class.getName();
                return string4;
            }
            String string2 = string3.trim();
            return string2;
        }
        catch (IOException iOException) {
            LauncherHelper.abort(iOException, "java.launcher.jar.error1", string);
            return null;
        }
    }

    static void abort(Throwable throwable, String string, Object ... objectArray) {
        if (string != null) {
            ostream.println(LauncherHelper.getLocalizedMessage(string, objectArray));
        }
        if (trace) {
            if (throwable != null) {
                throwable.printStackTrace();
            } else {
                Thread.dumpStack();
            }
        }
        System.exit(1);
    }

    public static Class<?> checkAndLoadMain(boolean bl, int n, String string) {
        LauncherHelper.initOutput(bl);
        String string2 = null;
        switch (n) {
            case 1: {
                string2 = string;
                break;
            }
            case 2: {
                string2 = LauncherHelper.getMainClassFromJar(string);
                break;
            }
            default: {
                throw new InternalError("" + n + ": Unknown launch mode");
            }
        }
        string2 = string2.replace('/', '.');
        Class<?> clazz = null;
        try {
            clazz = scloader.loadClass(string2);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            if (System.getProperty("os.name", "").contains("OS X") && Normalizer.isNormalized(string2, Normalizer.Form.NFD)) {
                try {
                    clazz = scloader.loadClass(Normalizer.normalize(string2, Normalizer.Form.NFC));
                }
                catch (ClassNotFoundException | NoClassDefFoundError throwable2) {
                    LauncherHelper.abort(throwable, "java.launcher.cls.error1", string2);
                }
            }
            LauncherHelper.abort(throwable, "java.launcher.cls.error1", string2);
        }
        appClass = clazz;
        if (clazz.equals(FXHelper.class) || FXHelper.doesExtendFXApplication(clazz)) {
            FXHelper.setFXLaunchParameters(string, n);
            return FXHelper.class;
        }
        LauncherHelper.validateMainClass(clazz);
        return clazz;
    }

    public static Class<?> getApplicationClass() {
        return appClass;
    }

    static void validateMainClass(Class<?> clazz) {
        Method method;
        try {
            method = clazz.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LauncherHelper.abort(null, "java.launcher.cls.error4", clazz.getName(), "javafx.application.Application");
            return;
        }
        int n = method.getModifiers();
        if (!Modifier.isStatic(n)) {
            LauncherHelper.abort(null, "java.launcher.cls.error2", "static", method.getDeclaringClass().getName());
        }
        if (method.getReturnType() != Void.TYPE) {
            LauncherHelper.abort(null, "java.launcher.cls.error3", method.getDeclaringClass().getName());
        }
    }

    static String makePlatformString(boolean bl, byte[] byArray) {
        LauncherHelper.initOutput(bl);
        if (encoding == null) {
            encoding = System.getProperty(encprop);
            isCharsetSupported = Charset.isSupported(encoding);
        }
        try {
            String string = isCharsetSupported ? new String(byArray, encoding) : new String(byArray);
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LauncherHelper.abort(unsupportedEncodingException, null, new Object[0]);
            return null;
        }
    }

    static String[] expandArgs(String[] stringArray) {
        ArrayList<StdArg> arrayList = new ArrayList<StdArg>();
        for (String string : stringArray) {
            arrayList.add(new StdArg(string));
        }
        return LauncherHelper.expandArgs(arrayList);
    }

    static String[] expandArgs(List<StdArg> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (trace) {
            System.err.println("Incoming arguments:");
        }
        for (StdArg stringArray : list) {
            if (trace) {
                System.err.println(stringArray);
            }
            if (stringArray.needsExpansion) {
                File file = new File(stringArray.arg);
                File file2 = file.getParentFile();
                String string = file.getName();
                if (file2 == null) {
                    file2 = new File(".");
                }
                try {
                    DirectoryStream<Path> exception = Files.newDirectoryStream(file2.toPath(), string);
                    Throwable throwable = null;
                    try {
                        int throwable3 = 0;
                        for (Path path : exception) {
                            arrayList.add(path.normalize().toString());
                            ++throwable3;
                        }
                        if (throwable3 != 0) continue;
                        arrayList.add(stringArray.arg);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (exception == null) continue;
                        if (throwable != null) {
                            try {
                                exception.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            continue;
                        }
                        exception.close();
                    }
                }
                catch (Exception exception) {
                    arrayList.add(stringArray.arg);
                    if (!trace) continue;
                    System.err.println("Warning: passing argument as-is " + stringArray);
                    System.err.print(exception);
                }
                continue;
            }
            arrayList.add(stringArray.arg);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        if (trace) {
            System.err.println("Expanded arguments:");
            for (String string : stringArray) {
                System.err.println(string);
            }
        }
        return stringArray;
    }

    static {
        outBuf = new StringBuilder();
        trace = VM.getSavedProperty(diagprop) != null;
        scloader = ClassLoader.getSystemClassLoader();
        encoding = null;
        isCharsetSupported = false;
    }

    static final class FXHelper {
        private static final String JAVAFX_APPLICATION_MARKER = "JavaFX-Application-Class";
        private static final String JAVAFX_APPLICATION_CLASS_NAME = "javafx.application.Application";
        private static final String JAVAFX_LAUNCHER_CLASS_NAME = "com.sun.javafx.application.LauncherImpl";
        private static final String JAVAFX_LAUNCH_MODE_CLASS = "LM_CLASS";
        private static final String JAVAFX_LAUNCH_MODE_JAR = "LM_JAR";
        private static String fxLaunchName = null;
        private static String fxLaunchMode = null;
        private static Class<?> fxLauncherClass = null;
        private static Method fxLauncherMethod = null;

        FXHelper() {
        }

        private static void setFXLaunchParameters(String string, int n) {
            try {
                fxLauncherClass = scloader.loadClass(JAVAFX_LAUNCHER_CLASS_NAME);
                fxLauncherMethod = fxLauncherClass.getMethod("launchApplication", String.class, String.class, String[].class);
                int n2 = fxLauncherMethod.getModifiers();
                if (!Modifier.isStatic(n2)) {
                    LauncherHelper.abort(null, "java.launcher.javafx.error1", new Object[0]);
                }
                if (fxLauncherMethod.getReturnType() != Void.TYPE) {
                    LauncherHelper.abort(null, "java.launcher.javafx.error1", new Object[0]);
                }
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                LauncherHelper.abort(reflectiveOperationException, "java.launcher.cls.error5", reflectiveOperationException);
            }
            fxLaunchName = string;
            switch (n) {
                case 1: {
                    fxLaunchMode = JAVAFX_LAUNCH_MODE_CLASS;
                    break;
                }
                case 2: {
                    fxLaunchMode = JAVAFX_LAUNCH_MODE_JAR;
                    break;
                }
                default: {
                    throw new InternalError(n + ": Unknown launch mode");
                }
            }
        }

        private static boolean doesExtendFXApplication(Class<?> clazz) {
            for (Class<?> clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                if (!clazz2.getName().equals(JAVAFX_APPLICATION_CLASS_NAME)) continue;
                return true;
            }
            return false;
        }

        public static void main(String ... stringArray) throws Exception {
            if (fxLauncherMethod == null || fxLaunchMode == null || fxLaunchName == null) {
                throw new RuntimeException("Invalid JavaFX launch parameters");
            }
            fxLauncherMethod.invoke(null, fxLaunchName, fxLaunchMode, stringArray);
        }
    }

    private static class ResourceBundleHolder {
        private static final ResourceBundle RB = ResourceBundle.getBundle("sun.launcher.resources.launcher");

        private ResourceBundleHolder() {
        }
    }

    private static enum SizePrefix {
        KILO(1024L, "K"),
        MEGA(0x100000L, "M"),
        GIGA(0x40000000L, "G"),
        TERA(0x10000000000L, "T");

        long size;
        String abbrev;

        private SizePrefix(long l, String string2) {
            this.size = l;
            this.abbrev = string2;
        }

        private static String scale(long l, SizePrefix sizePrefix) {
            return BigDecimal.valueOf(l).divide(BigDecimal.valueOf(sizePrefix.size), 2, RoundingMode.HALF_EVEN).toPlainString() + sizePrefix.abbrev;
        }

        static String scaleValue(long l) {
            if (l < SizePrefix.MEGA.size) {
                return SizePrefix.scale(l, KILO);
            }
            if (l < SizePrefix.GIGA.size) {
                return SizePrefix.scale(l, MEGA);
            }
            if (l < SizePrefix.TERA.size) {
                return SizePrefix.scale(l, GIGA);
            }
            return SizePrefix.scale(l, TERA);
        }
    }

    private static class StdArg {
        final String arg;
        final boolean needsExpansion;

        StdArg(String string, boolean bl) {
            this.arg = string;
            this.needsExpansion = bl;
        }

        StdArg(String string) {
            this.arg = string.substring(1);
            this.needsExpansion = string.charAt(0) == 'T';
        }

        public String toString() {
            return "StdArg{arg=" + this.arg + ", needsExpansion=" + this.needsExpansion + '}';
        }
    }
}

