/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.arsc;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pxb.android.arsc.ArscDumper;
import pxb.android.arsc.ArscParser;
import pxb.android.arsc.BagValue;
import pxb.android.arsc.Config;
import pxb.android.arsc.Pkg;
import pxb.android.arsc.ResConst;
import pxb.android.arsc.ResEntry;
import pxb.android.arsc.ResSpec;
import pxb.android.arsc.StringItem;
import pxb.android.arsc.StringItems;
import pxb.android.arsc.Type;
import pxb.android.arsc.Util;
import pxb.android.arsc.Value;

public class ArscWriter
implements ResConst {
    private List<PkgCtx> ctxs = new ArrayList<PkgCtx>(5);
    private List<Pkg> pkgs;
    private Map<String, StringItem> strTable = new TreeMap<String, StringItem>();
    private StringItems strTable0 = new StringItems();

    private static void D(String fmt, Object ... args) {
    }

    public ArscWriter(List<Pkg> pkgs) {
        this.pkgs = pkgs;
    }

    private static String decodeUnicode(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed   \\uxxxx   encoding.");
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    public static void main(String ... args) throws IOException {
        if (args.length < 2) {
            System.err.println("params error!");
            return;
        }
        String ofStr = null;
        String jqStr = null;
        String[] pkgNames = null;
        boolean bDump = false;
        int i = 1;
        while (i < args.length) {
            if (args[i].equals("-o")) {
                int n = ++i;
                ++i;
                ofStr = args[n];
                continue;
            }
            if (args[i].equals("-j")) {
                int n = ++i;
                ++i;
                jqStr = args[n];
                continue;
            }
            if (args[i].equals("--dump")) {
                ++i;
                bDump = true;
                continue;
            }
            if (args[i].equals("-p")) {
                int n = ++i;
                ++i;
                pkgNames = args[n].split(";");
                continue;
            }
            System.err.println("params error!");
            return;
        }
        byte[] data = Util.readFile(new File(args[0]));
        List<Pkg> pkgs = new ArscParser(data).parse();
        if (jqStr != null) {
            HashMap<String, String> toEdit = new HashMap<String, String>();
            Pattern pattern = Pattern.compile("\\s*([\\w\\._-]+)\\s*(=(.*))?");
            String[] strArr = null;
            strArr = -1 != jqStr.indexOf(";\r\n") ? jqStr.split(";\r\n") : jqStr.split(";\\s*\\\\r\\\\n");
            for (String s : strArr) {
                Matcher matcher = pattern.matcher(s);
                if (matcher.find()) {
                    if (matcher.group(2) != null) {
                        String v = "";
                        if (matcher.group(3) != null) {
                            v = matcher.group(3).trim();
                        }
                        toEdit.put(matcher.group(1), ArscWriter.decodeUnicode(v));
                        continue;
                    }
                    toEdit.put(matcher.group(1), "$$$READ$$$");
                    continue;
                }
                System.err.println("expression error!");
            }
            ArscDumper.edit(pkgs, toEdit);
        }
        if (pkgNames != null) {
            for (int x = 0; x < pkgs.size(); ++x) {
                Pkg pkg = pkgs.get(x);
                if (x >= pkgNames.length) continue;
                pkg.name = pkgNames[x].trim();
            }
        }
        byte[] data2 = new ArscWriter(pkgs).toByteArray();
        if (bDump) {
            ArscDumper.dump(new ArscParser(data2).parse());
        }
        if (ofStr != null) {
            Util.writeFile(data2, new File(ofStr));
        }
    }

    private void addString(String str) {
        if (this.strTable.containsKey(str)) {
            return;
        }
        StringItem stringItem = new StringItem(str);
        this.strTable.put(str, stringItem);
        this.strTable0.add(stringItem);
    }

    private int count() {
        int size = 0;
        size += 12;
        int stringSize = this.strTable0.getSize();
        if (stringSize % 4 != 0) {
            stringSize += 4 - stringSize % 4;
        }
        size += 8 + stringSize;
        for (PkgCtx ctx : this.ctxs) {
            ctx.offset = size;
            int pkgSize = 0;
            pkgSize += 268;
            ctx.typeStringOff = pkgSize += 20;
            int stringSize2 = ctx.typeNames0.getSize();
            if (stringSize2 % 4 != 0) {
                stringSize2 += 4 - stringSize2 % 4;
            }
            ctx.keyStringOff = pkgSize += 8 + stringSize2;
            stringSize2 = ctx.keyNames0.getSize();
            if (stringSize2 % 4 != 0) {
                stringSize2 += 4 - stringSize2 % 4;
            }
            pkgSize += 8 + stringSize2;
            for (Type type : ctx.pkg.types.values()) {
                type.wPosition = size + pkgSize;
                pkgSize += 16 + 4 * type.specs.length;
                for (Config config : type.configs) {
                    config.wPosition = pkgSize + size;
                    int configBasePostion = pkgSize;
                    pkgSize += 20;
                    int size0 = config.id.length;
                    if (size0 % 4 != 0) {
                        size0 += 4 - size0 % 4;
                    }
                    pkgSize += size0;
                    config.wEntryStart = (pkgSize += 4 * config.entryCount) - configBasePostion;
                    int entryBase = pkgSize;
                    for (ResEntry e : config.resources.values()) {
                        e.wOffset = pkgSize - entryBase;
                        pkgSize += 8;
                        if (e.value instanceof BagValue) {
                            BagValue big = (BagValue)e.value;
                            pkgSize += 8 + big.map.size() * 12;
                            continue;
                        }
                        pkgSize += 8;
                    }
                    config.wChunkSize = pkgSize - configBasePostion;
                }
            }
            ctx.pkgSize = pkgSize;
            size += pkgSize;
        }
        return size;
    }

    private List<PkgCtx> prepare() throws IOException {
        for (Pkg pkg : this.pkgs) {
            PkgCtx ctx = new PkgCtx();
            ctx.pkg = pkg;
            this.ctxs.add(ctx);
            for (Type type : pkg.types.values()) {
                ctx.addTypeName(type.id - 1, type.name);
                for (ResSpec spec : type.specs) {
                    ctx.addKeyName(spec.name);
                }
                for (Config config : type.configs) {
                    for (ResEntry e : config.resources.values()) {
                        Object object = e.value;
                        if (object instanceof BagValue) {
                            this.travelBagValue((BagValue)object);
                            continue;
                        }
                        this.travelValue((Value)object);
                    }
                }
            }
            ctx.keyNames0.prepare();
            ctx.typeNames0.addAll(ctx.typeNames);
            ctx.typeNames0.prepare();
        }
        this.strTable0.prepare();
        return this.ctxs;
    }

    public byte[] toByteArray() throws IOException {
        this.prepare();
        int size = this.count();
        ByteBuffer out = ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
        this.write(out, size);
        return out.array();
    }

    private void travelBagValue(BagValue bag) {
        for (Map.Entry<Integer, Value> e : bag.map) {
            this.travelValue(e.getValue());
        }
    }

    private void travelValue(Value v) {
        if (v.raw != null) {
            this.addString(v.raw);
        }
    }

    private void write(ByteBuffer out, int size) throws IOException {
        out.putInt(786434);
        out.putInt(size);
        out.putInt(this.ctxs.size());
        int stringSize = this.strTable0.getSize();
        int padding = 0;
        if (stringSize % 4 != 0) {
            padding = 4 - stringSize % 4;
        }
        out.putInt(0x1C0001);
        out.putInt(stringSize + padding + 8);
        this.strTable0.write(out);
        out.put(new byte[padding]);
        for (PkgCtx pctx : this.ctxs) {
            if (out.position() != pctx.offset) {
                throw new RuntimeException();
            }
            int basePosition = out.position();
            out.putInt(0x1200200);
            out.putInt(pctx.pkgSize);
            out.putInt(pctx.pkg.id);
            int p = out.position();
            out.put(pctx.pkg.name.getBytes("UTF-16LE"));
            out.position(p + 256);
            out.putInt(pctx.typeStringOff);
            out.putInt(pctx.typeNames0.size());
            out.putInt(pctx.keyStringOff);
            out.putInt(pctx.keyNames0.size());
            out.putInt(0);
            if (out.position() - basePosition != pctx.typeStringOff) {
                throw new RuntimeException();
            }
            int stringSize2 = pctx.typeNames0.getSize();
            int padding2 = 0;
            if (stringSize2 % 4 != 0) {
                padding2 = 4 - stringSize2 % 4;
            }
            out.putInt(0x1C0001);
            out.putInt(stringSize2 + padding2 + 8);
            pctx.typeNames0.write(out);
            out.put(new byte[padding2]);
            if (out.position() - basePosition != pctx.keyStringOff) {
                throw new RuntimeException();
            }
            stringSize2 = pctx.keyNames0.getSize();
            padding2 = 0;
            if (stringSize2 % 4 != 0) {
                padding2 = 4 - stringSize2 % 4;
            }
            out.putInt(0x1C0001);
            out.putInt(stringSize2 + padding2 + 8);
            pctx.keyNames0.write(out);
            out.put(new byte[padding2]);
            for (Type t : pctx.pkg.types.values()) {
                ArscWriter.D("[%08x]write spec", out.position(), t.name);
                if (t.wPosition != out.position()) {
                    throw new RuntimeException();
                }
                out.putInt(0x100202);
                out.putInt(16 + 4 * t.specs.length);
                out.putInt(t.id);
                out.putInt(t.specs.length);
                for (ResSpec spec : t.specs) {
                    out.putInt(spec.flags);
                }
                for (Config config : t.configs) {
                    ArscWriter.D("[%08x]write config", out.position());
                    int typeConfigPosition = out.position();
                    if (config.wPosition != typeConfigPosition) {
                        throw new RuntimeException();
                    }
                    int sizeH = 20;
                    int size0 = config.id.length;
                    int padding3 = 0;
                    if (size0 % 4 != 0) {
                        padding3 = 4 - size0 % 4;
                    }
                    out.putInt(0x201 | (sizeH += size0) << 16);
                    out.putInt(config.wChunkSize);
                    out.putInt(t.id);
                    out.putInt(t.specs.length);
                    out.putInt(config.wEntryStart);
                    ArscWriter.D("[%08x]write config ids", out.position());
                    out.put(config.id);
                    out.put(new byte[padding3]);
                    out.position(typeConfigPosition + sizeH);
                    ArscWriter.D("[%08x]write config entry offsets", out.position());
                    for (int i = 0; i < config.entryCount; ++i) {
                        ResEntry entry = config.resources.get(i);
                        if (entry == null) {
                            out.putInt(-1);
                            continue;
                        }
                        out.putInt(entry.wOffset);
                    }
                    if (out.position() - typeConfigPosition != config.wEntryStart) {
                        throw new RuntimeException();
                    }
                    ArscWriter.D("[%08x]write config entrys", out.position());
                    for (ResEntry e : config.resources.values()) {
                        ArscWriter.D("[%08x]ResTable_entry", out.position());
                        boolean isBag = e.value instanceof BagValue;
                        out.putShort((short)(isBag ? 16 : 8));
                        int flag = e.flag;
                        flag = isBag ? (flag |= 1) : (flag &= 0xFFFFFFFE);
                        out.putShort((short)flag);
                        out.putInt(pctx.keyNames.get((Object)e.spec.name).index);
                        if (isBag) {
                            BagValue bag = (BagValue)e.value;
                            out.putInt(bag.parent);
                            out.putInt(bag.map.size());
                            for (Map.Entry<Integer, Value> entry : bag.map) {
                                out.putInt(entry.getKey());
                                this.writeValue(entry.getValue(), out);
                            }
                            continue;
                        }
                        this.writeValue((Value)e.value, out);
                    }
                }
            }
        }
    }

    private void writeValue(Value value, ByteBuffer out) {
        out.putShort((short)8);
        out.put((byte)0);
        out.put((byte)value.type);
        if (value.type == 3) {
            out.putInt(this.strTable.get((Object)value.raw).index);
        } else {
            out.putInt(value.data);
        }
    }

    private static class PkgCtx {
        Map<String, StringItem> keyNames = new HashMap<String, StringItem>();
        StringItems keyNames0 = new StringItems();
        public int keyStringOff;
        int offset;
        Pkg pkg;
        int pkgSize;
        List<StringItem> typeNames = new ArrayList<StringItem>();
        StringItems typeNames0 = new StringItems();
        int typeStringOff;

        private PkgCtx() {
        }

        public void addKeyName(String name) {
            if (this.keyNames.containsKey(name)) {
                return;
            }
            StringItem stringItem = new StringItem(name);
            this.keyNames.put(name, stringItem);
            this.keyNames0.add(stringItem);
        }

        public void addTypeName(int id, String name) {
            while (this.typeNames.size() <= id) {
                this.typeNames.add(null);
            }
            StringItem item = this.typeNames.get(id);
            if (item != null) {
                throw new RuntimeException();
            }
            this.typeNames.set(id, new StringItem(name));
        }
    }
}

