/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.arsc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import pxb.android.arsc.ArscParser;
import pxb.android.arsc.Config;
import pxb.android.arsc.Pkg;
import pxb.android.arsc.ResEntry;
import pxb.android.arsc.ResSpec;
import pxb.android.arsc.Type;
import pxb.android.arsc.Util;
import pxb.android.arsc.Value;

public class ArscDumper {
    public static void dump(List<Pkg> pkgs) {
        for (int x = 0; x < pkgs.size(); ++x) {
            Pkg pkg = pkgs.get(x);
            System.out.println(String.format("  Package %d id=%d name=%s typeCount=%d", x, pkg.id, pkg.name, pkg.types.size()));
            for (Type type : pkg.types.values()) {
                int i;
                System.out.println(String.format("    type %d %s", type.id - 1, type.name));
                int resPrefix = pkg.id << 24 | type.id << 16;
                for (i = 0; i < type.specs.length; ++i) {
                    ResSpec spec = type.getSpec(i);
                    System.out.println(String.format("      spec 0x%08x 0x%08x %s", resPrefix | spec.id, spec.flags, spec.name));
                }
                for (i = 0; i < type.configs.size(); ++i) {
                    Config config = type.configs.get(i);
                    System.out.println("      config");
                    ArrayList<ResEntry> entries = new ArrayList<ResEntry>(config.resources.values());
                    for (int j = 0; j < entries.size(); ++j) {
                        ResEntry entry = (ResEntry)entries.get(j);
                        System.out.println(String.format("        resource 0x%08x %-20s: %s", resPrefix | entry.spec.id, entry.spec.name, entry.value));
                    }
                }
            }
        }
    }

    public static void edit(List<Pkg> pkgs, HashMap<String, String> toEdit) {
        for (int x = 0; x < pkgs.size(); ++x) {
            Pkg pkg = pkgs.get(x);
            for (Type type : pkg.types.values()) {
                int resPrefix = pkg.id << 24 | type.id << 16;
                for (int i = 0; i < type.configs.size(); ++i) {
                    Config config = type.configs.get(i);
                    ArrayList<ResEntry> entries = new ArrayList<ResEntry>(config.resources.values());
                    for (int j = 0; j < entries.size(); ++j) {
                        ResEntry entry = (ResEntry)entries.get(j);
                        if (!toEdit.containsKey(entry.spec.name) || !(entry.value instanceof Value)) continue;
                        if (((Value)entry.value).type == 3) {
                            String newVar = toEdit.get(entry.spec.name);
                            if (newVar.equals("$$$READ$$$")) {
                                System.out.println(entry.value);
                                continue;
                            }
                            System.out.println(entry.spec.name + ":" + entry.value + "=>" + newVar);
                            ((Value)entry.value).raw = newVar;
                            entries.set(i, entry);
                            continue;
                        }
                        System.err.println(entry.spec.name + "is not String!");
                    }
                }
            }
        }
    }

    public static HashMap<String, String> dumpResource(List<Pkg> pkgs) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int x = 0; x < pkgs.size(); ++x) {
            Pkg pkg = pkgs.get(x);
            for (Type type : pkg.types.values()) {
                int i;
                int resPrefix = pkg.id << 24 | type.id << 16;
                for (i = 0; i < type.specs.length; ++i) {
                    ResSpec spec = type.getSpec(i);
                }
                for (i = 0; i < type.configs.size(); ++i) {
                    Config config = type.configs.get(i);
                    ArrayList<ResEntry> entries = new ArrayList<ResEntry>(config.resources.values());
                    for (int j = 0; j < entries.size(); ++j) {
                        ResEntry entry = (ResEntry)entries.get(j);
                        hashMap.put(String.valueOf(resPrefix | entry.spec.id), entry.value.toString());
                    }
                }
            }
        }
        return hashMap;
    }

    public static void main(String ... args) throws IOException {
        byte[] data = Util.readFile(new File("resources.arsc"));
        List<Pkg> pkgs = new ArscParser(data).parse();
        ArscDumper.dump(pkgs);
    }
}

