using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Text;
using CuteEditor.Impl;
using CuteEditor;


/****************************************************************************
 * Copyright (c)   缼޹˾Ȩ
 * : ͼƬļҳ,ʾͼƬϸϢ
 * : 
 * ʱ: 2006/10/26
 * ע:
 ****************************************************************************/
namespace CuteEditor.Dialogs
{

	public class ThumbList2 : CuteEditor.EditorUtilityCtrl
	{

		// Fields
		protected int _columns;
		protected int _height;
		protected int _Pagesize;
		protected int _rows;
		protected string _type;
		protected string _vpath;
		protected string _vroot;
		protected int _width;
		private LanguageResourceManager a;
		public int CurPage;
		protected FileStorage fs;
		protected HtmlInputHidden hdnCurPage;
		protected HtmlInputHidden hdnPrevPath;
		protected DataList MyList;
		protected PlaceHolder plLinks;
		protected EditorProvider provider;
		public bool Refresh;
		protected SecuritySetting secset;
		protected EditorSetting setting;
		protected string String_Createddate;
		protected string String_Modifieddate;
		protected string String_Name;
		protected string String_Size;

		public ThumbList2()
		{
			this._vroot = "";
			this._vpath = "";
			this._type = "";
			this.a = new LanguageResourceManager("../languages/");
		}


		private void a2()
		{
			base.Load += new EventHandler(this.Page_Load);
		}


		/*****************************************
		 *  BindThumbList
		 * ܣ ͼƬļзҳ
		 * 京壺
		 * ֵ
		 *****************************************/
		public void BindThumbList()
		{
			new ArrayList(this.fs.GetDirectoryItems(this._vpath, false));
			ArrayList list1 = new ArrayList();
			if (this.Type == "*.*")
			{
				foreach (string text1 in this.secset.ImageFilters)
				{
					if ((text1 != null) && (text1.Length != 0))
					{
						list1.AddRange(this.fs.GetFileItems(this._vpath, this.secset.FileNamePrefix + "*" + text1));
					}
				}
			}
			else
			{
				list1.AddRange(this.fs.GetFileItems(this._vpath, this.secset.FileNamePrefix + this.Type));
			}
            
			// ͼƬմʱӴС
			for(int i=1; i< list1.Count; i++)
			{
				for(int j=0;j<list1.Count-i; j++)
				{
					CuteEditor.Impl.FileItem image1 = (CuteEditor.Impl.FileItem)list1[j];
					CuteEditor.Impl.FileItem image2 = (CuteEditor.Impl.FileItem)list1[j+1];
					if(image1.CreationTime<image2.CreationTime)
					{
						list1[j] = image2;
						list1[j+1] = image1;
					}

				}
			}

			this.MyList.Attributes["TotalFiles"] = list1.Count.ToString();
			int num1 = (int) Math.Ceiling((double) (((float) list1.Count) / ((float) this.Pagesize)));
			if (num1 == 0)
			{
				num1 = 1;
			}
			this.MyList.Attributes["TotalPages"] = num1.ToString();
			if (this.CurPage < 1)
			{
				try
				{
					this.CurPage = int.Parse(this.hdnCurPage.Value);
				}
				catch (Exception)
				{
					this.CurPage = 1;
				}
			}
			if (this.hdnPrevPath.Value != this.VPath)
			{
				this.CurPage = 1;
			}
			base.Trace.Warn("BindThumbList: Current page=" + this.CurPage.ToString());
			if (this.CurPage > num1)
			{
				this.CurPage = num1;
			}
			else if (this.CurPage < 1)
			{
				this.CurPage = 1;
			}
			this.MyList.Attributes["CurPage"] = this.CurPage.ToString();
			this.hdnCurPage.Value = this.CurPage.ToString();
			int num2 = (this.CurPage - 1) * this.Pagesize;
			int num3 = Math.Min(this.CurPage * this.Pagesize, list1.Count);
			// ÿҳʾͼƬ
			this.MyList.DataSource = list1.GetRange(num2, num3 - num2);
			// ݰ
			this.MyList.DataBind();
		}

		public void CreateNavBar(PlaceHolder plLinks)
		{
			base.Trace.Warn("CreateNavBar()");
			this.CurPage = int.Parse(this.MyList.Attributes["CurPage"]);
			int num1 = int.Parse(this.MyList.Attributes["TotalPages"]);
			if (num1 != 1)
			{
				if (this.CurPage > 1)
				{
                    plLinks.Controls.Add(new LiteralControl(string.Format("<A href=\"javascript:GoToPage('{0}',{1});\"> " + this.a.GetString("Prev") + " </A>&nbsp;&nbsp;&nbsp;&nbsp;", this.VPath, this.CurPage - 1)));
				}
				for (int num2 = 1; num2 <= num1; num2++)
				{
					string text1 = num2.ToString();
					plLinks.Controls.Add(new LiteralControl("&nbsp;"));
					if (num2 == this.CurPage)
					{
						Label label1 = new Label();
						label1.Text = text1;
						label1.Font.Bold = true;
						plLinks.Controls.Add(label1);
					}
					else
					{
						plLinks.Controls.Add(new LiteralControl(string.Format("<A href=\"javascript:GoToPage('{0}',{1});\">{2}</A>", this.VPath, text1, text1)));
					}
					if ((num2 % 20) == 0)
					{
						plLinks.Controls.Add(new LiteralControl("<br>"));
					}
				}
				if (this.CurPage < num1)
				{
					plLinks.Controls.Add(new LiteralControl("&nbsp;&nbsp;<A href=\"javascript:GoToPage" + string.Format("('{0}',{1});\">", this.VPath, this.CurPage + 1) + this.a.GetString("Next") + " &gt;&gt;</A>"));
				}
			}
		}

		public string ImageUrl(string sFile)
		{
			StringBuilder builder1 = new StringBuilder();
			builder1.AppendFormat("{0}/{1}", this._vpath, sFile);
			return builder1.ToString();
		}

		public void Item_DataBound(object sender, DataListItemEventArgs e)
		{
			if (e.Item.ItemType == ListItemType.Footer)
			{
				base.Trace.Warn("DataBound event for footer");
				PlaceHolder holder1 = (PlaceHolder) e.Item.FindControl("plLinks");
				this.CreateNavBar(holder1);
				this.hdnPrevPath.Value = this.VPath;
			}
		}

		public string NumImagesDisplayed()
		{
            //string strMyPageTest = this.String_Modifieddate = this.a.GetString("Total") + "   " + this.MyList.Attributes["TotalFiles"] + "   " + this.a.GetString("Images");
            //return strMyPageTest;
            return (this.String_Modifieddate = this.a.GetString("Total") + "   " + this.MyList.Attributes["TotalFiles"] + "   " + this.a.GetString("Images"));
		}

		protected override void OnInit(EventArgs e)
		{
			this.fs = FileStorage.CreateInstance(this.Context);
			this.setting = EditorSetting.GetFromContext(this.Context, true);
			this.provider = EditorProvider.CreateInstance(this.Context, this.setting);
			this.secset = this.provider.Security;
			this.a2();
			base.OnInit(e);
		}

		public void Page_Load(object Src, EventArgs e)  
		{
			this.fs.VirtualRoot = this._vroot;
			StringBuilder builder1 = new StringBuilder();
			builder1.Append("\n <script language=\"javascript\">");
			builder1.Append("\n function GoToPage(vpath,n) { \n");
			builder1.AppendFormat("\n document.getElementById('{0}').value=n; \n", this.hdnCurPage.ClientID);
			builder1.Append(this.Page.GetPostBackEventReference(this));
			builder1.Append("\n } ");
			builder1.Append("\nfunction Check(t,n)\t{");
			builder1.Append("\n if(n==1) {");
			builder1.Append("\n t.style.border = \"1px solid #00107B\";");
			builder1.Append("\n t.style.background = \"#F1EEE7\";");
			builder1.Append("\n }");
			builder1.Append("\n else  {");
			builder1.Append("\n \t\tt.style.border = \"1px solid white\";");
			builder1.Append("\n \t\tt.style.background = \"#FFFFFF\";");
			builder1.Append("\n \t}");
			builder1.Append("}\n ");
			builder1.Append("</script>");
			this.String_Name = this.a.GetString("Name");
			this.String_Size = this.a.GetString("Size");
			this.String_Createddate = this.a.GetString("Createddate");
			this.String_Modifieddate = this.a.GetString("Modifieddate");
			if (!this.Page.IsClientScriptBlockRegistered("clientGotoPageScript"))
			{
				this.Page.RegisterClientScriptBlock("clientGotoPageScript", builder1.ToString());
			}
			this.BindThumbList();
		}

		public string ThumbUrl(string path)
		{
			StringBuilder builder1 = new StringBuilder();
			builder1.AppendFormat("ThumbJpeg.aspx?settinghash=[[_setting_]]&VFilePath={0}&[[DNN_Arg]]", path);
			if (this._width > 0)
			{
				builder1.AppendFormat("&Width={0}", this._width);
			}
			if (this._height > 0)
			{
				builder1.AppendFormat("&Height={0}", this._height);
			}
			return EditorUtility.ResolveResource(this.Context, null, this.setting, "Dialogs/" + builder1.ToString());
		}

		public int Columns
		{
			get
			{
				this._columns = this.MyList.RepeatColumns;
				return this.MyList.RepeatColumns;
			}
			set
			{
				this._columns = value;
				this.MyList.RepeatColumns = value;
			}
		}


		public int Height
		{
			get
			{
				return this._height;
			}
			set
			{
				this._height = value;
			}
		}

		public int Pagesize
		{
			get
			{
				return (this._rows * this._columns);
			}
		}

		public int Rows
		{
			get
			{
				return this._rows;
			}
			set
			{
				this._rows = value;
			}
		}

		public string Type
		{
			get
			{
				return this._type;
			}
			set
			{
				this._type = value;
			}
		}

		public string VPath
		{
			get
			{
				return this._vpath;
			}
			set
			{
				this._vpath = value.TrimEnd(new char[] { '/' });
			}
		}

		public string VRoot
		{
			get
			{
				return this._vroot;
			}
			set
			{
				this._vroot = value;
			}
		}

		public int Width
		{
			get
			{
				return this._width;
			}
			set
			{
				this._width = value;
			}
		}

	}
}
