<?php
// +------------------------------------------------------------------------------------------------
// | 【使用说明】请将本文件上传至网站服务器：/application/index/controller/  目录下。
// +------------------------------------------------------------------------------------------------
// | [18淘客助手api文件(程序侠淘宝客专用)] Copyright (c) 2019 18.LA
// +------------------------------------------------------------------------------------------------
// | 最后修改：2019年4月19日
// +------------------------------------------------------------------------------------------------
// | 官网：http://taoke.18.la/
// +------------------------------------------------------------------------------------------------
namespace app\index\controller;

use think\Controller;
use think\Db;
use \think\Request;

class Api extends Controller
{
	//定义返回数据
	private $return  = array('state'=>'ok','code'=>1,'message'=>'','version'=>'5.7');
	public function index()
    {
		$this->return['system']=urlencode('程序侠淘宝客');//系统名称
		$this->return['updatetime']=urlencode('2019年4月19日');//最后修改日期

		//验证key
		$this->verify();

		//读取api参数
		$api=Request::instance()->post('api');

		//订单同步
		if($api=='postorder'){
			$this->postorder();
		}
		//商品采集
		elseif($api=='postgoods'){
			$this->postgoods();
		}
		//商品管理
		elseif($api=='delgoods'){
			$this->delgoods();
		}
		//代理管理
		elseif($api=='agentadmin'){
			$op=Request::instance()->post('op');
			if($op=='getrequest'){
				//获取待审核代理列表
				$this->getagent();
			}elseif($op=='check'){
				//审核代理
				$this->checkagent();
			}else{
				$this->returnExit($this->return,0,"传入条件数据不正确");//code值设置为0，表示失败
			}
		}
		//拼多多订单同步
		elseif($api=='postpddorder'){
			$this->postpddorder();
		}
		//京东订单同步
		elseif($api=='postjdorder'){
			$this->postjdorder();
		}
		$this->returnExit($this->return,0,"未传入有效API参数");//code值设置为0，表示失败
    }






// +----------------------------------------
// | 接口验证相关函数
// +----------------------------------------
	//接口验证
	private function verify()
	{
		//读取post的基础参数
		$api=Request::instance()->post('api');//api名称
		$getkey=Request::instance()->post('key');

		//如果未传入有效参数
		if (!isset($getkey) || !isset($api)) {
			$this->returnExit($this->return,0,"API接口正常");//code值设置为0，表示失败
		}

		//读取网站授权码
		$web_auth_code = Db::name('config')->where("name","WEB_AUTH_CODE")->value('value');
		//处理字符串
		$getkey=trim($getkey);
		$getkey=strtoupper($getkey);
		$web_auth_code=trim($web_auth_code);
		$web_auth_code=strtoupper($web_auth_code);

		//判断密钥是否正确
		if($getkey!=$web_auth_code){
			$this->returnExit($this->return,0,"密钥错误");//code值设置为0，表示失败
		}
		
		//接口验证
		if($api=='verify'){
			$this->returnExit($this->return,1,"验证成功");//code值设置为1，表示成功
		}
	}


// +----------------------------------------
// | 订单同步相关函数
// +----------------------------------------
	//订单同步
	private function postorder()
	{
		//获取post过来的订单内容
		$content=Request::instance()->post('content');
		if(empty($content)){
			$this->returnExit($this->return,0,"content参数不能为空");//code值设置为0，表示失败
		}
		$content=htmlspecialchars_decode($content);//把一些预定义的 HTML 实体转换为字符
		$contentArr=@json_decode($content, true);//json解码
		//如果数组不为空
		if(!empty($contentArr)){
				//将订单数据以订单号和商品ID做键值，保存到新数组
				$contentArr=$this->orderOnly($contentArr);
				$db = Db::name('union_order');//操作union_order表
				$resultStr="";//记录订单入库结果字符串
				//遍历订单数组
				foreach($contentArr as $orderData)
				{
					//判断是否为空数组
					if(count($orderData)<1){
						continue;
					}

					//读取订单编号和商品id
					$orderid=$orderData[0]['订单编号'];
					$goodsid=$orderData[0]['商品ID'];
					//查询是否存在
					$goods_order_id = $db->where('goods_order',$orderid)->where('goods_id',$goodsid)->column('id');
					//遍历数组
					$id=0;
					$resultValue=1;
					foreach($orderData as $data){
						//格式化订单数据
						$newdata=$this->orderFormat($data);
						
						Db::startTrans();// 启动事务
						//判断数据是否存在
						if(isset($goods_order_id[$id])){
							//如果数据已存在,更新
							try{
								$result=$db->where('id',$goods_order_id[$id])->update($newdata);
								// 提交事务
								Db::commit();
								$resultValue = ($resultValue==1) ? 1 : 0;//如果上次状态为1,这次也标记为1，否则设置为0
							} catch (\Exception $e) {
								// 回滚事务
								Db::rollback();
								$resultValue=0;
							}
						}else{
							//如果数据不存在,新增
							try{
								$result=$db->insert($newdata);
								// 提交事务 
								Db::commit();
								if (!empty($result)) {
									//添加成功
									$resultValue = ($resultValue==1) ? 1 : 0;//如果上次状态为1,这次也标记为1，否则设置为0
								}else{
									//添加失败
									$resultValue=0;
								}
								
							} catch (\Exception $e) {
								// 回滚事务
								Db::rollback();
								$resultValue=0;
							}
						}
						$id++;
					}
					//记录入库结果
					$resultStr=$this->resultState($resultStr,$orderid,$resultValue);
				}
				$this->returnExit($this->return,1,"result:".$resultStr);//code值设置为1，表示成功
			}else{
				$this->returnExit($this->return,0,"传入订单数据不正确");//code值设置为0，表示失败
			}
	}


	//将订单数据以订单号和商品ID做键值，保存到新数组
	private function orderOnly($contentArr)	
	{
		//遍历订单数组
		foreach($contentArr as $orderID=>$orderData)
		{
				foreach($orderData as $data){
					$key=$data['订单编号'].'_'.$data['商品ID'];
					$newData[$key][]=$data;
				}
		}
		return $newData;
	}



	//格式化订单数据
	function orderFormat($data){
		//将数据存储到符合当前系统的新数组
		$newData=array(
			//'id'=>0,//ID
			//'uid'=>0,//认领用户ID
			'type'=>0,//订单类型 0淘宝 1拼多多 2京东
			'goods_order'=>$data['订单编号'],//订单编号
			'goods_number'=>$data['商品数'],//成交数量
			'order_status'=>$data['订单状态'],//3：订单结算12：订单付款13:订单失效	
			'title'=>$data['商品信息'],//商品标题
			'goods_id'=>$data['商品ID'],//商品ID
			'price'=>$data['商品单价'],//商品价格
			'shop_type'=>$data['订单类型'],//订单类型
			'pay_price'=>$data['付款金额'],//付款金额
			'settlement_price'=>$data['结算金额'],//结算金额
			'commission'=>$data['效果预估'],//效果预估
			'commission_rate'=>$data['佣金比率'],//佣金比率
			//'status'=>0,//状态
			//'is_receive'=>0,//提现状态 0：未提现 1：已提现
			//'second_receive'=>0,//二代提现状态
			//'third_receive'=>0,//三代提现状态
			'terminal_type'=>$data['成交平台'],//成交平台
			'create_time'=>strtotime($data['创建时间']),//创建时间
			'adzone_id'=>$data['广告位ID'],//广告位ID
			'adzone_name'=>$data['渠道关系ID'] ? $this->getAdzoneName($data['渠道关系ID']) : $data['广告位名称'],//广告位名称
			'relation_id'=>$data['渠道关系ID'],//渠道id
			'special_id'=>$data['会员运营ID'],//渠道id
			'earning_time'=>strtotime($data['结算时间']),//结算时间
		);
		//将订单状态转化为程序侠支持的格式
		if($newData['order_status']=='订单结算' || $newData['order_status']=='订单完成'|| $newData['order_status']=='订单成功'){
			$newData['order_status']='3';
		}elseif($newData['order_status']=='订单付款'){
			$newData['order_status']='12';
		}if($newData['order_status']=='订单失效'){
			$newData['order_status']='13';
		}
		//处理维权订单
		if(strpos($data['维权状态'],"维权创建") !== false || strpos($data['维权状态'],"等待处理") !== false) {
			$newData['order_status']='12';//强制将订单状态设置为：订单付款
		}
		elseif(strpos($data['维权状态'],"维权成功") !== false) {
			$newData['order_status']='13';//强制将订单状态设置为：订单失效
		}
		elseif(strpos($data['维权状态'],"维权失败") !== false) {
			//$newData['order_status']='3';//强制将订单状态设置为：订单结算(因为订单也有可能本身是其他状态，所以此处不做处理即可)
		}
		//是否开启渠道
		$channel = get_config('AGENT_CHANNEL_MEMBER');
		//
		if ($channel == '1'){
			if (isset($newData['special_id']) && $newData['special_id']) {
				$data = $this->createOrderLog($newData);
	           	if ($data['uid']) {
	              	$newData['uid'] = $data['uid']; //用户id
	              	$newData['rebate_money'] = $data['money']; //返利金额
	           	}
			}
			if (Db::query('show tables like "cxxia_push_log"')) {
				if ($newData['order_status'] == '12'){
		            $this->pushOrder($newData,'1');
		        }
			}
        }
		return	$newData;
	}




// +----------------------------------------
// | 商品采集相关函数
// +----------------------------------------
	//商品采集
	private function postgoods()
	{
			//获取post过来的订单内容
			$content=Request::instance()->post('content');
			if(empty($content)){
				$this->returnExit($this->return,0,"content参数不能为空");//code值设置为0，表示失败
			}
			$content=htmlspecialchars_decode($content);//把一些预定义的 HTML 实体转换为字符
			$contentArr=@json_decode($content, true);//json解码
			//print_r($contentArr);

			//如果数组不为空
			if(!empty($contentArr['cat']) && !empty($contentArr['goods'])){
				//商品分类
				$cat=$this->goodsCat($contentArr['cat']);
				if(empty($cat)){
					$this->returnExit($this->return,0,"分类绑定不正确");//code值设置为0，表示失败
				}

				//商品数据
				$resultStr="";//记录订单入库结果字符串
				foreach($contentArr['goods'] as $data)
				{
					$itemid=$data['商品ID'];
					//格式化商品数据
					$newdata=$this->goodsFormat($cat,$data);
					//print_r($newdata);
					
					$db = Db::name('goods');
					//查询是否存在
					$goodsid = $db->where('goods_id',$itemid)->value('id');
					if (empty($goodsid)){
						Db::startTrans();// 启动事务
						try{
							$result=$db->insert($newdata);
							// 提交事务
							Db::commit();    
						} catch (\Exception $e) {
							// 回滚事务
							Db::rollback();
						}
					}else{
						//如果已存在，更新
						Db::startTrans();// 启动事务
						try{
							$result=$db->where('goods_id',$itemid)->update($newdata);
							// 提交事务
							Db::commit();    
						} catch (\Exception $e) {
							// 回滚事务
							Db::rollback();
						}
					}
					
					//记录入库结果
					if (!empty($result)) {
						//添加成功
						$resultStr=$this->resultState($resultStr,$itemid,"1");
					}else{
						//添加失败
						$resultStr=$this->resultState($resultStr,$itemid,"0");
					}
				}
				//清空缓存
				$this->clearcache();
				$this->returnExit($this->return,1,"result:".$resultStr);//code值设置为1，表示成功
			}else{
				$this->returnExit($this->return,0,"传入商品数据不正确");//code值设置为0，表示失败
			}
	}



	//处理商品分类
	private function goodsCat($softCat)
	{
		//查询数据库的分类名和对应ID
		$allCat = Db::name('goods_cate')->column('id','name');
		//print_r($allCat);

		foreach($allCat as $key=>$value){
			$key=str_replace("其他","其它",$key);//兼容分类名字为“其他”时的情况
			$dbCat[$key]=$value;
		}

		//将程序商品分类关系转化成对应的id
		foreach($softCat as $key=>$value){
			$value=str_replace("其他","其它",$value);//兼容分类名字为“其他”时的情况
			if (isset($dbCat[$value]))	$newCat[$key]=$dbCat[$value];
		}
		//print_r($softCat);
		return $newCat;
	}

	//格式化商品数据
	private function goodsFormat($cat,$data){
		//处理商品类目
		if (empty($cat[$data['商品类目']])){
			$data['商品类目']=0;
		}else{
			$data['商品类目']=$cat[$data['商品类目']];
		}
		
		//处理优惠券数量
		if(empty($data['优惠券总数量']))	$data['优惠券总数量']=rand(5000,20000);//生成随机的优惠券总数
		if(empty($data['优惠券领取量']))	$data['优惠券领取量']=intval($data['优惠券总数量']*(rand(60,98)/100));//生成随机的优惠券领取量
		$data['优惠券剩余量']=$data['优惠券总数量']-$data['优惠券领取量'];//计算优惠券剩余量

		//优化商品图片地址
		if($data['商品图片'])
		if(strpos($data['商品图片'],'http://') === 0 )	
		{
			if(!strpos($data['商品图片'],'.haodanku.') && !strpos($data['商品图片'],'.tbcdn.cn'))
	    	{
			    $data['商品图片']='https://'.substr($data['商品图片'],7);
			}
		}
		elseif(strpos($data['商品图片'],'//') === 0)	
		{
			if(!strpos($data['商品图片'],'.haodanku.') && !strpos($data['商品图片'],'.tbcdn.cn'))
	    	{
			    $data['商品图片']='https:'.$data['商品图片'];
			}else
			 {
			    $data['商品图片']='http:'.$data['商品图片'];
			 }
		}
	
		$newData=array(
				//'id' => '1',//自增ID
				//'sort' => '999',//排序
				'cid' => $data['商品类目'],//分类
				'goods_id' => $data['商品ID'],//商品ID
				'title' => $data['商品标题'],//商品标题
				'intro' => $data['商品文案'],//商品简介
				//'content' => '',//商品详情
				//'goods_url' => '',//商品URL地址
				'nick' => $data['卖家昵称'],//卖家旺旺
				'sellerId' => $data['卖家ID'],//卖家ID
				'img' => $data['商品图片'],//商品图片地址
				'price' => $data['商品原价'],//商品价格
				'discount_price' => $data['商品券后价'],//商品折扣价
				//'discount_rate' => '',//折扣率
				//'click_url' => '',//推广链接
				//'taokouling' => '',//淘口令
				'volume' => $data['商品销量'],//商品销量
				'commission' => $data['预计佣金'],//佣金金额
				'commission_rate' => $data['佣金比例'],//佣金比例
				'shop_type' => $data['店铺类型'],//店铺类型
				//'ems' => '',//是否包邮
				'coupon_id' => $data['优惠券ID'],//优惠券id
				//'coupon_url' => $data['优惠券链接'],//优惠券地址
				'coupon_price' => $data['优惠券金额'],//优惠券价格
				'coupon_receive' => $data['优惠券领取量'],//券已领取数量
				'coupon_surplus' => $data['优惠券剩余量'],//券剩余数量
				'coupon_total' => $data['优惠券总数量'],//优惠券总数
				'coupon_explain' => $data['优惠券使用条件'],//优惠券说明
				'start_time' => $data['优惠券开始时间'],//开始时间
				'end_time' => $data['优惠券结束时间'],//结束时间
				//'status' => '',//商品状态(1开启，0禁用)
				//'seo_title' => '',//seo标题
				//'seo_keys' => '',//seo关键词
				//'seo_desc' => '',//seo描述
				'create_time' => time(),//添加时间
		);
		//处理视频单
		if (!empty($data['商品视频ID'])) {
			//是否视频单
			$newData['video'] = 'http://cloud.video.taobao.com/play/u/1/p/1/e/6/t/1/' . $data['商品视频ID'] . '.mp4';
		}
		return	$newData;
	}


// +----------------------------------------
// | 商品管理相关函数
// +----------------------------------------
	//删除商品
	private function delgoods()
	{
		//获取post过来的订单内容
		$content=htmlspecialchars_decode(Request::instance()->post('content'));
		$contentArr=@json_decode($content, true);//json解码

		//按where条件删除商品
		if(!empty($contentArr['where']) ){//如果where数组不为空
			$whereArr=$contentArr['where'];
			//print_r($whereArr);
			
			$where='';
			//构造sql语句
			if(!empty($whereArr['销量小于']) )
			{
				if(!empty($where))	$where.=" or ";
				$where.=" volume<'{$whereArr['销量小于']}' ";
			}

			if(!empty($whereArr['价格小于'])){
				if(!empty($where))	$where.=" or ";
				$where.=" discount_price<'{$whereArr['价格小于']}' ";
			}
			
			if(!empty($whereArr['价格大于'])){
				if(!empty($where))	$where.=" or ";
				$where.=" discount_price>'{$whereArr['价格大于']}' ";
			}

			if(!empty($whereArr['佣金小于']) )
			{
				if(!empty($where))	$where.=" or ";
				$where.=" commission<'{$whereArr['佣金小于']}' ";
			}

			if(!empty($whereArr['佣金比例']) )
			{
				if(!empty($where))	$where.=" or ";
				$where.=" commission_rate<'{$whereArr['佣金比例']}' ";
			}

			if(!empty($whereArr['非天猫']) )
			{
				if(!empty($where))	$where.=" or ";
				$where.=" shop_type!='B' ";
			}
			
			/*
			if(!empty($whereArr['非视频单']) )
			{
				if(!empty($where))	$where.=" or ";
				$where.=" videoid='0' ";
			}
			*/

			if(!empty($whereArr['优惠券过期']) )
			{
				if(!empty($where))	$where.=" or ";
				$where.="(end_time<>'' and  end_time<='".time()."') ";
			}

			if(!empty($whereArr['无优惠券']) )
			{
				if(!empty($where))	$where.=" or ";
				$where.=" ((coupon_id='' or coupon_id is null) and (coupon_url='' or coupon_url is null)) ";
			}

			if(!empty($where)){
					Db::startTrans();// 启动事务
					try{
						$result = Db::name('goods')->where($where)->delete();//执行删除语句
						// 提交事务
						Db::commit();    
					} catch (\Exception $e) {
						// 回滚事务
						Db::rollback();
					}
				if(!empty($result)){
					$this->clearcache();//清空缓存
					$this->returnExit($this->return,1,'成功删除'.$result.'件商品');//code值设置为1，表示成功
				}else{
					$this->returnExit($this->return,1,'暂无符合条件商品');//code值设置为1，表示成功
				}
			}else{
				$this->returnExit($this->return,0,'传入条件数据不正确');//code值设置为1，表示成功
			}
		}

		//按传入的商品id列表删除商品
		elseif(!empty($contentArr['goodsid']) ){//如果goodsid数组不为空
				Db::startTrans();// 启动事务
				try{
					$result = Db::name('goods')->where('goods_id',array('IN',$contentArr['goodsid']))->delete();//执行删除语句
					// 提交事务
					Db::commit();    
				} catch (\Exception $e) {
					// 回滚事务
					Db::rollback();
				}
			if(!empty($result)){
				$this->clearcache();//清空缓存
				$this->returnExit($this->return,1,'成功删除'.$result.'件商品');//code值设置为1，表示成功
			}else{
				$this->returnExit($this->return,1,'暂无符合条件商品');//code值设置为1，表示成功
			}
		}

		//删除全部商品
		elseif(!empty($contentArr['all']) ){
			Db::startTrans();// 启动事务
			try{
				$result = Db::name('goods')->where('18=18')->delete();//清空数据表
				// 提交事务
				Db::commit(); 
			} catch (\Exception $e) {
				// 回滚事务
				Db::rollback();
			}
			if(!empty($result)){
				$this->clearcache();//清空缓存
				$this->returnExit($this->return,1,'成功删除'.$result.'件商品');//code值设置为1，表示成功
			}else{
				$this->returnExit($this->return,1,'暂无商品');//code值设置为1，表示成功
			}
		
		}

		//无有效参数
		else
		{
			$this->returnExit($this->return,0,'传入条件数据不正确');//code值设置为1，表示成功
		}
	}



// +----------------------------------------
// | 代理审核相关函数
// +----------------------------------------

	//获取待审核代理列表
	private function getagent()
	{
		//查询数据库
		$list = Db::name('agent')
			->field('id,name')
			->where('status',0)
			//->where('upid',null)
			//->where('wechat_pid',null)
			//->where('app_pid',null)
			->where('upid',['=',''],['EXP','IS NULL'],'or')
            ->where('wechat_pid',['=',''],['EXP','IS NULL'],'or')
			->where('app_pid',['=',''],['EXP','IS NULL'],'or')
			->select();
		//如果数组不为空
		if (!empty($list)){
			$this->returnExit($this->return,1,"获取未审核代理数据成功",$list);
		}else{
			$this->returnExit($this->return,1,"暂无未审核代理数据");
		}

	}

	//审核代理
	private function checkagent()
	{

		//获取post过来的订单内容
		$content=Request::instance()->post('content');
		if(empty($content)){
			$this->returnExit($this->return,0,"content参数不能为空");//code值设置为0，表示失败
		}
		$content=htmlspecialchars_decode($content);//把一些预定义的 HTML 实体转换为字符
		$contentArr=@json_decode($content, true);//json解码
		//判断数据是否正确
		if(empty($contentArr['id']))
		{
			$this->returnExit($this->return,0,"传入数据不正确");
		}

		$pid=(empty($contentArr['pid']))?'':$contentArr['pid'];

		//查询全局佣金比例配置
		$rate = Db::name('config')
			->where('name','AGENT_FIRST_RATE')
			->whereOr('name','AGENT_SECOND_RATE')
			->whereOr('name','AGENT_THIRD_RATE')
			->column('value','name');
		//设置审核数据
		$newdata = array(
			'status'=>1,//代理状态 1为代理，0为待审核
			'level' =>1,//代理级别 1为铜牌 2银牌 3金牌
			'agent_rate'=>$rate['AGENT_FIRST_RATE'],//一级代理分成比率
			'secondAgent_rate'=>$rate['AGENT_SECOND_RATE'],//二级代理分成比率
			'thirdAgent_rate'=>$rate['AGENT_THIRD_RATE'],//三级代理分成比率
			'upid'=>$pid,//普通pid，三段式，类似：mm_181818818_68516333_68516333格式
			'wechat_pid'=>$pid,//微信小程序pid，取普通pid一样即可
			'app_pid'=>$pid,//app应用pid，取普通pid一样即可
			'create_time'=>time(),
		);

		// 启动事务
		Db::startTrans();
		//更新数据
		try{
			$result=Db::name('agent')->where('id',$contentArr['id'])->update($newdata);
			// 提交事务
			Db::commit();
		} catch (\Exception $e) {
			// 回滚事务
			Db::rollback();
		}
		//判断结果
		if (!empty($result)){
			$this->returnExit($this->return,1,"代理审核成功");
		}else{
			$this->returnExit($this->return,1,"代理审核失败");
		}

	}



// +----------------------------------------
// | 拼多多订单同步相关函数
// +----------------------------------------
	//订单同步
	private function postpddorder()
	{
		//获取post过来的订单内容
		$content=Request::instance()->post('content');
		if(empty($content)){
			$this->returnExit($this->return,0,"content参数不能为空");//code值设置为0，表示失败
		}
		$content=htmlspecialchars_decode($content);//把一些预定义的 HTML 实体转换为字符
		$contentArr=@json_decode($content, true);//json解码

		//如果数组不为空
		if(!empty($contentArr)){
				$db = Db::name('union_order');//操作union_order表
				$resultStr="";//记录订单入库结果字符串
				//遍历订单数组
				foreach ($contentArr as $orderid => $orderdata)
				{
					//格式化订单数据
					$newdata = $this->orderFormatPdd($orderdata);
					//查询是否存在
					$goods_order_id = $db->where('goods_order',$orderid)->value('id');
					Db::startTrans();// 启动事务
					$resultValue=1;//定义存储返回结果变量
					//判断数据是否存在
					if(isset($goods_order_id)){
						//如果数据已存在,更新
						try{
							$result=$db->where('id',$goods_order_id)->update($newdata);
							// 提交事务
							Db::commit();
							$resultValue = 1;//不管数据是否有变动，都返回1
						} catch (\Exception $e) {
							// 回滚事务
							Db::rollback();
							$resultValue=0;
						}
					}else{
						//如果数据不存在,新增
						try{
							$result=$db->insert($newdata);
							// 提交事务
							Db::commit();
							$resultValue = (!empty($result)) ? 1 : 0;							
						} catch (\Exception $e) {
							// 回滚事务
							Db::rollback();
							$resultValue=0;
						}
					}

					//记录入库结果
					$resultStr=$this->resultState($resultStr,$orderid,$resultValue);
				}
				$this->returnExit($this->return,1,"result:".$resultStr);//code值设置为1，表示成功
			}else{
				$this->returnExit($this->return,0,"传入订单数据不正确");//code值设置为0，表示失败
			}
	}

	//格式化订单数据
	function orderFormatPdd($data){
		//设置订单状态
		$odtxt=$data['订单状态描述'];
		if ($odtxt == '未支付，已取消') {
			$order_status = 13;
		}elseif ($odtxt == '未支付') {
			$order_status = 13;
		}elseif ($odtxt == '已取消') {
			$order_status = 13;
		}elseif ($odtxt == '已支付') {
			$order_status = 12;
		}elseif ($odtxt == '待成团') {
			$order_status = 12;
		}elseif ($odtxt == '已成团') {
			$order_status = 12;
		}elseif ($odtxt == '确认收货') {
			$order_status = 12;
		}elseif ($odtxt == '审核通过') {
			$order_status = 12;
		}elseif ($odtxt == '审核失败') {
			$order_status = 13;
		}elseif ($odtxt == '已结算') {
			$order_status = 3;
		}elseif ($odtxt == '非多多进宝商品') {
			$order_status = 13;
		}elseif ($odtxt == '已处罚') {
			$order_status = 13;
		}else{
			$order_status = 13;
		}
		//设置结算时间
		$earning_time= (empty($data['结算时间'])) ? 0 : strtotime($data['结算时间']);

		//将数据存储到符合当前系统的新数组
		$newData=array(
			//'id'=>0,//ID
			//'uid'=>0,//认领用户ID
			'type'=>1,//订单类型 0淘宝 1拼多多 2京东
			'goods_order'=>$data['订单编号'],//订单编号
			'goods_number'=>$data['商品数'],//成交数量
			'order_status'=>$order_status,//3：订单结算12：订单付款13:订单失效	
			'title'=>$data['商品信息'],//商品标题
			'goods_id'=>$data['商品ID'],//商品ID
			'price'=>$data['商品价格'],//商品价格
			'shop_type'=>'拼多多',//订单类型
			'pay_price'=>$data['订单金额'],//付款金额
			'settlement_price'=>$data['订单金额'],//结算金额
			'commission'=>$data['预估佣金收入'],//效果预估
			'commission_rate'=>$data['佣金比例'],//佣金比率
			//'status'=>0,//状态
			//'is_receive'=>0,//提现状态 0：未提现 1：已提现
			//'second_receive'=>0,//二代提现状态
			//'third_receive'=>0,//三代提现状态
			'terminal_type'=>'无线',//成交平台
			'create_time'=>strtotime($data['创建时间']),//创建时间
			'adzone_id'=>$data['pid'],//广告位ID
			'adzone_name'=>$data['推广位名称'],//广告位名称
			'earning_time'=>$earning_time,//结算时间
		);
		return	$newData;
	}


// +----------------------------------------
// | 拼多多订单同步相关函数
// +----------------------------------------
	//订单同步
	private function postjdorder()
	{
		//获取post过来的订单内容
		$content=Request::instance()->post('content');
		if(empty($content)){
			$this->returnExit($this->return,0,"content参数不能为空");//code值设置为0，表示失败
		}
		$content=htmlspecialchars_decode($content);//把一些预定义的 HTML 实体转换为字符
		$contentArr=@json_decode($content, true);//json解码

		//如果数组不为空
		if(!empty($contentArr)){
				$db = Db::name('union_order');//操作union_order表
				$resultStr="";//记录订单入库结果字符串
				//遍历订单数组
				foreach ($contentArr as $orderid => $orderdata)
				{
					$resultValue=1;//定义存储返回结果变量
					foreach($orderdata as $data){
						//格式化订单数据
						$newdata = $this->orderFormatJd($data);
						//读取订单编号和商品id
						$orderid=$data['orderId'];
						$goodsid=$data['skuId'];
						//查询是否存在
						$goods_order_id = $db->where('goods_order',$orderid)->where('goods_id',$goodsid)->value('id');
						Db::startTrans();// 启动事务
						//判断数据是否存在
						if(isset($goods_order_id)){
							//如果数据已存在,更新
							try{
								$result=$db->where('id',$goods_order_id)->update($newdata);
								// 提交事务
								Db::commit();
								//$resultValue = 1;//不管数据是否有变动，都返回1
								$resultValue = ($resultValue==1) ? 1 : 0;//如果上次状态为1,这次也标记为1，否则设置为0
							} catch (\Exception $e) {
								// 回滚事务
								Db::rollback();
								$resultValue=0;
							}
						}else{
							//如果数据不存在,新增
							try{
								$result=$db->insert($newdata);
								// 提交事务
								Db::commit();
								if (!empty($result)) {
									//添加成功
									$resultValue = ($resultValue==1) ? 1 : 0;//如果上次状态为1,这次也标记为1，否则设置为0
								}else{
									//添加失败
									$resultValue=0;
								}						
							} catch (\Exception $e) {
								// 回滚事务
								Db::rollback();
								$resultValue=0;
							}
						}
					}
					//记录入库结果
					$resultStr=$this->resultState($resultStr,$orderid,$resultValue);
				}
				$this->returnExit($this->return,1,"result:".$resultStr);//code值设置为1，表示成功
			}else{
				$this->returnExit($this->return,0,"传入订单数据不正确");//code值设置为0，表示失败
			}
	}

	//格式化订单数据
	function orderFormatJd($data){
		//设置订单状态
		$validCode=$data['validCode'];
		if ($validCode == 16 ||$validCode == 17) {
			$order_status = 12;//订单付款
		}elseif ($validCode == 18) {
			$order_status = 3;//订单结算
		}else{
			$order_status = 13;//订单失效
		}
		//设置结算时间
		$finishTime=$data['finishTime'];//结算时间
		$finishTime=($finishTime == 0 || $finishTime == "0")?0:strtotime($finishTime);

		//将数据存储到符合当前系统的新数组
		$newData=array(
			//'id'=>0,//ID
			//'uid'=>0,//认领用户ID
			'type'=>2,//订单类型 0淘宝 1拼多多 2京东
			'goods_order'=>$data['orderId'],//订单编号
			'goods_number'=>$data['skuNum'],//成交数量
			'order_status'=>$order_status,//3：订单结算12：订单付款13:订单失效	
			'title'=>$data['skuName'],//商品标题
			'goods_id'=>$data['skuId'],//商品ID
			'price'=>$data['price'],//商品价格
			'shop_type'=>'京东',//订单类型
			'pay_price'=>$data['estimateCosPrice'],//付款金额
			'settlement_price'=>$data['actualCosPrice'],//结算金额
			'commission'=>$data['estimateFee'],//效果预估
			'commission_rate'=>$data['commissionRate'],//佣金比率
			//'status'=>0,//状态
			//'is_receive'=>0,//提现状态 0：未提现 1：已提现
			//'second_receive'=>0,//二代提现状态
			//'third_receive'=>0,//三代提现状态
			'terminal_type'=>'无线',//成交平台
			'create_time'=>strtotime($data['orderTime']),//创建时间
			'adzone_id'=>$data['positionId'],//广告位ID
			'adzone_name'=>$data['positionId'],//广告位名称
			'earning_time'=>$finishTime,//结算时间
		);
		return	$newData;
	}



// +----------------------------------------
// | 其他函数
// +----------------------------------------
	//返回json信息并退出
	private function returnExit($return,$code,$message,$data=''){
		$return['code']=$code;
		$return['message']=urlencode($message);
		if(!empty($data))	$return['data']=$data;
		exit(urldecode(json_encode($return)));
	}


	//构造返回状态结果字符串
	private function resultState($result,$id,$v){
		if (!empty($result))	$result.='|';
		$result.=$id.':'.$v;
		return	$result;
	}

	//清空缓存
	private function clearcache() {
		//清空缓存
		array_map( 'unlink', glob(RUNTIME_PATH.'/cache/*/*.php' ) );
		array_map( 'unlink', glob(RUNTIME_PATH.'/temp/*.php' ) );
	}


	/**
    *计算返利价格
    *@param $rebate['home'] 用来判断选中的限制类型 0固定金额 1百分比
    *@param $rebate['money'] 用来判断他所选中的返利类型 0固定金额 1百分比
    */
    public function createOrderLog($data){
        $uid = Db::name('User')->where('special_id',$data['special_id'])->value('id');
        $money = 0;
        $agent = Db::name('agent')->where('uid',$uid)->where('status','1')->find();
        if (!$agent) {
    		$rebateStatus = get_config('REBATE_STATUS');
    		if ($rebateStatus) {
    			$rebateMoney = get_config('REBATE_MONEY') ? get_config('REBATE_MONEY') :0;
				$agentTaobaoRate = get_config('AGENT_TAOBAO_RATE') ? (100 - get_config('AGENT_TAOBAO_RATE'))/100 : 1;
				$commission = $data['commission'] * $agentTaobaoRate;
				$money = round($commission * $rebateMoney/100,2);
    		}
        }else{
          if ($data['relation_id'] != $agent['relation_id']) {
              $uid = '0';
          }
        }
        $rod = [];
        $rod['money'] = $money;
        $rod['uid'] = $uid;
        return $rod;
    }
    //推广位名称
    public function getAdzoneName($relation_id){
      $name ='';
      if ($relation_id) {
        $name = Db::name('agent')->where('relation_id',$relation_id)->value('name');
        if (!$name) {
           $name = '渠道&会员';
        }
      }
      return $name;
    }


    //$data 订单数据
    //$type $type 1淘宝/天猫 2拼多多 3京东
   public function pushOrder($data,$type){
      
        //判断订单是否是代理订单
        $extra = [
            'orderId' => $data['goods_order'],
            'orderType' => $data['shop_type'],
            'orderPrice' => round($data['pay_price'],2),
        ];
        // 判断订单是否村在
        $hasGoodsOrder = Db::name('PushLog')->where('extra','like','%'.$data['goods_order'].'%')->find();
        if($hasGoodsOrder){
            return;
        }

        if (isset($data['uid']) && $data['uid']) {
            $uid = $data['uid'];
        }
        if (isset($data['special_id']) && $data['special_id']) {
            $uid = Db::name('User')->where('special_id',$data['special_id'])->value('id');
        }
      
        if($uid){
            $money = new \app\common\controller\Money();
            $extra['money'] = $money->earnMoney2($data['commission']*100,$uid,$type);
            $extra['fansName'] =  Db::name('User')->where('id',$uid)->value('username');
            $extra['time'] =  $data['create_time'];
            push_log('buy',$uid,$extra); //自购推送
            $userPid = Db::name('User')->where('id',$uid)->value('pid');
        
            if ($userPid) {
                $agentinfo = Db::name('Agent')->where('uid',$uid)->find();//代理信息
                if ($agentinfo) {
                    $a = '2';
                    $pid = $agentinfo['pid'];
                }else{
                    $a = '1';
                    $pid = Db::name('Agent')->where('uid',$userPid)->value('id');//代理信息
                }
                if ($pid) {
                    $this->pushLog($data['commission'],$pid,$a,$data['create_time'],$extra);      //执行推送
                }
                
            }
        }
    }


    // 订单代理推送消息
    // $a  1： 一带关系 2：二代关系 3：三代关系  
    //$id 代理id；
    //$goodCommission 订单佣金；
     public function pushLog($goodCommission,$id,$a,$time,$extra){
        $agentinfo = Db::name('Agent')->where('id',$id)->find();//代理信息
        if (!$agentinfo) {
            return;
        }
        $channel = get_config('AGENT_CHANNEL_MEMBER');
        if ($channel) {
            switch ($a) {
                case '1':
                    $agentRate = get_config('AGENT_FIRST_RATE');
                    break;
                case '2':
                    $agentRate = get_config('AGENT_SECOND_RATE');
                    break;
                case '3':
                    $agentRate = get_config('AGENT_THIRD_RATE');
                    break;
            }
        }else{
            switch ($a) {
                case '1':
                    if($agent['agent_rate'])
                    { 
                        $agentRate = $agent['agent_rate'];
                    }else{
                        $agentRate = get_config('AGENT_FIRST_RATE');
                    }
                   
                    break;
                case '2':
                    if($agent['secondAgent_rate'])
                    { 
                        $agentRate = $agent['secondAgent_rate'];
                    }else{
                        $agentRate = get_config('AGENT_SECOND_RATE');
                    }
                    break;
                case '3':
                    if($agent['thirdAgent_rate'])
                    { 
                        $agentRate = $agent['thirdAgent_rate'];
                    }else{
                        $agentRate = get_config('AGENT_THIRD_RATE');
                    }
                    break;
            }
        }
        $taobaoRate = get_config('AGENT_TAOBAO_RATE') ? (100 - get_config('AGENT_TAOBAO_RATE'))/100 : 1;
        $commission = round($goodCommission * $taobaoRate * $agentRate * 0.98/100,2);

        $extra['money']     = $commission;
        $extra['level']     = $a;
        push_log('fanBuy',$agentinfo['uid'],$extra); //推送
        $a++;
        //根据uid 在User表中查找上级uid
        if ($agentinfo['pid']) {
            $this->pushLog($goodCommission,$agentinfo['pid'],$a,$time,$extra);
        }
    }

}