<?php
// +------------------------------------------------------------------------------------------------
// | 【使用说明】请将本文件上传至网站服务器：/app/Lib/Action/index  目录下。
// +------------------------------------------------------------------------------------------------
// | [18淘客助手api文件(杨他他淘宝客专用)] Copyright (c) 2018 18.LA
// +------------------------------------------------------------------------------------------------
// | 最后修改：2018年8月1日
// +------------------------------------------------------------------------------------------------
// | 官网：http://taoke.18.la/
// +------------------------------------------------------------------------------------------------
class apiAction extends FirstendAction {
    //定义返回数据
	private $return  = array('state'=>'ok','code'=>1,'message'=>'','version'=>'1.0');
  
    public function _initialize() {
        parent::_initialize();
		$this->_mod = D('fan_trade');
    }
  
	public function index(){
		$this->return['system']=urlencode('杨他他淘宝客');//系统名称
		$this->return['updatetime']=urlencode('2018年8月1日');//最后修改日期
      
      	//验证key
		$this->verify();
      
		//读取api参数
		$api=I('post.api');

		//订单同步
		if($api=='postorder'){
			$this->postorder();
		}
      
		$this->returnExit($this->return,0,"未传入有效API参数");//code值设置为0，表示失败
	}

// +----------------------------------------
// | 接口验证相关函数
// +----------------------------------------
	//接口验证
	private function verify()
	{
		//读取post的基础参数

		$api=I('post.api');//api名称
		$getkey=I('post.key');

		//如果未传入有效参数
		if (empty($getkey) || empty($api)) {
			$this->returnExit($this->return,0,"API接口正常");//code值设置为0，表示失败
		}

		//读取网站授权码
      	$settingdata=D('setting')->where(array('name' => 'site_token'))->find();
		$web_auth_code = $settingdata['data'];
      
		//处理字符串
		$getkey=trim($getkey);
		$getkey=strtoupper($getkey);
		$web_auth_code=trim($web_auth_code);
		$web_auth_code=strtoupper($web_auth_code);

		//判断密钥是否正确
		if($getkey!=$web_auth_code){
			$this->returnExit($this->return,0,"密钥错误");//code值设置为0，表示失败
		}
		
		//接口验证
		if($api=='verify'){
			$this->returnExit($this->return,1,"验证成功");//code值设置为1，表示成功
		}
	}

  
// +----------------------------------------
// | 订单同步相关函数
// +----------------------------------------
	//订单同步
	private function postorder()
	{
		//获取post过来的订单内容
		$content=I('post.content');
		if(empty($content)){
			$this->returnExit($this->return,0,"content参数不能为空");//code值设置为0，表示失败
		}
		$content=htmlspecialchars_decode($content);//把一些预定义的 HTML 实体转换为字符
		$contentArr=@json_decode($content, true);//json解码

		//如果数组不为空
		if(!empty($contentArr)){
				//将订单数据以订单号和商品ID做键值，保存到新数组
				$contentArr=$this->orderOnly($contentArr);
				//$db = D('fan_trade');//操作fan_trade表
				$db = M('fan_trade');//操作fan_trade表
				//遍历订单数组
				foreach($contentArr as $orderData)
				{
					//判断是否为空数组
					if(count($orderData)<1){
						continue;
					}

					//读取订单编号和商品id
					$orderid=$orderData[0]['订单编号'];
					$goodsid=$orderData[0]['商品ID'];

					//查询是否存在
					$goods_order_id = $db->where(array('tb_yid' => $orderid))->where(array('num_iid' => $goodsid))->getField('id',true);

					//遍历数组
					$id=0;
					$resultValue=1;
					foreach($orderData as $data){
                      	//过滤非结算订单
                      	if($data['订单状态']!='订单结算')
                        {
                          	$resultValue = ($resultValue==1) ? 1 : 0;//非结算订单直接标记为成功
                        	continue;
                        }
						
						//过滤维权订单
                      	if(strpos($data['维权状态'],"维权创建") !== false || strpos($data['维权状态'],"等待处理") !== false || strpos($data['维权状态'],"维权成功") !== false)
                        {
                          	$resultValue = ($resultValue==1) ? 1 : 0;//非结算订单直接标记为成功
                        	continue;
                        }
                      
						//格式化订单数据
						$newdata=$this->orderFormat($data);
                      
     					$db->startTrans();// 启动事务
                      
						//判断数据是否存在
						if(isset($goods_order_id[$id])){
							//如果数据已存在,更新
							try{
								$result=$db->where(array('id' => $goods_order_id[$id]))->save($newdata);
								// 提交事务
								$db->commit();
								$resultValue = ($resultValue==1) ? 1 : 0;//如果上次状态为1,这次也标记为1，否则设置为0
							} catch (\Exception $e) {
								// 回滚事务
								$db->rollback();
								$resultValue=0;
							}
						}else{
							//如果数据不存在,新增
							try{
								//print_r($newdata);
								$result=$db->add($newdata);
								// 提交事务
								$db->commit();
								if (!empty($result)) {
									//添加成功
									$resultValue = ($resultValue==1) ? 1 : 0;//如果上次状态为1,这次也标记为1，否则设置为0
								}else{
									//添加失败
									$resultValue=0;
								}
								
							} catch (\Exception $e) {
								// 回滚事务
								$db->rollback();
								$resultValue=0;
							}
						}
                      
						$id++;
					}
					//记录入库结果
					$resultStr=$this->resultState($resultStr,$orderid,$resultValue);
				}
				$this->returnExit($this->return,1,"result:".$resultStr);//code值设置为1，表示成功
			}else{
				$this->returnExit($this->return,0,"传入商品数据不正确");//code值设置为0，表示失败
			}
	}
  
  
	//将订单数据以订单号和商品ID做键值，保存到新数组
	private function orderOnly($contentArr)	
	{
		//遍历订单数组
		foreach($contentArr as $orderID=>$orderData)
		{
				foreach($orderData as $data){
					$key=$data['订单编号'].'_'.$data['商品ID'];
					$newData[$key][]=$data;
				}
		}
		return $newData;
	}


	//格式化订单数据
	function orderFormat($data){
		//将数据存储到符合当前系统的新数组
		$newData=array(
			//'id'=>0,// int(10) NOT NULL AUTO_INCREMENT,  ID序号
			'uid'=>0,// int(10) DEFAULT NULL,            用户UID  
			'tb_yid'=>$data['订单编号'],// varchar(30) NOT NULL,         订单号
			'tb_uid'=>$this->ordertbuid($data['订单编号']),// varchar(6) NOT NULL,          用户绑定淘宝账号后六位和订单号后六位（订单号后六位顺序颠倒）
			'type'=>'taoke',// varchar(10) NOT NULL,           订单类型
			//'memberid'=>'',// varchar(20) NOT NULL,       不同联盟账号ID
			'terminaltype'=>$data['成交平台'],// varchar(10) NOT NULL,   平台类型
			'createtime'=>$data['创建时间'],// varchar(20) NOT NULL,      订单创建时间  
			'earningtime'=>$data['结算时间'],// varchar(20) DEFAULT NULL,  订单结算时间
			'num_iid'=>$data['商品ID'],// varchar(15) NOT NULL,     产品ID
			'sharerate'=>$data['分成比率'],// varchar(10) NOT NULL,   分成比率
			'title'=>$data['商品信息'],// varchar(50) NOT NULL,   产品标题
			'itemnum'=>$data['商品数'],// tinyint(10) NOT NULL,  产品数量
			'commission'=>$data['佣金金额'],// decimal(11,2) NOT NULL,  佣金
			'yugu'=>$data['效果预估'],// decimal(11,2) NOT NULL,   预估
			'payprice'=>$data['付款金额'],// decimal(11,2) NOT NULL,  实付
			//'sellerId'=>'',// varchar(15) NOT NULL,  卖家数字ID
			'comm_rate'=>$data['佣金比率'],// varchar(10) NOT NULL,  佣金比率
			'paystatus'=>'3',// tinyint(2) NOT NULL,  结算状态 3：代表订单结算
			'shop_title'=>$data['所属店铺'],// varchar(20) NOT NULL,  店铺名称
			'nick'=>$data['掌柜旺旺'],// varchar(20) NOT NULL,  掌柜名称
			'add_time'=>time(),// int(10) NOT NULL,  添加时间
		);

		return	$newData;
	}
  
	//根据订单ID计算符合杨他他规则的淘宝uid数据
	function ordertbuid($orderid){
		return substr($orderid,-6,2).substr($orderid,-2).substr($orderid,-4,2);//取订单ID后6位，然后3-4位和5-6位调换位置
	}
  
// +----------------------------------------
// | 其他函数
// +----------------------------------------
	//返回json信息并退出
	private function returnExit($return,$code,$message,$data=''){
		$return['code']=$code;
		$return['message']=urlencode($message);
		if(!empty($data))	$return['data']=$data;
		exit(urldecode(json_encode($return)));
	}


	//构造返回状态结果字符串
	private function resultState($result,$id,$v){
		if (!empty($result))	$result.='|';
		$result.=$id.':'.$v;
		return	$result;
	}
  
  


}