/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.theTitans;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.item.Item;
import net.minecraft.theTitans.CommandClearMinions;
import net.minecraft.theTitans.CommonProxy;
import net.minecraft.theTitans.TitanItems;
import net.minecraft.theTitans.TitanStructureGenerator;
import net.minecraft.theTitans.TitansAchievments;
import net.minecraft.theTitans.TitansOreGeneration;
import net.minecraft.theTitans.ench.EnchantmentDurability;
import net.minecraft.theTitans.ench.EnchantmentFerocity;
import net.minecraft.theTitans.ench.EnchantmentKnockup;
import net.minecraft.theTitans.ench.EnchantmentManiac;
import net.minecraft.theTitans.ench.EnchantmentShurakin;
import net.minecraft.theTitans.ench.EnchantmentTitanSlayer;
import net.minecraft.theTitans.ench.EnchantmentUnstablility;
import net.minecraft.theTitans.world.BiomeGenNowhere;
import net.minecraft.theTitans.world.BiomeGenVoid;
import net.minecraft.theTitans.world.WorldProviderNowhere;
import net.minecraft.theTitans.world.WorldProviderVoid;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Logger;

@Mod(modid="thetitans", name="The Titans Mod", version="0.425")
public class TheTitans {
    public static final String MODNAME = "The Titans Mod";
    public static final String MODID = "thetitans";
    public static final String VERSION = "0.45";
    public static final String CLIENT = "net.minecraft.theTitans.ClientProxy";
    public static final String SERVER = "net.minecraft.theTitans.ServerProxy";
    public static final ResourceLocation genericTitanWhiteTexture32x64 = new ResourceLocation("thetitans", "textures/entities/32x64_disintigration.png");
    public static final ResourceLocation genericTitanWhiteTexture64x64 = new ResourceLocation("thetitans", "textures/entities/64x64_disintigration.png");
    @SidedProxy(clientSide="net.minecraft.theTitans.ClientProxy", serverSide="net.minecraft.theTitans.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Metadata
    public static ModMetadata meta;
    @Mod.Instance(value="thetitans")
    public static TheTitans modInstance;
    public static final CreativeTabs titansTab;
    public static final BiomeGenBase voidland;
    public static final BiomeGenBase nowhere;
    private Logger logger;
    public static final int VOID_DIMENSION_ID = 200;
    public static final int NOWHERE_DIMENSION_ID = 201;
    public static final Enchantment turretEnchant1;
    public static final Enchantment turretEnchant2;
    public static final Enchantment turretEnchant3;
    public static final Enchantment turretEnchant4;
    public static final Enchantment turretEnchant5;
    public static final Enchantment titanSlaying;
    public static final Enchantment hammer;
    public static int OmegafishMinionSpawnrate;
    public static int SpiderTitanMinionSpawnrate;
    public static int CaveSpiderTitanMinionSpawnrate;
    public static int SlimeTitanMinionSpawnrate;
    public static int MagmaCubeTitanMinionSpawnrate;
    public static int ZombieTitanMinionSpawnrate;
    public static int PigZombieTitanMinionSpawnrate;
    public static int SkeletonTitanMinionSpawnrate;
    public static int CreeperTitanMinionSpawnrate;
    public static int BlazeTitanMinionSpawnrate;
    public static int WitherSkeletonTitanMinionSpawnrate;
    public static int EnderColossusMinionSpawnrate;
    public static int GhastTitanMinionSpawnrate;
    public static int WitherzillaMinionSpawnrate;
    public static int UltimaIronGolemMinionSpawnrate;
    public static int SnowGolemMinionSpawnrate;
    public static boolean NightmareMode;
    public static boolean TitansFFAMode;
    public static TitanStructureGenerator mStructureGenerator;

    public static BiomeGenBase[] getExludedBiomes() {
        return new BiomeGenBase[]{BiomeGenBase.field_76778_j, BiomeGenBase.field_76779_k, voidland, nowhere};
    }

    public static BiomeGenBase[] getExludedBiomesButHell() {
        return new BiomeGenBase[]{BiomeGenBase.field_76779_k, voidland, nowhere};
    }

    public static BiomeGenBase[] getExludedBiomesButEnd() {
        return new BiomeGenBase[]{BiomeGenBase.field_76778_j, voidland, nowhere};
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        this.logger = e.getModLog();
        proxy.preInit(e);
        this.logger.info("Loading The Titans...");
        this.logger.debug("Pre Initialization started!");
        Configuration config = new Configuration(e.getSuggestedConfigurationFile());
        config.load();
        NightmareMode = config.get("general", "Nightmare Mode", false).getBoolean(NightmareMode);
        OmegafishMinionSpawnrate = config.get("general", "OmegafishMinionSpawnrate", 10).getInt();
        SpiderTitanMinionSpawnrate = config.get("general", "SpiderTitanMinionSpawnrate", 15).getInt();
        CaveSpiderTitanMinionSpawnrate = config.get("general", "CaveSpiderTitanMinionSpawnrate", 15).getInt();
        SlimeTitanMinionSpawnrate = config.get("general", "SlimeTitanMinionSpawnrate", 30).getInt();
        MagmaCubeTitanMinionSpawnrate = config.get("general", "MagmaCubeTitanMinionSpawnrate", 30).getInt();
        ZombieTitanMinionSpawnrate = config.get("general", "ZombieTitanMinionSpawnrate", 5).getInt();
        PigZombieTitanMinionSpawnrate = config.get("general", "PigZombieTitanMinionSpawnrate", 20).getInt();
        SkeletonTitanMinionSpawnrate = config.get("general", "SkeletonTitanMinionSpawnrate", 15).getInt();
        CreeperTitanMinionSpawnrate = config.get("general", "CreeperTitanMinionSpawnrate", 20).getInt();
        BlazeTitanMinionSpawnrate = config.get("general", "BlazeTitanMinionSpawnrate", 10).getInt();
        WitherSkeletonTitanMinionSpawnrate = config.get("general", "WitherSkeletonTitanMinionSpawnrate", 15).getInt();
        GhastTitanMinionSpawnrate = config.get("general", "GhastTitanMinionSpawnrate", 15).getInt();
        EnderColossusMinionSpawnrate = config.get("general", "EnderColossusMinionSpawnrate", 10).getInt();
        WitherzillaMinionSpawnrate = config.get("general", "WitherzillaMinionSpawnrate", 15).getInt();
        UltimaIronGolemMinionSpawnrate = config.get("general", "UltimaIronGolemMinionSpawnrate", 20).getInt();
        SnowGolemMinionSpawnrate = config.get("general", "SnowGolemMinionSpawnrate", 20).getInt();
        config.save();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new TitansOreGeneration(), (int)100);
        this.logger.debug("Finished pre-init for The Titans!");
        DimensionManager.registerProviderType((int)200, WorldProviderVoid.class, (boolean)false);
        DimensionManager.registerDimension((int)200, (int)200);
        DimensionManager.registerProviderType((int)201, WorldProviderNowhere.class, (boolean)false);
        DimensionManager.registerDimension((int)201, (int)201);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandClearMinions());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        proxy.init(e);
        proxy.registerRenders();
        this.logger.debug("Initialization started!");
        GameRegistry.registerWorldGenerator((IWorldGenerator)mStructureGenerator, (int)0);
        TitansAchievments.addAchievments();
        Enchantment.addToBookList((Enchantment)turretEnchant1);
        Enchantment.addToBookList((Enchantment)turretEnchant2);
        Enchantment.addToBookList((Enchantment)turretEnchant3);
        Enchantment.addToBookList((Enchantment)turretEnchant4);
        Enchantment.addToBookList((Enchantment)turretEnchant5);
        Enchantment.addToBookList((Enchantment)titanSlaying);
        Enchantment.addToBookList((Enchantment)hammer);
        BiomeGenBase.field_150597_n.remove(voidland);
        BiomeGenBase.field_150597_n.remove(nowhere);
        this.logger.debug("Finished init for The Titans!");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.postInit(e);
        this.logger.debug("Post Initialization started!");
        proxy.registerRenderThings();
        proxy.registerItemRenderers();
        this.logger.debug("Finished post-init for The Titans!");
        this.logger.info("Finished The Titans!");
    }

    static {
        titansTab = new CreativeTabs(MODID){

            public Item func_78016_d() {
                return TitanItems.growthSerum;
            }
        };
        voidland = new BiomeGenVoid(150).func_76739_b(986895).func_76735_a("Void Island").func_76745_m().func_76732_a(2.0f, 0.0f);
        nowhere = new BiomeGenNowhere(151).func_76739_b(3278130).func_76735_a("The Nowhere").func_76745_m().func_76732_a(0.0f, 0.0f);
        turretEnchant1 = new EnchantmentDurability(249, new ResourceLocation("healing"), 10, EnumEnchantmentType.weapon);
        turretEnchant2 = new EnchantmentFerocity(250, new ResourceLocation("damage"), 10, EnumEnchantmentType.weapon);
        turretEnchant3 = new EnchantmentManiac(251, new ResourceLocation("shootingSpeed"), 5, EnumEnchantmentType.weapon);
        turretEnchant4 = new EnchantmentUnstablility(252, new ResourceLocation("explosivePower"), 2, EnumEnchantmentType.weapon);
        turretEnchant5 = new EnchantmentShurakin(253, new ResourceLocation("skullSpeed"), 1, EnumEnchantmentType.weapon);
        titanSlaying = new EnchantmentTitanSlayer(254, new ResourceLocation("titankiller"), 10);
        hammer = new EnchantmentKnockup(255, new ResourceLocation("hammer"), 5);
        TitansFFAMode = false;
        mStructureGenerator = new TitanStructureGenerator();
    }
}

