/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titanminion;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.entity.titan.EntityCaveSpiderTitan;
import net.minecraft.entity.titan.EntitySpiderTitan;
import net.minecraft.entity.titan.EntityTitan;
import net.minecraft.entity.titan.EntityTitanSpirit;
import net.minecraft.entity.titan.ITitan;
import net.minecraft.entity.titan.ai.EntityAIBreakDoorMinion;
import net.minecraft.entity.titan.ai.EntityAINearestTargetTitan;
import net.minecraft.entity.titanminion.EntitySkeletonLoyalist;
import net.minecraft.entity.titanminion.EnumMinionType;
import net.minecraft.entity.titanminion.IMinion;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.theTitans.TheTitans;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;

public class EntitySpiderLoyalist
extends EntitySpider
implements IMinion {
    public EntityLiving master;
    public boolean isSpeedy;
    public boolean isStrong;
    public boolean isPredator;
    public boolean isWolverine;
    public boolean isSuperSwimmer;
    public boolean isLavaSwimmer;
    public boolean isJumper;
    public boolean isHealthy;
    public boolean isShielded;
    public boolean isTough;
    public int randomSoundDelay;

    public EntitySpiderLoyalist(World worldIn) {
        super(worldIn);
        this.func_70661_as().func_75498_b(true);
        this.func_70661_as().func_75490_c(true);
        this.func_70661_as().func_75495_e(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityWitherSkull.class, 2.0f, 1.2, 1.75));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityTitanSpirit.class, 48.0f, 1.5, 1.5));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIBreakDoorMinion((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.2, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        if (TheTitans.TitansFFAMode) {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan((EntityCreature)this, EntityLivingBase.class, 0, false, false, ITitan.SpiderTitanSorter));
        } else {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan((EntityCreature)this, EntityLivingBase.class, 0, false, false, ITitan.SearchForAThingToKill));
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.master != null && this.master instanceof EntityTitan) {
            ((EntityTitan)this.master).retractMinionNumFromType(this.getMinionType());
        }
    }

    @Override
    public EnumMinionType getMinionType() {
        return EnumMinionType.LOYALIST;
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.isSpeedy = tagCompund.func_74767_n("Speedy");
        this.isStrong = tagCompund.func_74767_n("Strong");
        this.isPredator = tagCompund.func_74767_n("Predator");
        this.isWolverine = tagCompund.func_74767_n("Wolverine");
        this.isSuperSwimmer = tagCompund.func_74767_n("SuperSwimmer");
        this.isLavaSwimmer = tagCompund.func_74767_n("LavaSwimmer");
        this.isJumper = tagCompund.func_74767_n("Jumper");
        this.isHealthy = tagCompund.func_74767_n("Healthy");
        this.isShielded = tagCompund.func_74767_n("Shielded");
        this.isTough = tagCompund.func_74767_n("Tough");
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("Speedy", this.isSpeedy);
        tagCompound.func_74757_a("Strong", this.isStrong);
        tagCompound.func_74757_a("Predator", this.isPredator);
        tagCompound.func_74757_a("Wolverine", this.isWolverine);
        tagCompound.func_74757_a("SuperSwimmer", this.isSuperSwimmer);
        tagCompound.func_74757_a("LavaSwimmer", this.isLavaSwimmer);
        tagCompound.func_74757_a("Jumper", this.isJumper);
        tagCompound.func_74757_a("Healthy", this.isHealthy);
        tagCompound.func_74757_a("Shielded", this.isShielded);
        tagCompound.func_74757_a("Tough", this.isTough);
    }

    protected void func_70069_a(float p_70069_1_) {
        this.field_70701_bs = 0.0f;
        this.field_70702_br = 0.0f;
        if ((p_70069_1_ = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)p_70069_1_)) <= 0.0f) {
            return;
        }
        PotionEffect potioneffect = this.func_70660_b(Potion.field_76430_j);
        float f1 = potioneffect != null ? (float)(potioneffect.func_76458_c() + 1) : 0.0f;
        int i = MathHelper.func_76123_f((float)(p_70069_1_ - 3.0f - f1));
        if (i > 0) {
            this.func_85030_a(this.func_146067_o(i), 1.0f, 1.0f);
            int j = MathHelper.func_76128_c((double)this.field_70165_t);
            int k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - (double)this.field_70129_M));
            int l = MathHelper.func_76128_c((double)this.field_70161_v);
            Block block = this.field_70170_p.func_147439_a(j, k, l);
            if (block.func_149688_o() != Material.field_151579_a) {
                Block.SoundType soundtype = block.field_149762_H;
                this.func_85030_a(soundtype.func_150498_e(), soundtype.func_150497_c() * 0.5f, soundtype.func_150494_d() * 0.75f);
            }
        }
    }

    public int func_70627_aG() {
        return this.isPredator ? 600 : 80;
    }

    protected String func_70639_aQ() {
        return this.isPredator ? "thetitans:predatorSpider" : "mob.spider.say";
    }

    protected float func_70647_i() {
        return this.isSpeedy || this.isJumper ? (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.5f : (this.isTough || this.isStrong ? (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.8f : super.func_70647_i());
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public boolean func_70686_a(Class p_70686_1_) {
        return p_70686_1_ != EntitySpiderLoyalist.class && (p_70686_1_ == EntityCaveSpiderTitan.class || p_70686_1_ != EntitySpiderTitan.class);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (source.func_76346_g() instanceof EntitySpiderLoyalist || source.func_76346_g() instanceof EntitySpiderTitan && !(source.func_76346_g() instanceof EntityCaveSpiderTitan)) {
            return false;
        }
        if (source.func_76346_g() != null && this.field_70702_br == 0.0f && this.getMinionType() == EnumMinionType.ZEALOT) {
            this.field_70761_aq = this.field_70177_z = this.field_70759_as;
            this.func_85030_a("thetitans:titanSwing", 1.0f, 2.0f);
            switch (this.field_70146_Z.nextInt(3)) {
                case 0: {
                    this.field_70701_bs = -2.0f;
                    this.func_70060_a(0.0f, -2.0f, 0.99f);
                    this.field_70702_br = 0.01f;
                    break;
                }
                case 1: {
                    this.field_70702_br = 1.0f;
                    this.func_70060_a(1.0f, 0.0f, 0.25f);
                    break;
                }
                case 2: {
                    this.field_70702_br = -1.0f;
                    this.func_70060_a(-1.0f, 0.0f, 0.25f);
                }
            }
            this.func_70664_aZ();
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityLivingBase) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(32.0, 32.0, 32.0));
            for (int i = 0; i < list.size(); ++i) {
                Entity entity1 = (Entity)list.get(i);
                if (entity1 instanceof EntitySpiderLoyalist) {
                    EntitySpiderLoyalist entitypigzombie = (EntitySpiderLoyalist)entity1;
                    entitypigzombie.func_70624_b((EntityLivingBase)entity);
                    entitypigzombie.func_70604_c((EntityLivingBase)entity);
                    entitypigzombie.randomSoundDelay = this.field_70146_Z.nextInt(40);
                }
                this.func_70624_b((EntityLivingBase)entity);
                this.func_70604_c((EntityLivingBase)entity);
                this.randomSoundDelay = this.field_70146_Z.nextInt(40);
            }
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        super.func_70628_a(p_70628_1_, p_70628_2_);
        int j = this.field_70146_Z.nextInt(3 + p_70628_2_);
        for (int k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151081_bc, 1);
        }
        if (this.field_70146_Z.nextInt(60) == 0 || this.field_70146_Z.nextInt(1 + p_70628_2_) > 0) {
            this.func_70099_a(new ItemStack(Blocks.field_150321_G), 0.0f);
        }
    }

    protected void func_70664_aZ() {
        this.field_70181_x += 0.6;
        if (this.func_70644_a(Potion.field_76430_j)) {
            this.field_70181_x += (double)((float)(this.func_70660_b(Potion.field_76430_j).func_76458_c() + 1) * 0.1f);
        }
        if (this.isJumper) {
            this.field_70181_x += 0.6;
            float f = this.field_70177_z * ((float)Math.PI / 180);
            this.field_70159_w -= (double)(MathHelper.func_76126_a((float)f) * 0.2f);
            this.field_70179_y += (double)(MathHelper.func_76134_b((float)f) * 0.2f);
        }
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    protected void func_70619_bc() {
        if (this.randomSoundDelay > 0 && --this.randomSoundDelay == 0) {
            this.func_85030_a(this.func_70621_aR(), this.func_70599_aP(), this.func_70647_i() + 0.25f);
        }
        if (this.isPredator) {
            this.func_82142_c(true);
        }
        if (this.func_70090_H() && this.isSuperSwimmer) {
            this.field_70159_w *= 1.25;
            this.field_70181_x *= 1.25;
            this.field_70179_y *= 1.25;
            if (this.field_70173_aa % 20 == 0) {
                this.func_70691_i(1.0f);
            }
        }
        if (!this.func_70058_J() && this.isLavaSwimmer) {
            this.func_70066_B();
        }
        if (this.func_70058_J() && this.isLavaSwimmer) {
            this.field_70159_w *= 2.0;
            this.field_70181_x *= 2.0;
            this.field_70179_y *= 2.0;
            if (this.field_70173_aa % 5 == 0) {
                this.func_70691_i(1.0f);
            }
        }
        if (this.isHealthy) {
            this.func_70031_b(true);
        }
        if (this.isShielded && this.func_110139_bj() > 0.0f) {
            this.field_110153_bc = 300.0f;
            this.field_70771_an = 30;
        }
        if (this.isWolverine && this.field_70173_aa % 5 == 0) {
            this.func_70691_i(1.0f);
        }
        if (this.isTough) {
            this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        }
        this.field_70138_W = 1.0f;
        this.func_70839_e(this.field_70123_F);
        if (this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() != null) {
            float f2;
            double d1;
            if (this.isPredator && this.func_70638_az().func_70068_e((Entity)this) < 25.0 && this.field_70146_Z.nextInt(10) == 0) {
                double d3;
                double d2;
                Vec3 vec3 = Vec3.func_72443_a((double)(this.field_70165_t - this.func_70638_az().field_70165_t), (double)(this.field_70121_D.field_72338_b + (double)(this.field_70131_O / 2.0f) - this.func_70638_az().field_70163_u + (double)this.func_70638_az().func_70047_e()), (double)(this.field_70161_v - this.func_70638_az().field_70161_v));
                vec3 = vec3.func_72432_b();
                double d0 = 16.0;
                double d12 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72450_a * d0;
                EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, d12, d2 = (double)this.field_70170_p.func_72825_h((int)d12, (int)(d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72449_c * d0)), d3, 0.0f);
                if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                    this.func_70652_k((Entity)this.func_70638_az());
                    this.field_70165_t = event.targetX;
                    this.field_70163_u = event.targetY;
                    this.field_70161_v = event.targetZ;
                    this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                }
            }
            if (this.func_70638_az().func_70068_e((Entity)this) < 256.0 && this.func_70638_az().func_70068_e((Entity)this) > 9.0 && this.field_70146_Z.nextInt(10) == 0 && this.field_70122_E) {
                double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
                f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                if (this.isSpeedy) {
                    this.field_70159_w = d0 / (double)f2 * 2.0;
                    this.field_70179_y = d1 / (double)f2 * 2.0;
                } else {
                    this.field_70159_w = d0 / (double)f2 * 0.75;
                    this.field_70179_y = d1 / (double)f2 * 0.75;
                }
                this.func_70664_aZ();
                this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 180.0f, 30.0f);
                this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), 1.0);
            }
            if (!this.func_70685_l((Entity)this.func_70638_az())) {
                double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
                f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                if (this.isSpeedy) {
                    this.field_70159_w = d0 / (double)f2 * 1.0;
                    this.field_70179_y = d1 / (double)f2 * 1.0;
                } else {
                    this.field_70159_w = d0 / (double)f2 * 0.35;
                    this.field_70179_y = d1 / (double)f2 * 0.35;
                }
            }
        }
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) > 256.0) {
            this.func_70605_aq().func_75642_a(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 1.0);
        }
        if (this.master != null) {
            if (this.func_70068_e((Entity)this.master) > 2304.0) {
                this.func_70605_aq().func_75642_a(this.master.field_70165_t, this.master.field_70163_u, this.master.field_70161_v, 2.0);
            }
            if (this.master.func_70638_az() != null && this.master.func_70638_az().field_70131_O < 4.0f) {
                this.func_70624_b(this.master.func_70638_az());
            }
        } else {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(100.0, 100.0, 100.0));
            if (list != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    Entity entity = (Entity)list.get(i1);
                    if (entity == null || !(entity instanceof EntitySpiderTitan) || !(((EntitySpiderTitan)entity).createInstance() instanceof EntitySpiderLoyalist)) continue;
                    this.master = (EntitySpiderTitan)entity;
                }
            }
        }
        super.func_70619_bc();
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        if (this.isStrong) {
            p_70652_1_.field_70181_x += 0.6;
            this.func_85030_a("mob.irongolem.throw", 1.0f, 1.0f);
        }
        return super.func_70652_k(p_70652_1_);
    }

    public IEntityLivingData func_110161_a(IEntityLivingData p_110161_1_) {
        if (this.field_70170_p.field_73012_v.nextInt(100) == 0) {
            EntitySkeletonLoyalist entityskeleton = new EntitySkeletonLoyalist(this.field_70170_p);
            entityskeleton.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            entityskeleton.func_110161_a(null);
            this.field_70170_p.func_72838_d((Entity)entityskeleton);
            entityskeleton.func_70078_a((Entity)this);
        }
        if (this.field_70146_Z.nextInt(this.field_70170_p.field_73013_u == EnumDifficulty.NORMAL ? 25 : (this.field_70170_p.field_73013_u == EnumDifficulty.HARD ? 2 : 500)) == 0) {
            switch (this.field_70146_Z.nextInt(10)) {
                case 0: {
                    this.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, Integer.MAX_VALUE, 1));
                    this.isSpeedy = true;
                    break;
                }
                case 1: {
                    this.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, Integer.MAX_VALUE, 4));
                    this.isStrong = true;
                    break;
                }
                case 2: {
                    this.func_70690_d(new PotionEffect(Potion.field_76441_p.field_76415_H, Integer.MAX_VALUE, 0, false));
                    this.isPredator = true;
                    break;
                }
                case 3: {
                    this.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, Integer.MAX_VALUE, 9));
                    this.isWolverine = true;
                    break;
                }
                case 4: {
                    this.func_70690_d(new PotionEffect(Potion.field_76427_o.field_76415_H, Integer.MAX_VALUE, 0));
                    this.isSuperSwimmer = true;
                    break;
                }
                case 5: {
                    this.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, Integer.MAX_VALUE, 0));
                    this.isLavaSwimmer = true;
                    break;
                }
                case 6: {
                    this.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, Integer.MAX_VALUE, 2));
                    this.isJumper = true;
                    break;
                }
                case 7: {
                    this.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 100, 9));
                    this.func_70690_d(new PotionEffect(Potion.field_76434_w.field_76415_H, Integer.MAX_VALUE, 9));
                    this.isHealthy = true;
                    break;
                }
                case 8: {
                    this.func_70690_d(new PotionEffect(Potion.field_76444_x.field_76415_H, Integer.MAX_VALUE, 9));
                    this.isShielded = true;
                    break;
                }
                case 9: {
                    this.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, Integer.MAX_VALUE, 2));
                    this.isTough = true;
                }
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextGaussian() * 0.05, 1));
        return p_110161_1_;
    }

    public static class GroupData
    implements IEntityLivingData {
        public int field_111105_a;

        public void func_111104_a(Random p_111104_1_) {
        }
    }
}

