/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titan;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.titan.EntityIronGolemTitan;
import net.minecraft.entity.titan.EntityMagmaCubeTitan;
import net.minecraft.entity.titan.EntitySnowGolemTitan;
import net.minecraft.entity.titan.EntityTitan;
import net.minecraft.entity.titan.ITitan;
import net.minecraft.entity.titan.ai.EntityAINearestTargetTitan;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.theTitans.TheTitans;
import net.minecraft.theTitans.TitanItems;
import net.minecraft.theTitans.TitansAchievments;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntitySlimeTitan
extends EntityTitan {
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private boolean field_175452_bi;
    private int slimeJumpDelay;
    public boolean doubleJumped;

    public EntitySlimeTitan(World worldIn) {
        super(worldIn);
        this.setTitanHealth(this.func_110138_aP());
        this.field_70178_ae = true;
        this.field_70138_W = this.field_70131_O;
        this.slimeJumpDelay = 0;
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityIronGolemTitan.class, 0, false));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntitySnowGolemTitan.class, 0, false));
    }

    @Override
    public boolean canAttack() {
        return true;
    }

    @Override
    protected void applyEntityAI() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        if (TheTitans.TitansFFAMode) {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.SlimeTitanSorter));
        } else {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.SearchForAThingToKill));
        }
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
        EntityLivingBase entity = this.func_70638_az();
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y != 0.0) {
            this.field_70761_aq = this.field_70177_z = (float)Math.atan2(this.field_70179_y, this.field_70159_w) * 57.295776f - 90.0f;
        }
        if (this.field_70122_E && this.slimeJumpDelay-- <= 0 && this.getInvulTime() <= 0) {
            this.slimeJumpDelay = this.getJumpDelay();
            if (entity != null) {
                this.slimeJumpDelay /= 3;
                this.func_70671_ap().func_75651_a((Entity)entity, 180.0f, 60.0f);
            }
            this.func_70664_aZ();
            if (this.makesSoundOnJump()) {
                this.func_85030_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.field_70701_bs = 2 * this.getSlimeSize();
            this.func_70612_e(this.field_70702_br, this.field_70701_bs);
        } else {
            this.field_70703_bu = false;
            if (this.field_70122_E) {
                this.field_70701_bs = 0.0f;
                this.field_70702_br = 0.0f;
            }
        }
    }

    public boolean func_70686_a(Class p_70686_1_) {
        return this.createProtoInstance() instanceof EntityMagmaCube ? p_70686_1_ != EntityMagmaCube.class && p_70686_1_ != EntityMagmaCubeTitan.class : !(p_70686_1_ != EntityMagmaCube.class && p_70686_1_ == EntitySlime.class || p_70686_1_ != EntityMagmaCubeTitan.class && p_70686_1_ == EntitySlimeTitan.class);
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(20) == 0 && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL;
    }

    @Override
    public int getMinionSpawnRate() {
        return TheTitans.SlimeTitanMinionSpawnrate;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)1);
    }

    protected void setSlimeSize(int p_70799_1_) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)p_70799_1_));
        this.func_70105_a(8.0f * (float)p_70799_1_, 8.0f * (float)p_70799_1_);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (TheTitans.NightmareMode) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6000.0 * (double)p_70799_1_);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3000.0 * (double)p_70799_1_);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)this.getAttackStrength());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)(0.5f + 0.1f * (float)p_70799_1_));
        this.setTitanHealth(this.func_110138_aP());
        this.field_70728_aV = this instanceof EntityMagmaCubeTitan ? p_70799_1_ * 3000 : p_70799_1_ * 1000;
    }

    @Override
    public int getParticleCount() {
        return 4;
    }

    @Override
    public String getParticles() {
        return this.func_180487_n();
    }

    @Override
    public int getRegenTime() {
        return 40;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)this.getAttackStrength());
    }

    public int getSlimeSize() {
        return this.field_70180_af.func_75683_a(16);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Size", this.getSlimeSize() - 1);
        tagCompound.func_74757_a("wasOnGround", this.field_175452_bi);
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        int i = tagCompund.func_74762_e("Size");
        if (i < 0) {
            i = 0;
        }
        this.setSlimeSize(i + 1);
        this.field_175452_bi = tagCompund.func_74767_n("wasOnGround");
    }

    public void func_82206_m() {
        this.setInvulTime(860);
        this.setTitanHealth(this.func_110138_aP() / 10.0f);
    }

    protected String func_180487_n() {
        return "slime";
    }

    protected String getJumpSound() {
        return "mob.slime.big";
    }

    protected String getSlimeParticle() {
        return "slime";
    }

    public void func_70071_h_() {
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        boolean flag = this.field_70122_E;
        super.func_70071_h_();
        if (this.field_70122_E && !flag) {
            int i = this.getSlimeSize();
            for (int j = 0; j < i * 32; ++j) {
                float f = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
                float f1 = this.field_70146_Z.nextFloat() * 8.0f + 8.0f;
                float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
                this.field_70170_p.func_72869_a(this.getSlimeParticle(), this.field_70165_t + (double)f2, this.field_70121_D.field_72338_b, this.field_70161_v + (double)f3, 0.0, 0.0, 0.0);
            }
            if (this.makesSoundOnLand()) {
                this.func_85030_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            }
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E && flag) {
            this.squishAmount = 1.0f;
        }
        this.alterSquishAmount();
    }

    @Override
    public boolean shouldMove() {
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)this.getAttackStrength());
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y != 0.0) {
            this.field_70177_z = this.field_70759_as = (float)Math.atan2(this.field_70179_y, this.field_70159_w) * 57.295776f - 90.0f;
            this.field_70761_aq = this.field_70759_as;
        }
        this.meleeTitan = true;
        this.field_70761_aq = this.field_70177_z = this.field_70759_as;
        if (this.createProtoInstance() instanceof EntityMagmaCube) {
            this.func_94058_c(StatCollector.func_74838_a((String)"entity.LavaSlimeTitan.name"));
            this.field_70747_aH = 0.5f * (float)this.getSlimeSize();
        } else {
            this.func_94058_c(StatCollector.func_74838_a((String)"entity.SlimeTitan.name"));
            this.field_70747_aH = 0.33f * (float)this.getSlimeSize();
        }
        if (this.func_70638_az() == null && this.doubleJumped || this.field_70122_E) {
            this.doubleJumped = false;
        }
        if (this.func_70638_az() != null && !this.doubleJumped && this.field_70146_Z.nextInt(100) == 0 && !this.field_70122_E) {
            this.squishAmount = 2.0f;
            this.func_70664_aZ();
            this.doubleJumped = true;
            this.func_85030_a(this.getJumpSound(), this.func_70599_aP(), ((this.func_70681_au().nextFloat() - this.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
        }
        if (this.field_70146_Z.nextInt(this.getMinionSpawnRate()) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K) {
            EntitySlime entitychicken = this.createProtoInstance();
            entitychicken.func_110161_a((IEntityLivingData)null);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
            entitychicken.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
        }
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(40) + 20;
    }

    protected EntitySlimeTitan createInstance() {
        return new EntitySlimeTitan(this.field_70170_p);
    }

    protected EntitySlime createProtoInstance() {
        return new EntitySlime(this.field_70170_p);
    }

    public void func_145781_i(int p_145781_1_) {
        if (p_145781_1_ == 16) {
            int j = this.getSlimeSize();
            this.func_70105_a(8.0f * (float)j, 8.0f * (float)j);
            this.field_70177_z = this.field_70759_as;
            this.field_70761_aq = this.field_70759_as;
        }
        super.func_145781_i(p_145781_1_);
    }

    @Override
    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
        if (entityIn instanceof EntityLivingBase && this.canDamagePlayer() && entityIn == this.func_70638_az() && this.field_70173_aa % 30 == 0) {
            this.func_175451_e((EntityLivingBase)entityIn);
        }
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        if (this.canDamagePlayer()) {
            this.func_175451_e((EntityLivingBase)entityIn);
        }
    }

    protected void func_175451_e(EntityLivingBase p_175451_1_) {
        int i = this.getSlimeSize();
        if (this.field_70173_aa % 30 == 0 && this.func_70685_l((Entity)p_175451_1_) && this.func_70068_e((Entity)p_175451_1_) < 12.0 * (double)i * 12.0 * (double)i) {
            float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            int i1 = this.getKnockbackAmount();
            this.attackChoosenEntity((Entity)p_175451_1_, f, i1);
            this.func_85030_a("mob.attack.slime", 10.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        }
    }

    public float func_70047_e() {
        return 0.625f * this.field_70131_O;
    }

    protected boolean canDamagePlayer() {
        return true;
    }

    protected int getAttackStrength() {
        if (TheTitans.NightmareMode) {
            return this.getSlimeSize() * 90;
        }
        return this.getSlimeSize() * 30;
    }

    @Override
    protected String func_70621_aR() {
        return "mob.slime.big";
    }

    @Override
    protected String func_70673_aS() {
        return "mob.slime.big";
    }

    protected Item func_146068_u() {
        return Items.field_151123_aH;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.deathTicks >= this.getThreashHold() && this.getSlimeSize() <= 0) {
            EntityItem entityitem;
            int l;
            for (l = 0; l < 48 + this.field_70146_Z.nextInt(48 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(this.func_146068_u()));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 16 + this.field_70146_Z.nextInt(16 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151044_h));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 0 + this.field_70146_Z.nextInt(8 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151166_bC));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 0 + this.field_70146_Z.nextInt(8 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151045_i));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 0 + this.field_70146_Z.nextInt(4 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(TitanItems.harcadiumWafer));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
        }
    }

    @Override
    protected boolean isValidLightLevel() {
        return true;
    }

    public int func_70646_bf() {
        return 30;
    }

    protected boolean makesSoundOnJump() {
        return true;
    }

    protected boolean makesSoundOnLand() {
        return true;
    }

    @Override
    protected void func_70664_aZ() {
        this.field_70181_x = 1.5 + (double)((float)this.getSlimeSize() * 0.2f);
        this.field_70160_al = true;
        if (this.func_70638_az() != null) {
            double d01 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d11 = this.func_70638_az().field_70161_v - this.field_70161_v;
            float f21 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11));
            double hor = 0.75 + (double)((float)this.getSlimeSize() * 0.25f);
            this.field_70159_w = d01 / (double)f21 * hor * hor + this.field_70159_w * hor;
            this.field_70179_y = d11 / (double)f21 * hor * hor + this.field_70179_y * hor;
        }
    }

    protected void func_70069_a(float p_70069_1_) {
        this.func_70624_b(null);
        p_70069_1_ = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)p_70069_1_);
        if (p_70069_1_ <= 0.0f) {
            return;
        }
        super.func_70069_a(p_70069_1_);
        PotionEffect potioneffect = this.func_70660_b(Potion.field_76430_j);
        float f1 = potioneffect != null ? (float)(potioneffect.func_76458_c() + 1) : 0.0f;
        int i = MathHelper.func_76123_f((float)(p_70069_1_ - 12.0f - f1));
        if (i > 0) {
            int l;
            int k;
            int j;
            Block block;
            this.func_85030_a("thetitans:titanSlam", 100.0f, 1.5f);
            List list11 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(6.0 * (double)this.getSlimeSize(), 0.0, 6.0 * (double)this.getSlimeSize()));
            if (list11 != null && !list11.isEmpty()) {
                for (int i1 = 0; i1 < list11.size(); ++i1) {
                    Entity entity = (Entity)list11.get(i1);
                    if (!(entity instanceof EntityLivingBase) || !this.func_70686_a(entity.getClass())) continue;
                    float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                    int i11 = this.getKnockbackAmount();
                    this.attackChoosenEntity(entity, f, i11);
                    double d0 = this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d;
                    double d1 = this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f;
                    double d2 = entity.field_70165_t - d0;
                    double d3 = entity.field_70161_v - d1;
                    double d4 = d2 * d2 + d3 * d3;
                    if (this.doubleJumped) {
                        entity.func_70024_g(d2 / d4 * 16.0, 2.0, d3 / d4 * 16.0);
                        continue;
                    }
                    entity.func_70024_g(d2 / d4 * 8.0, 1.0, d3 / d4 * 8.0);
                }
            }
            if ((block = this.field_70170_p.func_147439_a(j = MathHelper.func_76128_c((double)this.field_70165_t), k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - (double)this.field_70129_M)), l = MathHelper.func_76128_c((double)this.field_70161_v))).func_149688_o() != Material.field_151579_a) {
                Block.SoundType soundtype = block.field_149762_H;
                this.func_85030_a(soundtype.func_150498_e(), soundtype.func_150497_c() * 0.5f, soundtype.func_150494_d() * 0.75f);
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (source.func_76346_g() instanceof EntitySlime && this.createProtoInstance() instanceof EntitySlime || source.func_76346_g() instanceof EntitySlimeTitan && !(source.func_76346_g() instanceof EntityMagmaCubeTitan)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K) {
            EntitySlime entitychicken = this.createProtoInstance();
            entitychicken.func_110161_a((IEntityLivingData)null);
            entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
            entitychicken.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
        }
        if (source.func_76346_g() instanceof EntityLivingBase) {
            this.func_70604_c((EntityLivingBase)source.func_76346_g());
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData p_180482_2_) {
        int i = this.field_70146_Z.nextInt(3);
        if (i < 2 && this.field_70146_Z.nextFloat() < 0.5f) {
            ++i;
        }
        int j = 1 << i;
        this.setSlimeSize(j);
        return super.func_110161_a(p_180482_2_);
    }

    @Override
    public StatBase getAchievement() {
        if (this.createProtoInstance() instanceof EntityMagmaCube) {
            return TitansAchievments.magmacubetitan;
        }
        return TitansAchievments.slimetitan;
    }

    @Override
    protected void inactDeathAction() {
        int i = this.getSlimeSize();
        for (int i1 = 0; i1 < 8 * this.getSlimeSize() + this.field_70170_p.field_73012_v.nextInt(8 * this.getSlimeSize()); ++i1) {
            EntitySlime entitychicken = this.createProtoInstance();
            entitychicken.func_110161_a((IEntityLivingData)null);
            entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
            entitychicken.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
        }
        if (!this.field_70170_p.field_72995_K && i > 1) {
            int j = 2 + this.field_70146_Z.nextInt(3);
            for (int k = 0; k < j; ++k) {
                float f = ((float)(k % 2) - 0.5f) * (float)i / 4.0f;
                float f1 = ((float)(k / 2) - 0.5f) * (float)i / 4.0f;
                EntitySlimeTitan entityslime = this.createInstance();
                if (this.func_94056_bM()) {
                    entityslime.func_94058_c(this.func_94057_bL());
                }
                if (this.func_104002_bU()) {
                    entityslime.func_110163_bv();
                }
                entityslime.setSlimeSize(i / 2);
                entityslime.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)entityslime);
            }
        }
    }
}

