/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titan;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.titan.EntityIronGolemTitan;
import net.minecraft.entity.titan.EntitySnowGolemTitan;
import net.minecraft.entity.titan.EntitySpiderTitan;
import net.minecraft.entity.titan.EntityTitan;
import net.minecraft.entity.titan.EntityTitanSpirit;
import net.minecraft.entity.titan.EnumTitanStatus;
import net.minecraft.entity.titan.ITitan;
import net.minecraft.entity.titan.ai.EntityAINearestTargetTitan;
import net.minecraft.entity.titan.animation.skeletontitan.AnimationSkeletonTitanAntiTitanAttack1;
import net.minecraft.entity.titan.animation.skeletontitan.AnimationSkeletonTitanAntiTitanAttack2;
import net.minecraft.entity.titan.animation.skeletontitan.AnimationSkeletonTitanAttack;
import net.minecraft.entity.titan.animation.skeletontitan.AnimationSkeletonTitanAttack2;
import net.minecraft.entity.titan.animation.skeletontitan.AnimationSkeletonTitanAttack3;
import net.minecraft.entity.titan.animation.skeletontitan.AnimationSkeletonTitanDeath;
import net.minecraft.entity.titan.animation.skeletontitan.AnimationSkeletonTitanLightningAttack;
import net.minecraft.entity.titan.animation.skeletontitan.AnimationSkeletonTitanRangedAttack;
import net.minecraft.entity.titan.animation.skeletontitan.AnimationSkeletonTitanStun;
import net.minecraft.entity.titan.animation.skeletontitan.AnimationSkeletonTitanSwat;
import net.minecraft.entity.titanminion.EntitySkeletonLoyalist;
import net.minecraft.entity.titanminion.EntitySkeletonPriest;
import net.minecraft.entity.titanminion.EntitySkeletonTemplar;
import net.minecraft.entity.titanminion.EntitySkeletonZealot;
import net.minecraft.entity.titanminion.EntityWitherMinion;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.theTitans.DamageSourceExtra;
import net.minecraft.theTitans.TheTitans;
import net.minecraft.theTitans.TitanItems;
import net.minecraft.theTitans.TitansAchievments;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;
import net.minecraftforge.common.ForgeHooks;
import thehippomaster.AnimationAPI.AnimationAPI;
import thehippomaster.AnimationAPI.IAnimatedEntity;

public class EntitySkeletonTitan
extends EntityTitan
implements IRangedAttackMob,
IAnimatedEntity,
IEntityMultiPart {
    public boolean shouldBeWitherSkeleton;
    public int attackTimer;
    public boolean isAttacking;
    public boolean isStunned;
    public EntityDragonPart[] partArray;
    public EntityDragonPart head = new EntityDragonPart((IEntityMultiPart)this, "head", 8.0f, 8.0f);
    public EntityDragonPart body = new EntityDragonPart((IEntityMultiPart)this, "body", 7.0f, 12.0f);
    public EntityDragonPart rightArm = new EntityDragonPart((IEntityMultiPart)this, "rightarm", 2.0f, 2.0f);
    public EntityDragonPart leftArm = new EntityDragonPart((IEntityMultiPart)this, "leftarm", 2.0f, 2.0f);
    public EntityDragonPart rightLeg = new EntityDragonPart((IEntityMultiPart)this, "rightleft", 2.0f, 12.0f);
    public EntityDragonPart leftLeg = new EntityDragonPart((IEntityMultiPart)this, "leftleg", 2.0f, 12.0f);

    public EntitySkeletonTitan(World worldIn) {
        super(worldIn);
        this.partArray = new EntityDragonPart[]{this.head, this.body, this.rightArm, this.leftArm, this.rightLeg, this.leftLeg};
        this.setTitanHealth(this.func_110138_aP());
        this.field_70178_ae = true;
        if (!this.field_70170_p.field_72995_K && this.getSkeletonType() == 1) {
            this.func_70105_a(9.6f, 38.4f);
            this.field_70728_aV = 50000;
            this.field_70138_W = 12.0f;
            this.func_85030_a("thetitans:titanBirth", 10000.0f, 0.875f);
            this.func_85030_a("thetitans:titanBirth", 10000.0f, 0.875f);
            this.func_85030_a("thetitans:titanBirth", 10000.0f, 0.875f);
            this.func_85030_a("thetitans:titanBirth", 10000.0f, 0.875f);
        } else if (!this.field_70170_p.field_72995_K && this.getSkeletonType() != 1) {
            this.func_70105_a(8.0f, 32.0f);
            this.field_70728_aV = 20000;
            this.field_70138_W = 9.0f;
            this.func_85030_a("thetitans:titanBirth", 1000.0f, 1.0f);
            this.func_85030_a("thetitans:titanBirth", 1000.0f, 1.0f);
            this.func_85030_a("thetitans:titanBirth", 1000.0f, 1.0f);
            this.func_85030_a("thetitans:titanBirth", 1000.0f, 1.0f);
        }
        if (worldIn != null && !worldIn.field_72995_K) {
            this.setCombatTask();
        }
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityIronGolemTitan.class, 0, false));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntitySnowGolemTitan.class, 0, false));
    }

    @Override
    protected void applyEntityAI() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationSkeletonTitanDeath(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationSkeletonTitanLightningAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationSkeletonTitanStun(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationSkeletonTitanAttack3(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationSkeletonTitanAttack2(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationSkeletonTitanRangedAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationSkeletonTitanAntiTitanAttack1(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationSkeletonTitanAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationSkeletonTitanSwat(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationSkeletonTitanAntiTitanAttack2(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        if (TheTitans.TitansFFAMode) {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.SkeletonTitanSorter));
        } else {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.SearchForAThingToKill));
        }
    }

    public boolean func_70686_a(Class p_70686_1_) {
        return p_70686_1_ != EntitySkeletonLoyalist.class && p_70686_1_ != EntitySkeletonTitan.class && p_70686_1_ != EntityWitherMinion.class;
    }

    @Override
    protected EntityLivingBase getMinion() {
        return new EntitySkeleton(this.field_70170_p);
    }

    @Override
    protected EntityLivingBase getSecondMinion() {
        if (this.getSkeletonType() == 1) {
            return new EntityWither(this.field_70170_p);
        }
        return null;
    }

    @Override
    public int getMinionCap() {
        return 160;
    }

    @Override
    public int getPriestCap() {
        return 90;
    }

    @Override
    public int getZealotCap() {
        return 40;
    }

    @Override
    public int getTemplarCap() {
        return 10;
    }

    @Override
    public int getSpecialMinionCap() {
        return 6;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(100) == 0 && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && this.isValidLightLevel();
    }

    @Override
    public int getMinionSpawnRate() {
        if (this.getSkeletonType() == 1) {
            return TheTitans.WitherSkeletonTitanMinionSpawnrate;
        }
        return TheTitans.SkeletonTitanMinionSpawnrate;
    }

    @Override
    public float func_70603_bj() {
        float f = 16.0f;
        if (this.getSkeletonType() == 1) {
            f *= 1.2f;
        }
        return f;
    }

    @Override
    public int getParticleCount() {
        if (this.getSkeletonType() == 1) {
            return 48;
        }
        return super.getParticleCount();
    }

    @Override
    public String getParticles() {
        if (this.getSkeletonType() == 1) {
            this.shouldParticlesBeUpward = true;
            return "largesmoke";
        }
        return super.getParticles();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(140.0);
    }

    @Override
    public int getRegenTime() {
        if (!this.field_70170_p.func_72935_r() || this.getSkeletonType() == 1) {
            return 5;
        }
        return super.getRegenTime();
    }

    @Override
    public float getRegen() {
        if (this.getSkeletonType() == 1) {
            return 10.0f;
        }
        return super.getRegen();
    }

    @Override
    public boolean canBeHurtByPlayer() {
        return this.isStunned && !this.func_85032_ar();
    }

    @Override
    public EnumTitanStatus getTitanStatus() {
        return this.getSkeletonType() == 1 ? EnumTitanStatus.GREATER : EnumTitanStatus.AVERAGE;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(13, (Object)new Byte(0));
    }

    protected String func_70639_aQ() {
        return this.getSkeletonType() == 1 ? "thetitans:titanWitherSkeletonLiving" : (this.isStunned ? null : "thetitans:titanSkeletonLiving");
    }

    @Override
    protected String func_70621_aR() {
        return this.getSkeletonType() == 1 ? "thetitans:titanWitherSkeletonGrunt" : "thetitans:titanSkeletonGrunt";
    }

    @Override
    protected String func_70673_aS() {
        return this.getSkeletonType() == 1 ? "thetitans:titanWitherSkeletonDeath" : "thetitans:titanSkeletonDeath";
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
        this.func_85030_a("thetitans:titanStep", 10.0f, 1.0f);
        this.func_85030_a("mob.skeleton.step", 10.0f, 0.5f);
        float f3 = this.field_70177_z * (float)Math.PI / 180.0f;
        float f11 = MathHelper.func_76126_a((float)f3);
        float f4 = MathHelper.func_76134_b((float)f3);
        this.collideWithEntities(this.leftLeg, this.field_70170_p.func_72839_b((Entity)this, this.leftLeg.field_70121_D.func_72314_b(1.0, 1.0, 1.0).func_72317_d((double)(f11 * 4.0f), 0.0, (double)(f4 * 4.0f))));
        this.collideWithEntities(this.rightLeg, this.field_70170_p.func_72839_b((Entity)this, this.rightLeg.field_70121_D.func_72314_b(1.0, 1.0, 1.0).func_72317_d((double)(f11 * 4.0f), 0.0, (double)(f4 * 4.0f))));
    }

    @Override
    public boolean func_70652_k(Entity p_70652_1_) {
        return false;
    }

    @Override
    public double getSpeed() {
        return this.getSkeletonType() == 1 ? 0.4 : 0.3;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public void becomeWitherSkeleton(boolean skelly) {
        if (skelly) {
            this.setSkeletonType(1);
            this.func_70062_b(0, new ItemStack(Items.field_151052_q));
        }
    }

    protected void func_70069_a(float p_70069_1_) {
        if ((p_70069_1_ = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)p_70069_1_)) <= 0.0f) {
            return;
        }
        super.func_70069_a(p_70069_1_);
        PotionEffect potioneffect = this.func_70660_b(Potion.field_76430_j);
        float f1 = potioneffect != null ? (float)(potioneffect.func_76458_c() + 1) : 0.0f;
        int i = MathHelper.func_76123_f((float)(p_70069_1_ - 12.0f - f1));
        if (i > 0) {
            int l;
            int k;
            int j;
            Block block;
            this.func_85030_a("thetitans:groundSmash", 20.0f, 1.0f);
            this.func_85030_a("thetitans:titanland", 10000.0f, 1.0f);
            this.destroyBlocksInAABB(this.field_70121_D.func_72314_b(16.0, 2.0, 16.0));
            List list11 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(48.0, 2.0, 48.0));
            if (list11 != null && !list11.isEmpty()) {
                for (int i1 = 0; i1 < list11.size(); ++i1) {
                    Entity entity = (Entity)list11.get(i1);
                    if (!(entity instanceof EntityLivingBase) || !this.func_70686_a(entity.getClass()) || entity instanceof EntityTitan) continue;
                    float smash = 50.0f - this.func_70032_d(entity);
                    if (smash <= 1.0f) {
                        smash = 1.0f;
                    }
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), smash);
                    double d0 = this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d;
                    double d1 = this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f;
                    double d2 = entity.field_70165_t - d0;
                    double d3 = entity.field_70161_v - d1;
                    double d4 = d2 * d2 + d3 * d3;
                    entity.func_70024_g(d2 / d4 * 8.0, 1.0, d3 / d4 * 8.0);
                }
            }
            if ((block = this.field_70170_p.func_147439_a(j = MathHelper.func_76128_c((double)this.field_70165_t), k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - (double)this.field_70129_M)), l = MathHelper.func_76128_c((double)this.field_70161_v))).func_149688_o() != Material.field_151579_a) {
                Block.SoundType soundtype = block.field_149762_H;
                this.func_85030_a(soundtype.func_150498_e(), soundtype.func_150497_c() * 0.5f, soundtype.func_150494_d() * 0.75f);
            }
        }
    }

    @Override
    public boolean canAttack() {
        return false;
    }

    @Override
    public boolean shouldMove() {
        return this.animID == 0 && !this.isStunned && this.func_70638_az() != null ? super.shouldMove() : false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.animID != 0) {
            ++this.animTick;
        }
    }

    @Override
    public void func_70636_d() {
        List list;
        double dz;
        double dx;
        Vec3 vec3;
        double d8;
        this.setCombatTask();
        EntityPlayer entity = this.field_70170_p.func_72890_a((Entity)this, -1.0);
        if (this.getSkeletonType() == 1 && entity instanceof EntityPlayer && entity != null && entity == this.func_70638_az() && this.func_70638_az() != null) {
            if (this.field_70146_Z.nextInt(200) == 0 && this.func_70638_az() != null && this.func_110143_aJ() <= this.func_110138_aP() / 100.0f) {
                entity.func_70097_a(DamageSourceExtra.field_82727_n, Float.MAX_VALUE);
            }
            if (entity.func_110139_bj() <= 0.0f && this.field_70173_aa % 10 == 0) {
                entity.func_70097_a(DamageSourceExtra.field_82727_n.func_151518_m(), 12.0f);
                entity.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 800, 3));
                entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 400, 9));
                if (entity.func_110143_aJ() <= 5.0f) {
                    entity.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 400, 1));
                }
            } else if (entity.func_110139_bj() >= 0.0f && this.field_70173_aa % 20 == 0) {
                entity.func_70097_a(DamageSourceExtra.field_82727_n.func_151518_m(), 12.0f);
            }
        }
        if (this.isStunned) {
            this.func_70624_b(null);
            AnimationAPI.sendAnimPacket(this, 8);
            this.setAnimID(8);
        }
        if (this.animID == 8) {
            if (this.animTick == 70) {
                this.func_85030_a("thetitans:groundSmash", 8.0f, 0.9f);
                this.func_85030_a("thetitans:titanFall", 10.0f, 1.0f);
            }
            if (this.animTick == 74) {
                this.func_85030_a("thetitans:distantLargeFall", 10000.0f, 1.0f);
                this.func_85030_a(this.func_70621_aR(), this.func_70599_aP(), this.func_70647_i());
            }
            if (this.animTick == 480) {
                this.func_85030_a("thetitans:titanFall", 10.0f, 1.0f);
                this.func_85030_a("thetitans:titanStep", 10.0f, 1.0f);
                this.func_85030_a("mob.skeleton.step", 10.0f, 0.5f);
                this.func_85030_a("thetitans:titanStep", 10.0f, 1.0f);
                this.func_85030_a("mob.skeleton.step", 10.0f, 0.5f);
                this.collideWithEntities(this.leftLeg, this.field_70170_p.func_72839_b((Entity)this, this.leftLeg.field_70121_D.func_72314_b(16.0, 1.0, 16.0)));
                this.collideWithEntities(this.rightLeg, this.field_70170_p.func_72839_b((Entity)this, this.rightLeg.field_70121_D.func_72314_b(16.0, 1.0, 16.0)));
                this.collideWithEntities(this.leftLeg, this.field_70170_p.func_72839_b((Entity)this, this.leftLeg.field_70121_D.func_72314_b(16.0, 1.0, 16.0)));
                this.collideWithEntities(this.rightLeg, this.field_70170_p.func_72839_b((Entity)this, this.rightLeg.field_70121_D.func_72314_b(16.0, 1.0, 16.0)));
            }
            if (this.animTick == 450) {
                this.isStunned = false;
            } else {
                this.func_70624_b(null);
            }
        }
        if (this.animID == 10) {
            if (this.animTick == 30 || this.animTick == 70) {
                this.func_85030_a("thetitans:titanStep", 10.0f, 1.0f);
            }
            if (this.animTick == 190) {
                this.func_85030_a("thetitans:titanFall", 20.0f, 1.0f);
                this.collideWithEntities(this.leftLeg, this.field_70170_p.func_72839_b((Entity)this, this.leftLeg.field_70121_D.func_72314_b(16.0, 1.0, 16.0)));
                this.collideWithEntities(this.rightLeg, this.field_70170_p.func_72839_b((Entity)this, this.rightLeg.field_70121_D.func_72314_b(16.0, 1.0, 16.0)));
            }
            if (this.animTick == 200) {
                this.func_85030_a("thetitans:distantLargeFall", 10000.0f, 1.0f);
            }
        }
        if (this.getAnimID() == 9 && this.getAnimTick() <= 48 && this.getAnimTick() >= 30) {
            this.field_70761_aq = this.field_70177_z = this.field_70759_as;
            d8 = this.getAnimTick() - 17;
            vec3 = this.func_70676_i(1.0f);
            dx = vec3.field_72450_a * d8;
            dz = vec3.field_72449_c * d8;
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + 24.0, this.field_70161_v + dz));
        }
        if (this.getAnimID() == 9 && this.getAnimTick() == 48 && this.func_70638_az() != null) {
            d8 = 30.0;
            vec3 = this.func_70676_i(1.0f);
            dx = vec3.field_72450_a * d8;
            dz = vec3.field_72449_c * d8;
            float da = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            int i = this.getKnockbackAmount();
            this.attackChoosenEntity((Entity)this.func_70638_az(), da * 3.0f, i);
            this.func_70638_az().field_70181_x += (double)(2.0f + this.field_70146_Z.nextFloat());
            this.field_70170_p.func_72885_a((Entity)this, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 6.0f, false, false);
            this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t + dx, this.field_70163_u + 24.0, this.field_70161_v + dz, 2.0f, false, false);
            this.func_70638_az().func_70097_a(DamageSourceExtra.lightningBolt, da);
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + 24.0, this.field_70161_v + dz));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + 24.0, this.field_70161_v + dz));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + 24.0, this.field_70161_v + dz));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + 24.0, this.field_70161_v + dz));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v));
            List list1 = this.field_70170_p.func_72839_b((Entity)this.func_70638_az(), this.func_70638_az().field_70121_D.func_72314_b(16.0, 16.0, 16.0));
            if (list1 != null && !list1.isEmpty()) {
                for (int i1 = 0; i1 < list1.size(); ++i1) {
                    Entity entity1 = (Entity)list1.get(i1);
                    if (!(entity1 instanceof EntityLivingBase) || entity1 instanceof EntitySkeletonLoyalist || entity1 instanceof EntitySkeletonTitan || entity1 instanceof EntityWitherMinion) continue;
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v));
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v));
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v));
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v));
                    this.attackChoosenEntity(entity1, da, i);
                    entity1.field_70181_x += 2.0 + this.field_70146_Z.nextDouble();
                }
            }
        }
        if (this.getAnimID() == 7 && this.getAnimTick() == 92 && !AnimationAPI.isEffectiveClient()) {
            d8 = 32.0;
            if (this.getSkeletonType() == 1) {
                d8 *= 1.2;
            }
            vec3 = this.func_70676_i(1.0f);
            dx = vec3.field_72450_a * d8;
            dz = vec3.field_72449_c * d8;
            int y = MathHelper.func_76128_c((double)this.field_70163_u);
            int x = MathHelper.func_76128_c((double)(this.field_70165_t + dx));
            int z = MathHelper.func_76128_c((double)(this.field_70161_v + dz));
            for (int l1 = -4; l1 <= 4; ++l1) {
                for (int i2 = -4; i2 <= 4; ++i2) {
                    for (int j = -1; j <= 1; ++j) {
                        int j2 = x + l1;
                        int k = y + j;
                        int l = z + i2;
                        Block block = this.field_70170_p.func_147439_a(j2, k, l);
                        if (!block.isAir((IBlockAccess)this.field_70170_p, j2, k, l)) {
                            this.func_85030_a("thetitans:titanStrike", 20.0f, 1.0f);
                            this.func_85030_a("thetitans:titanSlam", 20.0f, 1.0f);
                            this.field_70170_p.func_72926_e(2001, j2, k, l, Block.func_149682_b((Block)block));
                            if (block == Blocks.field_150349_c) {
                                this.field_70170_p.func_147449_b(j2, k, l, Blocks.field_150346_d);
                            }
                        }
                        if (!(block.func_149638_a((Entity)this) > 500.0f)) continue;
                        AnimationAPI.sendAnimPacket(this, 8);
                        this.setAnimID(8);
                        this.setAnimTick(0);
                        this.func_85030_a("random.anvil_land", 20.0f, 0.5f);
                        this.isStunned = true;
                    }
                }
            }
        }
        float f = this.field_70761_aq * (float)Math.PI / 180.0f;
        float f1 = MathHelper.func_76126_a((float)f);
        float f2 = MathHelper.func_76134_b((float)f);
        if (this.getSkeletonType() == 1) {
            this.head.field_70131_O = 9.6f;
            this.head.field_70130_N = 9.6f;
            this.body.field_70131_O = 14.4f;
            this.body.field_70130_N = 9.6f;
            this.leftLeg.field_70130_N = 2.4f;
            this.rightLeg.field_70130_N = 2.4f;
            this.leftLeg.field_70131_O = 14.4f;
            this.rightLeg.field_70131_O = 14.4f;
            this.leftArm.field_70131_O = 2.4f;
            this.leftArm.field_70130_N = 2.4f;
            this.rightArm.field_70131_O = 2.4f;
            this.rightArm.field_70130_N = 2.4f;
            this.head.func_70071_h_();
            this.head.func_70012_b(this.field_70165_t, this.field_70163_u + 28.8, this.field_70161_v, 0.0f, 0.0f);
            this.body.func_70071_h_();
            this.body.func_70012_b(this.field_70165_t, this.field_70163_u + 14.4, this.field_70161_v, 0.0f, 0.0f);
            this.rightArm.func_70071_h_();
            this.rightArm.func_70012_b(this.field_70165_t + (double)(f2 * 9.6f), this.field_70163_u + 24.0, this.field_70161_v + (double)(f1 * 9.6f), 0.0f, 0.0f);
            this.leftArm.func_70071_h_();
            this.leftArm.func_70012_b(this.field_70165_t - (double)(f2 * 9.6f), this.field_70163_u + 24.0, this.field_70161_v - (double)(f1 * 9.6f), 0.0f, 0.0f);
            this.rightLeg.func_70071_h_();
            this.rightLeg.func_70012_b(this.field_70165_t + (double)(f2 * 2.4f), this.field_70163_u, this.field_70161_v + (double)(f1 * 2.4f), 0.0f, 0.0f);
            this.leftLeg.func_70071_h_();
            this.leftLeg.func_70012_b(this.field_70165_t - (double)(f2 * 2.4f), this.field_70163_u, this.field_70161_v - (double)(f1 * 2.4f), 0.0f, 0.0f);
        } else {
            this.head.func_70071_h_();
            this.head.func_70012_b(this.field_70165_t, this.field_70163_u + 24.0, this.field_70161_v, 0.0f, 0.0f);
            this.body.func_70071_h_();
            this.body.func_70012_b(this.field_70165_t, this.field_70163_u + 12.0, this.field_70161_v, 0.0f, 0.0f);
            this.rightArm.func_70071_h_();
            this.rightArm.func_70012_b(this.field_70165_t + (double)(f2 * 8.0f), this.field_70163_u + 20.0, this.field_70161_v + (double)(f1 * 8.0f), 0.0f, 0.0f);
            this.leftArm.func_70071_h_();
            this.leftArm.func_70012_b(this.field_70165_t - (double)(f2 * 8.0f), this.field_70163_u + 20.0, this.field_70161_v - (double)(f1 * 8.0f), 0.0f, 0.0f);
            this.rightLeg.func_70071_h_();
            this.rightLeg.func_70012_b(this.field_70165_t + (double)(f2 * 2.0f), this.field_70163_u, this.field_70161_v + (double)(f1 * 2.0f), 0.0f, 0.0f);
            this.leftLeg.func_70071_h_();
            this.leftLeg.func_70012_b(this.field_70165_t - (double)(f2 * 2.0f), this.field_70163_u, this.field_70161_v - (double)(f1 * 2.0f), 0.0f, 0.0f);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && !this.isStunned) {
            this.collideWithEntities(this.head, this.field_70170_p.func_72839_b((Entity)this, this.head.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.body, this.field_70170_p.func_72839_b((Entity)this, this.body.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.rightArm, this.field_70170_p.func_72839_b((Entity)this, this.rightArm.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.leftArm, this.field_70170_p.func_72839_b((Entity)this, this.leftArm.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.leftLeg, this.field_70170_p.func_72839_b((Entity)this, this.leftLeg.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.rightLeg, this.field_70170_p.func_72839_b((Entity)this, this.rightLeg.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
        }
        this.destroyBlocksInAABB(this.head.field_70121_D);
        this.destroyBlocksInAABB(this.body.field_70121_D);
        this.destroyBlocksInAABB(this.rightArm.field_70121_D);
        this.destroyBlocksInAABB(this.leftArm.field_70121_D);
        this.destroyBlocksInAABB(this.leftLeg.field_70121_D);
        this.destroyBlocksInAABB(this.rightLeg.field_70121_D);
        if (this.animID != 0 || this.isStunned || this.isAttacking) {
            this.field_70159_w *= 0.0;
            this.field_70179_y *= 0.0;
        }
        if ((list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(256.0, 256.0, 256.0))) != null && !list.isEmpty() && this.field_70173_aa % 400 == 0) {
            for (int i1 = 0; i1 < list.size(); ++i1) {
                Entity entity1 = (Entity)list.get(i1);
                if (entity1 == null || !(entity1 instanceof EntityArrow)) continue;
                entity1.func_70106_y();
            }
        }
        if (this.func_70638_az() != null) {
            this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 180.0f, 30.0f);
        }
        if (this.getAnimID() == 5 && this.getAnimTick() >= 80 && this.getAnimTick() <= 460) {
            ++this.attackTimer;
        } else if (this.getAnimID() != 5) {
            this.attackTimer = 0;
        }
        if (this.attackTimer < 0) {
            this.attackTimer = 0;
        }
        if (this.func_70638_az() != null && this.getAnimID() == 5 && this.getAnimTick() >= 120 && this.getAnimTick() <= 340) {
            this.func_82196_d(this.func_70638_az(), 1.0f);
            this.func_82196_d(this.func_70638_az(), 1.0f);
            this.func_82196_d(this.func_70638_az(), 1.0f);
            this.func_82196_d(this.func_70638_az(), 1.0f);
            this.func_82196_d(this.func_70638_az(), 1.0f);
            this.func_82196_d(this.func_70638_az(), 1.0f);
            this.func_82196_d(this.func_70638_az(), 1.0f);
            this.func_82196_d(this.func_70638_az(), 1.0f);
            this.func_82196_d(this.func_70638_az(), 1.0f);
            this.func_82196_d(this.func_70638_az(), 1.0f);
            this.attackTimer = 140;
        }
        if (!AnimationAPI.isEffectiveClient() && this.func_70638_az() != null && !this.isStunned && this.getAnimID() == 0) {
            double d0 = this.func_70068_e((Entity)this.func_70638_az());
            double d = this.field_70130_N * this.field_70130_N + this.func_70638_az().field_70130_N * this.func_70638_az().field_70130_N;
            double d2 = this.getSkeletonType() == 1 ? 1000.0 : 800.0;
            if (d0 < d + d2) {
                if (this.func_70638_az() instanceof EntityTitan || this.func_70638_az().field_70131_O >= 6.0f || this.func_70638_az().field_70163_u > this.field_70163_u + 6.0) {
                    this.isAttacking = true;
                    switch (this.field_70146_Z.nextInt(2)) {
                        case 0: {
                            AnimationAPI.sendAnimPacket(this, 4);
                            this.setAnimID(4);
                            this.setAnimTick(0);
                            break;
                        }
                        case 1: {
                            AnimationAPI.sendAnimPacket(this, 1);
                            this.setAnimID(1);
                            this.setAnimTick(0);
                        }
                    }
                } else {
                    this.isAttacking = true;
                    switch (this.field_70146_Z.nextInt(4)) {
                        case 0: {
                            AnimationAPI.sendAnimPacket(this, 6);
                            this.setAnimID(6);
                            this.setAnimTick(0);
                            break;
                        }
                        case 1: {
                            AnimationAPI.sendAnimPacket(this, 3);
                            this.setAnimID(3);
                            this.setAnimTick(0);
                            break;
                        }
                        case 2: {
                            AnimationAPI.sendAnimPacket(this, 7);
                            this.setAnimID(7);
                            this.setAnimTick(0);
                            break;
                        }
                        case 3: {
                            AnimationAPI.sendAnimPacket(this, 2);
                            this.setAnimID(2);
                            this.setAnimTick(0);
                        }
                    }
                }
            } else if (this.animID == 0 && this.func_70681_au().nextInt(80) == 0) {
                this.isAttacking = true;
                if (this.getSkeletonType() != 1) {
                    AnimationAPI.sendAnimPacket(this, 5);
                    this.setAnimID(5);
                } else {
                    AnimationAPI.sendAnimPacket(this, 9);
                    this.setAnimID(9);
                }
            }
        }
        if (this.getSkeletonType() == 1) {
            this.func_94058_c(StatCollector.func_74838_a((String)"entity.WitherSkeletonTitan.name"));
            if (TheTitans.NightmareMode) {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4500.0);
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200000.0);
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1500.0);
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100000.0);
            }
        } else {
            this.func_94058_c(StatCollector.func_74838_a((String)"entity.SkeletonTitan.name"));
            if (TheTitans.NightmareMode) {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(360.0);
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40000.0);
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(120.0);
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20000.0);
            }
        }
        if (this.field_70146_Z.nextInt(200) == 0 && this.func_70638_az() != null && this.field_70122_E && this.func_70068_e((Entity)this.func_70638_az()) > 512.0 && this.getSkeletonType() != 1 && this.animID == 0) {
            this.func_70664_aZ();
            this.func_85030_a(this.func_70621_aR(), this.func_70599_aP(), this.func_70647_i());
        }
        if (this.field_70146_Z.nextInt(2) == 0 && this.func_70026_G()) {
            this.func_85030_a("random.fizz", 10.0f, 1.0f);
        }
        if (this.field_70170_p.field_72995_K && this.getSkeletonType() == 1) {
            this.func_70105_a(9.6f, 38.4f);
        } else if (this.field_70170_p.field_72995_K && this.getSkeletonType() != 1) {
            this.func_70105_a(8.0f, 32.0f);
        }
        if (this.field_70146_Z.nextInt(this.getMinionSpawnRate()) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            if (this.numSpecialMinions < this.getSpecialMinionCap() && this.field_70146_Z.nextInt(100) == 0 && this.getSkeletonType() == 1) {
                EntityWitherMinion entitychicken = new EntityWitherMinion(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_70024_g(0.0, 0.25, 0.0);
                entitychicken.func_85030_a("thetitans:titansummonminion", 10.0f, 0.6f);
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                ++this.numSpecialMinions;
            } else if (this.numMinions < this.getMinionCap()) {
                EntitySkeletonLoyalist entitychicken = new EntitySkeletonLoyalist(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
                entitychicken.func_70024_g(0.0, 0.9, 0.0);
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
                Block block = this.field_70170_p.func_147439_a((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v);
                this.field_70170_p.func_72926_e(2001, (int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Block.func_149682_b((Block)block));
                ++this.numMinions;
                if (block == Blocks.field_150349_c) {
                    this.field_70170_p.func_147449_b((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v, Blocks.field_150346_d);
                }
                if (this.getSkeletonType() == 1) {
                    entitychicken.func_82201_a(1);
                } else {
                    entitychicken.func_82201_a(0);
                    entitychicken.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, Integer.MAX_VALUE, 0, false));
                }
            }
        }
        if (this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 2) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            if (this.numSpecialMinions < this.getSpecialMinionCap() && this.field_70146_Z.nextInt(100) == 0 && this.getSkeletonType() == 1) {
                EntityWitherMinion entitychicken = new EntityWitherMinion(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_70024_g(0.0, 0.25, 0.0);
                entitychicken.func_85030_a("thetitans:titansummonminion", 10.0f, 0.6f);
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                ++this.numSpecialMinions;
            } else if (this.numPriests < this.getPriestCap()) {
                EntitySkeletonPriest entitychicken = new EntitySkeletonPriest(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
                entitychicken.func_70024_g(0.0, 0.9, 0.0);
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
                Block block = this.field_70170_p.func_147439_a((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v);
                this.field_70170_p.func_72926_e(2001, (int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Block.func_149682_b((Block)block));
                ++this.numPriests;
                if (block == Blocks.field_150349_c) {
                    this.field_70170_p.func_147449_b((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v, Blocks.field_150346_d);
                }
                if (this.getSkeletonType() == 1) {
                    entitychicken.func_82201_a(1);
                } else {
                    entitychicken.func_82201_a(0);
                    entitychicken.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, Integer.MAX_VALUE, 0, false));
                }
            }
        }
        if (this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 5) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            if (this.numSpecialMinions < this.getSpecialMinionCap() && this.field_70146_Z.nextInt(100) == 0 && this.getSkeletonType() == 1) {
                EntityWitherMinion entitychicken = new EntityWitherMinion(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_70024_g(0.0, 0.25, 0.0);
                entitychicken.func_85030_a("thetitans:titansummonminion", 10.0f, 0.6f);
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                ++this.numSpecialMinions;
            } else if (this.numZealots < this.getZealotCap()) {
                EntitySkeletonZealot entitychicken = new EntitySkeletonZealot(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
                entitychicken.func_70024_g(0.0, 0.9, 0.0);
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
                Block block = this.field_70170_p.func_147439_a((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v);
                this.field_70170_p.func_72926_e(2001, (int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Block.func_149682_b((Block)block));
                ++this.numZealots;
                if (block == Blocks.field_150349_c) {
                    this.field_70170_p.func_147449_b((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v, Blocks.field_150346_d);
                }
                if (this.getSkeletonType() == 1) {
                    entitychicken.func_82201_a(1);
                } else {
                    entitychicken.func_82201_a(0);
                    entitychicken.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, Integer.MAX_VALUE, 0, false));
                }
            }
        }
        if (this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 10) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            if (this.numSpecialMinions < this.getSpecialMinionCap() && this.field_70146_Z.nextInt(100) == 0 && this.getSkeletonType() == 1) {
                EntityWitherMinion entitychicken = new EntityWitherMinion(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_70024_g(0.0, 0.25, 0.0);
                entitychicken.func_85030_a("thetitans:titansummonminion", 10.0f, 0.6f);
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                ++this.numSpecialMinions;
            } else if (this.numTemplar < this.getTemplarCap()) {
                EntitySkeletonTemplar entitychicken = new EntitySkeletonTemplar(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
                entitychicken.func_70024_g(0.0, 0.9, 0.0);
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
                Block block = this.field_70170_p.func_147439_a((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v);
                this.field_70170_p.func_72926_e(2001, (int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Block.func_149682_b((Block)block));
                ++this.numTemplar;
                if (block == Blocks.field_150349_c) {
                    this.field_70170_p.func_147449_b((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v, Blocks.field_150346_d);
                }
                if (this.getSkeletonType() == 1) {
                    entitychicken.func_82201_a(1);
                } else {
                    entitychicken.func_82201_a(0);
                    entitychicken.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, Integer.MAX_VALUE, 0, false));
                }
            }
        }
        super.func_70636_d();
    }

    @Override
    public void attackChoosenEntity(Entity damagedEntity, float damage, int knockbackAmount) {
        super.attackChoosenEntity(damagedEntity, damage, knockbackAmount);
        if (this.getSkeletonType() == 1 && damagedEntity instanceof EntityLivingBase) {
            ((EntityLivingBase)damagedEntity).func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 800, 3));
        }
    }

    public void func_70098_U() {
        super.func_70098_U();
        if (this.field_70154_o instanceof EntitySpiderTitan) {
            EntitySpiderTitan entitycreature = (EntitySpiderTitan)this.field_70154_o;
            this.field_70761_aq = entitycreature.field_70761_aq;
            if (this.func_70638_az() != null) {
                entitycreature.func_70624_b(this.func_70638_az());
            }
            if (!entitycreature.func_70089_S()) {
                this.field_70154_o = null;
            }
        }
    }

    @Override
    public StatBase getAchievement() {
        if (this.field_70154_o != null && this.field_70154_o instanceof EntitySpiderTitan) {
            return TitansAchievments.spiderjockeytitan;
        }
        if (this.getSkeletonType() == 1) {
            return TitansAchievments.witherskeletontitan;
        }
        return TitansAchievments.skeletontitan;
    }

    protected Item func_146068_u() {
        return Items.field_151032_g;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.deathTicks > 0) {
            EntityItem entityitem;
            int l;
            if (this.getSkeletonType() == 1) {
                for (l = 0; l < 16; ++l) {
                    entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151045_i));
                    entityitem.field_145804_b = 40;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                }
                for (l = 0; l < 32; ++l) {
                    entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151042_j));
                    entityitem.field_145804_b = 40;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                }
                for (l = 0; l < 128 + this.field_70146_Z.nextInt(128 + p_70628_2_) + p_70628_2_; ++l) {
                    entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151103_aS));
                    entityitem.field_145804_b = 40;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                }
                for (l = 0; l < 128 + this.field_70146_Z.nextInt(128 + p_70628_2_) + p_70628_2_; ++l) {
                    entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151044_h));
                    entityitem.field_145804_b = 40;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                }
                for (l = 0; l < 256 + this.field_70146_Z.nextInt(256 + p_70628_2_) + p_70628_2_; ++l) {
                    entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151100_aR, 1, 15));
                    entityitem.field_145804_b = 40;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                }
                for (l = 0; l < 128 + this.field_70146_Z.nextInt(128 + p_70628_2_); ++l) {
                    entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151166_bC));
                    entityitem.field_145804_b = 40;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                }
                for (l = 0; l < 128 + this.field_70146_Z.nextInt(128 + p_70628_2_); ++l) {
                    entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151045_i));
                    entityitem.field_145804_b = 40;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                }
                for (l = 0; l < 64 + this.field_70146_Z.nextInt(64 + p_70628_2_); ++l) {
                    entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(TitanItems.harcadium));
                    entityitem.field_145804_b = 40;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                }
                for (l = 0; l < 32 + this.field_70146_Z.nextInt(32 + p_70628_2_); ++l) {
                    entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(TitanItems.voidItem));
                    entityitem.field_145804_b = 40;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                }
                for (l = 0; l < 16 + this.field_70146_Z.nextInt(16 + p_70628_2_); ++l) {
                    entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150357_h));
                    entityitem.field_145804_b = 40;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                }
            } else {
                for (l = 0; l < 48; ++l) {
                    entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151055_y));
                    entityitem.field_145804_b = 40;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                }
                for (l = 0; l < 48; ++l) {
                    entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151007_F));
                    entityitem.field_145804_b = 40;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                }
                for (l = 0; l < 128 + this.field_70146_Z.nextInt(128 + p_70628_2_) + p_70628_2_; ++l) {
                    entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151032_g));
                    entityitem.field_145804_b = 40;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                }
                for (l = 0; l < 0 + this.field_70146_Z.nextInt(16 + p_70628_2_); ++l) {
                    entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151166_bC));
                    entityitem.field_145804_b = 40;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                }
                for (l = 0; l < 0 + this.field_70146_Z.nextInt(16 + p_70628_2_); ++l) {
                    entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151045_i));
                    entityitem.field_145804_b = 40;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                }
                for (l = 0; l < 0 + this.field_70146_Z.nextInt(4 + p_70628_2_); ++l) {
                    entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(TitanItems.harcadium));
                    entityitem.field_145804_b = 40;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                }
            }
            for (l = 0; l < 128 + this.field_70146_Z.nextInt(128 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151103_aS));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 128 + this.field_70146_Z.nextInt(128 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151044_h));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 256 + this.field_70146_Z.nextInt(256 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151100_aR, 1, 15));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
        }
    }

    protected void func_70600_l(int p_70600_1_) {
        if (this.getSkeletonType() == 1) {
            this.func_70099_a(new ItemStack(Items.field_151144_bL, 256, 1), 0.0f);
        } else {
            this.func_70099_a(new ItemStack(Items.field_151144_bL, 256, 0), 0.0f);
        }
    }

    protected void func_82164_bB() {
        super.func_82164_bB();
        if (this.getSkeletonType() == 1) {
            this.func_70062_b(0, new ItemStack(Items.field_151052_q));
        } else {
            this.func_70062_b(0, new ItemStack((Item)Items.field_151031_f));
        }
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData p_180482_2_) {
        Calendar calendar;
        p_180482_2_ = super.func_110161_a(p_180482_2_);
        this.func_98053_h(true);
        this.func_82162_bC();
        if (this.field_70170_p.field_73011_w instanceof WorldProviderHell && this.func_70681_au().nextInt(5) > 0 && !this.field_70170_p.field_72995_K || this.shouldBeWitherSkeleton && !this.field_70170_p.field_72995_K) {
            this.becomeWitherSkeleton(true);
            this.func_70105_a(9.6f, 38.4f);
            this.func_70062_b(0, new ItemStack(Items.field_151052_q));
        } else {
            this.func_70105_a(8.0f, 32.0f);
            this.func_70062_b(0, new ItemStack((Item)Items.field_151031_f));
        }
        if (this.func_71124_b(4) == null && (calendar = this.field_70170_p.func_83015_S()).get(2) + 1 == 10 && calendar.get(5) == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
            this.func_70062_b(4, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
            this.field_82174_bp[4] = 0.0f;
        }
        this.func_82164_bB();
        return p_180482_2_;
    }

    public void setCombatTask() {
        this.meleeTitan = true;
    }

    public void func_82196_d(EntityLivingBase p_82196_1_, float p_82196_2_) {
        this.field_70761_aq = this.field_70177_z = this.field_70759_as;
        this.func_70625_a((Entity)p_82196_1_, 180.0f, 30.0f);
        double d8 = 8.0;
        Vec3 vec3 = this.func_70676_i(1.0f);
        EntityArrow entityarrow = new EntityArrow(this.field_70170_p, (EntityLivingBase)this, p_82196_2_);
        double d0 = p_82196_1_.field_70165_t - this.field_70165_t;
        double d1 = p_82196_1_.field_70163_u - (this.field_70163_u + 16.0);
        double d2 = p_82196_1_.field_70161_v - this.field_70161_v;
        float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + (double)f1, d2, f1 / 57.295776f * 1.5f, 9.0f);
        int i = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)this.func_70694_bm());
        int j = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)this.func_70694_bm());
        int f = EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)this.func_70694_bm());
        if (TheTitans.NightmareMode) {
            entityarrow.func_70239_b(90.0);
        } else {
            entityarrow.func_70239_b(30.0);
        }
        entityarrow.func_70243_d(true);
        if (i > 0) {
            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)i * 1.0 + 1.0);
        }
        if (j > 0) {
            entityarrow.func_70240_a(j);
        } else {
            entityarrow.func_70240_a(1);
        }
        if (f > 0 || this.getSkeletonType() == 1) {
            entityarrow.func_70015_d(10000);
        }
        this.field_70170_p.func_72838_d((Entity)entityarrow);
        entityarrow.field_70165_t = this.field_70165_t + vec3.field_72450_a * d8;
        entityarrow.field_70163_u = this.field_70163_u + 16.0;
        entityarrow.field_70161_v = this.field_70161_v + vec3.field_72449_c * d8;
        this.func_85030_a("random.bow", 3.0f, 1.9f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        if (this.func_70068_e((Entity)p_82196_1_) < 400.0) {
            this.attackChoosenEntity((Entity)p_82196_1_, 10.0f, 5);
        }
    }

    public int getSkeletonType() {
        return this.field_70180_af.func_75683_a(13);
    }

    public void setSkeletonType(int p_82201_1_) {
        this.field_70180_af.func_75692_b(13, (Object)((byte)p_82201_1_));
        if (p_82201_1_ == 1) {
            this.func_70105_a(9.6f, 38.4f);
        } else {
            this.func_70105_a(8.0f, 32.0f);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_150297_b("SkeletonType", 99)) {
            byte b0 = tagCompund.func_74771_c("SkeletonType");
            this.setSkeletonType(b0);
        }
        this.setCombatTask();
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74774_a("SkeletonType", (byte)this.getSkeletonType());
    }

    public void func_82206_m() {
        this.setInvulTime(860);
        this.setTitanHealth(this.func_110138_aP() / 10.0f);
    }

    public void func_70062_b(int slotIn, ItemStack stack) {
        super.func_70062_b(slotIn, stack);
        if (!this.field_70170_p.field_72995_K && slotIn == 0) {
            this.setCombatTask();
        }
    }

    public float func_70047_e() {
        return this.getSkeletonType() == 1 ? 33.12f : 27.6f;
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
        List list11 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D);
        if (list11 != null && !list11.isEmpty()) {
            for (int i1 = 0; i1 < list11.size(); ++i1) {
                Entity entity = (Entity)list11.get(i1);
                if (!(entity instanceof EntityLivingBase) || !entity.field_70122_E || entity instanceof EntityTitan) continue;
                float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                entity.func_70097_a(DamageSourceExtra.causeSquishingDamage((Entity)this), f / 2.0f);
                if (this.getSkeletonType() != 1) continue;
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 1500, 3));
            }
        }
    }

    public double func_70033_W() {
        if (this.getSkeletonType() == 1) {
            return super.func_70033_W() - 12.48;
        }
        return super.func_70033_W() - 10.4;
    }

    @Override
    protected void inactDeathAction() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                this.func_70628_a(true, 0);
                this.func_82160_b(true, 0);
                this.func_70600_l(1);
            }
            EntityTitanSpirit entitytitan = new EntityTitanSpirit(this.field_70170_p);
            entitytitan.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entitytitan);
            entitytitan.setVesselHunting(false);
            if (this.getSkeletonType() == 1) {
                entitytitan.setSpiritType(5);
            } else {
                entitytitan.setSpiritType(4);
            }
        }
    }

    @Override
    protected void onTitanDeathUpdate() {
        this.field_70180_af.func_75692_b(6, (Object)Float.valueOf(MathHelper.func_76131_a((float)this.field_70180_af.func_111145_d(5), (float)0.0f, (float)this.func_110138_aP())));
        if (this.field_70180_af.func_111145_d(5) <= 0.0f) {
            ++this.deathTicks;
            AnimationAPI.sendAnimPacket(this, 10);
            this.setAnimID(10);
            this.setTitanHealth(0.0f);
        } else {
            this.func_70097_a(DamageSource.field_76380_i, 25.0f);
            this.setTitanHealth(this.field_70180_af.func_111145_d(5));
            this.func_70606_j(this.field_70180_af.func_111145_d(5));
            this.deathTicks = 0;
            if (this.animID == 10) {
                this.animID = 0;
            }
        }
        this.field_70159_w *= 0.0;
        this.field_70179_y *= 0.0;
        this.func_70624_b(null);
        if (this.deathTicks == 1 && !this.field_70170_p.field_72995_K) {
            this.func_85030_a(this.func_70673_aS(), this.func_70599_aP(), this.func_70647_i());
            ArrayList listp = Lists.newArrayList((Iterable)this.field_70170_p.field_73010_i);
            if (listp != null && !listp.isEmpty()) {
                for (int i1 = 0; i1 < listp.size(); ++i1) {
                    Entity entity = (Entity)listp.get(i1);
                    if (entity == null || !(entity instanceof EntityPlayer)) continue;
                    ((EntityPlayer)entity).func_71029_a(this.getAchievement());
                }
            }
        }
        if (this.deathTicks == 1) {
            this.setAnimTick(1);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot") && this.deathTicks >= 500 && this.deathTicks % 10 == 0) {
            int j;
            for (int i = this.func_70693_a(this.field_70717_bb) / 10; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 64.0, this.field_70161_v, j));
            }
        }
        if (this.deathTicks >= 500) {
            this.setInvulTime(this.getInvulTime() + 8);
            --this.animTick;
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 24.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 24.0f;
            this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.getInvulTime() >= this.getThreashHold()) {
            this.func_70106_y();
        }
    }

    public void collideWithEntities(EntityDragonPart part, List p_70970_1_) {
        double d0 = (part.field_70121_D.field_72340_a + part.field_70121_D.field_72336_d) / 2.0;
        double d1 = (part.field_70121_D.field_72339_c + part.field_70121_D.field_72334_f) / 2.0;
        for (Entity entity : p_70970_1_) {
            if (entity == null || !(entity instanceof EntityLivingBase) || entity instanceof EntityTitan || entity instanceof EntityTitanSpirit || !this.func_70686_a(entity.getClass()) || !entity.func_70067_L()) continue;
            double d2 = entity.field_70165_t - d0;
            double d3 = entity.field_70161_v - d1;
            double d4 = d2 * d2 + d3 * d3;
            entity.func_70024_g(d2 / d4 * 0.75, 0.25, d3 / d4 * 0.75);
            entity.func_70097_a(DamageSource.func_92087_a((Entity)this), 10.0f);
            if (this.getSkeletonType() != 1) continue;
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 1000, 3));
        }
    }

    public boolean attackSkeletonFrom(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityPlayer && !this.field_70170_p.field_72995_K) {
            this.func_70624_b((EntityLivingBase)source.func_76346_g());
            this.func_70604_c((EntityLivingBase)source.func_76346_g());
        }
        if (this.func_85032_ar()) {
            return false;
        }
        if (!this.isStunned && source.func_76346_g() instanceof EntityPlayer) {
            return false;
        }
        if (source.func_76346_g() instanceof EntitySkeletonLoyalist || this.field_70154_o != null && source.func_76346_g() == this.field_70154_o && this.field_70154_o instanceof EntitySpiderTitan || source.func_76346_g() instanceof EntitySkeletonTitan || source.func_76346_g() instanceof EntityWitherMinion) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityLivingBase && !this.func_85032_ar() && amount > 25.0f) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(256.0, 256.0, 256.0));
            for (int i = 0; i < list.size(); ++i) {
                Entity entity1 = (Entity)list.get(i);
                if (entity1 instanceof EntitySkeletonTitan) {
                    EntitySkeletonTitan entitypigzombie = (EntitySkeletonTitan)entity1;
                    entitypigzombie.func_70624_b((EntityLivingBase)entity);
                    entitypigzombie.func_70604_c((EntityLivingBase)entity);
                }
                this.func_70624_b((EntityLivingBase)entity);
                this.func_70604_c((EntityLivingBase)entity);
            }
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return this.attackSkeletonFrom(source, amount);
    }

    public boolean func_70067_L() {
        return false;
    }

    public Entity[] func_70021_al() {
        return this.partArray;
    }

    public boolean func_70965_a(EntityDragonPart p_70965_1_, DamageSource source, float amount) {
        if (p_70965_1_ != this.head) {
            amount /= 3.0f;
        }
        this.func_82195_e(source, amount);
        return true;
    }

    protected boolean func_82195_e(DamageSource p_82195_1_, float p_82195_2_) {
        return this.attackSkeletonFrom(p_82195_1_, p_82195_2_);
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    @Override
    public void setAnimID(int id) {
        this.animID = id;
    }

    @Override
    public void setAnimTick(int tick) {
        this.animTick = tick;
    }

    @Override
    public int getAnimID() {
        return this.animID;
    }

    @Override
    public int getAnimTick() {
        return this.animTick;
    }
}

