/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titan;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.titan.EntitySpiderTitan;
import net.minecraft.entity.titan.EntityTitan;
import net.minecraft.entity.titan.EntityTitanSpirit;
import net.minecraft.entity.titan.ITitan;
import net.minecraft.entity.titan.ai.EntityAINearestTargetTitan;
import net.minecraft.entity.titanminion.EntityCaveSpiderLoyalist;
import net.minecraft.entity.titanminion.EntityCaveSpiderPriest;
import net.minecraft.entity.titanminion.EntityCaveSpiderTemplar;
import net.minecraft.entity.titanminion.EntityCaveSpiderZealot;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.theTitans.TheTitans;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thehippomaster.AnimationAPI.AnimationAPI;

public class EntityCaveSpiderTitan
extends EntitySpiderTitan {
    public boolean isSubdued;

    public EntityCaveSpiderTitan(World worldIn) {
        super(worldIn);
        this.head = new EntityDragonPart((IEntityMultiPart)this, "head", 5.6f, 5.6f);
        this.thorax = new EntityDragonPart((IEntityMultiPart)this, "thorax", 4.2f, 4.2f);
        this.abdomen = new EntityDragonPart((IEntityMultiPart)this, "abdomen", 8.4f, 4.2f);
        this.rightlegs = new EntityDragonPart((IEntityMultiPart)this, "rightlegs", 8.4f, 4.2f);
        this.leftlegs = new EntityDragonPart((IEntityMultiPart)this, "leftlegs", 8.4f, 4.2f);
        this.partArray = new EntityDragonPart[]{this.head, this.thorax, this.abdomen, this.rightlegs, this.leftlegs};
        this.func_70105_a(16.0f, 10.0f);
        this.field_70138_W = 6.0f;
        this.field_70728_aV = 9000 + this.getExtraPower() * 350;
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            this.field_70153_n.func_70107_b(this.field_70165_t, this.field_70163_u + (8.8 + (double)this.getExtraPower() * 0.1), this.field_70161_v);
        }
    }

    @Override
    public int getMinionCap() {
        return 180;
    }

    @Override
    public int getPriestCap() {
        return 80;
    }

    @Override
    public int getZealotCap() {
        return 20;
    }

    @Override
    public int getTemplarCap() {
        return 4;
    }

    protected boolean func_70610_aX() {
        return this.isSubdued && this.field_70153_n == null ? true : super.func_70610_aX();
    }

    @Override
    public void collideWithEntities(EntityDragonPart part, List p_70970_1_) {
        double d0 = (part.field_70121_D.field_72340_a + part.field_70121_D.field_72336_d) / 2.0;
        double d1 = (part.field_70121_D.field_72339_c + part.field_70121_D.field_72334_f) / 2.0;
        for (Entity entity : p_70970_1_) {
            if ((this.isStunned || !(entity instanceof EntityLivingBase) || entity instanceof EntityTitan || entity instanceof EntityTitanSpirit || !this.func_70686_a(entity.getClass()) || entity instanceof EntityTitan) && (!(entity instanceof EntityPlayer) || this.isSubdued)) continue;
            double d2 = entity.field_70165_t - d0;
            double d3 = entity.field_70161_v - d1;
            double d4 = d2 * d2 + d3 * d3;
            entity.func_70024_g(d2 / d4 * 3.0, 0.5, d3 / d4 * 3.0);
            entity.func_70097_a(DamageSource.func_92087_a((Entity)this), 8.0f);
        }
    }

    @Override
    protected void applyEntityAI() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        if (TheTitans.TitansFFAMode) {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.CaveSpiderTitanSorter));
        } else {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.SearchForAThingToKill));
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(40.0);
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.isSubdued = tagCompund.func_74767_n("Subdued");
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("Subdued", this.isSubdued);
    }

    @Override
    public boolean func_70067_L() {
        return true;
    }

    @Override
    public boolean shouldMove() {
        return this.animID != 3 && this.animID != 4 && this.animID != 5 && this.animID != 6 && this.animID != 7 && this.animID != 8 && this.animID != 9 && !this.isStunned && this.func_70638_az() != null ? super.shouldMove() : false;
    }

    @Override
    public double getSpeed() {
        return 0.65 + (double)this.getExtraPower() * 0.005;
    }

    @Override
    public boolean func_70686_a(Class p_70686_1_) {
        return p_70686_1_ != EntityCaveSpiderLoyalist.class && (p_70686_1_ != EntityCaveSpiderTitan.class || p_70686_1_ == EntitySpiderTitan.class);
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(50) == 0 && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && this.isValidLightLevel();
    }

    @Override
    public int getMinionSpawnRate() {
        return TheTitans.CaveSpiderTitanMinionSpawnrate;
    }

    @Override
    public boolean func_70652_k(Entity p_70652_1_) {
        if (super.func_70652_k(p_70652_1_)) {
            if (p_70652_1_ instanceof EntityLivingBase) {
                int b0 = 15;
                if (this.field_70170_p.field_73013_u == EnumDifficulty.NORMAL) {
                    b0 = 30;
                } else if (this.field_70170_p.field_73013_u == EnumDifficulty.HARD) {
                    b0 = 100;
                }
                if (b0 > 0) {
                    ((EntityLivingBase)p_70652_1_).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, b0 * 20, 3));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public EntitySpider createInstance() {
        return new EntityCaveSpiderLoyalist(this.field_70170_p);
    }

    @Override
    protected EntitySpider createBetterInstance() {
        return new EntityCaveSpiderPriest(this.field_70170_p);
    }

    @Override
    protected EntitySpider createEvenBetterInstance() {
        return new EntityCaveSpiderZealot(this.field_70170_p);
    }

    @Override
    protected EntitySpider createSuperInstance() {
        return new EntityCaveSpiderTemplar(this.field_70170_p);
    }

    @Override
    public float func_70047_e() {
        return 7.28f;
    }

    @Override
    public boolean attackSpiderFrom(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityPlayer && !this.field_70170_p.field_72995_K) {
            this.func_70624_b((EntityLivingBase)source.func_76346_g());
            this.func_70604_c((EntityLivingBase)source.func_76346_g());
        }
        if (this.func_85032_ar()) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityPlayer && this.isSubdued) {
            if (this.func_70681_au().nextInt(3) == 0) {
                AnimationAPI.sendAnimPacket(this, 3);
                this.setAnimID(3);
            } else {
                AnimationAPI.sendAnimPacket(this, 9);
                this.setAnimID(9);
            }
            return false;
        }
        if (source.func_76346_g() instanceof EntityCaveSpiderLoyalist || source.func_76346_g() instanceof EntityCaveSpiderTitan) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityLivingBase && !this.func_85032_ar() && amount > 25.0f) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(100.0, 100.0, 100.0));
            for (int i = 0; i < list.size(); ++i) {
                Entity entity1 = (Entity)list.get(i);
                if (entity1 instanceof EntityCaveSpiderTitan) {
                    EntityCaveSpiderTitan entitypigzombie = (EntityCaveSpiderTitan)entity1;
                    entitypigzombie.func_70624_b((EntityLivingBase)entity);
                    entitypigzombie.func_70604_c((EntityLivingBase)entity);
                }
                this.func_70624_b((EntityLivingBase)entity);
                this.func_70604_c((EntityLivingBase)entity);
            }
        }
        return super.attackSpiderFrom(source, amount);
    }

    public boolean func_70085_c(EntityPlayer p_70085_1_) {
        ItemStack itemstack = p_70085_1_.field_71071_by.func_70448_g();
        p_70085_1_.func_71038_i();
        if (this.isStunned && !this.isSubdued) {
            if (itemstack != null && itemstack.func_77973_b() == Items.field_151153_ao) {
                this.isSubdued = true;
                this.field_70170_p.func_72956_a((Entity)this, "random.levelup", 10.0f, 1.0f);
                p_70085_1_.func_145747_a((IChatComponent)new ChatComponentText(this.func_94057_bL() + " has been subdued by " + p_70085_1_.func_70005_c_()));
                return super.func_70085_c(p_70085_1_);
            }
        } else if (this.isSubdued) {
            if (itemstack == null && p_70085_1_.field_70154_o == null) {
                p_70085_1_.func_70078_a((Entity)this);
            } else if (itemstack != null) {
                if (itemstack.func_77973_b() == Items.field_151077_bg) {
                    AnimationAPI.sendAnimPacket(this, 3);
                    this.setAnimID(3);
                    this.isAttacking = true;
                }
                if (itemstack.func_77973_b() == Items.field_151103_aS) {
                    AnimationAPI.sendAnimPacket(this, 9);
                    this.setAnimID(9);
                    this.isAttacking = true;
                }
            }
        }
        return false;
    }

    public void func_70612_e(float p_70612_1_, float p_70612_2_) {
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityLivingBase && this.isSubdued) {
            this.func_70624_b(null);
            this.field_70125_A = this.field_70153_n.field_70125_A;
            this.field_70759_as = ((EntityLivingBase)this.field_70153_n).field_70759_as;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            p_70612_1_ = ((EntityLivingBase)this.field_70153_n).field_70702_br;
            p_70612_2_ = ((EntityLivingBase)this.field_70153_n).field_70701_bs;
            if (((EntityLivingBase)this.field_70153_n).field_70701_bs > 0.0f) {
                this.func_70024_g((double)(-MathHelper.func_76126_a((float)(((EntityLivingBase)this.field_70153_n).field_70759_as * (float)Math.PI / 180.0f))) * this.getSpeed(), 0.0, (double)MathHelper.func_76134_b((float)(((EntityLivingBase)this.field_70153_n).field_70759_as * (float)Math.PI / 180.0f)) * this.getSpeed());
            }
            if (((EntityLivingBase)this.field_70153_n).field_70701_bs < 0.0f) {
                this.func_70024_g((double)(-MathHelper.func_76126_a((float)(((EntityLivingBase)this.field_70153_n).field_70759_as * (float)Math.PI / 180.0f))) * -this.getSpeed(), 0.0, (double)MathHelper.func_76134_b((float)(((EntityLivingBase)this.field_70153_n).field_70759_as * (float)Math.PI / 180.0f)) * -this.getSpeed());
            }
            if (this.field_70122_E && ((EntityLivingBase)this.field_70153_n).field_70125_A < -80.0f) {
                this.func_70664_aZ();
            }
            if (!this.field_70170_p.field_72995_K) {
                super.func_70612_e(p_70612_1_, p_70612_2_);
            }
            this.field_70722_aY = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f4 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
            this.field_70754_ba += this.field_70721_aZ;
        } else {
            super.func_70612_e(p_70612_1_, p_70612_2_);
        }
    }
}

