/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titan;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.titan.EntityBlazeTitanFireball;
import net.minecraft.entity.titan.EntityIronGolemTitan;
import net.minecraft.entity.titan.EntitySnowGolemTitan;
import net.minecraft.entity.titan.EntityTitan;
import net.minecraft.entity.titan.EntityTitanSpirit;
import net.minecraft.entity.titan.EntityWitherzilla;
import net.minecraft.entity.titan.EnumTitanStatus;
import net.minecraft.entity.titan.ITitan;
import net.minecraft.entity.titan.ai.EntityAINearestTargetTitan;
import net.minecraft.entity.titanminion.EntityBlazeLoyalist;
import net.minecraft.entity.titanminion.EntityBlazePriest;
import net.minecraft.entity.titanminion.EntityBlazeTemplar;
import net.minecraft.entity.titanminion.EntityBlazeZealot;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.theTitans.DamageSourceExtra;
import net.minecraft.theTitans.TheTitans;
import net.minecraft.theTitans.TitanItems;
import net.minecraft.theTitans.TitansAchievments;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityBlazeTitan
extends EntityTitan {
    private float heightOffset = 32.0f;
    private int heightOffsetUpdateTime;
    public boolean shouldBurn;

    public EntityBlazeTitan(World worldIn) {
        super(worldIn);
        this.field_70181_x = 0.75;
        this.shouldParticlesBeUpward = true;
        this.setTitanHealth(this.func_110138_aP());
        this.field_70178_ae = true;
        this.func_70105_a(8.0f, 8.0f);
        this.field_70728_aV = 50000;
        this.field_70138_W = 6.0f;
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityIronGolemTitan.class, 0, false));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntitySnowGolemTitan.class, 0, false));
    }

    @Override
    protected void applyEntityAI() {
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIFireballAttack());
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        if (TheTitans.TitansFFAMode) {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.BlazeTitanSorter));
        } else {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.SearchForAThingToKill));
        }
    }

    public float func_70047_e() {
        return 4.0f;
    }

    @Override
    public int getMinionCap() {
        return 120;
    }

    @Override
    public int getPriestCap() {
        return 60;
    }

    @Override
    public int getZealotCap() {
        return 20;
    }

    @Override
    public int getTemplarCap() {
        return 8;
    }

    public boolean func_70686_a(Class p_70686_1_) {
        return p_70686_1_ != EntityBlazeLoyalist.class && p_70686_1_ != EntityBlazeTitan.class;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(250) == 0 && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && super.func_70601_bi();
    }

    @Override
    public int getMinionSpawnRate() {
        return TheTitans.BlazeTitanMinionSpawnrate;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.375);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(300.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(0));
    }

    @Override
    public int getParticleCount() {
        return 32;
    }

    @Override
    public String getParticles() {
        if (this.func_70026_G()) {
            return "";
        }
        return "largesmoke";
    }

    @Override
    public int getRegenTime() {
        return 10;
    }

    @Override
    public EnumTitanStatus getTitanStatus() {
        return EnumTitanStatus.AVERAGE;
    }

    public void func_82206_m() {
        this.setInvulTime(860);
        this.setTitanHealth(this.func_110138_aP() / 10.0f);
    }

    protected String func_70639_aQ() {
        return "thetitans:titanBlazeBreathe";
    }

    @Override
    protected String func_70621_aR() {
        return "thetitans:titanBlazeGrunt";
    }

    @Override
    protected String func_70673_aS() {
        return "thetitans:titanBlazeDeath";
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public float func_70013_c(float p_70013_1_) {
        return 1.0f;
    }

    @Override
    public double getSpeed() {
        return 20.0;
    }

    @Override
    public void func_70636_d() {
        int i;
        this.destroyBlocksInAABB(this.field_70121_D);
        if (this.field_70170_p.field_72995_K && this.deathTicks < this.getThreashHold()) {
            for (i = 0; i < this.getParticleCount(); ++i) {
                if (this.shouldParticlesBeUpward) {
                    this.field_70170_p.func_72869_a(this.getParticles(), this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u - 16.0 + this.field_70146_Z.nextDouble() * 16.0, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
                    continue;
                }
                this.field_70170_p.func_72869_a(this.getParticles(), this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u - 16.0 + this.field_70146_Z.nextDouble() * 16.0, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
            if (TheTitans.NightmareMode && this.field_70146_Z.nextInt(20) == 0) {
                for (i = 0; i < 2; ++i) {
                    this.field_70170_p.func_72869_a("flame", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u - 16.0 + this.field_70146_Z.nextDouble() * 16.0, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
                }
            }
        }
        for (i = 0; i < 8; ++i) {
            double d0 = this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 8.0f - 4.0f);
            double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 8.0f);
            double d2 = this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 8.0f - 4.0f);
            if (this.field_70170_p.field_72995_K || this.field_70170_p.func_147439_a((int)d0, (int)d1 + (int)this.func_70047_e(), (int)d2).func_149688_o() == Material.field_151579_a) continue;
            this.func_70107_b(this.field_70165_t, this.field_70163_u + 0.1, this.field_70161_v);
        }
        for (int in = 0; in < 400; ++in) {
            for (int i2 = 0; i2 < 8; ++i2) {
                double d0 = this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 8.0f - 4.0f);
                double d1 = this.field_70163_u;
                double d2 = this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 8.0f - 4.0f);
                if (this.field_70170_p.field_72995_K || this.field_70170_p.func_147439_a((int)d0, (int)d1 - this.field_70146_Z.nextInt(20), (int)d2).func_149688_o() == Material.field_151579_a) continue;
                this.field_70181_x = 0.25;
            }
        }
        if (TheTitans.NightmareMode) {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(600.0);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60000.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(200.0);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30000.0);
        }
        this.func_94058_c(StatCollector.func_74838_a((String)"entity.BlazeTitan.name"));
        if (this.numMinions < this.getMinionCap() && this.field_70146_Z.nextInt(this.getMinionSpawnRate()) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            EntityBlazeLoyalist entitychicken = new EntityBlazeLoyalist(this.field_70170_p);
            entitychicken.func_70012_b(this.field_70165_t, this.field_70163_u - 2.0, this.field_70161_v, this.field_70177_z, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            ++this.numMinions;
        }
        if (this.numPriests < this.getPriestCap() && this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 2) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            EntityBlazePriest entitychicken = new EntityBlazePriest(this.field_70170_p);
            entitychicken.func_70012_b(this.field_70165_t, this.field_70163_u - 2.0, this.field_70161_v, this.field_70177_z, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            ++this.numPriests;
        }
        if (this.numZealots < this.getZealotCap() && this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 5) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            EntityBlazeZealot entitychicken = new EntityBlazeZealot(this.field_70170_p);
            entitychicken.func_70012_b(this.field_70165_t, this.field_70163_u - 2.0, this.field_70161_v, this.field_70177_z, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            ++this.numZealots;
        }
        if (this.numTemplar < this.getTemplarCap() && this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 10) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            EntityBlazeTemplar entitychicken = new EntityBlazeTemplar(this.field_70170_p);
            entitychicken.func_70012_b(this.field_70165_t, this.field_70163_u - 2.0, this.field_70161_v, this.field_70177_z, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            ++this.numTemplar;
        }
        if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(48) == 0) {
            this.field_70170_p.func_72980_b(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "fire.fire", 10.0f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.3f + 0.2f, false);
        }
        if (this.func_70638_az() != null) {
            this.func_70625_a((Entity)this.func_70638_az(), 5.0f, 180.0f);
            this.func_70605_aq().func_75642_a(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 20.0);
            if (this.field_70163_u < this.func_70638_az().field_70163_u + 24.0) {
                if (this.field_70181_x < 0.0) {
                    this.field_70181_x = 0.0;
                }
                this.field_70181_x += (0.8 - this.field_70181_x) * 0.8;
            }
            if (!this.field_70122_E && this.field_70181_x < 0.0) {
                this.field_70181_x *= 0.9;
            }
        } else if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.25;
        }
        super.func_70636_d();
    }

    @Override
    protected void func_70619_bc() {
        if (this.getInvulTime() < 0) {
            EntityLivingBase entitylivingbase;
            --this.heightOffsetUpdateTime;
            if (this.heightOffsetUpdateTime <= 0) {
                this.heightOffsetUpdateTime = 300;
                this.heightOffset = 40.0f + (float)this.field_70146_Z.nextGaussian() * 16.0f;
            }
            if ((entitylivingbase = this.func_70638_az()) != null && entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() > this.field_70163_u + (double)this.func_70047_e() + (double)this.heightOffset) {
                this.field_70181_x += (0.9 - this.field_70181_x) * 0.9;
                this.field_70160_al = true;
            }
        }
        super.func_70619_bc();
    }

    public void fall(float distance, float damageMultiplier) {
    }

    protected Item func_146068_u() {
        return Items.field_151072_bj;
    }

    public int func_70646_bf() {
        return 180;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.deathTicks > 0) {
            EntityItem entityitem;
            int l;
            for (l = 0; l < 144 + this.field_70146_Z.nextInt(144 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151072_bj));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 96 + this.field_70146_Z.nextInt(96 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151065_br));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 64 + this.field_70146_Z.nextInt(64 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151044_h));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 24 + this.field_70146_Z.nextInt(64 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151043_k));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 16 + this.field_70146_Z.nextInt(24 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151166_bC));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 16 + this.field_70146_Z.nextInt(24 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151045_i));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 1 + this.field_70146_Z.nextInt(8 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(TitanItems.harcadium));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            if (this.field_70146_Z.nextInt(5) == 0) {
                EntityItem entityitem2 = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150357_h));
                entityitem2.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem2);
            }
            if (this.field_70146_Z.nextInt(5) == 0) {
                EntityItem entityitem3 = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150357_h));
                entityitem3.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem3);
            }
        }
    }

    protected void func_82164_bB() {
        this.func_145779_a(Items.field_151067_bt, 64);
    }

    public boolean func_70845_n() {
        return (this.field_70180_af.func_75683_a(16) & 1) != 0;
    }

    public void func_70844_e(boolean p_70844_1_) {
        byte b0 = this.field_70180_af.func_75683_a(16);
        b0 = p_70844_1_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_75692_b(16, (Object)b0);
    }

    @Override
    protected boolean isValidLightLevel() {
        return true;
    }

    @Override
    public boolean func_70058_J() {
        return false;
    }

    protected void func_82167_n(Entity p_82167_1_) {
        if (!(p_82167_1_ instanceof EntitySmallFireball) || !(p_82167_1_ instanceof EntityLargeFireball)) {
            p_82167_1_.func_70108_f((Entity)this);
        }
    }

    @Override
    public StatBase getAchievement() {
        return TitansAchievments.blazetitan;
    }

    public boolean attackBlazeFrom(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityPlayer && !this.field_70170_p.field_72995_K) {
            this.func_70624_b((EntityLivingBase)source.func_76346_g());
            this.func_70604_c((EntityLivingBase)source.func_76346_g());
        }
        if (this.func_85032_ar()) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityBlazeLoyalist || source.func_76346_g() instanceof EntityBlazeTitan) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70067_L() {
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityBlazeLoyalist || source.func_76346_g() instanceof EntityBlazeTitan) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    protected void inactDeathAction() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                this.func_70628_a(true, 0);
                this.func_82160_b(true, 0);
                this.func_70600_l(1);
            }
            EntityTitanSpirit entitytitan = new EntityTitanSpirit(this.field_70170_p);
            entitytitan.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entitytitan);
            entitytitan.setVesselHunting(false);
            entitytitan.setSpiritType(9);
        }
    }

    class AIFireballAttack
    extends EntityAIBase {
        private EntityBlazeTitan field_179469_a;
        private int field_179467_b;
        private int field_179468_c;

        public AIFireballAttack() {
            this.field_179469_a = EntityBlazeTitan.this;
            this.func_75248_a(4);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.field_179469_a.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S();
        }

        public void func_75249_e() {
            this.field_179467_b = 0;
        }

        public void func_75251_c() {
            this.field_179469_a.func_70844_e(false);
        }

        public void func_75246_d() {
            --this.field_179468_c;
            EntityLivingBase entitylivingbase = this.field_179469_a.func_70638_az();
            double d0 = this.field_179469_a.func_70068_e((Entity)entitylivingbase);
            if (d0 <= 1000.0) {
                if (this.field_179468_c <= 0) {
                    this.field_179468_c = 30;
                    float f = (float)this.field_179469_a.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                    int i = this.field_179469_a.getKnockbackAmount();
                    this.field_179469_a.attackChoosenEntity((Entity)entitylivingbase, f, i);
                }
            } else if (d0 < 10000.0 && d0 > 600.0) {
                double d1 = entitylivingbase.field_70165_t - this.field_179469_a.field_70165_t;
                double d2 = entitylivingbase.field_70163_u - (this.field_179469_a.field_70163_u + (double)(this.field_179469_a.field_70131_O * 0.5f));
                double d3 = entitylivingbase.field_70161_v - this.field_179469_a.field_70161_v;
                if (this.field_179468_c <= 0) {
                    ++this.field_179467_b;
                    if (this.field_179467_b == 1) {
                        this.field_179468_c = 20 + this.field_179469_a.func_70681_au().nextInt(40);
                        this.field_179469_a.func_70844_e(true);
                    } else if (this.field_179467_b <= 4) {
                        this.field_179468_c = 6;
                    } else {
                        this.field_179468_c = 20 + this.field_179469_a.func_70681_au().nextInt(40);
                        this.field_179467_b = 0;
                        this.field_179469_a.func_70844_e(false);
                    }
                    if (this.field_179467_b > 1) {
                        float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d0)) * 0.75f;
                        this.field_179469_a.func_85030_a("thetitans:titanGhastFireball", 100.0f, 1.1f);
                        for (int i = 0; i < 50; ++i) {
                            EntityBlazeTitanFireball entitysmallfireball = new EntityBlazeTitanFireball(this.field_179469_a.field_70170_p, (EntityLivingBase)this.field_179469_a, d1 + this.field_179469_a.func_70681_au().nextGaussian() * (double)f, d2, d3 + this.field_179469_a.func_70681_au().nextGaussian() * (double)f);
                            double d8 = 4.0;
                            Vec3 vec3 = this.field_179469_a.func_70676_i(1.0f);
                            entitysmallfireball.field_70165_t = this.field_179469_a.field_70165_t + vec3.field_72450_a * d8;
                            entitysmallfireball.field_70163_u = this.field_179469_a.field_70163_u + 4.0;
                            entitysmallfireball.field_70161_v = this.field_179469_a.field_70161_v + vec3.field_72449_c * d8;
                            this.field_179469_a.field_70170_p.func_72838_d((Entity)entitysmallfireball);
                            if (this.field_179469_a.func_70681_au().nextInt(30) != 0) continue;
                            this.field_179469_a.field_70170_p.func_72885_a((Entity)this.field_179469_a, entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 4.0f, false, false);
                            entitylivingbase.func_70097_a(DamageSourceExtra.lightningBolt, 49.0f);
                            float f2 = (float)EntityBlazeTitan.this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                            int i1 = EntityBlazeTitan.this.getKnockbackAmount();
                            EntityBlazeTitan.this.attackChoosenEntity((Entity)entitylivingbase, f2, i1);
                            this.field_179469_a.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_179469_a.field_70170_p, this.field_179469_a.field_70165_t, this.field_179469_a.field_70163_u + (double)this.field_179469_a.func_70047_e(), this.field_179469_a.field_70161_v));
                            this.field_179469_a.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_179469_a.field_70170_p, entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v));
                            if (!(entitylivingbase instanceof EntityWitherzilla)) continue;
                            entitylivingbase.func_70097_a(DamageSource.field_76377_j, 400.0f);
                        }
                    }
                }
            } else {
                this.field_179469_a.func_70661_as().func_75499_g();
            }
            super.func_75246_d();
        }
    }
}

