using UnityEngine;

public class Util {
    public static float SmoothStepInOut(float time) {
        if (time < 0.5f) {
            return Mathf.SmoothStep(0, 1, time * 2);
        }
        else {
            return Mathf.SmoothStep(0, 1, time * 2 - 1) * -1 + 1;
        }
    }

    // Easing functions from from https://gist.github.com/Fonserbc/3d31a25e87fdaa541ddf
    public static float QuadInOut(float k) {
        if ((k *= 2f) < 1f) return 0.5f*k*k;
        return -0.5f*((k -= 1f)*(k - 2f) - 1f);
    }

    public static float QuadIn(float k) {
        return k*k;
    }

    public static float QuadOut(float k) {
        return k*(2f - k);
    }

    public static float QuadOscillate(float k) {
        // Keep it in the 0-1 range
        k = k - Mathf.Floor(k);

        // Going up
        if (k < 0.5f) {
            return QuadInOut(k*2);
        }
        // Going down
        else {
            return QuadInOut(1 - (k-0.5f)*2);
        }
    }

    public static float QuadParabola(float k) {
        if (k < 0.5f) {
            return QuadOut(2*k);
        }
        else {
            return QuadOut(1f-(k-0.5f)*2);
        }
    }

    public static float CubicInOut(float k) {
        if ((k *= 2f) < 1f) return 0.5f*k*k*k;
        return 0.5f*((k -= 2f)*k*k + 2f);
    }

    public static float CubicIn(float k) {
        return k*k*k;
    }

    public static float CubicOut(float k) {
        return 1f + ((k -= 1f)*k*k);
    }

    public static float QuartIn(float k) {
        return k*k*k*k;
    }

    public static float QuartOut(float k) {
        return 1f - ((k -= 1f)*k*k*k);
    }

    public static float QuartInOut(float k) {
        if ((k *= 2f) < 1f) return 0.5f*k*k;
        return -0.5f*((k -= 1f)*(k - 2f) - 1f);
    }

    public static float SinInOut(float k) {
        return 0.5f*(1f - Mathf.Cos(Mathf.PI*k));
    }

    public static float SinOscillate(float k) {
        if (k < 0.5) return SinInOut(k*2);
        else return 1-SinInOut((k-0.5f)*2);
    }

    public static float SmoothStep(float k) {
        return Mathf.SmoothStep(0, 1, k);
    }

    public static float SmoothStepIn(float k) {
        return 2*Mathf.SmoothStep(0, 1, (k*0.5f));
    }

    public static float SmoothStepOut(float k) {
        return 2*Mathf.SmoothStep(0, 1, (k*0.5f)+0.5f)-1;
    }

    public static float ExponentialOut(float k) {
        return k == 1f? 1f : 1f - Mathf.Pow(2f, -10f*k);
    }

    public static double MinDouble(double a, double b) {
        if (a < b) return a;
        return b;
    }

    public static double MaxDouble(double a, double b) {
        if (a > b) return a;
        return b;
    }

    public static double LerpDouble(double a, double b, double t) {
        return a + (b - a) * t;
    }

    public static double AbsDouble(double n) {
        if (n < 0) return -n;
        return n;
    }

    public static Vector2 RadianToVector2(float radian) {
        return new Vector2(Mathf.Cos(radian), Mathf.Sin(radian));
    }

    public static Vector2 DegreeToVector2(float degree) {
        return RadianToVector2(degree * Mathf.Deg2Rad);
    }

    public static float Vector2ToDegrees(Vector2 vec) {
        return Vector2.SignedAngle(Vector2.right, vec);
    }

    // a and b must be in the 0-1 range.
    public static float LerpFloat01Wrap(float a, float b, float t) {
        // If they're close by, lerp directly.
        if (Mathf.Abs(b - a) < 0.5f) {
            return Mathf.Lerp(a, b, t);
        }
        else {
            // Otherwise, add 1 to the lesser value, then lerp directly,
            // then wrap below 1.
            if (a > b) b += 1;
            else a += 1;

            float v = Mathf.Lerp(a, b, t);
            if (v > 1) v -= 1;
            return v;
        }
    }

    public static int ClampInt(int n, int min, int max) {
        if (n < min) return min;
        if (n > max) return max;
        return n;
    }

    public static float ModPositive(float n, float mod) {
        return ((n % mod) + mod) % mod;
    }

    public static int SignInt(int n) {
        if (n > 0) return 1;
        if (n < 0) return -1;
        return 0;
    }

    public static bool ParseBool(string arg) {
        if (arg == "0") return false;
        if (arg == "1") return true;
        throw new System.FormatException("Unable to parse bool: "+arg);
    }

    public static float ParseFloat(string arg) {
        return float.Parse(arg, System.Globalization.CultureInfo.InvariantCulture);
    }

    public static string FloatToString(float f) {
        return f.ToString(System.Globalization.CultureInfo.InvariantCulture);
    }
}
