/**
 * This is a simplified version of standard PAC.
 * 这是标准 PAC 的一个简化版本。
 *
 * The return value could be one of the strings below:
 *    - 'DIRECT': No proxy.
 *    - 'PRECONFIG': Apply the system-wide proxy.
 *    - A single-proxy-formatted string, like '127.0.0.1:8888', 'SOCKS 127.0.0.1:8888' or 'SOCKS5 127.0.0.1:8888' etc.
 * 返回值可以是以下几种字符串之一：
 *    - 'DIRECT'：不使用代理。
 *    - 'PRECONFIG'：使用系统代理。
 *    - 一个单独代理服务器格式的字符串，如 '127.0.0.1:8888'、'SOCKS 127.0.0.1:8888'、'SOCKS5 127.0.0.1:8888' 等。
 *
 * Note:
 *    1. If `pac.js` does not exist in the directory of MangaCon,
 *       or function `McFindProxyForURL` could not be found in `pac.js`,
 *       or `McFindProxyForURL` returns a non-string value,
 *       MangaCon will not set proxy for its net requests ('DIRECT').
 *    2. If `pac.js` is modified while MangaCon still running,
 *       the proxy settings will not take effort until MangaCon restarted.
 * 注意：
 *    1. 如果漫画控文件夹下不存在 `pac.js` ，或 `pac.js` 中没有 `McFindProxyForURL` 函数，
 *       或 `McFindProxyForURL` 没有返回一个字符串，那么漫画控将不会使用代理（'DIRECT'）。
 *    2. 如果在漫画控运行期间修改了 `pac.js`，那么代理服务器配置在漫画控重新启动后才会生效。
 */

function McFindProxyForURL(url, host) {
    return 'PRECONFIG';
}
